/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileEditComponent;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolution;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolutionEditComponent;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchEditComponent;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.Container;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CcBatchProfile
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    public static final int RESOLUTIONS_REQUIRED_TO_START = 1;
    public static final int MAXIMUM_RESOLUTIONS = CcBatchProfileResolution.PIXEL_SIZES.length;
    protected static final int DEFAULT_PROFILE_ID_SID = -1;
    protected static final int DEFAULT_PROFILE_ID_JP2 = -2;
    protected static final int DEFAULT_PROFILE_ID_DEFAULT = -2;
    protected static final String DEFAULT_PROFILE_NAME_SID = "Insight w/ SID";
    protected static final String DEFAULT_PROFILE_NAME_JP2 = "Insight w/ JPEG2000";
    protected static final String DEFAULT_URL_PREFIX = "";
    protected static final String DEFAULT_SID_URL_PREFIX = "";
    protected static final boolean DEFAULT_PRESERVE_FILENAMES = true;
    protected static final boolean DEFAULT_PRESERVE_DIR_STRUCTURE = false;
    protected int profileID;
    protected CollectionServer collectionServer;
    protected String profileName = "";
    protected String urlPrefix = "";
    protected String sidUrlPrefix = "";
    protected boolean preserveFilenames = true;
    protected boolean preserveDirStructure = false;
    protected Vector resolutions = new Vector();
    protected Vector originalResolutions = new Vector();
    protected CcBatchProfileEditComponent editComponent = null;
    protected CcTaskItem taskItem;
    private CcMediaBatch currentReferencingBatch = null;

    public CcBatchProfile(CollectionServer collectionServer, int n, String string, String string2, String string3, boolean bl, boolean bl2, Vector vector) {
        this.collectionServer = collectionServer;
        this.profileID = n;
        this.profileName = string == null ? "" : string;
        this.urlPrefix = string2 == null ? "" : string2;
        this.sidUrlPrefix = string3 == null ? "" : string3;
        this.preserveFilenames = bl;
        this.preserveDirStructure = bl2;
        this.resolutions = vector == null ? new Vector() : vector;
        this.originalResolutions = this.deepCopyResolutions(this.resolutions);
    }

    public CcBatchProfile(int n, CollectionServer collectionServer) {
        this.profileID = n;
        this.collectionServer = collectionServer;
    }

    protected Vector deepCopyResolutions(Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector<CcBatchProfileResolution> vector2 = new Vector<CcBatchProfileResolution>();
        for (int i = 0; i < vector.size(); ++i) {
            CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)vector.elementAt(i);
            vector2.addElement(ccBatchProfileResolution.getCopy());
        }
        return vector2;
    }

    public void setProfileName(String string) {
        this.profileName = string == null ? "" : string;
    }

    public void setUrlPrefix(String string) {
        this.urlPrefix = string == null ? "" : string;
    }

    public void setSidUrlPrefix(String string) {
        this.sidUrlPrefix = string == null ? "" : string;
    }

    public void setPreserveFilenames(boolean bl) {
        this.preserveFilenames = bl;
    }

    public void setPreserveDirStructure(boolean bl) {
        this.preserveDirStructure = bl;
    }

    public void setResolutions(Vector vector) {
        this.setResolutions(vector, false);
    }

    public void setResolutions(Vector vector, boolean bl) {
        Vector vector2 = this.resolutions = vector == null ? new Vector() : vector;
        if (bl) {
            for (int i = 0; i < this.resolutions.size(); ++i) {
                CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)this.resolutions.elementAt(i);
                ccBatchProfileResolution.setBatchProfileParent(this);
            }
        }
        this.originalResolutions = this.deepCopyResolutions(this.resolutions);
    }

    public CcMediaBatch getCurrentReferencingBatch() {
        return this.currentReferencingBatch;
    }

    public void setCurrentReferencingBatch(CcMediaBatch ccMediaBatch) {
        this.currentReferencingBatch = ccMediaBatch;
    }

    protected List getReferencingMediaBatches() {
        return ((CollectionServerConnector)this.collectionServer.getServerConnector()).getMediaBatchesReferencingProfile(this);
    }

    public void deleteProfile() {
        this.collectionServer.removeDataObject(this);
        this.updateProfileComboBoxesAfterDelete();
        this.cancelEditDialogExplicit();
    }

    public CcBatchProfileResolution createNewResolution() {
        int n = this.resolutions != null ? this.resolutions.size() : 0;
        CcBatchProfileResolution ccBatchProfileResolution = new CcBatchProfileResolution(this.collectionServer, 0, n);
        ccBatchProfileResolution.setBatchProfileParent(this);
        if (ccBatchProfileResolution != null && !this.resolutions.contains(ccBatchProfileResolution)) {
            this.resolutions.addElement(ccBatchProfileResolution);
        }
        return ccBatchProfileResolution;
    }

    public CcBatchProfileResolution getResolutionToRemove() {
        if (this.resolutions == null || this.resolutions.size() == 0) {
            return null;
        }
        return (CcBatchProfileResolution)this.resolutions.remove(this.resolutions.size() - 1);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.profileName;
    }

    public int getIndex() {
        return this.profileID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CcBatchProfileEditComponent(this);
        this.editComponent.getProfileNameField().setText(this.profileName);
        this.editComponent.getUrlPrefixField().setText(this.urlPrefix);
        this.editComponent.getSidUrlPrefixField().setText(this.sidUrlPrefix);
        this.editComponent.getPreserveFilenamesCheckBox().setSelected(this.preserveFilenames);
        this.editComponent.getPreserveDirectoriesCheckBox().setSelected(this.preserveDirStructure);
        for (int i = 0; i < this.resolutions.size(); ++i) {
            CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)this.resolutions.elementAt(i);
            CcBatchProfileResolutionEditComponent ccBatchProfileResolutionEditComponent = (CcBatchProfileResolutionEditComponent)ccBatchProfileResolution.getEditComponent();
            if (ccBatchProfileResolutionEditComponent == null) continue;
            this.editComponent.getImageTypesPanel().add(ccBatchProfileResolutionEditComponent);
            ccBatchProfileResolutionEditComponent.enableComponents(!this.isDefaultProfile());
        }
        List list = this.getReferencingMediaBatches();
        this.editComponent.getDeleteButton().setEnabled((list == null || list.size() == 0) && !this.isDefaultProfile());
        this.editComponent.getProfileNameField().setEnabled(!this.isDefaultProfile());
        this.editComponent.getUrlPrefixField().setEnabled(!this.isDefaultProfile());
        this.editComponent.getSidUrlPrefixField().setEnabled(!this.isDefaultProfile());
        this.editComponent.getPreserveFilenamesCheckBox().setEnabled(!this.isDefaultProfile());
        this.editComponent.getPreserveDirectoriesCheckBox().setEnabled(!this.isDefaultProfile());
        this.editComponent.getAddImageTypeButton().setEnabled(!this.isDefaultProfile());
        this.editComponent.getRemoveImageTypeButton().setEnabled(!this.isDefaultProfile());
        return this.editComponent;
    }

    public void save() {
        Vector vector;
        boolean bl;
        boolean bl2;
        CcBatchProfile.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.profileName, this.editComponent.getProfileNameField().getText())) {
            this.profileName = this.editComponent.getProfileNameField().getText();
        }
        if (this.hasChanged(this.urlPrefix, this.editComponent.getUrlPrefixField().getText())) {
            this.urlPrefix = this.editComponent.getUrlPrefixField().getText();
        }
        if (this.hasChanged(this.sidUrlPrefix, this.editComponent.getSidUrlPrefixField().getText())) {
            this.sidUrlPrefix = this.editComponent.getSidUrlPrefixField().getText();
        }
        if (this.hasChanged(this.preserveFilenames, bl2 = this.editComponent.getPreserveFilenamesCheckBox().isSelected())) {
            this.preserveFilenames = bl2;
        }
        if (this.hasChanged(this.preserveDirStructure, bl = this.editComponent.getPreserveDirectoriesCheckBox().isSelected())) {
            this.preserveDirStructure = bl;
        }
        if (this.haveResolutionsChanged(this.originalResolutions, vector = this.getUpdatedResolutionsFromEditComponent())) {
            this.resolutions = vector;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServer.commitDataObject(this);
            this.updateProfileComboBoxesAfterSave();
        } else {
            this.cancelEdit();
        }
    }

    public void cancel() {
        CcBatchProfile.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.cancelEdit();
    }

    private void cancelEdit() {
        this.collectionServer.cancelEdit(this);
        if (this.taskItem != null) {
            this.taskItem.setTaskItemCancelled();
        }
    }

    protected void cancelEditDialogExplicit() {
        EditDialog editDialog = (EditDialog)this.collectionServer.getEditDialogCache(this).get(this.getUniqueIdentifier());
        if (editDialog != null) {
            editDialog.cancel();
        }
        this.cancel();
    }

    public String getEditWindowTitle() {
        return "Image Creation Profile";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-field-groups-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof CcBatchProfile) {
            CcBatchProfile ccBatchProfile = (CcBatchProfile)object;
            return this.profileID == ccBatchProfile.profileID;
        }
        return super.equals(object);
    }

    private void updateProfileComboBoxesAfterSave() {
        if (this.currentReferencingBatch != null) {
            Hashtable hashtable = this.collectionServer.getEditDialogCache(this.currentReferencingBatch);
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    EditDialog editDialog = (EditDialog)enumeration.nextElement();
                    CcMediaBatchEditComponent ccMediaBatchEditComponent = (CcMediaBatchEditComponent)editDialog.getEditComponent();
                    ccMediaBatchEditComponent.addToProfileComboBox(this);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void updateProfileComboBoxesAfterDelete() {
        if (this.currentReferencingBatch != null) {
            Hashtable hashtable = this.collectionServer.getEditDialogCache(this.currentReferencingBatch);
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    EditDialog editDialog = (EditDialog)enumeration.nextElement();
                    CcMediaBatchEditComponent ccMediaBatchEditComponent = (CcMediaBatchEditComponent)editDialog.getEditComponent();
                    ccMediaBatchEditComponent.removeFromProfileComboBox(this);
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcBatchProfile) {
            CcBatchProfile ccBatchProfile = (CcBatchProfile)databaseRecord;
            return this.profileID == ccBatchProfile.profileID;
        }
        return false;
    }

    public boolean haveResolutionsChanged(Vector vector, Vector vector2) {
        boolean bl = false;
        Vector vector3 = vector;
        Vector vector4 = vector2;
        if (this.requiresCommit || vector3.size() != vector4.size()) {
            bl = true;
        } else {
            for (int i = 0; i < vector4.size(); ++i) {
                if (vector3.contains((CcBatchProfileResolution)vector4.elementAt(i))) continue;
                bl = true;
            }
        }
        if (bl) {
            this.requiresCommit = true;
        }
        return bl;
    }

    protected Vector getUpdatedResolutionsFromEditComponent() {
        Vector<CcBatchProfileResolution> vector = new Vector<CcBatchProfileResolution>();
        for (int i = 0; i < this.resolutions.size(); ++i) {
            CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)this.resolutions.elementAt(i);
            ccBatchProfileResolution.updateFromEditComponent();
            vector.add(ccBatchProfileResolution);
        }
        return vector;
    }

    public boolean isReadyToStart() {
        boolean bl = this.profileName != null && !this.profileName.trim().equals("") && this.urlPrefix != null && !this.urlPrefix.trim().equals("") && this.resolutions != null && this.resolutions.size() >= 1;
        return bl;
    }

    protected EditDialog getParentEditDialog() {
        if (this.editComponent == null) {
            return null;
        }
        for (Container container = this.editComponent.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof EditDialog)) continue;
            return (EditDialog)container;
        }
        return null;
    }

    public boolean isDefaultProfile() {
        return CcBatchProfile.isDefaultProfile(this.profileID);
    }

    public static boolean isDefaultProfile(int n) {
        return n == -1 || n == -2;
    }

    public static CcBatchProfile getDefaultProfile(CollectionServer collectionServer, int n) {
        if (n == -2) {
            if (InsightAdministrator.LICENSED_JP2K_ENCODER) {
                Vector<CcBatchProfileResolution> vector = new Vector<CcBatchProfileResolution>(CcBatchProfileResolution.DEFAULT_RESOLUTION_TYPES_JP2.length);
                for (int i = 0; i < CcBatchProfileResolution.DEFAULT_RESOLUTION_TYPES_JP2.length; ++i) {
                    vector.addElement(new CcBatchProfileResolution(collectionServer, CcBatchProfileResolution.DEFAULT_RESOLUTION_TYPES_JP2[i], i));
                }
                return new CcBatchProfile(collectionServer, -2, DEFAULT_PROFILE_NAME_JP2, "", "", true, false, vector);
            }
            Vector<CcBatchProfileResolution> vector = new Vector<CcBatchProfileResolution>(CcBatchProfileResolution.DEFAULT_RESOLUTION_TYPES_JP2_UNLICENSED.length);
            for (int i = 0; i < CcBatchProfileResolution.DEFAULT_RESOLUTION_TYPES_JP2_UNLICENSED.length; ++i) {
                vector.addElement(new CcBatchProfileResolution(collectionServer, CcBatchProfileResolution.DEFAULT_RESOLUTION_TYPES_JP2_UNLICENSED[i], i));
            }
            return new CcBatchProfile(collectionServer, -2, DEFAULT_PROFILE_NAME_JP2, "", "", true, false, vector);
        }
        Vector<CcBatchProfileResolution> vector = new Vector<CcBatchProfileResolution>(CcBatchProfileResolution.DEFAULT_RESOLUTION_TYPES_SID.length);
        for (int i = 0; i < CcBatchProfileResolution.DEFAULT_RESOLUTION_TYPES_SID.length; ++i) {
            vector.addElement(new CcBatchProfileResolution(collectionServer, CcBatchProfileResolution.DEFAULT_RESOLUTION_TYPES_SID[i], i));
        }
        return new CcBatchProfile(collectionServer, -1, DEFAULT_PROFILE_NAME_SID, "", "", true, false, vector);
    }

    public static void debugOut(String string) {
        CcBatchProfile.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcBatchProfile: " + string, n);
    }
}

