/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.join;

import com.luna.insight.admin.ControlPanelNode;
import com.luna.insight.admin.ControlTreeRenderer;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.SaveCancelController;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.join.CcJoinEditPanel;
import com.luna.insight.admin.collserver.join.CcJoinManager;
import com.luna.insight.admin.collserver.join.CcJoinRecord;
import com.luna.insight.admin.collserver.join.CcJoinSubNode;
import com.luna.insight.admin.collserver.table.CcTableRecord;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CcJoinsEditComponent
extends EditComponent
implements SaveCancelController,
TreeSelectionListener,
MouseListener,
ActionListener {
    public static final Dimension DEFAULT_SIZE = new Dimension(507, 320);
    protected CollectionServer server;
    protected CcJoinManager manager;
    protected JScrollPane treeScrollPane;
    protected JTree joinTree;
    protected DefaultTreeModel treeModel;
    protected CcJoinSubNode rootNode;
    protected JScrollPane subPanelScroller;
    protected CcJoinEditPanel joinEditPanel;
    protected List nodes = new Vector();

    public static void debugOut(String string) {
        CcJoinsEditComponent.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcJoinsEditComponent: " + string, n);
    }

    public CcJoinsEditComponent(CollectionServer collectionServer, CcJoinManager ccJoinManager) {
        this.server = collectionServer;
        this.manager = ccJoinManager;
        this.initComponents();
    }

    public CollectionServer getCollectionServer() {
        return this.server;
    }

    public CcJoinManager getManager() {
        return this.manager;
    }

    public JTree getJoinTree() {
        return this.joinTree;
    }

    protected void initComponents() {
        CcJoinRecord ccJoinRecord;
        this.setLayout(null);
        this.setSize(DEFAULT_SIZE);
        if (this.manager.getJoinsType() == 2) {
            ccJoinRecord = new CcJoinRecord(this.manager.getCollection().getUniqueCollectionID(), -1, null, null, null, null, this.manager.getJoinsType());
        } else {
            ccJoinRecord = new CcJoinRecord(this.manager.getCollection().getUniqueCollectionID(), -1, null, null, this.manager.getPrimaryObjectTable(), "", this.manager.getJoinsType());
            ccJoinRecord.setStartTable(ccJoinRecord.getEndTable());
        }
        this.rootNode = new CcJoinSubNode(ccJoinRecord, this, true);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.joinTree = new JTree(this.treeModel);
        this.joinTree.setCellRenderer(new ControlTreeRenderer());
        this.joinTree.putClientProperty("JTree.lineStyle", "Angled");
        this.joinTree.getSelectionModel().setSelectionMode(1);
        this.joinTree.addTreeSelectionListener(this);
        this.joinTree.addMouseListener(this);
        this.joinTree.setVisible(true);
        this.joinTree.setShowsRootHandles(false);
        this.addJoinNodes();
        this.rootNode.expandNode();
        this.treeScrollPane = new JScrollPane();
        this.treeScrollPane.setViewportView(this.joinTree);
        this.add((Component)this.treeScrollPane, "Center");
        this.joinEditPanel = new CcJoinEditPanel(this);
        this.subPanelScroller = new JScrollPane();
        this.subPanelScroller.setViewportView(this.joinEditPanel);
        this.add(this.subPanelScroller);
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        if (this.joinEditPanel.isEditingJoin()) {
            n2 = this.getHeight() - insets.bottom - 165;
            this.subPanelScroller.setBounds(n, n2, n3, 165);
            n2 = insets.top;
            this.treeScrollPane.setBounds(n, n2, n3, this.subPanelScroller.getY() - n2);
            this.treeScrollPane.doLayout();
            this.subPanelScroller.doLayout();
        } else {
            this.treeScrollPane.setBounds(n, n2, n3, n4);
            this.treeScrollPane.doLayout();
        }
    }

    protected void addJoinNodes() {
        List list = this.manager.getJoinPaths();
        if (this.manager.getJoinsType() == 2) {
            for (int i = 0; i < list.size(); ++i) {
                List list2 = (List)list.get(i);
                if (list2.size() <= 0) continue;
                CcJoinRecord ccJoinRecord = (CcJoinRecord)list2.get(0);
                CcJoinSubNode ccJoinSubNode = this.getNode(ccJoinRecord, true);
                CcJoinSubNode ccJoinSubNode2 = this.findNodeWithEndEquals(ccJoinRecord.getStartTable());
                if (ccJoinSubNode2 == null) {
                    ccJoinSubNode2 = this.rootNode;
                    CcJoinRecord ccJoinRecord2 = new CcJoinRecord(this.manager.getCollection().getUniqueCollectionID(), -1, null, null, ccJoinRecord.getStartTable(), ccJoinRecord.getStartFieldName(), this.manager.getJoinsType());
                    CcJoinSubNode ccJoinSubNode3 = this.getNode(ccJoinRecord2, false);
                    ccJoinSubNode3.setSubRoot(true);
                    ccJoinSubNode.setSubRootNode(ccJoinSubNode3);
                    ccJoinSubNode2.add(ccJoinSubNode3);
                    ccJoinSubNode2 = ccJoinSubNode3;
                    ccJoinSubNode2.add(ccJoinSubNode);
                    ccJoinSubNode2 = ccJoinSubNode;
                } else {
                    ccJoinSubNode2.add(ccJoinSubNode);
                    ccJoinSubNode2 = ccJoinSubNode;
                }
                for (int j = 1; j < list2.size(); ++j) {
                    ccJoinRecord = (CcJoinRecord)list2.get(j);
                    ccJoinSubNode = this.getNode(ccJoinRecord, true);
                    ccJoinSubNode2.add(ccJoinSubNode);
                    ccJoinSubNode2 = ccJoinSubNode;
                }
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                List list3 = (List)list.get(i);
                CcJoinSubNode ccJoinSubNode = this.rootNode;
                for (int j = list3.size() - 1; j >= 0; --j) {
                    CcJoinRecord ccJoinRecord = (CcJoinRecord)list3.get(j);
                    CcJoinSubNode ccJoinSubNode4 = this.getNode(ccJoinRecord, true);
                    ccJoinSubNode.add(ccJoinSubNode4);
                    ccJoinSubNode = ccJoinSubNode4;
                }
            }
        }
    }

    protected CcJoinSubNode findNodeWithEndEquals(CcTableRecord ccTableRecord) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            CcJoinSubNode ccJoinSubNode = (CcJoinSubNode)this.nodes.get(i);
            CcTableRecord ccTableRecord2 = ccJoinSubNode.getJoinRecord().getEndTable();
            if (ccTableRecord2 == null || !ccTableRecord2.equals(ccTableRecord)) continue;
            return ccJoinSubNode;
        }
        return null;
    }

    protected CcJoinSubNode getNode(CcJoinRecord ccJoinRecord, boolean bl) {
        CcJoinSubNode ccJoinSubNode = null;
        if (bl) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                CcJoinSubNode ccJoinSubNode2 = (CcJoinSubNode)this.nodes.get(i);
                if (!ccJoinSubNode2.getJoinRecord().equalsRecord(ccJoinRecord)) continue;
                ccJoinSubNode = ccJoinSubNode2;
                break;
            }
        }
        if (ccJoinSubNode == null) {
            ccJoinSubNode = new CcJoinSubNode(ccJoinRecord, this);
            this.nodes.add(ccJoinSubNode);
        }
        return ccJoinSubNode;
    }

    public void prependJoin(CcJoinSubNode ccJoinSubNode) {
        int n = this.manager.getNextJoinID();
        switch (this.manager.getJoinsType()) {
            case 2: {
                CcJoinRecord ccJoinRecord = new CcJoinRecord(this.manager.getCollection().getUniqueCollectionID(), n, ccJoinSubNode.getJoinRecord().getEndTable(), ccJoinSubNode.getJoinRecord().getEndFieldName(), null, null, this.manager.getJoinsType());
                CcJoinSubNode ccJoinSubNode2 = this.getNode(ccJoinRecord, false);
                this.joinEditPanel.setJoinToEdit(ccJoinSubNode2, ccJoinSubNode, ccJoinSubNode == this.rootNode);
                break;
            }
            default: {
                CcJoinRecord ccJoinRecord = new CcJoinRecord(this.manager.getCollection().getUniqueCollectionID(), n, null, null, ccJoinSubNode.getJoinRecord().getStartTable(), ccJoinSubNode.getJoinRecord().getStartFieldName(), this.manager.getJoinsType());
                CcJoinSubNode ccJoinSubNode3 = this.getNode(ccJoinRecord, false);
                this.joinEditPanel.setJoinToEdit(ccJoinSubNode3, ccJoinSubNode, true);
            }
        }
        this.doLayout();
    }

    public void editJoin(CcJoinSubNode ccJoinSubNode) {
        this.joinEditPanel.setJoinToEdit(ccJoinSubNode, null, this.manager.getJoinsType() == 1);
        this.doLayout();
    }

    public void deleteJoin(CcJoinSubNode ccJoinSubNode) {
        boolean bl = false;
        CcJoinSubNode ccJoinSubNode2 = null;
        if (this.manager.getJoinsType() == 2 && (ccJoinSubNode2 = ccJoinSubNode.getSubRootNode()) != null && ccJoinSubNode2.getChildCount() == 1) {
            bl = true;
        }
        this.manager.removeJoin(ccJoinSubNode.getJoinRecord());
        ccJoinSubNode.removeFromParent();
        if (bl) {
            ccJoinSubNode2.removeFromParent();
        }
        this.treeModel.reload();
        this.cancelEditJoin();
    }

    public void applyJoinEdits() {
        CcJoinSubNode ccJoinSubNode;
        CcJoinSubNode ccJoinSubNode2 = this.joinEditPanel.getEditedJoin();
        if (ccJoinSubNode2 != null && (ccJoinSubNode = this.joinEditPanel.getNextJoin()) != null) {
            if (this.manager.getJoinsType() == 2) {
                if (ccJoinSubNode != this.rootNode && !ccJoinSubNode.isSubRoot() && ccJoinSubNode.getJoinRecord().getNextJoin() == null) {
                    ccJoinSubNode.getJoinRecord().setNextJoin(ccJoinSubNode2.getJoinRecord());
                }
                if (ccJoinSubNode == this.rootNode) {
                    CcJoinRecord ccJoinRecord = new CcJoinRecord(this.manager.getCollection().getUniqueCollectionID(), -1, null, null, ccJoinSubNode2.getJoinRecord().getStartTable(), ccJoinSubNode2.getJoinRecord().getStartFieldName(), this.manager.getJoinsType());
                    CcJoinSubNode ccJoinSubNode3 = this.getNode(ccJoinRecord, false);
                    ccJoinSubNode3.setSubRoot(true);
                    ccJoinSubNode2.setSubRootNode(ccJoinSubNode3);
                    ccJoinSubNode.add(ccJoinSubNode3);
                    ccJoinSubNode = ccJoinSubNode3;
                }
            } else if (ccJoinSubNode != this.rootNode) {
                ccJoinSubNode2.getJoinRecord().setNextJoin(ccJoinSubNode.getJoinRecord());
            }
            this.manager.addJoin(ccJoinSubNode2.getJoinRecord());
            ccJoinSubNode.add(ccJoinSubNode2);
        }
        this.treeModel.reload();
        this.cancelEditJoin();
    }

    public void cancelEditJoin() {
        this.joinEditPanel.setJoinToEdit(null, null, this.manager.getJoinsType() == 1);
        this.doLayout();
    }

    public void save() {
        CcJoinsEditComponent.debugOut("Save.", 3);
        CcJoinsEditComponent.debugOut("Changes detected? " + this.manager.hasChanged());
        if (this.manager.hasChanged()) {
            this.server.getCollectionServerConnector().saveJoins(this.manager);
        }
        this.cancel();
    }

    public void cancel() {
        switch (this.manager.getJoinsType()) {
            case 2: {
                this.server.cancelEditInscribeJoins();
                break;
            }
            default: {
                this.server.cancelEditInsightJoins();
            }
        }
    }

    public EditComponent getEditComponent() {
        return this;
    }

    public String getWindowTitle() {
        switch (this.manager.getJoinsType()) {
            case 2: {
                return "Edit Record Joins";
            }
        }
        return "Edit Field Joins";
    }

    public ImageIcon getWindowIcon() {
        return IconMaker.createImage("images/collection-server-field-standards-node-icon.gif");
    }

    public String getSaveButtonText() {
        return "Save";
    }

    public String getCancelButtonText() {
        return "Cancel";
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.joinTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode instanceof ControlPanelNode) {
            this.displayNodeInfo((ControlPanelNode)defaultMutableTreeNode);
        }
        this.repaint();
    }

    protected void displayNodeInfo(ControlPanelNode controlPanelNode) {
    }

    protected void refreshDisplayedInfo() {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        TreePath treePath = this.joinTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            JPopupMenu jPopupMenu;
            TreeNode treeNode;
            this.joinTree.setSelectionPath(treePath);
            if ((mouseEvent.getModifiers() & 4) == 4 && (treeNode = (TreeNode)treePath.getLastPathComponent()) instanceof ControlPanelNode && (jPopupMenu = ((ControlPanelNode)treeNode).getPopup()) != null) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }
}

