/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.join;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.join.CcJoinRecord;
import com.luna.insight.admin.collserver.join.CcJoinSubNode;
import com.luna.insight.admin.collserver.join.CcJoinsEditComponent;
import com.luna.insight.admin.collserver.table.CcTableRecord;
import com.luna.insight.server.Debug;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CcJoinEditPanel
extends EditComponent
implements ActionListener,
DocumentListener,
KeyListener,
ItemListener {
    public static final String OKAY_COMMAND = "okay-command";
    public static final String CANCEL_COMMAND = "cancel-command";
    protected CcJoinsEditComponent mainEditComponent;
    protected CcJoinSubNode joinToEdit;
    protected CcJoinSubNode nextJoin;
    protected JLabel startTableLabel;
    protected JComboBox startTableComboBox;
    protected JLabel startFieldLabel;
    protected JTextField startFieldTextField;
    protected JLabel endTableLabel;
    protected JComboBox endTableComboBox;
    protected JLabel endFieldLabel;
    protected JTextField endFieldTextField;
    protected JButton okayButton;
    protected JButton cancelButton;
    protected CcTableRecord lastTableSelection;

    public static void debugOut(String string) {
        CcJoinEditPanel.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcJoinEditPanel: " + string, n);
    }

    public CcJoinEditPanel(CcJoinsEditComponent ccJoinsEditComponent) {
        this.mainEditComponent = ccJoinsEditComponent;
        this.initComponents();
    }

    public void initComponents() {
        this.setLayout(null);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.startTableLabel = this.createLabel("Start table:");
        this.startTableComboBox = this.createTableComboBox();
        if (this.mainEditComponent.getManager().getJoinsType() == 2) {
            this.startTableComboBox.setEnabled(false);
        }
        this.startFieldLabel = this.createLabel("Start field name:");
        this.startFieldTextField = this.createTextField();
        this.endTableLabel = this.createLabel("End table:");
        this.endTableComboBox = this.createTableComboBox();
        if (this.mainEditComponent.getManager().getJoinsType() == 1) {
            this.endTableComboBox.setEnabled(false);
        }
        this.endFieldLabel = this.createLabel("End field name:");
        this.endFieldTextField = this.createTextField();
        this.okayButton = this.createButton("Okay", OKAY_COMMAND);
        this.okayButton.setEnabled(false);
        this.cancelButton = this.createButton("Cancel", CANCEL_COMMAND);
        this.add(this.startTableComboBox);
        this.add(this.startFieldTextField);
        this.add(this.endTableComboBox);
        this.add(this.endFieldTextField);
        this.add(this.okayButton);
        this.add(this.cancelButton);
        this.add(this.startTableLabel);
        this.add(this.startFieldLabel);
        this.add(this.endTableLabel);
        this.add(this.endFieldLabel);
        if (this.mainEditComponent.getManager().getJoinsType() == 2) {
            this.endTableComboBox.addItemListener(this);
        } else {
            this.startTableComboBox.addItemListener(this);
        }
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        int n5 = this.startTableComboBox.getHeight();
        int n6 = 0;
        this.startTableLabel.setBounds(n, n2, this.startTableLabel.getWidth(), n5);
        n2 += this.startTableLabel.getHeight() + 5;
        if (this.startTableLabel.getWidth() > n6) {
            n6 = this.startTableLabel.getWidth();
        }
        this.startFieldLabel.setBounds(n, n2, this.startFieldLabel.getWidth(), n5);
        n2 += this.startFieldLabel.getHeight() + 5;
        if (this.startFieldLabel.getWidth() > n6) {
            n6 = this.startFieldLabel.getWidth();
        }
        this.endTableLabel.setBounds(n, n2, this.endTableLabel.getWidth(), n5);
        n2 += this.endTableLabel.getHeight() + 5;
        if (this.endTableLabel.getWidth() > n6) {
            n6 = this.endTableLabel.getWidth();
        }
        this.endFieldLabel.setBounds(n, n2, this.endFieldLabel.getWidth(), n5);
        n2 += this.endFieldLabel.getHeight() + 5;
        if (this.endFieldLabel.getWidth() > n6) {
            n6 = this.endFieldLabel.getWidth();
        }
        n3 = this.getWidth() - insets.right - (n += n6 + 5);
        this.startTableComboBox.setBounds(n, this.startTableLabel.getY(), n3, n5);
        this.startFieldTextField.setBounds(n, this.startFieldLabel.getY(), n3, n5);
        this.endTableComboBox.setBounds(n, this.endTableLabel.getY(), n3, n5);
        this.endFieldTextField.setBounds(n, this.endFieldLabel.getY(), n3, n5);
        n = this.getWidth() - insets.right - this.okayButton.getWidth() - 5 - this.cancelButton.getWidth();
        n2 = this.endFieldLabel.getY() + this.endFieldLabel.getHeight() + 5;
        this.okayButton.setLocation(n, n2);
        this.cancelButton.setLocation(n += this.okayButton.getWidth() + 5, n2);
    }

    public boolean isEditingJoin() {
        return this.joinToEdit != null;
    }

    public void setJoinToEdit(CcJoinSubNode ccJoinSubNode, CcJoinSubNode ccJoinSubNode2, boolean bl) {
        this.joinToEdit = ccJoinSubNode;
        this.nextJoin = ccJoinSubNode2;
        if (ccJoinSubNode != null) {
            CcJoinRecord ccJoinRecord = ccJoinSubNode.getJoinRecord();
            if (ccJoinRecord.getStartTable() != null) {
                this.startTableComboBox.setSelectedItem(ccJoinRecord.getStartTable());
            } else if (this.startTableComboBox.getItemCount() > 0) {
                this.startTableComboBox.setSelectedIndex(0);
            }
            this.startFieldTextField.setText(ccJoinRecord.getStartFieldName() == null ? "" : ccJoinRecord.getStartFieldName());
            if (ccJoinRecord.getEndTable() != null) {
                this.endTableComboBox.setSelectedItem(ccJoinRecord.getEndTable());
            } else if (this.endTableComboBox.getItemCount() > 0) {
                this.endTableComboBox.setSelectedIndex(0);
            }
            this.endFieldTextField.setText(ccJoinRecord.getEndFieldName() == null ? "" : ccJoinRecord.getEndFieldName());
            this.validateTableSelections();
            this.startTableComboBox.setEnabled(bl);
        }
    }

    public CcJoinSubNode getEditedJoin() {
        return this.joinToEdit;
    }

    public CcJoinSubNode getNextJoin() {
        return this.nextJoin;
    }

    protected void applyJoinEdits() {
        if (this.joinToEdit != null) {
            CcJoinRecord ccJoinRecord = this.joinToEdit.getJoinRecord();
            ccJoinRecord.setStartTable((CcTableRecord)this.startTableComboBox.getSelectedItem());
            ccJoinRecord.setStartFieldName(this.startFieldTextField.getText());
            ccJoinRecord.setEndTable((CcTableRecord)this.endTableComboBox.getSelectedItem());
            ccJoinRecord.setEndFieldName(this.endFieldTextField.getText());
            try {
                this.mainEditComponent.manager.hasChanged = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.joinToEdit.setNodeName();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        CcJoinEditPanel.debugOut("Received command: " + string);
        if (string.equals(OKAY_COMMAND)) {
            if (!this.verifyJoinEdits()) {
                return;
            }
            this.applyJoinEdits();
            this.mainEditComponent.applyJoinEdits();
            if (this.mainEditComponent.getManager().getJoinsType() == 2) {
                this.startTableComboBox.setEnabled(false);
            }
        } else if (string.equals(CANCEL_COMMAND)) {
            this.mainEditComponent.cancelEditJoin();
            if (this.mainEditComponent.getManager().getJoinsType() == 2) {
                this.startTableComboBox.setEnabled(false);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.startFieldTextField.getDocument() || documentEvent.getDocument() == this.endFieldTextField.getDocument()) {
            this.okayButton.setEnabled(this.startFieldTextField.getText().length() > 0 && this.endFieldTextField.getText().length() > 0);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.startFieldTextField.getDocument() || documentEvent.getDocument() == this.endFieldTextField.getDocument()) {
            this.okayButton.setEnabled(this.startFieldTextField.getText().length() > 0 && this.endFieldTextField.getText().length() > 0);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.endFieldTextField && keyEvent.getKeyCode() == 10) {
            this.okayButton.doClick();
            keyEvent.consume();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && itemEvent.getItemSelectable() instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
            if (jComboBox == this.endTableComboBox && this.mainEditComponent.getManager().getJoinsType() == 2) {
                this.validateTableSelections();
            } else if (jComboBox == this.startTableComboBox && this.mainEditComponent.getManager().getJoinsType() == 1) {
                this.validateTableSelections();
            }
        }
    }

    protected void validateTableSelections() {
        if (this.mainEditComponent.getManager().getJoinsType() == 2) {
            this.validateEndTableSelections();
        } else {
            this.validateStartTableSelections();
        }
    }

    private void validateStartTableSelections() {
        if (this.startTableComboBox.getSelectedItem().equals(this.endTableComboBox.getSelectedItem())) {
            if (this.lastTableSelection != null && !this.lastTableSelection.equals(this.endTableComboBox.getSelectedItem())) {
                this.startTableComboBox.setSelectedItem(this.lastTableSelection);
            } else if (this.startTableComboBox.getItemCount() > 1) {
                this.startTableComboBox.setSelectedIndex(this.endTableComboBox.getSelectedIndex() == 0 ? 1 : 0);
            }
        }
        this.lastTableSelection = (CcTableRecord)this.startTableComboBox.getSelectedItem();
    }

    private void validateEndTableSelections() {
        if (this.startTableComboBox.getSelectedItem().equals(this.endTableComboBox.getSelectedItem())) {
            if (this.lastTableSelection != null && !this.lastTableSelection.equals(this.startTableComboBox.getSelectedItem())) {
                this.endTableComboBox.setSelectedItem(this.lastTableSelection);
            } else if (this.endTableComboBox.getItemCount() > 1) {
                this.endTableComboBox.setSelectedIndex(this.startTableComboBox.getSelectedIndex() == 0 ? 1 : 0);
            }
        }
        this.lastTableSelection = (CcTableRecord)this.endTableComboBox.getSelectedItem();
    }

    protected JComboBox createTableComboBox() {
        JComboBox<Object> jComboBox = this.mainEditComponent.getManager().getTables() instanceof Vector ? new JComboBox((Vector)this.mainEditComponent.getManager().getTables()) : new JComboBox<Object>(this.mainEditComponent.getManager().getTables().toArray());
        jComboBox.setSize(jComboBox.getPreferredSize());
        jComboBox.doLayout();
        return jComboBox;
    }

    protected JTextField createTextField() {
        final JTextField jTextField = new JTextField();
        jTextField.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.black), new EmptyBorder(0, 2, 0, 0)));
        jTextField.getDocument().addDocumentListener(this);
        jTextField.addKeyListener(this);
        jTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                jTextField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        return jTextField;
    }

    protected JButton createButton(String string, String string2) {
        JButton jButton = new JButton(string);
        jButton.setSize(jButton.getPreferredSize());
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        return jButton;
    }

    protected JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setSize(jLabel.getPreferredSize());
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        return jLabel;
    }

    protected boolean verifyJoinEdits() {
        if (this.mainEditComponent.getManager().getJoinsType() == 2) {
            CcTableRecord ccTableRecord;
            CcTableRecord ccTableRecord2 = (CcTableRecord)this.endTableComboBox.getSelectedItem();
            if (ccTableRecord2 != null && this.mainEditComponent.findNodeWithEndEquals(ccTableRecord2) != null) {
                InsightAdministrator.showWarningDialog(this, "Join cannot be created. End table already exists", "Join Validation Warning");
                return false;
            }
            if (this.startTableComboBox.isEnabled() && (ccTableRecord = (CcTableRecord)this.startTableComboBox.getSelectedItem()) != null && this.mainEditComponent.findNodeWithEndEquals(ccTableRecord) != null) {
                InsightAdministrator.showWarningDialog(this, "Join cannot be created. Start table already exists", "Join Validation Warning");
                return false;
            }
        }
        return true;
    }
}

