/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.inscribe;

import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.NodeChild;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.inscribe.CcMedeProfile;
import com.luna.insight.admin.collserver.inscribe.CcMedeProfileNode;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CcMedeProfileNodeChild
extends TableDisplayControlPanelNode
implements ActionListener,
NodeChild {
    protected CollectionServerNode collectionServerNode = null;
    protected int highestProfileId = 0;
    protected int collectionId = -1;
    protected boolean supportsMpd = true;
    protected boolean supportsMede = true;

    public CcMedeProfileNodeChild(InsightAdministrator insightAdministrator, CcMedeProfileNode ccMedeProfileNode, int n, String string, boolean bl) {
        super(insightAdministrator, string, bl);
        this.collectionId = n;
        this.name = string;
        this.collectionServerNode = ccMedeProfileNode.getCollectionServerNode();
        this.columnNames = new Object[]{"ProfileID", "Profile Name", "Approval Level", "Read", "Edit", "Add", "Delete", "Record Mapping", "Media Mapping"};
    }

    public int getDeterminantIndex() {
        return this.collectionId;
    }

    public void updateInformationDisplay() {
        if (this.tableModel == null) {
            this.createInformationModel();
        }
        this.tableModel.setDataVector(this.getTableData(this.collectionServerNode.getCollectionServer().getMedeProfiles(this.collectionId)), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        if (vector.size() == 0) {
            this.supportsMpd = this.collectionServerNode.getCollectionServer().getCollectionServerConnector().getSupportsMpd();
        }
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CcMedeProfile ccMedeProfile = (CcMedeProfile)vector.elementAt(i);
            this.supportsMpd = ccMedeProfile.getSupportsMpd();
            objectArray[i][0] = ccMedeProfile;
            this.highestProfileId = Math.max(this.highestProfileId, Integer.parseInt(ccMedeProfile.toString()));
            objectArray[i][1] = ccMedeProfile.getDisplayName();
            objectArray[i][2] = ccMedeProfile.getApprovalLevel() + "";
            objectArray[i][3] = new Boolean(ccMedeProfile.hasMedePermission(1));
            objectArray[i][4] = new Boolean(ccMedeProfile.hasMedePermission(3));
            objectArray[i][5] = new Boolean(ccMedeProfile.hasMedePermission(5));
            objectArray[i][6] = new Boolean(ccMedeProfile.hasMedePermission(9));
            objectArray[i][7] = new Boolean(ccMedeProfile.hasMedePermission(17));
            objectArray[i][8] = new Boolean(ccMedeProfile.hasMedePermission(33));
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        return null;
    }

    public boolean hasReadPermission() {
        return this.collectionServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-profiles-node-child-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Edit");
        jMenuItem.setActionCommand("Edit MEDE Profile Command");
        jMenuItem.addActionListener(actionListener);
        if (n != 1) {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("Edit MEDE Profile Command")) {
            CcMedeProfileNodeChild.debugOut("in actionPerformed, CollectionServerNode.COMMAND_EDIT_PROFILE_MEDE");
            if (vector != null && vector.size() == 1) {
                this.collectionServerNode.editProfileMede((CcMedeProfile)vector.firstElement());
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void defaultItemAction(Object object) {
        if (object != null && object instanceof EditableDataObject) {
            this.collectionServerNode.editProfileMede((CcMedeProfile)object);
        }
    }

    public String toString() {
        return this.name;
    }

    public static void debugOut(String string) {
        CcMedeProfileNodeChild.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMedeProfileNodeChild: " + string, n);
    }
}

