/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.inscribe;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.catalog.CatalogTemplate;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.admin.collserver.field.CollectionServerFieldTableInfo;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityRelationshipEditComponent;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityType;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CcMedeEntityRelationship
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected int entityTypeID;
    protected int relEntityTypeID;
    protected int joinID = 0;
    protected int sourceMapTableID = 0;
    protected boolean publishRelatedMedia = false;
    protected int relatedEntitiesAllowed = 0;
    protected CatalogTemplate catalogTemplate;
    protected CollectionServerConnector serverConnector;
    protected int originalEntityTypeID;
    protected int originalRelEntityTypeID;
    protected CcMedeEntityRelationshipEditComponent editComponent = null;
    private String entityTypeName;

    public CcMedeEntityRelationship(CollectionServerConnector collectionServerConnector, CatalogTemplate catalogTemplate, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.serverConnector = collectionServerConnector;
        this.catalogTemplate = catalogTemplate;
        this.entityTypeID = n;
        this.relEntityTypeID = n2;
        this.originalEntityTypeID = n;
        this.originalRelEntityTypeID = n2;
        this.joinID = n3;
        this.sourceMapTableID = n4;
        this.relatedEntitiesAllowed = n5;
        this.publishRelatedMedia = bl;
    }

    public CcMedeEntityRelationship(CollectionServerConnector collectionServerConnector, int n, int n2, CatalogTemplate catalogTemplate) {
        this.serverConnector = collectionServerConnector;
        this.catalogTemplate = catalogTemplate;
        this.entityTypeID = n;
        this.relEntityTypeID = n2;
        this.originalEntityTypeID = n;
        this.originalRelEntityTypeID = n2;
    }

    public CatalogTemplate getTemplate() {
        return this.catalogTemplate;
    }

    public void setEntityTypeName(String string) {
        this.entityTypeName = string;
    }

    public String toString() {
        return this.entityTypeName != null ? this.entityTypeName : this.getName();
    }

    public String getName() {
        return this.entityTypeID + "";
    }

    public int getIndex() {
        return this.entityTypeID;
    }

    public EditComponent getEditComponent() {
        String string;
        int n;
        Object object;
        this.editComponent = new CcMedeEntityRelationshipEditComponent();
        Vector vector = this.catalogTemplate.getServer().getMedeEntityTypes(this.catalogTemplate.getTemplateID());
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = ((CcMedeEntityType)vector.elementAt(i)).getIndex();
            String string2 = ((CcMedeEntityType)vector.elementAt(i)).getName();
            object = n2 + " - " + string2;
            this.editComponent.getEntityTypeComboBox().addItem(object);
            if (this.entityTypeID == n2) {
                this.editComponent.getEntityTypeComboBox().setSelectedItem(object);
            }
            this.editComponent.getRelEntityTypeComboBox().addItem("" + (String)object);
            if (this.relEntityTypeID != n2) continue;
            this.editComponent.getRelEntityTypeComboBox().setSelectedItem("" + (String)object);
        }
        this.editComponent.getJoinComboBox().addItem("None");
        Vector vector2 = this.serverConnector.fieldHandler.getTableNames();
        Vector vector3 = this.serverConnector.fieldHandler.getJoinNames(2);
        for (n = 0; n < vector3.size(); ++n) {
            object = (CollectionServerFieldTableInfo)vector3.elementAt(n);
            int n3 = ((CollectionServerFieldTableInfo)object).getTableId();
            string = ((CollectionServerFieldTableInfo)object).getName();
            String string3 = n3 + " - " + string;
            this.editComponent.getJoinComboBox().addItem(string3);
            if (this.joinID != n3) continue;
            this.editComponent.getJoinComboBox().setSelectedItem(string3);
        }
        this.editComponent.getSourceMapTableComboBox().addItem("None");
        for (n = 0; n < vector2.size(); ++n) {
            int n4 = ((CollectionServerFieldTableInfo)vector2.elementAt(n)).getTableId();
            String string4 = ((CollectionServerFieldTableInfo)vector2.elementAt(n)).getName();
            string = n4 + " - " + string4;
            this.editComponent.getSourceMapTableComboBox().addItem(string);
            if (this.sourceMapTableID != n4) continue;
            this.editComponent.getSourceMapTableComboBox().setSelectedItem(string);
        }
        this.editComponent.getPublishRelatedMediaCheckBox().setSelected(this.publishRelatedMedia);
        this.editComponent.getRelatedEntitiesAllowedField().setText(this.relatedEntitiesAllowed + "");
        return this.editComponent;
    }

    public void save() {
        CcMedeEntityRelationship.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.joinID == 0) {
            this.joinID = this.catalogTemplate.getServer().getCollectionServerConnector().getNextJoinID();
        }
        if (this.sourceMapTableID == 0) {
            this.sourceMapTableID = this.catalogTemplate.getServer().getCollectionServerConnector().getNextValidTableRecordID();
        }
        String string = (String)this.editComponent.getEntityTypeComboBox().getSelectedItem();
        int n = this.entityTypeID;
        try {
            n = Integer.parseInt(string.substring(0, string.indexOf(32)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged("" + this.entityTypeID, "" + n)) {
            this.entityTypeID = n;
        }
        String string2 = (String)this.editComponent.getRelEntityTypeComboBox().getSelectedItem();
        int n2 = this.relEntityTypeID;
        try {
            n2 = Integer.parseInt(string2.substring(0, string2.indexOf(32)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged("" + this.relEntityTypeID, "" + n2)) {
            this.relEntityTypeID = n2;
        }
        String string3 = (String)this.editComponent.getJoinComboBox().getSelectedItem();
        int n3 = this.joinID;
        try {
            n3 = Integer.parseInt(string3.substring(0, string3.indexOf(32)));
        }
        catch (Exception exception) {
            n3 = 0;
        }
        if (this.hasChanged("" + this.joinID, "" + n3)) {
            this.joinID = n3;
        }
        String string4 = (String)this.editComponent.getSourceMapTableComboBox().getSelectedItem();
        int n4 = this.sourceMapTableID;
        try {
            n4 = Integer.parseInt(string4.substring(0, string4.indexOf(32)));
        }
        catch (Exception exception) {
            n4 = 0;
        }
        if (this.hasChanged("" + this.sourceMapTableID, "" + n4)) {
            this.sourceMapTableID = n4;
        }
        if (this.hasChanged(this.publishRelatedMedia, this.editComponent.getPublishRelatedMediaCheckBox().isSelected())) {
            this.publishRelatedMedia = this.editComponent.getPublishRelatedMediaCheckBox().isSelected();
        }
        try {
            if (this.hasChanged(this.relatedEntitiesAllowed, Integer.parseInt(this.editComponent.getRelatedEntitiesAllowedField().getText()))) {
                this.relatedEntitiesAllowed = Integer.parseInt(this.editComponent.getRelatedEntitiesAllowedField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.catalogTemplate.getServer().commitDataObject(this);
        } else {
            this.catalogTemplate.getServer().cancelEdit(this);
        }
    }

    public void cancel() {
        CcMedeEntityRelationship.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.catalogTemplate.getServer().cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Record Relationship";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return this.entityTypeID + "-" + this.relEntityTypeID;
    }

    public String getOriginalUniqueIdentifier() {
        return this.originalEntityTypeID + "-" + this.originalRelEntityTypeID;
    }

    public boolean equals(Object object) {
        if (object instanceof CcMedeEntityRelationship) {
            CcMedeEntityRelationship ccMedeEntityRelationship = (CcMedeEntityRelationship)object;
            return this.entityTypeID == ccMedeEntityRelationship.entityTypeID && this.relEntityTypeID == ccMedeEntityRelationship.relEntityTypeID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcMedeEntityRelationship) {
            CcMedeEntityRelationship ccMedeEntityRelationship = (CcMedeEntityRelationship)databaseRecord;
            return this.entityTypeID == ccMedeEntityRelationship.entityTypeID && this.relEntityTypeID == ccMedeEntityRelationship.relEntityTypeID && this.joinID == ccMedeEntityRelationship.joinID && this.sourceMapTableID == ccMedeEntityRelationship.sourceMapTableID && this.relatedEntitiesAllowed == ccMedeEntityRelationship.relatedEntitiesAllowed && this.publishRelatedMedia == ccMedeEntityRelationship.publishRelatedMedia;
        }
        return false;
    }

    public static void debugOut(String string) {
        CcMedeEntityRelationship.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMedeEntityRelationship: " + string, n);
    }
}

