/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.inscribe;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.catalog.CatalogTemplateNode;
import com.luna.insight.admin.collserver.field.CollectionServerField;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityField;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityType;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CcMedeEntityFieldsNode
extends TableDisplayControlPanelNode {
    protected CatalogTemplateNode catalogTemplateNode = null;

    public CcMedeEntityFieldsNode(CatalogTemplateNode catalogTemplateNode) {
        super(catalogTemplateNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), "Record Fields", false);
        this.catalogTemplateNode = catalogTemplateNode;
        this.columnNames = new Object[]{"Record Type", "Field Display Name", "Field Column Name", "Restriction Level", "Required", "Integer Range", "Allow Value List", "Approval To Add Value", "Allow Repeated Values", "Display In Related Records", "Validate New Values", "Hierarchy Column Name", "Hierarchy Node Column Name"};
    }

    public void updateInformationDisplay() {
        Integer n = this.catalogTemplateNode.getTemplate().getTemplateID();
        this.tableModel.setDataVector(this.getTableData(this.catalogTemplateNode.getCollectionServerNode().getCollectionServer().getEntityFields(n)), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Integer n = this.catalogTemplateNode.getTemplate().getTemplateID();
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        Vector vector2 = this.catalogTemplateNode.getCollectionServerNode().getCollectionServer().getMedeEntityTypes(n);
        Vector vector3 = this.catalogTemplateNode.getCollectionServerNode().getCollectionServer().getFields(n);
        for (int i = 0; i < vector.size(); ++i) {
            EditableDataObject editableDataObject;
            int n2;
            CcMedeEntityField ccMedeEntityField = (CcMedeEntityField)vector.elementAt(i);
            objectArray[i][0] = "";
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                editableDataObject = (CcMedeEntityType)vector2.elementAt(n2);
                if (ccMedeEntityField.entityTypeID != ((CcMedeEntityType)editableDataObject).getIndex()) continue;
                objectArray[i][0] = ((CcMedeEntityType)editableDataObject).getName();
                break;
            }
            objectArray[i][1] = "";
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                editableDataObject = (CollectionServerField)vector3.elementAt(n2);
                if (ccMedeEntityField.fieldID != ((CollectionServerField)editableDataObject).getIndex()) continue;
                objectArray[i][1] = ((CollectionServerField)editableDataObject).getDisplayName();
                break;
            }
            objectArray[i][2] = ccMedeEntityField;
            objectArray[i][3] = ccMedeEntityField.restrictionLevel + "";
            objectArray[i][4] = new Boolean(ccMedeEntityField.isRequired);
            objectArray[i][5] = ccMedeEntityField.integerRange;
            objectArray[i][6] = new Boolean(ccMedeEntityField.valueListAllowed);
            objectArray[i][7] = ccMedeEntityField.minApprovalToAddValue + "";
            objectArray[i][8] = new Boolean(ccMedeEntityField.repeatedValuesAllowed);
            objectArray[i][9] = new Boolean(ccMedeEntityField.displayInRelatedEntities);
            objectArray[i][10] = new Boolean(ccMedeEntityField.alwaysValidateNewValues);
            objectArray[i][11] = ccMedeEntityField.hierarchyIDColumnName;
            objectArray[i][12] = ccMedeEntityField.hierarchyNodeIDColumnName;
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        return null;
    }

    public boolean hasReadPermission() {
        return this.catalogTemplateNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.catalogTemplateNode.getCollectionServerNode().getAdminAccount(), null, "Edit Entity Field Command", null);
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("Edit Entity Field Command") && vector != null && vector.size() == 1) {
            this.catalogTemplateNode.getCollectionServerNode().editEntityField((CcMedeEntityField)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.catalogTemplateNode.getCollectionServerNode().editEntityField((CcMedeEntityField)object);
        }
    }

    public static void debugOut(String string) {
        CcMedeEntityFieldsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMedeEntityFieldsNode: " + string, n);
    }
}

