/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.inscribe;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.catalog.CatalogTemplate;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityFieldEditComponent;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityType;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CcMedeEntityField
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected CatalogTemplate catalogTemplate;
    protected int entityTypeID;
    protected int fieldID;
    protected int joinID;
    protected int fieldTableID = -1;
    protected String fieldValueColumnName;
    protected String preferredValueColumnName;
    protected int restrictionLevel = 0;
    protected boolean isRequired = false;
    protected String integerRange = "";
    protected boolean valueListAllowed = false;
    protected int minApprovalToAddValue = 0;
    protected boolean repeatedValuesAllowed = false;
    protected boolean displayInRelatedEntities = true;
    protected boolean alwaysValidateNewValues = false;
    protected String hierarchyIDColumnName;
    protected String hierarchyNodeIDColumnName;
    protected int originalEntityTypeID;
    protected int originalFieldID;
    protected CcMedeEntityFieldEditComponent editComponent = null;

    public CcMedeEntityField(CatalogTemplate catalogTemplate, int n, int n2, int n3, int n4, String string, String string2, int n5, boolean bl, String string3, boolean bl2, int n6, boolean bl3, boolean bl4, boolean bl5, String string4, String string5) {
        this.catalogTemplate = catalogTemplate;
        this.entityTypeID = n;
        this.originalEntityTypeID = n;
        this.fieldID = n2;
        this.originalFieldID = n2;
        this.joinID = n3;
        this.fieldTableID = n4;
        this.restrictionLevel = n5;
        this.isRequired = bl;
        this.valueListAllowed = bl2;
        this.minApprovalToAddValue = n6;
        this.repeatedValuesAllowed = bl3;
        this.fieldValueColumnName = string == null ? "" : string;
        this.preferredValueColumnName = string2 == null ? "" : string2;
        this.integerRange = string3 == null ? "" : string3;
        this.displayInRelatedEntities = bl4;
        this.alwaysValidateNewValues = bl5;
        this.hierarchyIDColumnName = string4 == null ? "" : string4;
        this.hierarchyNodeIDColumnName = string5 == null ? "" : string5;
    }

    public CcMedeEntityField(int n, int n2, CatalogTemplate catalogTemplate) {
        this.catalogTemplate = catalogTemplate;
        this.entityTypeID = n;
        this.fieldID = n2;
    }

    public CatalogTemplate getTemplate() {
        return this.catalogTemplate;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.fieldValueColumnName;
    }

    public int getIndex() {
        return this.fieldID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CcMedeEntityFieldEditComponent();
        Vector vector = this.catalogTemplate.getServer().getMedeEntityTypes(this.catalogTemplate.getTemplateID());
        for (int i = 0; i < vector.size(); ++i) {
            int n = ((CcMedeEntityType)vector.elementAt(i)).getIndex();
            String string = ((CcMedeEntityType)vector.elementAt(i)).getName();
            String string2 = n + " - " + string;
            this.editComponent.getEntityTypeComboBox().addItem(string2);
            if (this.entityTypeID != n) continue;
            this.editComponent.getEntityTypeComboBox().setSelectedItem(string2);
        }
        this.editComponent.getFieldColumnNameField().setText(this.fieldValueColumnName);
        this.editComponent.getPreferredValueColumnNameField().setText(this.preferredValueColumnName);
        this.editComponent.getRestrictionLevelField().setText(this.restrictionLevel + "");
        this.editComponent.getRequiredCheckBox().setSelected(this.isRequired);
        this.editComponent.getIntegerRangeField().setText(this.integerRange);
        this.editComponent.getValueListAllowedCheckBox().setSelected(this.valueListAllowed);
        this.editComponent.getMinApprovalNewValuesField().setText(this.minApprovalToAddValue + "");
        this.editComponent.getRepeatValuesAllowedCheckBox().setSelected(this.repeatedValuesAllowed);
        this.editComponent.getRestrictionLevelField().selectAll();
        this.editComponent.getRestrictionLevelField().requestFocus();
        this.editComponent.getDisplayInRelatedEntitiesCheckBox().setSelected(this.displayInRelatedEntities);
        this.editComponent.getAlwaysValidateNewValuesCheckBox().setSelected(this.alwaysValidateNewValues);
        this.editComponent.getHierarchyIDColumnNameField().setText(this.hierarchyIDColumnName);
        this.editComponent.getHierarchyNodeIDColumnNameField().setText(this.hierarchyNodeIDColumnName);
        return this.editComponent;
    }

    public void save() {
        String string;
        String string2;
        String string3;
        String string4;
        CcMedeEntityField.debugOut("Save...", 3);
        this.requiresCommit = false;
        String string5 = (String)this.editComponent.getEntityTypeComboBox().getSelectedItem();
        int n = this.entityTypeID;
        try {
            n = Integer.parseInt(string5.substring(0, string5.indexOf(32)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged("" + this.entityTypeID, "" + n)) {
            this.entityTypeID = n;
        }
        if ((string4 = this.editComponent.getFieldColumnNameField().getText()) == null) {
            string4 = "";
        }
        if (this.hasChanged(this.fieldValueColumnName, string4)) {
            this.fieldValueColumnName = string4;
        }
        if ((string3 = this.editComponent.getPreferredValueColumnNameField().getText()) == null) {
            string3 = "";
        }
        if (this.hasChanged(this.preferredValueColumnName, string3)) {
            this.preferredValueColumnName = string3;
        }
        try {
            if (this.hasChanged(this.restrictionLevel, Integer.parseInt(this.editComponent.getRestrictionLevelField().getText()))) {
                this.restrictionLevel = Integer.parseInt(this.editComponent.getRestrictionLevelField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.isRequired, this.editComponent.getRequiredCheckBox().isSelected())) {
            this.isRequired = this.editComponent.getRequiredCheckBox().isSelected();
        }
        if (this.hasChanged(this.integerRange, this.editComponent.getIntegerRangeField().getText())) {
            this.integerRange = this.editComponent.getIntegerRangeField().getText();
        }
        if (this.hasChanged(this.valueListAllowed, this.editComponent.getValueListAllowedCheckBox().isSelected())) {
            this.valueListAllowed = this.editComponent.getValueListAllowedCheckBox().isSelected();
        }
        try {
            if (this.hasChanged(this.minApprovalToAddValue, Integer.parseInt(this.editComponent.getMinApprovalNewValuesField().getText()))) {
                this.minApprovalToAddValue = Integer.parseInt(this.editComponent.getMinApprovalNewValuesField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.repeatedValuesAllowed, this.editComponent.getRepeatValuesAllowedCheckBox().isSelected())) {
            this.repeatedValuesAllowed = this.editComponent.getRepeatValuesAllowedCheckBox().isSelected();
        }
        if (this.hasChanged(this.displayInRelatedEntities, this.editComponent.getDisplayInRelatedEntitiesCheckBox().isSelected())) {
            this.displayInRelatedEntities = this.editComponent.getDisplayInRelatedEntitiesCheckBox().isSelected();
        }
        if (this.hasChanged(this.alwaysValidateNewValues, this.editComponent.getAlwaysValidateNewValuesCheckBox().isSelected())) {
            this.alwaysValidateNewValues = this.editComponent.getAlwaysValidateNewValuesCheckBox().isSelected();
        }
        if ((string2 = this.editComponent.getHierarchyIDColumnNameField().getText()) == null) {
            string2 = "";
        }
        if (this.hasChanged(this.hierarchyIDColumnName, string2)) {
            this.hierarchyIDColumnName = string2;
        }
        if ((string = this.editComponent.getHierarchyNodeIDColumnNameField().getText()) == null) {
            string = "";
        }
        if (this.hasChanged(this.hierarchyNodeIDColumnName, string)) {
            this.hierarchyNodeIDColumnName = string;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.catalogTemplate.getServer().commitDataObject(this);
        } else {
            this.catalogTemplate.getServer().cancelEdit(this);
        }
    }

    public void cancel() {
        CcMedeEntityField.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.catalogTemplate.getServer().cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Record Field - " + this.getName();
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return this.entityTypeID + "-" + this.fieldID;
    }

    public String getOriginalUniqueIdentifier() {
        return this.originalEntityTypeID + "-" + this.originalFieldID;
    }

    public boolean equals(Object object) {
        if (object instanceof CcMedeEntityField) {
            CcMedeEntityField ccMedeEntityField = (CcMedeEntityField)object;
            return this.entityTypeID == ccMedeEntityField.entityTypeID && this.fieldID == ccMedeEntityField.fieldID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcMedeEntityField) {
            CcMedeEntityField ccMedeEntityField = (CcMedeEntityField)databaseRecord;
            return this.entityTypeID == ccMedeEntityField.entityTypeID && this.fieldID == ccMedeEntityField.fieldID && this.joinID == ccMedeEntityField.joinID && CcMedeEntityField.stringsAreEqual(this.fieldValueColumnName, ccMedeEntityField.fieldValueColumnName) && CcMedeEntityField.stringsAreEqual(this.preferredValueColumnName, ccMedeEntityField.preferredValueColumnName) && this.restrictionLevel == ccMedeEntityField.restrictionLevel && this.isRequired == ccMedeEntityField.isRequired && CcMedeEntityField.stringsAreEqual(this.integerRange, ccMedeEntityField.integerRange) && this.valueListAllowed == ccMedeEntityField.valueListAllowed && this.minApprovalToAddValue == ccMedeEntityField.minApprovalToAddValue && this.repeatedValuesAllowed == ccMedeEntityField.repeatedValuesAllowed && this.displayInRelatedEntities == ccMedeEntityField.displayInRelatedEntities && this.alwaysValidateNewValues == ccMedeEntityField.alwaysValidateNewValues && CcMedeEntityField.stringsAreEqual(this.hierarchyIDColumnName, ccMedeEntityField.hierarchyIDColumnName) && CcMedeEntityField.stringsAreEqual(this.hierarchyNodeIDColumnName, ccMedeEntityField.hierarchyNodeIDColumnName);
        }
        return false;
    }

    public static void debugOut(String string) {
        CcMedeEntityField.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMedeEntityField: " + string, n);
    }
}

