/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.inscribe;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.inscribe.CcMedeApprovalLevelsEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class CcMedeApprovalLevels
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected Integer uniqueCollectionID;
    protected Collection collection;
    protected int invertedDataApprovalLevel = -1;
    protected int sourceDataApprovalLevel = -1;
    protected int originalInvertedDataApprovalLevel = -1;
    protected int originalSourceDataApprovalLevel = -1;
    protected CcMedeApprovalLevelsEditComponent editComponent = null;

    public CcMedeApprovalLevels(Integer n, Collection collection) {
        this.uniqueCollectionID = n;
        this.collection = collection;
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.invertedDataApprovalLevel + " ";
    }

    public int getIndex() {
        return -1;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CcMedeApprovalLevelsEditComponent();
        this.editComponent.getInvertedDataApprovalLevelField().setText("" + this.invertedDataApprovalLevel);
        this.editComponent.getSourceDataApprovalLevelField().setText("" + this.sourceDataApprovalLevel);
        this.editComponent.getInvertedDataApprovalLevelField().selectAll();
        this.editComponent.getInvertedDataApprovalLevelField().requestFocus();
        return this.editComponent;
    }

    public void save() {
        CcMedeApprovalLevels.debugOut("Save...", 3);
        this.requiresCommit = false;
        try {
            if (this.hasChanged(this.invertedDataApprovalLevel + "", this.editComponent.getInvertedDataApprovalLevelField().getText() + "")) {
                this.invertedDataApprovalLevel = Integer.parseInt(this.editComponent.getInvertedDataApprovalLevelField().getText());
            }
        }
        catch (Exception exception) {
            this.invertedDataApprovalLevel = -1;
        }
        try {
            if (this.hasChanged(this.sourceDataApprovalLevel + "", this.editComponent.getSourceDataApprovalLevelField().getText() + "")) {
                this.sourceDataApprovalLevel = Integer.parseInt(this.editComponent.getSourceDataApprovalLevelField().getText());
            }
        }
        catch (Exception exception) {
            this.sourceDataApprovalLevel = -1;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collection.getServer().commitDataObject(this);
        } else {
            this.collection.getServer().cancelEdit(this);
        }
    }

    public void cancel() {
        CcMedeApprovalLevels.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collection.getServer().cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Inscribe Approval Levels";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "approval-levels";
    }

    public String getOriginalUniqueIdentifier() {
        return "approval-levels";
    }

    public boolean equals(Object object) {
        if (object instanceof CcMedeApprovalLevels) {
            CcMedeApprovalLevels ccMedeApprovalLevels = (CcMedeApprovalLevels)object;
            return this.invertedDataApprovalLevel == ccMedeApprovalLevels.invertedDataApprovalLevel && this.sourceDataApprovalLevel == ccMedeApprovalLevels.sourceDataApprovalLevel;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcMedeApprovalLevels) {
            CcMedeApprovalLevels ccMedeApprovalLevels = (CcMedeApprovalLevels)databaseRecord;
            return this.invertedDataApprovalLevel == ccMedeApprovalLevels.invertedDataApprovalLevel && this.sourceDataApprovalLevel == ccMedeApprovalLevels.sourceDataApprovalLevel;
        }
        return false;
    }

    public static void debugOut(String string) {
        CcMedeApprovalLevels.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMedeApprovalLevels: " + string, n);
    }
}

