/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.indexer;

import com.luna.insight.admin.AdminDesktopPane;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.VerticalStackResizeWidthLayout;
import com.luna.insight.admin.collserver.field.CollectionServerField;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.client.IntegerDocument;
import com.luna.insight.client.layouts.NoResizeCenterLayout;
import com.luna.insight.server.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class CsTasksInvokeIndexerDisplay
extends JInternalFrame
implements ActionListener,
ItemListener {
    private static final String COLLECTION_SERVER_FIELD_KEY = "CollectionServerField";
    public static final String DEFAULT_DIACRITICSFILE = "DiacriticMappings.dat";
    protected InsightAdministrator insightAdministrator = null;
    protected Vector mpdsToIndex = null;
    protected Vector fieldsToIndex = null;
    protected boolean isInscribeSetting = false;
    protected Vector fieldsToIndexCheckBoxes = new Vector(0);
    protected CcTaskItem taskItem;
    protected File diacriticsFile = null;
    protected JCheckBox selectAllFieldsCheckBox = new JCheckBox("Select All");
    protected JCheckBox normalIndexingCheckBox = new JCheckBox("Normal Indexing");
    protected JCheckBox valueIndexingCheckBox = new JCheckBox("Value Indexing");
    protected JCheckBox termIndexingCheckBox = new JCheckBox("Term Indexing");
    protected JCheckBox incrementalIndexingCheckBox = new JCheckBox("Incremental");
    protected JCheckBox browserIndexingCheckBox = new JCheckBox("Browser Indexing");
    protected JCheckBox insertLoadingCheckBox = new JCheckBox("Insert Data Into Database");
    protected JCheckBox bulkLoadingCheckBox = new JCheckBox("Create Files For Bulk Loading");
    protected JLabel bulkFileLabel = new JLabel("File Path: ");
    protected JTextField bulkFileField = new JTextField();
    protected String bulkFilePathname = null;
    protected JButton browseBulkButton = new JButton("Browse");
    protected JCheckBox hierarchyIndexingCheckBox = new JCheckBox("Hierarchy Indexing");
    protected JCheckBox mpdGenerationCheckBox = new JCheckBox("Multi-page Document Generation");
    protected JCheckBox fuzzyDateIndexingCheckBox = new JCheckBox("Fuzzy Date Indexing");
    protected JCheckBox updateThumbnailCachesCheckBox = new JCheckBox("Update Thumbnail Caches");
    protected JLabel serverHostLabel = new JLabel("Server Host: ");
    protected JTextField serverHost = new JTextField(10);
    protected JLabel serverPortLabel = new JLabel("Server Port: ");
    protected JTextField serverPort = new JTextField(4);
    protected JList mpdList = new JList();
    protected JLabel selectDocsLabel = new JLabel("Select documents to generate: ");
    protected JCheckBox automaticallyPostChangesCheckBox = new JCheckBox("Automatically Post Changes Without Confirmation");
    protected JCheckBox saveTemporaryTablesCheckBox = new JCheckBox("Save Temporary Tables");
    protected JTextField diacriticsFileTextField = new JTextField();
    protected JButton browseDiacriticsButton = new JButton("Browse");
    protected JLabel diacriticsFileLabel = new JLabel("Diacritics File:");
    protected JButton startButton = new JButton("Start Indexing");

    public static void debugOut(String string) {
        CsTasksInvokeIndexerDisplay.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsTasksInvokeIndexerDisplay: " + string, n);
    }

    public CsTasksInvokeIndexerDisplay(InsightAdministrator insightAdministrator, Vector vector, Vector vector2, boolean bl) {
        super(bl ? "Inscribe Indexer Setup" : "Insight Indexer Setup", true, true, true, true);
        this.insightAdministrator = insightAdministrator;
        this.mpdsToIndex = vector;
        this.fieldsToIndex = vector2;
        this.isInscribeSetting = bl;
        this.initComponents();
    }

    public void setTaskItem(CcTaskItem ccTaskItem) {
        this.taskItem = ccTaskItem;
    }

    public void dispose() {
        super.dispose();
        if (this.taskItem != null) {
            this.taskItem.setTaskItemCancelled();
        }
    }

    protected void initComponents() {
        JComponent jComponent;
        Object object;
        JPanel jPanel;
        JComponent jComponent2;
        JComponent jComponent3;
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder(this.isInscribeSetting ? "Record Indexing" : "Full Indexing"));
        jPanel4.add(this.valueIndexingCheckBox);
        jPanel4.add(this.termIndexingCheckBox);
        jPanel4.setSize(jPanel4.getPreferredSize());
        jPanel3.add((Component)jPanel4, "West");
        JLabel jLabel = new JLabel("- OR -");
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        jLabel.setSize(jLabel.getPreferredSize());
        if (!this.isInscribeSetting) {
            jComponent3 = new JPanel(new GridLayout(1, 1));
            jComponent3.setBorder(BorderFactory.createTitledBorder("Incremental Indexing"));
            jComponent3.add(this.incrementalIndexingCheckBox);
            jComponent3.setSize(jComponent3.getPreferredSize());
            jPanel3.add((Component)jComponent3, "East");
        }
        jPanel3.setSize(jPanel3.getPreferredSize());
        jPanel2.add(jPanel3);
        jComponent3 = new JSeparator();
        jComponent3.setSize(jComponent3.getPreferredSize());
        jPanel2.add(jComponent3);
        JPanel jPanel5 = new JPanel(new BorderLayout(0, 0));
        jPanel5.add((Component)this.insertLoadingCheckBox, "West");
        jPanel5.add((Component)this.bulkLoadingCheckBox, "West");
        JPanel jPanel6 = new JPanel(new BorderLayout(5, 5));
        jPanel6.add((Component)this.bulkFileLabel, "West");
        jPanel6.add((Component)this.bulkFileField, "Center");
        jPanel6.add((Component)this.browseBulkButton, "East");
        jPanel5.add(jPanel6);
        jPanel5.setLayout(new GridLayout(jPanel5.getComponentCount(), 1, 3, 3));
        jPanel5.setSize(jPanel5.getPreferredSize());
        jPanel2.add(jPanel5);
        jComponent3 = new JSeparator();
        jComponent3.setSize(jComponent3.getPreferredSize());
        jPanel2.add(jComponent3);
        if (!this.isInscribeSetting) {
            jComponent2 = new JLabel("Select fields to index:");
            jComponent2.setSize(jComponent2.getPreferredSize());
            this.selectAllFieldsCheckBox.setSize(this.selectAllFieldsCheckBox.getPreferredSize());
            jPanel = new JPanel(null);
            for (int i = 0; this.fieldsToIndex != null && i < this.fieldsToIndex.size(); ++i) {
                object = (CollectionServerField)this.fieldsToIndex.get(i);
                jComponent = new JCheckBox(((CollectionServerField)object).getDisplayName());
                jComponent.putClientProperty(COLLECTION_SERVER_FIELD_KEY, object);
                this.fieldsToIndexCheckBoxes.add(jComponent);
                jPanel.add(jComponent);
            }
            jPanel.setLayout(new GridLayout(jPanel.getComponentCount(), 1, 3, 3));
            jPanel.setSize(jPanel.getPreferredSize());
            this.selectAllFieldsCheckBox.addItemListener(this);
            this.selectAllFieldsCheckBox.setSelected(true);
            if (this.fieldsToIndexCheckBoxes.size() > 0) {
                JScrollPane jScrollPane = new JScrollPane(jPanel);
                jScrollPane.setVerticalScrollBarPolicy(20);
                jScrollPane.setSize(100, 100);
                jPanel2.add(jComponent2);
                jPanel2.add(this.selectAllFieldsCheckBox);
                jPanel2.add(jScrollPane);
            }
        }
        jComponent3 = new JSeparator();
        jComponent3.setSize(jComponent3.getPreferredSize());
        jPanel2.add(jComponent3);
        this.updateThumbnailCachesCheckBox.setSize(this.updateThumbnailCachesCheckBox.getPreferredSize());
        jPanel2.add(this.updateThumbnailCachesCheckBox);
        jComponent2 = new JPanel();
        jComponent2.add(this.serverHostLabel);
        jComponent2.add(this.serverHost);
        jComponent2.add(this.serverPortLabel);
        jComponent2.add(this.serverPort);
        this.serverPort.setDocument(new IntegerDocument());
        this.serverHost.setEnabled(false);
        this.serverPort.setEnabled(false);
        jComponent2.setSize(jComponent2.getPreferredSize());
        jPanel2.add(jComponent2);
        jComponent3 = new JSeparator();
        jComponent3.setSize(jComponent3.getPreferredSize());
        jPanel2.add(jComponent3);
        jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this.browserIndexingCheckBox, "West");
        jPanel.setSize(jPanel.getPreferredSize());
        jPanel2.add(jPanel);
        jComponent3 = new JSeparator();
        jComponent3.setSize(jComponent3.getPreferredSize());
        jPanel2.add(jComponent3);
        this.fuzzyDateIndexingCheckBox.setSize(this.fuzzyDateIndexingCheckBox.getPreferredSize());
        jPanel2.add(this.fuzzyDateIndexingCheckBox);
        this.mpdGenerationCheckBox.setSize(this.mpdGenerationCheckBox.getPreferredSize());
        jPanel2.add(this.mpdGenerationCheckBox);
        this.selectDocsLabel.setSize(this.selectDocsLabel.getPreferredSize());
        jPanel2.add(this.selectDocsLabel);
        this.mpdList = new JList();
        this.mpdList.setSelectionMode(2);
        if (this.mpdsToIndex != null && this.mpdsToIndex.size() > 0) {
            this.mpdList.setListData(this.mpdsToIndex);
        } else {
            this.mpdGenerationCheckBox.setEnabled(false);
            this.mpdGenerationCheckBox.setSelected(false);
            this.selectDocsLabel.setForeground(Color.gray);
            this.mpdList.setEnabled(false);
        }
        this.mpdList.doLayout();
        object = new JScrollPane(this.mpdList);
        ((JScrollPane)object).setVerticalScrollBarPolicy(20);
        ((JScrollPane)object).setHorizontalScrollBarPolicy(30);
        ((JComponent)object).setPreferredSize(new Dimension(100, 100));
        ((Component)object).setSize(100, 100);
        jPanel2.add((Component)object);
        jComponent3 = new JSeparator();
        jComponent3.setSize(jComponent3.getPreferredSize());
        jPanel2.add(jComponent3);
        jComponent = new JPanel(null);
        jComponent.setBorder(BorderFactory.createTitledBorder("Configuration Settings"));
        JPanel jPanel7 = new JPanel(new BorderLayout(5, 5));
        jPanel7.add((Component)this.diacriticsFileLabel, "West");
        jPanel7.add((Component)this.diacriticsFileTextField, "Center");
        jPanel7.add((Component)this.browseDiacriticsButton, "East");
        try {
            this.diacriticsFile = new File(DEFAULT_DIACRITICSFILE);
            this.diacriticsFileTextField.setText(DEFAULT_DIACRITICSFILE);
        }
        catch (Exception exception) {
            this.diacriticsFile = null;
        }
        jComponent.add(jPanel7);
        jComponent.add(this.automaticallyPostChangesCheckBox);
        jComponent.add(this.saveTemporaryTablesCheckBox);
        jComponent.setLayout(new GridLayout(jComponent.getComponentCount(), 1, 3, 3));
        jComponent.setSize(jComponent.getPreferredSize());
        jPanel2.add(jComponent);
        jPanel2.setLayout(new VerticalStackResizeWidthLayout(3));
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.getContentPane().setLayout(new BorderLayout());
        this.startButton.setSize(this.startButton.getPreferredSize());
        JPanel jPanel8 = new JPanel(new NoResizeCenterLayout());
        jPanel8.add(this.startButton);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel8, "South");
        this.normalIndexingCheckBox.addItemListener(this);
        this.valueIndexingCheckBox.addItemListener(this);
        this.termIndexingCheckBox.addItemListener(this);
        this.updateThumbnailCachesCheckBox.addItemListener(this);
        this.browserIndexingCheckBox.addItemListener(this);
        this.insertLoadingCheckBox.addItemListener(this);
        this.bulkLoadingCheckBox.addItemListener(this);
        this.incrementalIndexingCheckBox.addItemListener(this);
        this.mpdGenerationCheckBox.addItemListener(this);
        this.normalIndexingCheckBox.setSelected(true);
        this.valueIndexingCheckBox.setSelected(!this.isInscribeSetting);
        this.termIndexingCheckBox.setSelected(!this.isInscribeSetting);
        this.insertLoadingCheckBox.setSelected(true);
        this.bulkLoadingCheckBox.setSelected(false);
        this.bulkFileField.setEnabled(false);
        this.browseBulkButton.setEnabled(false);
        this.browserIndexingCheckBox.setSelected(true);
        this.fuzzyDateIndexingCheckBox.setSelected(true);
        this.mpdGenerationCheckBox.setSelected(false);
        this.browseDiacriticsButton.addActionListener(this);
        this.browseBulkButton.addActionListener(this);
    }

    public void show() {
        AdminDesktopPane adminDesktopPane = InsightAdministrator.getInsightAdministrator().getDesktop();
        adminDesktopPane.add(this);
        super.show();
    }

    public JCheckBox getNormalIndexingCheckBox() {
        return this.normalIndexingCheckBox;
    }

    public JCheckBox getValueIndexingCheckBox() {
        return this.valueIndexingCheckBox;
    }

    public JCheckBox getTermIndexingCheckBox() {
        return this.termIndexingCheckBox;
    }

    public JCheckBox getIncrementalIndexingCheckBox() {
        return this.incrementalIndexingCheckBox;
    }

    public JCheckBox getBrowserIndexingCheckBox() {
        return this.browserIndexingCheckBox;
    }

    public JCheckBox getInsertLoadingCheckBox() {
        return this.insertLoadingCheckBox;
    }

    public JCheckBox getBulkLoadingCheckBox() {
        return this.bulkLoadingCheckBox;
    }

    public JTextField getBulkFileField() {
        return this.bulkFileField;
    }

    public String getBulkFilePathname() {
        return this.bulkFilePathname;
    }

    public JButton getBrowseBulkButton() {
        return this.browseBulkButton;
    }

    public JCheckBox getHierarchyIndexingCheckBox() {
        return this.hierarchyIndexingCheckBox;
    }

    public JCheckBox getMultipageDocumentGenerationCheckBox() {
        return this.mpdGenerationCheckBox;
    }

    public JCheckBox getFuzzyDateIndexingCheckBox() {
        return this.fuzzyDateIndexingCheckBox;
    }

    public JCheckBox getUpdateThumbnailCachesCheckBox() {
        return this.updateThumbnailCachesCheckBox;
    }

    public JLabel getSelectDocsLabel() {
        return this.selectDocsLabel;
    }

    public JList getMultipageDocumentsList() {
        return this.mpdList;
    }

    public JCheckBox getAutomaticallyPostChangesCheckBox() {
        return this.automaticallyPostChangesCheckBox;
    }

    public JCheckBox getSaveTemporaryTablesCheckBox() {
        return this.saveTemporaryTablesCheckBox;
    }

    public JTextField getServerHost() {
        return this.serverHost;
    }

    public JTextField getServerPort() {
        return this.serverPort;
    }

    public JButton getStartButton() {
        return this.startButton;
    }

    public JTextField getDiacriticsFileTextField() {
        return this.diacriticsFileTextField;
    }

    public File getDiacriticsFile() {
        return this.diacriticsFile;
    }

    public JButton getBrowseDiacriticsButton() {
        return this.browseDiacriticsButton;
    }

    public int getMaxChars() {
        return 30;
    }

    public List getSelectedFieldIDs() {
        Vector<Integer> vector = new Vector<Integer>(0);
        for (int i = 0; this.fieldsToIndexCheckBoxes != null && i < this.fieldsToIndexCheckBoxes.size(); ++i) {
            CollectionServerField collectionServerField;
            JCheckBox jCheckBox = (JCheckBox)this.fieldsToIndexCheckBoxes.get(i);
            if (!jCheckBox.isSelected() || (collectionServerField = (CollectionServerField)jCheckBox.getClientProperty(COLLECTION_SERVER_FIELD_KEY)) == null) continue;
            vector.add(new Integer(collectionServerField.getFieldId()));
        }
        return vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        if (actionEvent.getSource() == this.browseDiacriticsButton) {
            serializable = new JFileChooser(this.diacriticsFileTextField.getText().length() > 0 ? this.diacriticsFileTextField.getText() : InsightAdministrator.FC_DIRECTORY_PATH);
            ((JFileChooser)serializable).setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file != null && (file.isDirectory() || file.getName().endsWith(".dat"));
                }

                public String getDescription() {
                    return "DiacriticMappings.dat File";
                }
            });
            int n = ((JFileChooser)serializable).showOpenDialog(this.insightAdministrator.getDesktop());
            if (n == 0) {
                InsightAdministrator.FC_DIRECTORY_PATH = ((JFileChooser)serializable).getCurrentDirectory().getAbsolutePath();
                this.diacriticsFile = ((JFileChooser)serializable).getSelectedFile();
                CsTasksInvokeIndexerDisplay.debugOut("diacriticsFile is: " + this.diacriticsFile);
            }
            if (this.diacriticsFile != null) {
                this.diacriticsFileTextField.setText(this.diacriticsFile.getAbsolutePath());
            }
        }
        if (actionEvent.getSource() == this.browseBulkButton) {
            serializable = new File(this.bulkFileField.getText().length() > 0 ? this.bulkFileField.getText() : InsightAdministrator.FC_DIRECTORY_PATH);
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setSelectedFile((File)serializable);
            int n = jFileChooser.showOpenDialog(this.insightAdministrator.getDesktop());
            if (n == 0) {
                this.bulkFilePathname = InsightAdministrator.FC_DIRECTORY_PATH = jFileChooser.getSelectedFile().getAbsolutePath();
            }
            if (this.bulkFilePathname != null) {
                this.bulkFileField.setText(this.bulkFilePathname);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.selectAllFieldsCheckBox) {
            for (int i = 0; i < this.fieldsToIndexCheckBoxes.size(); ++i) {
                ((JCheckBox)this.fieldsToIndexCheckBoxes.get(i)).setSelected(this.selectAllFieldsCheckBox.isSelected());
            }
        } else if (itemEvent.getSource() == this.mpdGenerationCheckBox) {
            this.mpdList.setEnabled(this.mpdGenerationCheckBox.isSelected());
        } else if (itemEvent.getSource() == this.normalIndexingCheckBox) {
            if (this.normalIndexingCheckBox.isSelected()) {
                this.valueIndexingCheckBox.setEnabled(true);
                this.termIndexingCheckBox.setEnabled(true);
                this.incrementalIndexingCheckBox.setSelected(false);
            } else {
                this.valueIndexingCheckBox.setSelected(false);
                this.termIndexingCheckBox.setSelected(false);
            }
        } else if (itemEvent.getSource() == this.incrementalIndexingCheckBox) {
            if (this.incrementalIndexingCheckBox.isSelected()) {
                this.normalIndexingCheckBox.setSelected(false);
                this.valueIndexingCheckBox.setEnabled(false);
                this.termIndexingCheckBox.setEnabled(false);
            } else {
                this.valueIndexingCheckBox.setEnabled(true);
                this.termIndexingCheckBox.setEnabled(true);
            }
        } else if (itemEvent.getSource() == this.valueIndexingCheckBox) {
            if (this.valueIndexingCheckBox.isSelected()) {
                this.normalIndexingCheckBox.setSelected(true);
            }
        } else if (itemEvent.getSource() == this.termIndexingCheckBox) {
            if (this.termIndexingCheckBox.isSelected()) {
                this.normalIndexingCheckBox.setSelected(true);
            }
        } else if (itemEvent.getSource() == this.insertLoadingCheckBox) {
            if (this.insertLoadingCheckBox.isSelected()) {
                if (this.bulkLoadingCheckBox.isSelected()) {
                    this.bulkLoadingCheckBox.setSelected(false);
                    this.bulkFileField.setEnabled(false);
                    this.browseBulkButton.setEnabled(false);
                }
            } else if (!this.bulkLoadingCheckBox.isSelected()) {
                this.bulkLoadingCheckBox.setSelected(true);
                this.bulkFileField.setEnabled(true);
                this.browseBulkButton.setEnabled(true);
            }
        } else if (itemEvent.getSource() == this.bulkLoadingCheckBox) {
            if (this.bulkLoadingCheckBox.isSelected()) {
                if (this.insertLoadingCheckBox.isSelected()) {
                    this.insertLoadingCheckBox.setSelected(false);
                    this.bulkFileField.setEnabled(true);
                    this.browseBulkButton.setEnabled(true);
                }
            } else if (!this.insertLoadingCheckBox.isSelected()) {
                this.insertLoadingCheckBox.setSelected(true);
                this.bulkFileField.setEnabled(false);
                this.browseBulkButton.setEnabled(false);
            }
        } else if (itemEvent.getSource() == this.updateThumbnailCachesCheckBox) {
            this.serverHost.setEnabled(this.updateThumbnailCachesCheckBox.isSelected());
            this.serverPort.setEnabled(this.updateThumbnailCachesCheckBox.isSelected());
        }
    }
}

