/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.indexer;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.admin.collserver.table.CsTableInfo;
import com.luna.insight.server.Debug;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Vector;

public class CsTasksIndexerRecordHandler {
    AdministeredServerConnector serverConnector = null;

    public CsTasksIndexerRecordHandler(CollectionServerConnector collectionServerConnector) {
        this.serverConnector = collectionServerConnector;
    }

    public Vector getMpdsToIndex(Integer n) {
        Vector<CsTableInfo> vector = new Vector<CsTableInfo>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("ISDOCUMENTS", null, new String[]{"DocumentID", "DocumentName"});
        sqlQueryGenerator.addJoin("ISDOCUMENTS", "TargetGroupID", "IRGROUPS", "GroupID", 0);
        sqlQueryGenerator.appendToWhere("IRGROUPS.UniqueCollectionID = " + n);
        sqlQueryGenerator.addOrderBy("ISDOCUMENTS", "DocumentID");
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        this.debugOut("mpdsToIndex query: \n" + databaseConnector.getQuery(), 3);
        databaseConnector.runQuery();
        if (databaseConnector.more()) {
            while (databaseConnector.more()) {
                int n2 = -1;
                String string = "";
                try {
                    n2 = databaseConnector.getIntegerFieldByName("DocumentID");
                    string = databaseConnector.getFieldByName("DocumentName");
                }
                catch (Exception exception) {
                    n2 = -1;
                    string = "";
                }
                if (n2 != -1) {
                    CsTableInfo csTableInfo = new CsTableInfo(n2, string);
                    vector.addElement(csTableInfo);
                }
                databaseConnector.next();
            }
        }
        databaseConnector.close();
        return vector;
    }

    public void setGenerateDocumentFlag(Object[] objectArray) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            int n = ((CsTableInfo)objectArray[i]).getTableId();
            string = "UPDATE ISDOCUMENTS SET GenerateDocument = 1 WHERE DocumentID = " + n + ";";
            databaseConnector.setQuery(string);
            this.debugOut("reset query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
        }
        databaseConnector.close();
    }

    public void resetGenerateDocumentFlag() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        String string = "UPDATE ISDOCUMENTS SET GenerateDocument = 0";
        databaseConnector.setQuery(string);
        this.debugOut("reset query: \n" + databaseConnector.getQuery(), 3);
        databaseConnector.runUpdateQuery();
        databaseConnector.close();
    }

    public DatabaseConnector getDatabaseConnector() {
        return this.serverConnector.getDatabaseConnector();
    }

    public SqlQueryGenerator getQueryGenerator() {
        return this.serverConnector.getQueryGenerator();
    }

    protected void debugOut(String string, int n) {
        Debug.debugOut("IndexerRecordHandler: " + string, n);
    }

    protected void debugOut(String string) {
        Debug.debugOut("IndexerRecordHandler: " + string, 3);
    }
}

