/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.indexer;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.SaveCancelController;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.backend.DatabaseConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class CsSetIndexerEditComponent
extends EditComponent
implements SaveCancelController {
    protected static final Dimension DEFAULT_SIZE = new Dimension(580, 390);
    protected CollectionServer server;
    private JCheckBox insightIndexerCheckBox;
    private JCheckBox inscribeIndexerCheckBox;
    private JLabel insightIndexerLabel1;
    private JLabel inscribeIndexerLabel1;
    private JLabel insightIndexerLabel2;
    private JLabel inscribeIndexerLabel2;

    public static void debugOut(String string) {
        CsSetIndexerEditComponent.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsSetIndexerEditComponent: " + string, n);
    }

    public CsSetIndexerEditComponent(CollectionServer collectionServer) {
        this.server = collectionServer;
        this.initComponents();
    }

    protected void initComponents() {
        this.insightIndexerCheckBox = new JCheckBox();
        this.inscribeIndexerCheckBox = new JCheckBox();
        this.insightIndexerLabel1 = new JLabel();
        this.inscribeIndexerLabel1 = new JLabel();
        this.insightIndexerLabel2 = new JLabel();
        this.inscribeIndexerLabel2 = new JLabel();
        this.setSize(DEFAULT_SIZE);
        this.setLayout(new GridBagLayout());
        this.insightIndexerCheckBox.setText("Insight Indexer");
        this.insightIndexerCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CsSetIndexerEditComponent.this.insightIndexerCheckBoxActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.insightIndexerCheckBox, gridBagConstraints);
        this.insightIndexerLabel1.setText("    - Indexes the source data for use in Insight only.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.insightIndexerLabel1, gridBagConstraints);
        this.insightIndexerLabel2.setText("      Data will not be available in Inscribe for editing.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.insightIndexerLabel2, gridBagConstraints);
        this.inscribeIndexerCheckBox.setText("Inscribe/Insight Indexer");
        this.inscribeIndexerCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CsSetIndexerEditComponent.this.inscribeIndexerCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.inscribeIndexerCheckBox, gridBagConstraints);
        this.inscribeIndexerLabel1.setText("    - Indexes the source data for use in Inscribe and Insight.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.inscribeIndexerLabel1, gridBagConstraints);
        this.inscribeIndexerLabel2.setText("      Inscribe Settings/ Record Types and Record Fields must be configured.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.inscribeIndexerLabel2, gridBagConstraints);
    }

    private void insightIndexerCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.inscribeIndexerCheckBox.setSelected(!this.insightIndexerCheckBox.isSelected());
    }

    private void inscribeIndexerCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.insightIndexerCheckBox.setSelected(!this.inscribeIndexerCheckBox.isSelected());
    }

    public void save() {
        CsSetIndexerEditComponent.debugOut("Save.", 3);
        boolean bl = this.inscribeIndexerCheckBox.isSelected();
        if (bl != this.server.getCollectionServerInscribeCompliant()) {
            DatabaseConnector databaseConnector = this.server.getCollectionServerConnector().getDatabaseConnector();
            StringBuffer stringBuffer = new StringBuffer().append("UPDATE ");
            this.server.getCollectionServerConnector();
            String string = stringBuffer.append("IRVERSION").append(" ").append("SET IsInscribeCompliant = ").append(bl ? "1" : "0").append(";").toString();
            databaseConnector.setQuery(string);
            CsSetIndexerEditComponent.debugOut("set Indexer query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            this.server.setCollectionServerInscribeCompliant(bl);
        }
        this.cancel();
    }

    public void cancel() {
        CsSetIndexerEditComponent.debugOut("Cancel.", 3);
        this.server.cancelEditSetIndexer();
    }

    public EditComponent getEditComponent() {
        this.inscribeIndexerCheckBox.setSelected(this.server.getCollectionServerInscribeCompliant());
        this.insightIndexerCheckBox.setSelected(!this.server.getCollectionServerInscribeCompliant());
        return this;
    }

    public String getWindowTitle() {
        return "Set Indexer Mode";
    }

    public ImageIcon getWindowIcon() {
        return IconMaker.createImage("images/collection-creation-indexer-icon.gif");
    }

    public String getSaveButtonText() {
        return "Save";
    }

    public String getCancelButtonText() {
        return "Cancel";
    }

    public boolean verify() {
        boolean bl = this.inscribeIndexerCheckBox.isSelected();
        if (bl != this.server.getCollectionServerInscribeCompliant() && !InsightAdministrator.getInsightAdministrator().showYesNoConfirmDialog("IMPORTANT: Changing the indexer mode may compromise the\nintegrity of the data stored in the Insight data tables.\nWould you still like to change the Indexer Mode Setting?", "Indexer Mode Change Alert")) {
            return false;
        }
        return super.verify();
    }
}

