/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.fieldstd;

import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardField;
import com.luna.insight.admin.manytomanymap.ManyToManyMapController;
import com.luna.insight.admin.manytomanymap.MappedThumbnail;
import com.luna.insight.server.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class CsStandardFieldThumbnail
extends MappedThumbnail {
    public static final Border UNSELECTED_BORDER = new MatteBorder(0, 0, 1, 0, Color.gray);
    public static final Color UNSELECTED_TEXT_COLOR = Color.black;
    public static Font UNSELECTED_FONT = null;
    public static final Border SELECTED_BORDER = BorderFactory.createLineBorder(Color.white, 1);
    public static final Color SELECTED_BKG_COLOR = Color.blue;
    public static final Color SELECTED_TEXT_COLOR = Color.white;
    public static Font SELECTED_FONT = null;
    public static final Border ANCHOR_BORDER = BorderFactory.createLineBorder(Color.white, 1);
    public static final Color ANCHOR_BKG_COLOR = Color.red;
    public static final Color ANCHOR_TEXT_COLOR = Color.white;
    protected CsFieldStandardField standardField;
    protected JLabel nameLabel = null;
    protected boolean isSelected = false;
    protected boolean isAnchor = false;

    public static void debugOut(String string) {
        CsStandardFieldThumbnail.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsStandardFieldThumbnail: " + string, n);
    }

    public CsStandardFieldThumbnail(ManyToManyMapController manyToManyMapController, CsFieldStandardField csFieldStandardField) {
        super(manyToManyMapController);
        this.standardField = csFieldStandardField;
        this.setLayout(new BorderLayout(0, 0));
        this.nameLabel = new JLabel(csFieldStandardField.getFieldDisplayName());
        this.nameLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        if (UNSELECTED_FONT == null) {
            UNSELECTED_FONT = this.nameLabel.getFont().deriveFont(0);
        }
        if (SELECTED_FONT == null) {
            SELECTED_FONT = UNSELECTED_FONT.deriveFont(1);
        }
        this.add((Component)this.nameLabel, "Center");
        this.setSize(this.getPreferredSize());
        this.drawSelected();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void select(boolean bl, boolean bl2) {
        this.isSelected = bl;
        this.isAnchor = bl2;
        this.drawSelected();
    }

    public Object getMapObject() {
        return this.standardField;
    }

    public boolean mapObjectEquals(Object object) {
        return this.standardField.equals(object);
    }

    protected void drawSelected() {
        if (this.isSelected) {
            if (this.isAnchor) {
                this.setBorder(ANCHOR_BORDER);
                this.setBackground(ANCHOR_BKG_COLOR);
                this.nameLabel.setForeground(ANCHOR_TEXT_COLOR);
                this.setOpaque(true);
            } else {
                this.setBorder(SELECTED_BORDER);
                this.setBackground(SELECTED_BKG_COLOR);
                this.nameLabel.setForeground(SELECTED_TEXT_COLOR);
                this.setOpaque(true);
            }
            this.nameLabel.setFont(SELECTED_FONT);
        } else {
            this.setBorder(UNSELECTED_BORDER);
            this.nameLabel.setForeground(UNSELECTED_TEXT_COLOR);
            this.nameLabel.setFont(UNSELECTED_FONT);
            this.setOpaque(false);
        }
        this.repaint();
    }
}

