/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.fieldstd;

import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandard;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardField;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardsManager;
import com.luna.insight.admin.collserver.fieldstd.CsStandardFieldThumbnail;
import com.luna.insight.admin.manytomanymap.ManyToManyMapEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class CsStandardFieldMappingEditComponent
extends ManyToManyMapEditComponent
implements ItemListener {
    protected static final Dimension DEFAULT_SIZE = new Dimension(580, 390);
    protected CollectionServer server;
    protected CsFieldStandardsManager manager;
    protected JLabel standard1Label;
    protected JLabel standard2Label;
    protected JComboBox standard1Selector;
    protected JComboBox standard2Selector;
    protected CsFieldStandard selectedStandard1 = null;
    protected CsFieldStandard selectedStandard2 = null;

    public static void debugOut(String string) {
        CsStandardFieldMappingEditComponent.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsStandardFieldMappingEditComponent: " + string, n);
    }

    public CsStandardFieldMappingEditComponent(CsFieldStandardsManager csFieldStandardsManager) {
        super(csFieldStandardsManager);
        this.server = csFieldStandardsManager.getServer();
        this.manager = csFieldStandardsManager;
        csFieldStandardsManager.setRecordChanges(true);
        this.initComponents();
        this.applyFieldStandardSelections();
    }

    protected void initComponents() {
        this.setSize(DEFAULT_SIZE);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.standard1Label = new JLabel("Select field standard 1:");
        this.standard1Label.setSize(this.standard1Label.getPreferredSize());
        this.standard2Label = new JLabel("Field standard 2:");
        this.standard2Label.setSize(this.standard2Label.getPreferredSize());
        this.standard1Selector = new JComboBox();
        this.standard2Selector = new JComboBox();
        Iterator iterator = this.manager.getFieldStandards().iterator();
        while (iterator.hasNext()) {
            CsFieldStandard csFieldStandard = (CsFieldStandard)iterator.next();
            this.standard1Selector.addItem(csFieldStandard);
        }
        this.standard2Selector.addItem(this.manager.getMappingFieldStandard());
        this.standard1Selector.setSelectedItem(this.manager.getCollectionStandard());
        this.standard1Selector.doLayout();
        this.standard1Selector.setSize(this.standard1Selector.getPreferredSize());
        this.standard2Selector.doLayout();
        this.standard2Selector.setSize(this.standard2Selector.getPreferredSize());
        this.add(this.standard1Label);
        this.add(this.standard2Label);
        this.add(this.standard1Selector);
        this.add(this.standard2Selector);
        this.standard1Selector.addItemListener(this);
        this.standard2Selector.addItemListener(this);
    }

    public void calculateSideBounds() {
        Insets insets = this.getInsets();
        int n = insets.top + this.standard1Label.getHeight() + 5 + this.standard1Selector.getHeight() + 10;
        int n2 = (this.getWidth() - insets.left - insets.right - 10) / 2;
        int n3 = this.getHeight() - n - insets.bottom;
        this.setWestSideBounds(new Rectangle(insets.left, n, n2, n3));
        this.setEastSideBounds(new Rectangle(this.westSideBounds.x + this.westSideBounds.width + 10, n, this.getWidth() - insets.right - 10 - this.westSideBounds.x - this.westSideBounds.width, n3));
    }

    public void doLayout() {
        super.doLayout();
        Insets insets = this.getInsets();
        this.standard1Label.setBounds(this.getWestSideBounds().x, insets.top, this.getWestSideBounds().width, this.standard1Label.getHeight());
        this.standard1Selector.setBounds(this.getWestSideBounds().x, this.standard1Label.getY() + this.standard1Label.getHeight() + 5, this.getWestSideBounds().width, this.standard1Selector.getHeight());
        this.standard2Label.setBounds(this.getEastSideBounds().x, insets.top, this.getEastSideBounds().width, this.standard2Label.getHeight());
        this.standard2Selector.setBounds(this.getEastSideBounds().x, this.standard2Label.getY() + this.standard2Label.getHeight() + 5, this.getEastSideBounds().width, this.standard2Selector.getHeight());
    }

    public List getCsStandardFieldThumbnails(CsFieldStandard csFieldStandard) {
        Vector<CsStandardFieldThumbnail> vector = new Vector<CsStandardFieldThumbnail>();
        if (csFieldStandard != null) {
            List list = this.manager.getFieldList(csFieldStandard);
            Comparator comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object instanceof CsFieldStandardField && object2 instanceof CsFieldStandardField) {
                        return ((CsFieldStandardField)object).getFieldDisplayName().compareTo(((CsFieldStandardField)object2).getFieldDisplayName());
                    }
                    return 0;
                }
            };
            Collections.sort(list, comparator);
            for (int i = 0; i < list.size(); ++i) {
                vector.add(new CsStandardFieldThumbnail(this, (CsFieldStandardField)list.get(i)));
            }
        }
        return vector;
    }

    public void applyFieldStandardSelections() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.selectedStandard1 == null || !this.standard1Selector.getSelectedItem().equals(this.selectedStandard1)) {
            if (this.standard1Selector.getSelectedItem().equals(this.selectedStandard2) && this.selectedStandard1 != null) {
                this.standard1Selector.setSelectedItem(this.selectedStandard1);
                return;
            }
            this.selectedStandard1 = (CsFieldStandard)this.standard1Selector.getSelectedItem();
            this.populateWestViewer(this.getCsStandardFieldThumbnails(this.selectedStandard1));
            bl = true;
        }
        if (this.selectedStandard2 == null || !this.standard2Selector.getSelectedItem().equals(this.selectedStandard2)) {
            if (this.standard2Selector.getSelectedItem().equals(this.selectedStandard1) && this.selectedStandard2 != null) {
                this.standard2Selector.setSelectedItem(this.selectedStandard2);
                return;
            }
            this.selectedStandard2 = (CsFieldStandard)this.standard2Selector.getSelectedItem();
            this.populateEastViewer(this.getCsStandardFieldThumbnails(this.selectedStandard2));
            bl2 = true;
        }
        if (bl || bl2) {
            if (bl && this.anchorViewer != this.westViewer) {
                this.updateView();
            } else if (bl2 && this.anchorViewer != this.eastViewer) {
                this.updateView();
            } else {
                this.resetView();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JComboBox jComboBox;
        if (itemEvent.getStateChange() == 1 && itemEvent.getItemSelectable() instanceof JComboBox && ((jComboBox = (JComboBox)itemEvent.getItemSelectable()) == this.standard1Selector || jComboBox == this.standard2Selector)) {
            this.applyFieldStandardSelections();
        }
    }

    public String getSelectionCountText(int n, int n2) {
        return n + " field" + (n == 1 ? "" : "s") + " mapped.";
    }

    public String getAvailableCountText(int n, int n2) {
        return n + " field" + (n == 1 ? "" : "s") + " available.";
    }

    public void save() {
        CsStandardFieldMappingEditComponent.debugOut("Save.", 3);
        CsStandardFieldMappingEditComponent.debugOut("Changes detected? " + this.manager.hasChanged());
        if (this.manager.hasChanged()) {
            this.server.getCollectionServerConnector().saveStandardFieldMappings(this.manager);
        }
        this.server.cancelEditStandardFieldMappings();
    }

    public void cancel() {
        CsStandardFieldMappingEditComponent.debugOut("Cancel.", 3);
        this.server.cancelEditStandardFieldMappings();
    }

    public String getWindowTitle() {
        return "Manage Field Standard Relations";
    }

    public ImageIcon getWindowIcon() {
        return IconMaker.createImage("images/collection-server-field-standards-node-icon.gif");
    }
}

