/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.fieldstd;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerTableNames;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandard;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardField;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardsManager;
import com.luna.insight.admin.manytomanymap.MapRecord;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlBatchController;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CsFieldStandardRecordHandler
extends DatabaseRecordHandler
implements CollectionServerTableNames {
    public CsFieldStandardRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CollectionServerFieldStandardRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            CsFieldStandard csFieldStandard = (CsFieldStandard)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, "StandardName");
            sqlQueryGenerator.appendToWhere("StandardName = " + this.prepForInsertQuery(csFieldStandard.standardName));
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                databaseConnector.close();
                return;
            }
            databaseConnector.close();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator2 = this.getQueryGeneratorUtil();
            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, csFieldStandard.standardID);
            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "StandardName", 1, stringBuffer2, csFieldStandard.standardName);
            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "Standard_Type", 2, stringBuffer2, csFieldStandard.type);
            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "Version", 1, stringBuffer2, csFieldStandard.version);
            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "Version_Info", 1, stringBuffer2, csFieldStandard.versionInfo);
            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "Standards_Order", 2, stringBuffer2, csFieldStandard.orderPosition);
            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "StandardDescriptionURL", 1, stringBuffer2, csFieldStandard.descriptionUrl);
            if (csFieldStandard.parentStandardID != null) {
                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "ParentStandardID", 2, stringBuffer2, csFieldStandard.parentStandardID);
            }
            if (csFieldStandard.standardCreatorID != null) {
                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "StandardCreatorID", 2, stringBuffer2, csFieldStandard.standardCreatorID);
            }
            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "IsTemplate", 2, stringBuffer2, csFieldStandard.isTemplate);
            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "IsPCTemplate", 2, stringBuffer2, csFieldStandard.isPCTemplate);
            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "IsPublishedTemplate", 2, stringBuffer2, csFieldStandard.isPublished);
            sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, stringBuffer2, csFieldStandard.createdTimestamp);
            String string = "INSERT INTO SLSTANDARDSLOOKUP (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
            databaseConnector.setQuery(string);
            this.debugOut("insertStandardsLookupQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            String string2 = "INSERT INTO SLSTANDARDSSTARTUP (StandardID, CreateThumbCache, Thumbnail1FieldID, Thumbnail2FieldID, Thumbnail3FieldID, Thumbnail4FieldID, Sort1FieldID, Sort2FieldID, Sort3FieldID, Sort4FieldID) VALUES (" + csFieldStandard.standardID + ", " + (csFieldStandard.createThumbCache ? 1 : 0) + ", " + csFieldStandard.thumbnail1FieldID + ", " + csFieldStandard.thumbnail2FieldID + ", " + csFieldStandard.thumbnail3FieldID + ", " + csFieldStandard.thumbnail4FieldID + ", " + csFieldStandard.sort1FieldID + ", " + csFieldStandard.sort2FieldID + ", " + csFieldStandard.sort3FieldID + ", " + csFieldStandard.sort4FieldID + ")";
            databaseConnector.setQuery(string2);
            this.debugOut("insertStandardsStartupQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            CsFieldStandard csFieldStandard = (CsFieldStandard)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("DELETE FROM SLSTANDARDSLOOKUP WHERE StandardID = " + csFieldStandard.getIndex());
            this.debugOut("Delete from SLSTANDARDSLOOKUP command:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            databaseConnector.setQuery("DELETE FROM SLSTANDARDSSTARTUP WHERE StandardID = " + csFieldStandard.getIndex());
            this.debugOut("Delete from SLSTANDARDSSTARTUP command:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            if (!csFieldStandard.isSaveOnly()) {
                databaseConnector.setQuery("DELETE FROM SLSTANDARDFIELDS WHERE StandardID = " + csFieldStandard.getIndex());
                this.debugOut("Delete from SLSTANDARDFIELDS command:\n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                databaseConnector.setQuery("DELETE FROM SLFIELDSTANDARDRELATION WHERE StandardID = " + csFieldStandard.getIndex() + " OR MappingStandardName = " + this.prepForInsertQuery(csFieldStandard.getName()));
                this.debugOut("Delete from SLFIELDSTANDARDRELATION command:\n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public Vector getRecords() {
        this.debugOut("in getRecords()");
        Vector<CsFieldStandard> vector = new Vector<CsFieldStandard>();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, "*");
            sqlQueryGenerator.addTable("SLSTANDARDSSTARTUP", null, new String[]{"CreateThumbCache", "Thumbnail1FieldID", "Thumbnail2FieldID", "Thumbnail3FieldID", "Thumbnail4FieldID", "Sort1FieldID", "Sort2FieldID", "Sort3FieldID", "Sort4FieldID"});
            sqlQueryGenerator.addJoin("SLSTANDARDSLOOKUP", "SLSTANDARDSSTARTUP", "StandardID", 0);
            sqlQueryGenerator.addOrderBy("SLSTANDARDSLOOKUP", "Standards_Order");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Standards query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                boolean bl = false;
                while (databaseConnector.more()) {
                    try {
                        bl = databaseConnector.getBooleanField("IsMappingStandard");
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    int n = databaseConnector.getIntegerField("ParentStandardID", -1);
                    int n2 = databaseConnector.getIntegerField("StandardCreatorID", -1);
                    CsFieldStandard csFieldStandard = new CsFieldStandard((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("StandardID"), databaseConnector.getFieldByName("StandardName"), databaseConnector.getIntegerFieldByName("Standard_Type"), bl, databaseConnector.getFieldByName("Version"), databaseConnector.getFieldByName("Version_Info"), databaseConnector.getIntegerField("Standards_Order", -1), databaseConnector.getFieldByName("StandardDescriptionURL"), databaseConnector.getIntegerFieldByName("CreateThumbCache") == 1, databaseConnector.getIntegerFieldByName("Thumbnail1FieldID"), databaseConnector.getIntegerFieldByName("Thumbnail2FieldID"), databaseConnector.getIntegerFieldByName("Thumbnail3FieldID"), databaseConnector.getIntegerFieldByName("Thumbnail4FieldID"), databaseConnector.getIntegerFieldByName("Sort1FieldID"), databaseConnector.getIntegerFieldByName("Sort2FieldID"), databaseConnector.getIntegerFieldByName("Sort3FieldID"), databaseConnector.getIntegerFieldByName("Sort4FieldID"), n == -1 ? null : new Integer(n), n2 == -1 ? null : new Integer(n2), databaseConnector.getBooleanField("IsTemplate", false), databaseConnector.getBooleanField("IsPCTemplate", false), databaseConnector.getBooleanField("IsPublishedTemplate", false), databaseConnector.getFieldByName("CreatedTimestamp"));
                    vector.addElement(csFieldStandard);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CsFieldStandard csFieldStandard = null;
        int n = databaseRecord.getIndex();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, "*");
            sqlQueryGenerator.addTable("SLSTANDARDSSTARTUP", null, new String[]{"CreateThumbCache", "Thumbnail1FieldID", "Thumbnail2FieldID", "Thumbnail3FieldID", "Thumbnail4FieldID", "Sort1FieldID", "Sort2FieldID", "Sort3FieldID", "Sort4FieldID"});
            sqlQueryGenerator.addJoin("SLSTANDARDSLOOKUP", "SLSTANDARDSSTARTUP", "StandardID", 0);
            sqlQueryGenerator.appendToWhere("SLSTANDARDSLOOKUP.StandardID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Standard query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                boolean bl = false;
                try {
                    bl = databaseConnector.getBooleanField("IsMappingStandard");
                }
                catch (Exception exception) {
                    bl = false;
                }
                int n2 = databaseConnector.getIntegerField("ParentStandardID", -1);
                int n3 = databaseConnector.getIntegerField("StandardCreatorID", -1);
                csFieldStandard = new CsFieldStandard((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("StandardID"), databaseConnector.getFieldByName("StandardName"), databaseConnector.getIntegerFieldByName("Standard_Type"), bl, databaseConnector.getFieldByName("Version"), databaseConnector.getFieldByName("Version_Info"), databaseConnector.getIntegerField("Standards_Order", -1), databaseConnector.getFieldByName("StandardDescriptionURL"), databaseConnector.getIntegerFieldByName("CreateThumbCache") == 1, databaseConnector.getIntegerFieldByName("Thumbnail1FieldID"), databaseConnector.getIntegerFieldByName("Thumbnail2FieldID"), databaseConnector.getIntegerFieldByName("Thumbnail3FieldID"), databaseConnector.getIntegerFieldByName("Thumbnail4FieldID"), databaseConnector.getIntegerFieldByName("Sort1FieldID"), databaseConnector.getIntegerFieldByName("Sort2FieldID"), databaseConnector.getIntegerFieldByName("Sort3FieldID"), databaseConnector.getIntegerFieldByName("Sort4FieldID"), n2 == -1 ? null : new Integer(n2), n3 == -1 ? null : new Integer(n3), databaseConnector.getBooleanField("IsTemplate", false), databaseConnector.getBooleanField("IsPCTemplate", false), databaseConnector.getBooleanField("IsPublishedTemplate", false), databaseConnector.getFieldByName("CreatedTimestamp"));
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return csFieldStandard;
    }

    public String getNextValidIDQuery() {
        return "SELECT StandardID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "SLSTANDARDSLOOKUP" + " ORDER BY StandardID";
    }

    public CsFieldStandardsManager getFieldStandardsManager() {
        DatabaseConnector databaseConnector;
        CsFieldStandardsManager csFieldStandardsManager;
        block7: {
            this.debugOut("In getFieldStandardsManager().");
            csFieldStandardsManager = new CsFieldStandardsManager((CollectionServer)this.serverConnector.getAdministeredServer());
            databaseConnector = this.getDatabaseConnector();
            try {
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, new String[]{"*", "StandardName AS FieldStandardName"});
                sqlQueryGenerator.addTable("SLSTANDARDFIELDS", null, new String[]{"*", "StandardID AS FieldStandardID"});
                sqlQueryGenerator.addJoin("SLSTANDARDFIELDS", "SLSTANDARDSLOOKUP", "StandardID", 0);
                sqlQueryGenerator.addOrderBy("SLSTANDARDSLOOKUP", "StandardID");
                sqlQueryGenerator.addOrderBy("SLSTANDARDFIELDS", "StandardFieldID");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Standard fields query: \n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    boolean bl = false;
                    while (databaseConnector.more()) {
                        try {
                            bl = databaseConnector.getBooleanField("IsMappingStandard");
                        }
                        catch (Exception exception) {
                            bl = false;
                        }
                        csFieldStandardsManager.addFieldStandard(databaseConnector.getFieldByName("FieldStandardName"), databaseConnector.getIntegerFieldByName("FieldStandardID"), databaseConnector.getIntegerFieldByName("Standard_Type"), bl, databaseConnector.getFieldByName("StandardFieldName"), databaseConnector.getFieldByName("StandardFieldDisplayName"), databaseConnector.getIntegerFieldByName("StandardFieldID"));
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    sqlQueryGenerator.clear();
                    sqlQueryGenerator.addTable("SLFIELDSTANDARDRELATION", null, "*");
                    sqlQueryGenerator.addOrderBy("SLFIELDSTANDARDRELATION", "StandardID");
                    sqlQueryGenerator.addOrderBy("SLFIELDSTANDARDRELATION", "StandardFieldID");
                    sqlQueryGenerator.addOrderBy("SLFIELDSTANDARDRELATION", "MappingStandardFieldID");
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                    this.debugOut("Field relations query: \n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                    while (databaseConnector.more()) {
                        csFieldStandardsManager.setFieldMapping(databaseConnector.getFieldByName("StandardName"), databaseConnector.getIntegerFieldByName("StandardFieldID"), databaseConnector.getFieldByName("MappingStandardName"), databaseConnector.getIntegerFieldByName("MappingStandardFieldID"));
                        databaseConnector.next();
                    }
                    databaseConnector.close();
                    csFieldStandardsManager.setCollectionStandard();
                    break block7;
                }
                this.debugOut("Field standards not defined.");
            }
            catch (Exception exception) {
                this.debugOut("Exception in getFieldStandardsManager():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
        databaseConnector.close();
        return csFieldStandardsManager;
    }

    public boolean saveStandardFieldMappings(CsFieldStandardsManager csFieldStandardsManager) {
        this.debugOut("in saveStandardFieldMappings()");
        try {
            SqlBatchController sqlBatchController = new SqlBatchController(this.getDatabaseConnector(), 100);
            List list = csFieldStandardsManager.getChanges();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MapRecord mapRecord = (MapRecord)iterator.next();
                CsFieldStandardField csFieldStandardField = (CsFieldStandardField)mapRecord.getObjectA();
                CsFieldStandardField csFieldStandardField2 = (CsFieldStandardField)mapRecord.getObjectB();
                if (mapRecord.getMappingType() == 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardID", 2, stringBuffer2, csFieldStandardField.getStandardID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardName", 1, stringBuffer2, csFieldStandardField.getStandardName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StandardFieldID", 2, stringBuffer2, csFieldStandardField.getFieldID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MappingStandardName", 1, stringBuffer2, csFieldStandardField2.getStandardName());
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MappingStandardFieldID", 2, stringBuffer2, csFieldStandardField2.getFieldID() + "");
                    sqlBatchController.postSqlCommand("INSERT INTO SLFIELDSTANDARDRELATION (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                    continue;
                }
                if (mapRecord.getMappingType() != 1) continue;
                sqlBatchController.postSqlCommand("DELETE FROM SLFIELDSTANDARDRELATION WHERE StandardName = " + this.prepForInsertQuery(csFieldStandardField.getStandardName()) + " AND StandardFieldID = " + csFieldStandardField.getFieldID() + " AND MappingStandardName = " + this.prepForInsertQuery(csFieldStandardField2.getStandardName()) + " AND MappingStandardFieldID = " + csFieldStandardField2.getFieldID());
            }
            sqlBatchController.executeRemainingCommands();
            return true;
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveStandardFieldMappings(): " + InsightUtilities.getStackTrace(exception));
            return false;
        }
    }

    public final int getNextValidDisplayOrder() {
        this.debugOut("in getNextValidDisplayOrder()");
        int n = 0;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "SELECT Standards_Order FROM SLSTANDARDSLOOKUP ORDER BY Standards_Order";
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            Vector<Integer> vector = new Vector<Integer>();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    vector.addElement(new Integer(databaseConnector.getIntegerFieldByName("Standards_Order")));
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            n = this.serverConnector.findFirstAvailableIndex(vector);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextValidDisplayOrder(): " + exception);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMaxIDValue(long l) {
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRMAXIDS", null, new String[]{"MaxStandardID"});
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            int n = 0;
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("MaxStandardID", 0);
            }
            databaseConnector.close();
            if (l > (long)n && n != 0) {
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxStandardID = " + l);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateMaxIDValue():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }
}

