/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.fieldstd;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.field.CollectionServerField;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandard;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardFieldEditComponent;
import com.luna.insight.admin.collserver.fieldstd.TypeCodeConverter;
import com.luna.insight.admin.verifier.CustomJComboBoxComponentVerifier;
import com.luna.insight.admin.verifier.CustomVerificationChecker;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CsFieldStandardField
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
Comparable,
ActionListener {
    public static int SELECT_LIST_NONE = 0;
    public static int SELECT_LIST_AVAILABLE = 1;
    public static int SELECT_LIST_AUTOMATIC = 2;
    public static String[] SELECT_LIST_OPTIONS = new String[]{"0 - None", "1- Available", "2 - Automatic"};
    protected CollectionServer server;
    protected CsFieldStandard fieldStandard;
    protected int fieldID = -1;
    protected int originalFieldID = -1;
    protected int displayOrder;
    protected String fieldName = "";
    protected String fieldDisplayName = "";
    protected int fieldType;
    protected boolean isPicked;
    protected boolean isDate;
    protected int stringType;
    protected String descriptionUrl;
    protected boolean isDataFieldSearchable = true;
    protected boolean isDisplayedInThumbnail = true;
    protected boolean isSortable = true;
    protected CsFieldStandardFieldEditComponent editComponent = null;
    protected int selectListSetting = 1;
    protected boolean toStringFieldDisplayName = false;
    protected Vector collectionFields = new Vector();

    public static void debugOut(String string) {
        CsFieldStandardField.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsFieldStandardField: " + string, n);
    }

    public CsFieldStandardField(CollectionServer collectionServer, CsFieldStandard csFieldStandard, int n) {
        this.server = collectionServer;
        this.fieldStandard = csFieldStandard;
        this.fieldID = n;
        this.originalFieldID = n;
    }

    public CsFieldStandardField(CollectionServer collectionServer, CsFieldStandard csFieldStandard, int n, String string, String string2) {
        this.server = collectionServer;
        this.fieldStandard = csFieldStandard;
        this.fieldID = n;
        this.originalFieldID = n;
        this.fieldName = string;
        this.fieldDisplayName = string2;
    }

    public CsFieldStandardField(CollectionServer collectionServer, CsFieldStandard csFieldStandard, int n, int n2, String string, String string2, int n3, boolean bl, boolean bl2, int n4, String string3, boolean bl3, boolean bl4, boolean bl5) {
        this.server = collectionServer;
        this.fieldStandard = csFieldStandard;
        this.fieldID = n;
        this.originalFieldID = n;
        this.displayOrder = n2;
        this.fieldName = string;
        this.fieldDisplayName = string2;
        this.fieldType = n3;
        this.isPicked = bl;
        this.isDate = bl2;
        this.stringType = n4;
        this.descriptionUrl = string3;
        this.isDataFieldSearchable = bl3;
        this.isDisplayedInThumbnail = bl4;
        this.isSortable = bl5;
        this.creationCompleted = true;
    }

    public void setSelectListSettings(int n) {
        this.selectListSetting = n;
    }

    public CollectionServer getServer() {
        return this.server;
    }

    public CsFieldStandard getFieldStandard() {
        return this.fieldStandard;
    }

    public int getStandardID() {
        return this.fieldStandard.getStandardID();
    }

    public String getStandardName() {
        return this.fieldStandard.getName();
    }

    public int getFieldID() {
        return this.fieldID;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldDisplayName() {
        return this.fieldDisplayName;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public boolean isPicked() {
        return this.isPicked;
    }

    public boolean isDate() {
        return this.isDate;
    }

    public int getStringType() {
        return this.stringType;
    }

    public String getDescriptionUrl() {
        return this.descriptionUrl;
    }

    public boolean isDataFieldSearchable() {
        return this.isDataFieldSearchable;
    }

    public boolean isDisplayedInThumbnail() {
        return this.isDisplayedInThumbnail;
    }

    public boolean isSortable() {
        return this.isSortable;
    }

    public String toString() {
        if (this.toStringFieldDisplayName) {
            return this.getFieldDisplayName();
        }
        return this.getFieldName();
    }

    public int getIndex() {
        return this.getFieldID();
    }

    public EditComponent getEditComponent() {
        Object object;
        Object object2;
        this.editComponent = new CsFieldStandardFieldEditComponent();
        boolean bl = this.fieldStandard != null && this.fieldStandard.type == 1;
        this.editComponent.setCollectionStandardField(bl);
        if (!bl) {
            this.editComponent.getFieldNameField().setText(this.getFieldName());
            this.editComponent.getDisplayNameField().setText(this.getFieldDisplayName());
            this.editComponent.removeCollectionFieldComboBox();
        } else {
            this.collectionFields = this.server.getFields(new Integer(this.fieldStandard.standardID));
            for (int i = 0; i < this.collectionFields.size(); ++i) {
                object2 = (CollectionServerField)this.collectionFields.elementAt(i);
                int n = ((CollectionServerField)object2).getFieldId();
                this.editComponent.getCollectionFieldComboBox().addItem(n + " - " + ((CollectionServerField)object2).getFieldName());
                if (this.fieldID != n) continue;
                this.editComponent.getCollectionFieldComboBox().setSelectedItem(n + " - " + ((CollectionServerField)object2).getFieldName());
            }
            this.editComponent.getCollectionFieldComboBox().addActionListener(this);
            this.editComponent.getDisplayNameField().setText(this.getFieldDisplayName());
            this.editComponent.removeFieldNameEntryFields();
            object = new CustomVerificationChecker(){

                public boolean verify(String string) {
                    Vector vector = CsFieldStandardField.this.server.getFieldStandardFields(CsFieldStandardField.this.fieldStandard);
                    if (vector == null || vector.size() == 0) {
                        return true;
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        CsFieldStandardField csFieldStandardField = (CsFieldStandardField)vector.get(i);
                        if (csFieldStandardField.fieldID == CsFieldStandardField.this.fieldID || !string.startsWith(csFieldStandardField.fieldID + " ")) continue;
                        return false;
                    }
                    return true;
                }

                public String getFailedMessage() {
                    return "The selected field is already in use by another standard field in this standard.";
                }
            };
            this.editComponent.getCollectionFieldComboBox().setInputVerifier(new CustomJComboBoxComponentVerifier((CustomVerificationChecker)object));
        }
        this.editComponent.getDisplayOrderField().setText(this.getDisplayOrder() + "");
        this.editComponent.getDescUrlField().setText(this.getDescriptionUrl());
        object = TypeCodeConverter.getFieldTypeNameIterator();
        while (object.hasNext()) {
            object2 = (String)object.next();
            if (((String)object2).equals(TypeCodeConverter.UNSEARCHABLE) || ((String)object2).equals(TypeCodeConverter.DATE)) continue;
            this.editComponent.getFieldTypeComboBox().addItem(object2);
        }
        this.editComponent.getFieldTypeComboBox().setSelectedItem(TypeCodeConverter.convertFieldType(this.getFieldType()));
        object = TypeCodeConverter.getStringTypeNameIterator();
        while (object.hasNext()) {
            this.editComponent.getStringTypeComboBox().addItem(object.next());
        }
        this.editComponent.getStringTypeComboBox().setSelectedItem(TypeCodeConverter.convertStringType(this.getStringType()));
        for (int i = 0; i < SELECT_LIST_OPTIONS.length; ++i) {
            this.editComponent.getSelectListComboBox().addItem(SELECT_LIST_OPTIONS[i]);
        }
        if (this.selectListSetting >= 0 && this.selectListSetting < SELECT_LIST_OPTIONS.length) {
            this.editComponent.getSelectListComboBox().setSelectedItem(SELECT_LIST_OPTIONS[this.selectListSetting]);
        }
        this.editComponent.getIsPickedCheckBox().setSelected(this.isPicked());
        this.editComponent.getIsDateCheckBox().setSelected(this.isDate());
        this.editComponent.getIsDataFieldSearchableCheckBox().setSelected(this.isDataFieldSearchable());
        this.editComponent.getIsDisplayedInThumbnailCheckBox().setSelected(this.isDisplayedInThumbnail());
        this.editComponent.getIsSortableCheckBox().setSelected(this.isSortable());
        return this.editComponent;
    }

    public void save() {
        int n;
        CsFieldStandardField.debugOut("Save.", 3);
        this.requiresCommit = false;
        if (!this.editComponent.isCollectionStandardField()) {
            if (this.hasChanged(this.getFieldName(), this.editComponent.getFieldNameField().getText())) {
                this.fieldName = this.editComponent.getFieldNameField().getText();
                this.requiresCommit = true;
            }
            if (this.hasChanged(this.getFieldDisplayName(), this.editComponent.getDisplayNameField().getText())) {
                this.fieldDisplayName = this.editComponent.getDisplayNameField().getText();
                this.requiresCommit = true;
            }
        } else {
            String string = (String)this.editComponent.getCollectionFieldComboBox().getSelectedItem();
            int n2 = this.fieldID;
            try {
                n2 = Integer.parseInt(string.substring(0, string.indexOf(32)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Vector vector = this.server.getFields(new Integer(this.fieldStandard.standardID));
            String string2 = "";
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                CollectionServerField collectionServerField = (CollectionServerField)vector.get(i);
                if (collectionServerField.getFieldId() != n2) continue;
                string2 = collectionServerField.getFieldName();
                break;
            }
            if (this.hasChanged(this.fieldID, n2)) {
                this.fieldID = n2;
            }
            if (this.hasChanged(this.fieldName, string2)) {
                this.fieldName = string2;
            }
            if (this.hasChanged(this.getFieldDisplayName(), this.editComponent.getDisplayNameField().getText())) {
                this.fieldDisplayName = this.editComponent.getDisplayNameField().getText();
                this.requiresCommit = true;
            }
        }
        if (this.hasChanged(this.getDisplayOrder() + "", this.editComponent.getDisplayOrderField().getText())) {
            try {
                this.displayOrder = Integer.parseInt(this.editComponent.getDisplayOrderField().getText());
                this.requiresCommit = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged(this.getDescriptionUrl(), this.editComponent.getDescUrlField().getText())) {
            this.descriptionUrl = this.editComponent.getDescUrlField().getText();
            this.requiresCommit = true;
        }
        if (this.hasChanged(this.getFieldType(), TypeCodeConverter.convertFieldType((String)this.editComponent.getFieldTypeComboBox().getSelectedItem()))) {
            this.fieldType = TypeCodeConverter.convertFieldType((String)this.editComponent.getFieldTypeComboBox().getSelectedItem());
            this.requiresCommit = true;
        }
        if (this.hasChanged(this.getStringType(), TypeCodeConverter.convertStringType((String)this.editComponent.getStringTypeComboBox().getSelectedItem()))) {
            this.stringType = TypeCodeConverter.convertStringType((String)this.editComponent.getStringTypeComboBox().getSelectedItem());
            this.requiresCommit = true;
        }
        if (this.hasChanged(this.isPicked(), this.editComponent.getIsPickedCheckBox().isSelected())) {
            this.isPicked = this.editComponent.getIsPickedCheckBox().isSelected();
            this.requiresCommit = true;
        }
        if (this.hasChanged(this.isDate(), this.editComponent.getIsDateCheckBox().isSelected())) {
            this.isDate = this.editComponent.getIsDateCheckBox().isSelected();
            this.requiresCommit = true;
        }
        if (this.hasChanged(this.isDisplayedInThumbnail(), this.editComponent.getIsDisplayedInThumbnailCheckBox().isSelected())) {
            this.isDisplayedInThumbnail = this.editComponent.getIsDisplayedInThumbnailCheckBox().isSelected();
            this.requiresCommit = true;
        }
        if (this.hasChanged(this.isSortable(), this.editComponent.getIsSortableCheckBox().isSelected())) {
            this.isSortable = this.editComponent.getIsSortableCheckBox().isSelected();
            this.requiresCommit = true;
        }
        if (this.hasChanged(this.isDataFieldSearchable(), this.editComponent.getIsDataFieldSearchableCheckBox().isSelected())) {
            this.isDataFieldSearchable = this.editComponent.getIsDataFieldSearchableCheckBox().isSelected();
            this.requiresCommit = true;
        }
        if (this.hasChanged(this.selectListSetting, this.editComponent.getSelectListComboBox().getSelectedIndex()) && (n = this.editComponent.getSelectListComboBox().getSelectedIndex()) >= 0 && n < SELECT_LIST_OPTIONS.length) {
            this.selectListSetting = n;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.server.commitDataObject(this);
        } else {
            this.server.cancelEdit(this);
        }
    }

    public void cancel() {
        CsFieldStandardField.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.server.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit - " + this.getFieldName();
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-field-standards-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return this.getStandardName() + "-" + this.getStandardID() + "-" + this.getFieldID();
    }

    public String getOriginalUniqueIdentifier() {
        return this.getStandardName() + "-" + this.getStandardID() + "-" + this.originalFieldID;
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseRecord) {
            return this.equalsRecord((DatabaseRecord)object);
        }
        return super.equals(object);
    }

    public int compareTo(Object object) {
        return this.getComparableValue().compareTo(((CsFieldStandardField)object).getComparableValue());
    }

    public String getComparableValue() {
        return "StandID-" + this.getStandardID() + ":FieldID-" + this.getFieldID();
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CsFieldStandardField) {
            CsFieldStandardField csFieldStandardField = (CsFieldStandardField)databaseRecord;
            return this.getFieldID() == csFieldStandardField.getFieldID() && this.getDisplayOrder() == csFieldStandardField.getDisplayOrder() && this.getFieldType() == csFieldStandardField.getFieldType() && this.isPicked() == csFieldStandardField.isPicked() && this.isDate() == csFieldStandardField.isDate() && this.isDataFieldSearchable() == csFieldStandardField.isDataFieldSearchable() && this.isDisplayedInThumbnail() == csFieldStandardField.isDisplayedInThumbnail() && this.isSortable() == csFieldStandardField.isSortable() && this.getStringType() == csFieldStandardField.getStringType() && this.getFieldStandard().equalsRecord(csFieldStandardField.getFieldStandard()) && this.getFieldName().equals(csFieldStandardField.getFieldName()) && this.getFieldDisplayName().equals(csFieldStandardField.getFieldDisplayName()) && (this.getDescriptionUrl() == null && csFieldStandardField.getDescriptionUrl() == null || this.getDescriptionUrl() != null && this.getDescriptionUrl().equals(csFieldStandardField.getDescriptionUrl()));
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.editComponent.getCollectionFieldComboBox()) {
            String string = (String)this.editComponent.getCollectionFieldComboBox().getSelectedItem();
            int n = this.fieldID;
            try {
                n = Integer.parseInt(string.substring(0, string.indexOf(32)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string2 = this.editComponent.getDisplayNameField().getText();
            for (int i = 0; this.collectionFields != null && i < this.collectionFields.size(); ++i) {
                CollectionServerField collectionServerField = (CollectionServerField)this.collectionFields.get(i);
                if (collectionServerField.getFieldId() != n) continue;
                string2 = collectionServerField.getDisplayName();
                break;
            }
            this.editComponent.getDisplayNameField().setText(string2);
        }
    }
}

