/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.fieldstd;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardEditComponent;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardField;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CsFieldStandard
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected static final int[] standardTypeValues = new int[]{1, 2, 3, 4};
    protected static final String[] standardTypeOptions = new String[]{"" + standardTypeValues[0] + " - Catalog Template", "" + standardTypeValues[1] + " - Local", "" + standardTypeValues[2] + " - Published", "" + standardTypeValues[3] + " - Custom"};
    protected int standardID;
    protected CollectionServer collectionServer;
    protected String standardName = "";
    protected int type = 1;
    protected String version = "";
    protected String versionInfo = "";
    protected int orderPosition = 0;
    protected String descriptionUrl = "";
    protected boolean createThumbCache = true;
    protected boolean isMappingStandard = false;
    protected int thumbnail1FieldID = 0;
    protected int thumbnail2FieldID = 0;
    protected int thumbnail3FieldID = 0;
    protected int thumbnail4FieldID = 0;
    protected int sort1FieldID = 0;
    protected int sort2FieldID = 0;
    protected int sort3FieldID = 0;
    protected int sort4FieldID = 0;
    protected Integer parentStandardID = null;
    protected Integer standardCreatorID = null;
    protected boolean isTemplate = false;
    protected boolean isPCTemplate = false;
    protected boolean isPublished = false;
    protected String createdTimestamp = "";
    protected boolean saveOnly = false;
    protected CsFieldStandardEditComponent editComponent = null;
    protected List standardFields = null;

    public static void debugOut(String string) {
        CsFieldStandard.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsFieldStandard: " + string, n);
    }

    public CsFieldStandard(int n, CollectionServer collectionServer) {
        this.standardID = n;
        this.collectionServer = collectionServer;
        this.parentStandardID = new Integer(n);
        this.createdTimestamp = new SimpleDate().get();
    }

    public CsFieldStandard(CollectionServer collectionServer, int n, String string, int n2, boolean bl) {
        this.collectionServer = collectionServer;
        this.standardID = n;
        this.standardName = string == null ? "" : string;
        this.type = n2;
        this.isMappingStandard = bl;
        this.parentStandardID = new Integer(n);
        this.createdTimestamp = new SimpleDate().get();
    }

    public CsFieldStandard(CollectionServer collectionServer, int n, String string, int n2, boolean bl, String string2, String string3, int n3, String string4, boolean bl2, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, Integer n12, Integer n13, boolean bl3, boolean bl4, boolean bl5, String string5) {
        this.collectionServer = collectionServer;
        this.standardID = n;
        this.standardName = string == null ? "" : string;
        this.type = n2;
        this.isMappingStandard = bl;
        this.version = string2 == null ? "" : string2;
        this.versionInfo = string3 == null ? "" : string3;
        this.orderPosition = n3;
        this.descriptionUrl = string4 == null ? "" : string4;
        this.createThumbCache = bl2;
        this.thumbnail1FieldID = n4;
        this.thumbnail2FieldID = n5;
        this.thumbnail3FieldID = n6;
        this.thumbnail4FieldID = n7;
        this.sort1FieldID = n8;
        this.sort2FieldID = n9;
        this.sort3FieldID = n10;
        this.sort4FieldID = n11;
        this.parentStandardID = n12;
        this.standardCreatorID = n13;
        this.isTemplate = bl3;
        this.isPCTemplate = bl4;
        this.isPublished = bl5;
        this.createdTimestamp = string5 == null ? new SimpleDate().get() : string5;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.standardName;
    }

    public int getStandardID() {
        return this.standardID;
    }

    public boolean isMappingStandard() {
        return this.isMappingStandard;
    }

    public List getFields() {
        return this.standardFields;
    }

    public CsFieldStandardField getField(int n) {
        CsFieldStandardField csFieldStandardField = null;
        CsFieldStandardField csFieldStandardField2 = null;
        for (int i = 0; this.standardFields != null && i < this.standardFields.size(); ++i) {
            csFieldStandardField2 = (CsFieldStandardField)this.standardFields.get(i);
            if (csFieldStandardField2.getFieldID() != n) continue;
            csFieldStandardField = csFieldStandardField2;
            break;
        }
        return csFieldStandardField;
    }

    public void addField(CsFieldStandardField csFieldStandardField) {
        if (this.standardFields == null) {
            this.standardFields = new ArrayList();
        }
        if (!this.standardFields.contains(csFieldStandardField)) {
            this.standardFields.add(csFieldStandardField);
        }
    }

    public int getIndex() {
        return this.getStandardID();
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CsFieldStandardEditComponent(this);
        this.editComponent.getStandardNameField().setText(this.standardName);
        this.editComponent.getTypeComboBox().setEnabled(this.type != 4);
        int n = this.type == 4 ? 3 : 2;
        for (int i = 0; i <= n; ++i) {
            this.editComponent.getTypeComboBox().addItem(standardTypeOptions[i]);
        }
        if (this.type >= standardTypeValues[0] && this.type <= standardTypeValues[standardTypeValues.length - 1]) {
            this.editComponent.getTypeComboBox().setSelectedItem(standardTypeOptions[this.type - standardTypeValues[0]]);
        }
        this.editComponent.getVersionField().setText(this.version);
        this.editComponent.getVersionInfoField().setText(this.versionInfo);
        this.editComponent.getDescriptionUrlField().setText(this.descriptionUrl);
        this.editComponent.getOrderPositionField().setText(this.orderPosition < 0 ? "" : "" + this.orderPosition);
        this.editComponent.getCreateThumbCacheCheckBox().setSelected(this.createThumbCache);
        Vector vector = this.collectionServer.getFieldStandardFields(this);
        for (int i = 0; i < vector.size(); ++i) {
            CsFieldStandardField csFieldStandardField = (CsFieldStandardField)vector.elementAt(i);
            csFieldStandardField.toStringFieldDisplayName = true;
            int n2 = csFieldStandardField.fieldID;
            this.editComponent.getSort1ComboBox().addItem(csFieldStandardField);
            this.editComponent.getSort2ComboBox().addItem(csFieldStandardField);
            this.editComponent.getSort3ComboBox().addItem(csFieldStandardField);
            this.editComponent.getSort4ComboBox().addItem(csFieldStandardField);
            if (this.sort1FieldID == n2) {
                this.editComponent.getSort1ComboBox().setSelectedItem(csFieldStandardField);
            }
            if (this.sort2FieldID == n2) {
                this.editComponent.getSort2ComboBox().setSelectedItem(csFieldStandardField);
            }
            if (this.sort3FieldID == n2) {
                this.editComponent.getSort3ComboBox().setSelectedItem(csFieldStandardField);
            }
            if (this.sort4FieldID == n2) {
                this.editComponent.getSort4ComboBox().setSelectedItem(csFieldStandardField);
            }
            this.editComponent.getThumbnail1ComboBox().addItem(csFieldStandardField);
            this.editComponent.getThumbnail2ComboBox().addItem(csFieldStandardField);
            this.editComponent.getThumbnail3ComboBox().addItem(csFieldStandardField);
            this.editComponent.getThumbnail4ComboBox().addItem(csFieldStandardField);
            if (this.thumbnail1FieldID == n2) {
                this.editComponent.getThumbnail1ComboBox().setSelectedItem(csFieldStandardField);
            }
            if (this.thumbnail2FieldID == n2) {
                this.editComponent.getThumbnail2ComboBox().setSelectedItem(csFieldStandardField);
            }
            if (this.thumbnail3FieldID == n2) {
                this.editComponent.getThumbnail3ComboBox().setSelectedItem(csFieldStandardField);
            }
            if (this.thumbnail4FieldID != n2) continue;
            this.editComponent.getThumbnail4ComboBox().setSelectedItem(csFieldStandardField);
        }
        this.editComponent.getStandardNameField().selectAll();
        this.editComponent.getStandardNameField().requestFocus();
        return this.editComponent;
    }

    public void save() {
        CsFieldStandard.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.standardName, this.editComponent.getStandardNameField().getText())) {
            this.standardName = this.editComponent.getStandardNameField().getText();
        }
        String string = (String)this.editComponent.getTypeComboBox().getSelectedItem();
        int n = this.type;
        try {
            n = Integer.parseInt(string.substring(0, string.indexOf(32)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.type, n)) {
            this.type = n;
        }
        if (this.hasChanged(this.version, this.editComponent.getVersionField().getText())) {
            this.version = this.editComponent.getVersionField().getText();
        }
        if (this.hasChanged(this.versionInfo, this.editComponent.getVersionInfoField().getText())) {
            this.versionInfo = this.editComponent.getVersionInfoField().getText();
        }
        if (this.hasChanged(this.descriptionUrl, this.editComponent.getDescriptionUrlField().getText())) {
            this.descriptionUrl = this.editComponent.getDescriptionUrlField().getText();
        }
        String string2 = this.editComponent.getOrderPositionField().getText();
        if (this.orderPosition >= 0) {
            if (string2.equals("")) {
                this.requiresCommit = true;
                this.orderPosition = -1;
            } else if (this.hasChanged("" + this.orderPosition, string2)) {
                try {
                    this.orderPosition = Integer.parseInt(string2);
                }
                catch (Exception exception) {}
            }
        } else if (!string2.equals("")) {
            this.requiresCommit = true;
            try {
                this.orderPosition = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged(this.isPublished, this.editComponent.getPublishedTemplateCheckBox().isSelected())) {
            this.isPublished = this.editComponent.getPublishedTemplateCheckBox().isSelected();
        }
        if (this.hasChanged(this.createThumbCache, this.editComponent.getCreateThumbCacheCheckBox().isSelected())) {
            this.createThumbCache = this.editComponent.getCreateThumbCacheCheckBox().isSelected();
        }
        try {
            int n2 = ((CsFieldStandardField)this.editComponent.getSort1ComboBox().getSelectedItem()).fieldID;
            if (this.hasChanged(this.sort1FieldID, n2)) {
                this.sort1FieldID = n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n3 = ((CsFieldStandardField)this.editComponent.getSort2ComboBox().getSelectedItem()).fieldID;
            if (this.hasChanged(this.sort2FieldID, n3)) {
                this.sort2FieldID = n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n4 = ((CsFieldStandardField)this.editComponent.getSort3ComboBox().getSelectedItem()).fieldID;
            if (this.hasChanged(this.sort3FieldID, n4)) {
                this.sort3FieldID = n4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n5 = ((CsFieldStandardField)this.editComponent.getSort4ComboBox().getSelectedItem()).fieldID;
            if (this.hasChanged(this.sort4FieldID, n5)) {
                this.sort4FieldID = n5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n6 = ((CsFieldStandardField)this.editComponent.getThumbnail1ComboBox().getSelectedItem()).fieldID;
            if (this.hasChanged(this.thumbnail1FieldID, n6)) {
                this.thumbnail1FieldID = n6;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n7 = ((CsFieldStandardField)this.editComponent.getThumbnail2ComboBox().getSelectedItem()).fieldID;
            if (this.hasChanged(this.thumbnail2FieldID, n7)) {
                this.thumbnail2FieldID = n7;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n8 = ((CsFieldStandardField)this.editComponent.getThumbnail3ComboBox().getSelectedItem()).fieldID;
            if (this.hasChanged(this.thumbnail3FieldID, n8)) {
                this.thumbnail3FieldID = n8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n9 = ((CsFieldStandardField)this.editComponent.getThumbnail4ComboBox().getSelectedItem()).fieldID;
            if (this.hasChanged(this.thumbnail4FieldID, n9)) {
                this.thumbnail4FieldID = n9;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.saveOnly = true;
            this.collectionServer.commitDataObject(this);
            this.saveOnly = false;
        } else {
            this.collectionServer.cancelEdit(this);
        }
    }

    public void cancel() {
        CsFieldStandard.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Field Standard - " + this.standardName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-field-standards-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof CsFieldStandard) {
            CsFieldStandard csFieldStandard = (CsFieldStandard)object;
            return this.standardID == csFieldStandard.standardID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CsFieldStandard) {
            CsFieldStandard csFieldStandard = (CsFieldStandard)databaseRecord;
            return this.standardID == csFieldStandard.standardID && CsFieldStandard.stringsAreEqual(this.standardName, csFieldStandard.standardName) && this.type == csFieldStandard.type && CsFieldStandard.stringsAreEqual(this.version, csFieldStandard.version) && CsFieldStandard.stringsAreEqual(this.versionInfo, csFieldStandard.versionInfo) && this.orderPosition == csFieldStandard.orderPosition && CsFieldStandard.stringsAreEqual(this.descriptionUrl, csFieldStandard.descriptionUrl) && this.createThumbCache == csFieldStandard.createThumbCache && this.thumbnail1FieldID == csFieldStandard.thumbnail1FieldID && this.thumbnail2FieldID == csFieldStandard.thumbnail2FieldID && this.thumbnail3FieldID == csFieldStandard.thumbnail3FieldID && this.thumbnail4FieldID == csFieldStandard.thumbnail4FieldID && this.sort1FieldID == csFieldStandard.sort1FieldID && this.sort2FieldID == csFieldStandard.sort2FieldID && this.sort3FieldID == csFieldStandard.sort3FieldID && this.sort4FieldID == csFieldStandard.sort4FieldID && CsFieldStandard.stringsAreEqual(this.createdTimestamp, csFieldStandard.createdTimestamp);
        }
        return false;
    }

    public void setDisplayOrder(int n) {
        this.orderPosition = n;
    }

    public boolean isSaveOnly() {
        return this.saveOnly;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }
}

