/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.field;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.catalog.CatalogTemplateNode;
import com.luna.insight.admin.collserver.field.CollectionServerField;
import com.luna.insight.admin.collserver.field.CollectionServerFieldTableInfo;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CollectionServerFieldNode
extends TableDisplayControlPanelNode {
    protected CatalogTemplateNode catalogTemplateNode = null;
    protected JPopupMenu tablePopup = null;

    public CollectionServerFieldNode(CatalogTemplateNode catalogTemplateNode) {
        super(catalogTemplateNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), "Fields", false);
        this.catalogTemplateNode = catalogTemplateNode;
        this.columnNames = new Object[]{"Field Name", "Display Name", "FieldGroupName", "Display Order", "Tables", "Joined Tables", "Delimiter Type", "String Type", "Field Type", "Hierarchy Mode", "Hierarchy", "Grouping TableID", "Grouping Field Name", "Preferred Field", "Keyword Searchable", "Displayed In Data", "Data Field Searchable", "Search Pick Field (browser)", "Fuzzy Date Field"};
    }

    public void updateInformationDisplay() {
        Integer n = this.catalogTemplateNode.getTemplate().getTemplateID();
        this.tableModel.setDataVector(this.getTableData(this.catalogTemplateNode.getCollectionServerNode().getCollectionServer().getFields(n)), this.columnNames);
        try {
            this.catalogTemplateNode.getCollectionServerNode().vocabulariesNode.refreshChildNodes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            CollectionServerField collectionServerField = (CollectionServerField)vector.elementAt(i);
            objectArray[i][0] = collectionServerField.getFieldName() != null ? collectionServerField.getFieldName() : "";
            objectArray[i][1] = collectionServerField;
            String string = "Null";
            Vector vector2 = collectionServerField.getFieldGroupNames();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                object4 = (CollectionServerFieldTableInfo)enumeration.nextElement();
                if (((CollectionServerFieldTableInfo)object4).getTableId() != collectionServerField.getFieldGroupId()) continue;
                string = ((CollectionServerFieldTableInfo)object4).getName();
                break;
            }
            objectArray[i][2] = string;
            objectArray[i][3] = new Integer(collectionServerField.getDisplayOrder());
            object4 = "Null";
            Vector vector3 = collectionServerField.getTableNames();
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                object3 = (CollectionServerFieldTableInfo)enumeration2.nextElement();
                if (((CollectionServerFieldTableInfo)object3).getTableId() != collectionServerField.getTableId()) continue;
                object4 = ((CollectionServerFieldTableInfo)object3).getName();
                break;
            }
            objectArray[i][4] = object4;
            object3 = "Primary Objects Table";
            Vector vector4 = collectionServerField.getJoinNames();
            Enumeration enumeration3 = vector4.elements();
            while (enumeration3.hasMoreElements()) {
                object2 = (CollectionServerFieldTableInfo)enumeration3.nextElement();
                if (((CollectionServerFieldTableInfo)object2).getTableId() != collectionServerField.getJoinId()) continue;
                object3 = ((CollectionServerFieldTableInfo)object2).getName();
                break;
            }
            objectArray[i][5] = object3;
            objectArray[i][6] = this.convertDelimiterType(collectionServerField.getDelimiterType());
            objectArray[i][7] = this.convertStringType(collectionServerField.getStringType());
            objectArray[i][8] = this.convertFieldType(collectionServerField.getFieldType());
            objectArray[i][9] = this.convertHierarchyMode(collectionServerField.getHierarchyMode());
            object2 = "None";
            Vector vector5 = collectionServerField.getHierarchyValues();
            Enumeration enumeration4 = vector5.elements();
            while (enumeration4.hasMoreElements()) {
                object = (CollectionServerFieldTableInfo)enumeration4.nextElement();
                if (((CollectionServerFieldTableInfo)object).getTableId() != collectionServerField.getHierarchyId()) continue;
                object2 = ((CollectionServerFieldTableInfo)object).getName();
                break;
            }
            objectArray[i][10] = object2;
            object = "";
            Vector vector6 = collectionServerField.getTableNames();
            Enumeration enumeration5 = vector3.elements();
            while (enumeration5.hasMoreElements()) {
                CollectionServerFieldTableInfo collectionServerFieldTableInfo = (CollectionServerFieldTableInfo)enumeration5.nextElement();
                if (collectionServerFieldTableInfo.getTableId() != collectionServerField.getGroupingTableId()) continue;
                object = collectionServerFieldTableInfo.getName();
                break;
            }
            objectArray[i][11] = object;
            objectArray[i][12] = collectionServerField.getGroupingFieldName();
            objectArray[i][13] = collectionServerField.getPreferredFieldName();
            objectArray[i][14] = new Boolean(collectionServerField.getSearchable());
            objectArray[i][15] = new Boolean(collectionServerField.getDisplayedInData());
            objectArray[i][16] = new Boolean(collectionServerField.getDataFieldSearchable());
            objectArray[i][17] = new Boolean(collectionServerField.getSearchPick());
            objectArray[i][18] = new Boolean(collectionServerField.getIsDate());
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.catalogTemplateNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("New...", "New Field Command", this.catalogTemplateNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.catalogTemplateNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-fields-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.catalogTemplateNode.getCollectionServerNode().getAdminAccount(), "New Field Command", "Edit Field Command", "Delete Field Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Field Command")) {
            this.catalogTemplateNode.getCollectionServerNode().createNewField(this.catalogTemplateNode.getTemplate().getTemplateID());
        } else if (string.equals("Delete Field Command")) {
            if (vector != null && vector.size() > 0) {
                this.catalogTemplateNode.getCollectionServerNode().removeField(vector);
            }
        } else if (string.equals("Edit Field Command") && vector != null && vector.size() == 1) {
            this.catalogTemplateNode.getCollectionServerNode().editField((CollectionServerField)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.catalogTemplateNode.getCollectionServerNode().editField((CollectionServerField)object);
        }
    }

    private String convertDelimiterType(int n) {
        String string = "";
        if (n == 1) {
            string = "Multi-field Name";
        }
        if (n == 2) {
            string = "Single-field Name";
        }
        if (n == 3) {
            string = "Comma";
        }
        if (n == 4) {
            string = "Semicolon";
        }
        return string;
    }

    private String convertStringType(int n) {
        String string = "";
        if (n == 0) {
            string = "Expandable Short String";
        } else if (n == 1) {
            string = "Long String";
        } else if (n == 2) {
            string = "Nonexpandable Short String";
        }
        return string;
    }

    private String convertHierarchyMode(int n) {
        String string = "";
        if (n == Field.HIERARCHY_MODE_NONE) {
            string = "None";
        } else if (n == Field.HIERARCHY_MODE_CURRENT_ONLY) {
            string = "Current Node Only";
        } else if (n == Field.HIERARCHY_MODE_INCLUDE_CHILDREN) {
            string = "Include Children of Current Node";
        } else if (n == Field.HIERARCHY_MODE_INSCRIBE_ONLY) {
            string = "Inscribe Access Only";
        }
        return string;
    }

    private String convertFieldType(int n) {
        String string = "";
        if (n == 0) {
            string = "Unsearchable";
        }
        if (n == 1) {
            string = "String";
        }
        if (n == 2) {
            string = "Integer";
        }
        if (n == 3) {
            string = "Date";
        }
        return string;
    }

    public static void debugOut(String string) {
        CollectionServerFieldNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerFieldNode: " + string, n);
    }
}

