/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.field;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.catalog.CatalogTemplate;
import com.luna.insight.admin.collserver.field.CollectionServerFieldGroupEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CollectionServerFieldGroup
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected static final int[] fieldGroupTypeValues = new int[]{1, 2, 3, 4};
    protected static final String[] fieldGroupTypeOptions = new String[]{"1 - Single (Use Delimiter Type)", "2 - Display Field Names", "3 - Display Field Group Names", "4 - Display Field and Field Group Names"};
    protected int fieldGroupID;
    protected CatalogTemplate catalogTemplate;
    protected String displayName = "";
    protected int fieldGroupType = 1;
    protected int displayOrder = 0;
    protected Vector fields = new Vector();
    protected CollectionServerFieldGroupEditComponent editComponent = null;
    protected ListItemSelector itemSelector = null;

    public CollectionServerFieldGroup(CatalogTemplate catalogTemplate, int n, String string, int n2, int n3) {
        this.catalogTemplate = catalogTemplate;
        this.fieldGroupID = n;
        this.displayName = string == null ? "" : string;
        this.fieldGroupType = n2;
        this.displayOrder = n3;
    }

    public CollectionServerFieldGroup(int n, CatalogTemplate catalogTemplate) {
        this.fieldGroupID = n;
        this.catalogTemplate = catalogTemplate;
    }

    public CatalogTemplate getTemplate() {
        return this.catalogTemplate;
    }

    public void addFieldIndex(int n) {
        Integer n2 = new Integer(n);
        if (!this.fields.contains(n2)) {
            this.fields.addElement(n2);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.displayName;
    }

    public int getIndex() {
        return this.fieldGroupID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CollectionServerFieldGroupEditComponent();
        this.editComponent.getDisplayNameField().setText(this.displayName);
        for (int i = 0; i < fieldGroupTypeOptions.length; ++i) {
            this.editComponent.getFieldGroupTypeComboBox().addItem(fieldGroupTypeOptions[i]);
        }
        if (this.fieldGroupType >= fieldGroupTypeValues[0] && this.fieldGroupType <= fieldGroupTypeValues[fieldGroupTypeValues.length - 1]) {
            this.editComponent.getFieldGroupTypeComboBox().setSelectedItem(fieldGroupTypeOptions[this.fieldGroupType - fieldGroupTypeValues[0]]);
        }
        this.editComponent.getDisplayOrderField().setText("" + this.displayOrder);
        this.editComponent.getDisplayNameField().selectAll();
        this.editComponent.getDisplayNameField().requestFocus();
        this.itemSelector = new ListItemSelector("Available Fields:", "Member Fields:", this.catalogTemplate.getServer().getFields(this.catalogTemplate.getTemplateID()), this.fields);
        this.editComponent.getFieldSelectionPanel().add(this.itemSelector);
        return this.editComponent;
    }

    public void save() {
        CollectionServerFieldGroup.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.displayName, this.editComponent.getDisplayNameField().getText())) {
            this.displayName = this.editComponent.getDisplayNameField().getText();
        }
        String string = (String)this.editComponent.getFieldGroupTypeComboBox().getSelectedItem();
        int n = this.fieldGroupType;
        try {
            n = Integer.parseInt(string.substring(0, string.indexOf(32)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.fieldGroupType, n)) {
            this.fieldGroupType = n;
        }
        try {
            if (this.hasChanged(this.displayOrder, Integer.parseInt(this.editComponent.getDisplayOrderField().getText()))) {
                this.displayOrder = Integer.parseInt(this.editComponent.getDisplayOrderField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.fields, this.itemSelector.getChosenItemIndices())) {
            this.fields = this.itemSelector.getChosenItemIndices();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.catalogTemplate.getServer().commitDataObject(this);
        } else {
            this.catalogTemplate.getServer().cancelEdit(this);
        }
    }

    public void cancel() {
        CollectionServerFieldGroup.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.catalogTemplate.getServer().cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Field Group - " + this.displayName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-field-groups-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof CollectionServerFieldGroup) {
            CollectionServerFieldGroup collectionServerFieldGroup = (CollectionServerFieldGroup)object;
            return this.fieldGroupID == collectionServerFieldGroup.fieldGroupID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CollectionServerFieldGroup) {
            CollectionServerFieldGroup collectionServerFieldGroup = (CollectionServerFieldGroup)databaseRecord;
            return this.fieldGroupID == collectionServerFieldGroup.fieldGroupID && CollectionServerFieldGroup.stringsAreEqual(this.displayName, collectionServerFieldGroup.displayName) && this.fieldGroupType == collectionServerFieldGroup.fieldGroupType && this.displayOrder == collectionServerFieldGroup.displayOrder;
        }
        return false;
    }

    public void setFields(Vector vector) {
        this.fields = vector != null ? vector : new Vector();
    }

    public void setDisplayOrder(int n) {
        this.displayOrder = n;
    }

    public static void debugOut(String string) {
        CollectionServerFieldGroup.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerFieldGroup: " + string, n);
    }
}

