/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.field;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.NodeChildDeterminant;
import com.luna.insight.admin.catalog.CatalogTemplate;
import com.luna.insight.admin.collserver.field.CollectionServerFieldEditComponent;
import com.luna.insight.admin.collserver.field.CollectionServerFieldTableInfo;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardField;
import com.luna.insight.admin.verifier.IntegerJTextComponentVerifier;
import com.luna.insight.admin.verifier.NonEmptyJTextComponentVerifier;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CollectionServerField
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
NodeChildDeterminant {
    public static int DELETE_MODE_EDIT = 0;
    public static int DELETE_MODE_DELETE = 1;
    public static int TYPE_STRING_INDEX = 0;
    public static int TYPE_INTEGER_INDEX = 1;
    private CatalogTemplate catalogTemplate = null;
    private int fieldId = 0;
    private String fieldName = "";
    private String displayName = "";
    private String preferredFieldName = "";
    private int fieldGroupId = 0;
    private int delimiterType = 1;
    private int stringType = 0;
    private int tableId = 0;
    private int joinId = 0;
    private int hierarchyMode = 0;
    private int hierarchyId = 0;
    private boolean searchable = false;
    private boolean displayedInData = false;
    private boolean searchPick = false;
    private boolean multiValue = false;
    private int displayOrder = 0;
    private int fieldType = 0;
    private boolean dataFieldSearchable = false;
    private boolean isDate = false;
    private Vector tableNames = new Vector();
    private Vector hierarchyValues = new Vector();
    private Vector joinNames = new Vector();
    private Vector fieldGroupNames = new Vector();
    private Vector entityTypeNames = new Vector();
    private String nullString = "None";
    private String primaryObjectsTable = "Resides in Primary Objects Table";
    private int groupingTableId = -1;
    private String groupingFieldName = "";
    private int entityTypeID = 0;
    protected CollectionServerFieldEditComponent editComponent = null;
    protected int selectListSetting = 1;
    protected boolean isNewField = false;
    protected int deleteMode = DELETE_MODE_EDIT;

    public static int getFieldTypeIndex(int n) {
        if (n == 2) {
            return TYPE_INTEGER_INDEX;
        }
        return TYPE_STRING_INDEX;
    }

    public CollectionServerField(CatalogTemplate catalogTemplate, int n, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5) {
        this.catalogTemplate = catalogTemplate;
        this.fieldId = n;
        this.tableNames = vector;
        this.hierarchyValues = vector2;
        this.joinNames = vector3;
        this.fieldGroupNames = vector4;
        this.isNewField = true;
        this.entityTypeNames = vector5;
    }

    public CollectionServerField(CatalogTemplate catalogTemplate, int n, String string, String string2, String string3, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n9, boolean bl5, boolean bl6, int n10, int n11, String string4, Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        this.catalogTemplate = catalogTemplate;
        this.fieldId = n;
        this.fieldName = string;
        this.preferredFieldName = string3;
        this.fieldGroupId = n2;
        this.displayName = string2;
        this.delimiterType = n3;
        this.stringType = n4;
        this.tableId = n5;
        this.joinId = n6;
        this.hierarchyMode = n7;
        this.hierarchyId = n8;
        this.searchable = bl;
        this.displayedInData = bl2;
        this.searchPick = bl3;
        this.multiValue = bl4;
        this.displayOrder = n10;
        this.fieldType = n9;
        this.dataFieldSearchable = bl5;
        this.isDate = bl6;
        this.displayOrder = n10;
        this.groupingTableId = n11;
        this.groupingFieldName = string4;
        this.tableNames = vector;
        this.hierarchyValues = vector2;
        this.joinNames = vector3;
        this.fieldGroupNames = vector4;
    }

    public CatalogTemplate getTemplate() {
        return this.catalogTemplate;
    }

    public String toString() {
        return this.displayName;
    }

    public int getIndex() {
        return this.fieldId;
    }

    public String getNodeChildName() {
        return this.fieldName;
    }

    public int getNodeChildIndex() {
        return this.fieldId;
    }

    public void setSelectListSettings(int n) {
        this.selectListSetting = n;
    }

    public EditComponent getEditComponent() {
        int n;
        this.editComponent = new CollectionServerFieldEditComponent();
        this.editComponent.getSearchable().setSelected(this.searchable);
        this.editComponent.getDisplayedInData().setSelected(this.displayedInData);
        this.editComponent.getSearchPick().setSelected(this.searchPick);
        this.editComponent.getFieldName().setText(this.fieldName);
        this.editComponent.getFieldName().setInputVerifier(new NonEmptyJTextComponentVerifier());
        this.editComponent.getFieldDisplayName().setText(this.displayName);
        this.editComponent.getFieldDisplayName().setInputVerifier(new NonEmptyJTextComponentVerifier());
        this.editComponent.getPreferredFieldName().setText(this.preferredFieldName);
        this.editComponent.getDisplayOrder().setText(this.displayOrder + "");
        this.editComponent.getDisplayOrder().setInputVerifier(new IntegerJTextComponentVerifier());
        this.editComponent.getIsDate().setSelected(this.isDate);
        this.editComponent.getDataFieldSearchable().setSelected(this.dataFieldSearchable);
        this.editComponent.getDelimiterType().addItem(new String("Multi-field Name"));
        this.editComponent.getDelimiterType().addItem(new String("Single-field Name"));
        this.editComponent.getDelimiterType().addItem(new String("Comma"));
        this.editComponent.getDelimiterType().addItem(new String("Semicolon"));
        this.editComponent.getDelimiterType().setSelectedItem(this.getDelimiterTypeItem(this.delimiterType));
        this.editComponent.getStringType().addItem(new String("Expandable Short String"));
        this.editComponent.getStringType().addItem(new String("Long String"));
        this.editComponent.getStringType().addItem(new String("Nonexpandable Short String"));
        this.editComponent.getStringType().setSelectedIndex(this.stringType);
        this.editComponent.getHierarchyMode().addItem(new String("None"));
        this.editComponent.getHierarchyMode().addItem(new String("Current Node Only"));
        this.editComponent.getHierarchyMode().addItem(new String("Include Children of Current Node"));
        this.editComponent.getHierarchyMode().addItem(new String("Inscribe Access Only"));
        this.editComponent.getHierarchyMode().setSelectedIndex(this.hierarchyMode);
        this.editComponent.getFieldType().addItem(new String("String"));
        this.editComponent.getFieldType().addItem(new String("Integer"));
        this.editComponent.getFieldType().setSelectedIndex(CollectionServerField.getFieldTypeIndex(this.fieldType));
        String[] stringArray = CsFieldStandardField.SELECT_LIST_OPTIONS;
        for (n = 0; n < stringArray.length; ++n) {
            this.editComponent.getSelectListComboBox().addItem(stringArray[n]);
        }
        if (this.selectListSetting >= 0 && this.selectListSetting < stringArray.length) {
            this.editComponent.getSelectListComboBox().setSelectedItem(stringArray[this.selectListSetting]);
        }
        this.editComponent.getHierarchy().addItem(this.nullString);
        for (n = 0; n < this.hierarchyValues.size(); ++n) {
            this.editComponent.getHierarchy().addItem(this.hierarchyValues.elementAt(n));
        }
        this.editComponent.getHierarchy().setSelectedItem(this.nullString);
        Enumeration enumeration = this.hierarchyValues.elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            CollectionServerFieldTableInfo collectionServerFieldTableInfo = null;
            try {
                collectionServerFieldTableInfo = (CollectionServerFieldTableInfo)enumeration.nextElement();
            }
            catch (ClassCastException classCastException) {
                collectionServerFieldTableInfo = null;
            }
            if (collectionServerFieldTableInfo == null || (n2 = collectionServerFieldTableInfo.getTableId()) != this.hierarchyId) continue;
            this.editComponent.getHierarchy().setSelectedItem(collectionServerFieldTableInfo);
        }
        for (int i = 0; i < this.tableNames.size(); ++i) {
            this.editComponent.getTableName().addItem(this.tableNames.elementAt(i));
        }
        Enumeration enumeration2 = this.tableNames.elements();
        while (enumeration2.hasMoreElements()) {
            CollectionServerFieldTableInfo collectionServerFieldTableInfo = (CollectionServerFieldTableInfo)enumeration2.nextElement();
            int n3 = collectionServerFieldTableInfo.getTableId();
            if (n3 != this.tableId) continue;
            this.editComponent.getTableName().setSelectedItem(collectionServerFieldTableInfo);
        }
        this.editComponent.getJoinName().addItem(this.primaryObjectsTable);
        for (int i = 0; i < this.joinNames.size(); ++i) {
            this.editComponent.getJoinName().addItem(this.joinNames.elementAt(i));
        }
        Enumeration enumeration3 = this.joinNames.elements();
        while (enumeration3.hasMoreElements()) {
            CollectionServerFieldTableInfo collectionServerFieldTableInfo = null;
            try {
                collectionServerFieldTableInfo = (CollectionServerFieldTableInfo)enumeration3.nextElement();
                int n4 = collectionServerFieldTableInfo.getTableId();
                if (n4 != this.joinId) continue;
                this.editComponent.getJoinName().setSelectedItem(collectionServerFieldTableInfo);
            }
            catch (ClassCastException classCastException) {
                this.editComponent.getJoinName().setSelectedItem(this.primaryObjectsTable);
            }
        }
        for (int i = 0; i < this.fieldGroupNames.size(); ++i) {
            this.editComponent.getFieldGroupName().addItem(this.fieldGroupNames.elementAt(i));
        }
        Enumeration enumeration4 = this.fieldGroupNames.elements();
        while (enumeration4.hasMoreElements()) {
            CollectionServerFieldTableInfo collectionServerFieldTableInfo = (CollectionServerFieldTableInfo)enumeration4.nextElement();
            int n5 = collectionServerFieldTableInfo.getTableId();
            if (n5 != this.fieldGroupId) continue;
            this.editComponent.getFieldGroupName().setSelectedItem(collectionServerFieldTableInfo);
            break;
        }
        if (this.isNewField) {
            this.editComponent.setEntityTypeVisible(true);
            Iterator iterator = this.entityTypeNames.iterator();
            while (iterator.hasNext()) {
                this.editComponent.getEntityTypeName().addItem(iterator.next());
            }
        } else {
            this.editComponent.setEntityTypeVisible(false);
        }
        this.editComponent.getGroupingTableId().addItem(this.nullString);
        for (int i = 0; i < this.tableNames.size(); ++i) {
            this.editComponent.getGroupingTableId().addItem(this.tableNames.elementAt(i));
        }
        Enumeration enumeration5 = this.tableNames.elements();
        while (enumeration5.hasMoreElements()) {
            CollectionServerFieldTableInfo collectionServerFieldTableInfo = (CollectionServerFieldTableInfo)enumeration5.nextElement();
            int n6 = collectionServerFieldTableInfo.getTableId();
            if (n6 != this.groupingTableId) continue;
            this.editComponent.getGroupingTableId().setSelectedItem(collectionServerFieldTableInfo);
        }
        this.editComponent.getGroupingFieldName().setText(this.groupingFieldName);
        return this.editComponent;
    }

    public void save() {
        CollectionServerField.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(new Boolean(this.searchable), new Boolean(this.editComponent.getSearchable().isSelected()))) {
            this.searchable = this.editComponent.getSearchable().isSelected();
        }
        if (this.hasChanged(new Boolean(this.displayedInData), new Boolean(this.editComponent.getDisplayedInData().isSelected()))) {
            this.displayedInData = this.editComponent.getDisplayedInData().isSelected();
        }
        if (this.hasChanged(new Boolean(this.searchPick), new Boolean(this.editComponent.getSearchPick().isSelected()))) {
            this.searchPick = this.editComponent.getSearchPick().isSelected();
        }
        if (this.hasChanged(this.fieldName, this.editComponent.getFieldName().getText())) {
            this.fieldName = this.editComponent.getFieldName().getText();
        }
        if (this.hasChanged(this.displayName, this.editComponent.getFieldDisplayName().getText())) {
            this.displayName = this.editComponent.getFieldDisplayName().getText();
        }
        if (this.hasChanged(this.preferredFieldName, this.editComponent.getPreferredFieldName().getText())) {
            this.preferredFieldName = this.editComponent.getPreferredFieldName().getText();
        }
        if (this.hasChanged(this.delimiterType, this.delimiterTypeValue((String)this.editComponent.getDelimiterType().getSelectedItem()))) {
            this.delimiterType = this.delimiterTypeValue((String)this.editComponent.getDelimiterType().getSelectedItem());
        }
        if (this.hasChanged(this.stringType, this.stringTypeValue((String)this.editComponent.getStringType().getSelectedItem()))) {
            this.stringType = this.stringTypeValue((String)this.editComponent.getStringType().getSelectedItem());
        }
        if (this.hasChanged(this.tableId, this.getTableIdValue())) {
            this.tableId = this.getTableIdValue();
        }
        if (this.hasChanged(this.joinId, this.getJoinIdValue())) {
            this.joinId = this.getJoinIdValue();
        }
        if (this.hasChanged(this.fieldGroupId, this.getFieldGroupIdValue())) {
            this.fieldGroupId = this.getFieldGroupIdValue();
        }
        if (this.isNewField) {
            this.entityTypeID = this.getEntityTypeIdValue();
        }
        if (this.hasChanged(this.displayOrder, this.getDisplayOrderValue())) {
            this.displayOrder = this.getDisplayOrderValue();
        }
        if (this.hasChanged(this.hierarchyMode, this.hierarchyModeValue((String)this.editComponent.getHierarchyMode().getSelectedItem()))) {
            this.hierarchyMode = this.hierarchyModeValue((String)this.editComponent.getHierarchyMode().getSelectedItem());
        }
        if (this.hasChanged(this.hierarchyId, this.getHierarchyValue())) {
            this.hierarchyId = this.getHierarchyValue();
        }
        if (this.hasChanged(new Boolean(this.dataFieldSearchable), new Boolean(this.editComponent.getDataFieldSearchable().isSelected()))) {
            this.dataFieldSearchable = this.editComponent.getDataFieldSearchable().isSelected();
        }
        if (this.hasChanged(new Boolean(this.isDate), new Boolean(this.editComponent.getIsDate().isSelected()))) {
            this.isDate = this.editComponent.getIsDate().isSelected();
        }
        if (this.hasChanged(this.fieldType, this.fieldTypeValue((String)this.editComponent.getFieldType().getSelectedItem()))) {
            this.fieldType = this.fieldTypeValue((String)this.editComponent.getFieldType().getSelectedItem());
        }
        if (this.hasChanged(this.groupingTableId, this.getGroupingTableValue())) {
            this.groupingTableId = this.getGroupingTableValue();
        }
        if (this.hasChanged(this.groupingFieldName, this.editComponent.getGroupingFieldName().getText())) {
            this.groupingFieldName = this.editComponent.getGroupingFieldName().getText();
        }
        if (this.hasChanged(this.selectListSetting, this.editComponent.getSelectListComboBox().getSelectedIndex())) {
            String[] stringArray = CsFieldStandardField.SELECT_LIST_OPTIONS;
            int n = this.editComponent.getSelectListComboBox().getSelectedIndex();
            if (n >= 0 && n < stringArray.length) {
                this.selectListSetting = n;
            }
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.catalogTemplate.getServer().commitDataObject(this);
        } else {
            this.catalogTemplate.getServer().cancelEdit(this);
        }
    }

    public void cancel() {
        CollectionServerField.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.catalogTemplate.getServer().cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Field - " + this.fieldName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-fields-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof CollectionServerField) {
            CollectionServerField collectionServerField = (CollectionServerField)object;
            return this.fieldId == collectionServerField.getFieldId();
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CollectionServerField) {
            CollectionServerField collectionServerField = (CollectionServerField)databaseRecord;
            if (this.hierarchyMode == 0) {
                this.hierarchyId = -1;
                collectionServerField.setHierarchyId(-1);
            }
            if (this.fieldId != collectionServerField.getFieldId()) {
                return false;
            }
            if (!CollectionServerField.stringsAreEqual(this.fieldName, collectionServerField.getFieldName())) {
                return false;
            }
            if (!CollectionServerField.stringsAreEqual(this.displayName, collectionServerField.getDisplayName())) {
                return false;
            }
            if (this.fieldGroupId != collectionServerField.getFieldGroupId()) {
                return false;
            }
            if (this.delimiterType != collectionServerField.getDelimiterType()) {
                return false;
            }
            if (this.stringType != collectionServerField.getStringType()) {
                return false;
            }
            if (this.tableId != collectionServerField.getTableId()) {
                return false;
            }
            if (this.joinId != collectionServerField.getJoinId()) {
                return false;
            }
            if (this.hierarchyMode != collectionServerField.getHierarchyMode()) {
                return false;
            }
            if (this.hierarchyId != collectionServerField.getHierarchyId()) {
                return false;
            }
            if (!CollectionServerField.stringsAreEqual(this.preferredFieldName, collectionServerField.getPreferredFieldName())) {
                return false;
            }
            if (this.searchable != collectionServerField.getSearchable()) {
                return false;
            }
            if (this.displayedInData != collectionServerField.getDisplayedInData()) {
                return false;
            }
            if (this.searchPick != collectionServerField.getSearchPick()) {
                return false;
            }
            if (this.multiValue != collectionServerField.getMultiValue()) {
                return false;
            }
            if (this.fieldType != collectionServerField.getFieldType()) {
                return false;
            }
            if (this.dataFieldSearchable != collectionServerField.getDataFieldSearchable()) {
                return false;
            }
            if (this.isDate != collectionServerField.getIsDate()) {
                return false;
            }
            if (this.groupingTableId != collectionServerField.getGroupingTableId()) {
                return false;
            }
            return CollectionServerField.stringsAreEqual(this.groupingFieldName, collectionServerField.getGroupingFieldName());
        }
        return false;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPreferredFieldName() {
        return this.preferredFieldName;
    }

    public int getDelimiterType() {
        return this.delimiterType;
    }

    public int getStringType() {
        return this.stringType;
    }

    public int getTableId() {
        return this.tableId;
    }

    public int getJoinId() {
        return this.joinId;
    }

    public int getFieldGroupId() {
        return this.fieldGroupId;
    }

    public int getEntityTypeId() {
        return this.entityTypeID;
    }

    public int getHierarchyMode() {
        return this.hierarchyMode;
    }

    public int getHierarchyId() {
        return this.hierarchyId;
    }

    public boolean getSearchable() {
        return this.searchable;
    }

    public boolean getDisplayedInData() {
        return this.displayedInData;
    }

    public boolean getSearchPick() {
        return this.searchPick;
    }

    public boolean getMultiValue() {
        return this.multiValue;
    }

    public boolean getDataFieldSearchable() {
        return this.dataFieldSearchable;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public boolean getIsDate() {
        return this.isDate;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public int getGroupingTableId() {
        return this.groupingTableId;
    }

    public String getGroupingFieldName() {
        return this.groupingFieldName;
    }

    public Vector getHierarchyValues() {
        return this.hierarchyValues;
    }

    public Vector getTableNames() {
        return this.tableNames;
    }

    public Vector getJoinNames() {
        return this.joinNames;
    }

    public Vector getFieldGroupNames() {
        return this.fieldGroupNames;
    }

    public void setHierarchyId(int n) {
        this.hierarchyId = n;
    }

    private int delimiterTypeValue(String string) {
        int n = -1;
        n = string.equals("Multi-field Name") ? 1 : (string.equals("Single-field Name") ? 2 : (string.equals("Comma") ? 3 : (string.equals("Semicolon") ? 4 : -1)));
        return n;
    }

    private int stringTypeValue(String string) {
        if (string.equals("Expandable Short String")) {
            return 0;
        }
        if (string.equals("Long String")) {
            return 1;
        }
        if (string.equals("Nonexpandable Short String")) {
            return 2;
        }
        return -1;
    }

    private int hierarchyModeValue(String string) {
        if (string.equals("None")) {
            return Field.HIERARCHY_MODE_NONE;
        }
        if (string.equals("Current Node Only")) {
            return Field.HIERARCHY_MODE_CURRENT_ONLY;
        }
        if (string.equals("Include Children of Current Node")) {
            return Field.HIERARCHY_MODE_INCLUDE_CHILDREN;
        }
        if (string.equals("Inscribe Access Only")) {
            return Field.HIERARCHY_MODE_INSCRIBE_ONLY;
        }
        return -1;
    }

    private int fieldTypeValue(String string) {
        if (string.equals("Integer")) {
            return 2;
        }
        if (string.equals("String")) {
            return 1;
        }
        return -1;
    }

    private int getHierarchyValue() {
        Object object = this.editComponent.getHierarchy().getSelectedItem();
        if (object instanceof String) {
            return 0;
        }
        if (object instanceof CollectionServerFieldTableInfo) {
            return ((CollectionServerFieldTableInfo)this.editComponent.getHierarchy().getSelectedItem()).getTableId();
        }
        return 0;
    }

    private int getTableIdValue() {
        Object object = this.editComponent.getTableName().getSelectedItem();
        if (object instanceof CollectionServerFieldTableInfo) {
            return ((CollectionServerFieldTableInfo)this.editComponent.getTableName().getSelectedItem()).getTableId();
        }
        return 0;
    }

    private int getGroupingTableValue() {
        Object object = this.editComponent.getGroupingTableId().getSelectedItem();
        if (object instanceof CollectionServerFieldTableInfo) {
            return ((CollectionServerFieldTableInfo)this.editComponent.getGroupingTableId().getSelectedItem()).getTableId();
        }
        return 0;
    }

    private int getJoinIdValue() {
        Object object = this.editComponent.getJoinName().getSelectedItem();
        if (object instanceof CollectionServerFieldTableInfo) {
            return ((CollectionServerFieldTableInfo)this.editComponent.getJoinName().getSelectedItem()).getTableId();
        }
        return 0;
    }

    private int getFieldGroupIdValue() {
        Object object = this.editComponent.getFieldGroupName().getSelectedItem();
        if (object instanceof CollectionServerFieldTableInfo) {
            return ((CollectionServerFieldTableInfo)this.editComponent.getFieldGroupName().getSelectedItem()).getTableId();
        }
        return -1;
    }

    private int getEntityTypeIdValue() {
        Object object = this.editComponent.getEntityTypeName().getSelectedItem();
        if (object instanceof CollectionServerFieldTableInfo) {
            return ((CollectionServerFieldTableInfo)object).getTableId();
        }
        return -1;
    }

    private int getDisplayOrderValue() {
        int n = this.displayOrder;
        try {
            n = Integer.parseInt(this.editComponent.getDisplayOrder().getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private String getDelimiterTypeItem(int n) {
        if (n == 1) {
            return new String("Multi-field Name");
        }
        if (n == 2) {
            return new String("Single-field Name");
        }
        if (n == 3) {
            return new String("Comma");
        }
        if (n == 4) {
            return new String("Semicolon");
        }
        return new String("None");
    }

    public static void debugOut(String string) {
        CollectionServerField.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerField: " + string, n);
    }

    public int getDeleteMode() {
        return this.deleteMode;
    }

    public void setDeleteMode(int n) {
        this.deleteMode = n;
    }
}

