/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.config;

import com.luna.insight.admin.ColorChooser;
import com.luna.insight.admin.ColorChooserParent;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationVisualEditComponent;
import com.luna.insight.client.DefaultCollectionConfiguration;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class CollectionServerConfigurationVisualAttributes
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
ColorChooserParent {
    public CollectionServerConfiguration collectionServerConfiguration;
    protected int verticalBarX = DefaultCollectionConfiguration.VERTICAL_BAR_X;
    protected int horizontalBarY = DefaultCollectionConfiguration.HORIZONTAL_BAR_Y;
    protected int backgroundColorR = DefaultCollectionConfiguration.BACKGROUND_COLOR.getRed();
    protected int backgroundColorG = DefaultCollectionConfiguration.BACKGROUND_COLOR.getGreen();
    protected int backgroundColorB = DefaultCollectionConfiguration.BACKGROUND_COLOR.getBlue();
    protected int defaultViewResolution = DefaultCollectionConfiguration.DEFAULT_VIEW_RESOLUTION;
    protected int groupTopInset = DefaultCollectionConfiguration.GROUP_TOP_INSET;
    protected int groupLeftInset = DefaultCollectionConfiguration.GROUP_LEFT_INSET;
    protected int groupSpacingH = DefaultCollectionConfiguration.GROUP_SPACING_H;
    protected int groupSpacingV = DefaultCollectionConfiguration.GROUP_SPACING_V;
    protected int menuXPosition = DefaultCollectionConfiguration.MENU_X_POSITION;
    protected int maximumWindows = DefaultCollectionConfiguration.MAXIMUM_WINDOWS;
    protected int interWindowSpacing = DefaultCollectionConfiguration.INTERWINDOW_SPACING;
    protected int minImageWindowSizeWidth;
    protected int minImageWindowSizeHeight;
    protected int macWidthAdjustment;
    protected String bgUrl;
    protected int candidateBackgroundColorR;
    protected int candidateBackgroundColorG;
    protected int candidateBackgroundColorB;
    protected CollectionServerConfigurationVisualEditComponent editComponent;
    protected EditDialog colorChooserEditDialog;

    public CollectionServerConfigurationVisualAttributes(CollectionServerConfiguration collectionServerConfiguration) {
        this.minImageWindowSizeWidth = DefaultCollectionConfiguration.MINIMUM_IMAGE_WINDOW_SIZE.width;
        this.minImageWindowSizeHeight = DefaultCollectionConfiguration.MINIMUM_IMAGE_WINDOW_SIZE.height;
        this.macWidthAdjustment = DefaultCollectionConfiguration.MACINTOSH_WIDTH_ADJUSTMENT;
        this.bgUrl = DefaultCollectionConfiguration.BACKGROUND_IMAGE;
        this.candidateBackgroundColorR = this.backgroundColorR;
        this.candidateBackgroundColorG = this.backgroundColorG;
        this.candidateBackgroundColorB = this.backgroundColorB;
        this.editComponent = null;
        this.colorChooserEditDialog = null;
        this.collectionServerConfiguration = collectionServerConfiguration;
    }

    public CollectionServerConfigurationVisualAttributes(CollectionServerConfiguration collectionServerConfiguration, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, String string) {
        this.minImageWindowSizeWidth = DefaultCollectionConfiguration.MINIMUM_IMAGE_WINDOW_SIZE.width;
        this.minImageWindowSizeHeight = DefaultCollectionConfiguration.MINIMUM_IMAGE_WINDOW_SIZE.height;
        this.macWidthAdjustment = DefaultCollectionConfiguration.MACINTOSH_WIDTH_ADJUSTMENT;
        this.bgUrl = DefaultCollectionConfiguration.BACKGROUND_IMAGE;
        this.candidateBackgroundColorR = this.backgroundColorR;
        this.candidateBackgroundColorG = this.backgroundColorG;
        this.candidateBackgroundColorB = this.backgroundColorB;
        this.editComponent = null;
        this.colorChooserEditDialog = null;
        this.collectionServerConfiguration = collectionServerConfiguration;
        this.verticalBarX = n;
        this.horizontalBarY = n2;
        this.backgroundColorR = n3;
        this.backgroundColorG = n4;
        this.backgroundColorB = n5;
        this.candidateBackgroundColorR = n3;
        this.candidateBackgroundColorG = n4;
        this.candidateBackgroundColorB = n5;
        this.defaultViewResolution = n6;
        this.groupTopInset = n7;
        this.groupLeftInset = n8;
        this.groupSpacingH = n9;
        this.groupSpacingV = n10;
        this.menuXPosition = n11;
        this.maximumWindows = n12;
        this.interWindowSpacing = n13;
        this.minImageWindowSizeWidth = n14;
        this.minImageWindowSizeHeight = n15;
        this.macWidthAdjustment = n16;
        this.bgUrl = string;
    }

    public void setVisualAttributes(Hashtable hashtable) {
        this.verticalBarX = hashtable.get("verticalBarX") != null ? (Integer)hashtable.get("verticalBarX") : 0;
        this.horizontalBarY = hashtable.get("horizontalBarY") != null ? (Integer)hashtable.get("horizontalBarY") : 0;
        this.backgroundColorR = hashtable.get("backgroundColorR") != null ? (Integer)hashtable.get("backgroundColorR") : 0;
        this.backgroundColorG = hashtable.get("backgroundColorG") != null ? (Integer)hashtable.get("backgroundColorG") : 0;
        this.backgroundColorB = hashtable.get("backgroundColorB") != null ? (Integer)hashtable.get("backgroundColorB") : 0;
        this.candidateBackgroundColorR = this.backgroundColorR;
        this.candidateBackgroundColorG = this.backgroundColorG;
        this.candidateBackgroundColorB = this.backgroundColorB;
        this.defaultViewResolution = hashtable.get("defaultViewResolution") != null ? (Integer)hashtable.get("defaultViewResolution") : 0;
        this.groupTopInset = hashtable.get("groupTopInset") != null ? (Integer)hashtable.get("groupTopInset") : 0;
        this.groupLeftInset = hashtable.get("groupLeftInset") != null ? (Integer)hashtable.get("groupLeftInset") : 0;
        this.groupSpacingH = hashtable.get("groupSpacingH") != null ? (Integer)hashtable.get("groupSpacingH") : 0;
        this.groupSpacingV = hashtable.get("groupSpacingV") != null ? (Integer)hashtable.get("groupSpacingV") : 0;
        this.menuXPosition = hashtable.get("menuXPosition") != null ? (Integer)hashtable.get("menuXPosition") : 0;
        this.maximumWindows = hashtable.get("maximumWindows") != null ? (Integer)hashtable.get("maximumWindows") : 0;
        this.interWindowSpacing = hashtable.get("interWindowSpacing") != null ? (Integer)hashtable.get("interWindowSpacing") : 0;
        this.minImageWindowSizeWidth = hashtable.get("minImageWindowSizeWidth") != null ? (Integer)hashtable.get("minImageWindowSizeWidth") : 0;
        this.minImageWindowSizeHeight = hashtable.get("minImageWindowSizeHeight") != null ? (Integer)hashtable.get("minImageWindowSizeHeight") : 0;
        this.macWidthAdjustment = hashtable.get("macWidthAdjustment") != null ? (Integer)hashtable.get("macWidthAdjustment") : 0;
        this.bgUrl = hashtable.get("bgUrl") != null ? (String)hashtable.get("bgUrl") : "";
    }

    public String toString() {
        return this.collectionServerConfiguration != null ? this.collectionServerConfiguration.institutionID : "";
    }

    public String getName() {
        return this.collectionServerConfiguration != null ? this.collectionServerConfiguration.collectionName : "";
    }

    public int getIndex() {
        int n = 0;
        try {
            n = Integer.parseInt(this.collectionServerConfiguration.collectionID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public String getUniqueIdentifier() {
        if (this.collectionServerConfiguration != null) {
            return this.collectionServerConfiguration.institutionID + "-" + this.collectionServerConfiguration.collectionID + "-" + this.collectionServerConfiguration.vcID + "-V";
        }
        return "";
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CollectionServerConfigurationVisualEditComponent();
        this.editComponent.getBgColorDisplayPanel().setBackground(new Color(this.backgroundColorR, this.backgroundColorG, this.backgroundColorB));
        this.editComponent.getBgColorRGBLabel().setText("[" + this.backgroundColorR + ", " + this.backgroundColorG + ", " + this.backgroundColorB + "]");
        this.editComponent.getBgColorRGBLabel().setForeground(new Color(50, 50, 50));
        this.editComponent.getBgImageUrlField().setText(this.bgUrl);
        this.editComponent.getVerticalBarXField().setText("" + this.verticalBarX);
        this.editComponent.getHorizontalBarY().setText("" + this.horizontalBarY);
        this.editComponent.getDefaultViewResolution().setText("" + this.defaultViewResolution);
        this.editComponent.getGroupInsetsTopField().setText("" + this.groupTopInset);
        this.editComponent.getGroupInsetsLeftField().setText("" + this.groupLeftInset);
        this.editComponent.getGroupSpacingHField().setText("" + this.groupSpacingH);
        this.editComponent.getGroupSpacingVField().setText("" + this.groupSpacingV);
        this.editComponent.getInterWindowSpacingField().setText("" + this.interWindowSpacing);
        this.editComponent.getMaxWindowsField().setText("" + this.maximumWindows);
        this.editComponent.getMinImageWindowWidthField().setText("" + this.minImageWindowSizeWidth);
        this.editComponent.getMinImageWindowHeightField().setText("" + this.minImageWindowSizeHeight);
        this.editComponent.getMenuPositionXField().setText("" + this.menuXPosition);
        this.editComponent.getMacWidthAdjustmentField().setText("" + this.macWidthAdjustment);
        this.editComponent.getBgColorButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CollectionServerConfigurationVisualAttributes.this.chooseBgColor();
            }
        });
        return this.editComponent;
    }

    public void save() {
        CollectionServerConfigurationVisualAttributes.debugOut("Save...", 3);
        this.requiresCommit = false;
        Color color = new Color(this.candidateBackgroundColorR, this.candidateBackgroundColorG, this.candidateBackgroundColorB);
        if (this.hasChanged(this.backgroundColorR, color.getRed())) {
            this.backgroundColorR = color.getRed();
        }
        if (this.hasChanged(this.backgroundColorG, color.getGreen())) {
            this.backgroundColorG = color.getGreen();
        }
        if (this.hasChanged(this.backgroundColorB, color.getBlue())) {
            this.backgroundColorB = color.getBlue();
        }
        if (this.hasChanged(this.bgUrl, this.editComponent.getBgImageUrlField().getText())) {
            this.bgUrl = this.editComponent.getBgImageUrlField().getText();
        }
        if (this.hasChanged("" + this.verticalBarX, this.editComponent.getVerticalBarXField().getText())) {
            try {
                this.verticalBarX = Integer.parseInt(this.editComponent.getVerticalBarXField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.horizontalBarY, this.editComponent.getHorizontalBarY().getText())) {
            try {
                this.horizontalBarY = Integer.parseInt(this.editComponent.getHorizontalBarY().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.defaultViewResolution, this.editComponent.getDefaultViewResolution().getText())) {
            try {
                this.defaultViewResolution = Integer.parseInt(this.editComponent.getDefaultViewResolution().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.groupTopInset, this.editComponent.getGroupInsetsTopField().getText())) {
            try {
                this.groupTopInset = Integer.parseInt(this.editComponent.getGroupInsetsTopField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.groupLeftInset, this.editComponent.getGroupInsetsLeftField().getText())) {
            try {
                this.groupLeftInset = Integer.parseInt(this.editComponent.getGroupInsetsLeftField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.groupSpacingH, this.editComponent.getGroupSpacingHField().getText())) {
            try {
                this.groupSpacingH = Integer.parseInt(this.editComponent.getGroupSpacingHField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.groupSpacingV, this.editComponent.getGroupSpacingVField().getText())) {
            try {
                this.groupSpacingV = Integer.parseInt(this.editComponent.getGroupSpacingVField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.interWindowSpacing, this.editComponent.getInterWindowSpacingField().getText())) {
            try {
                this.interWindowSpacing = Integer.parseInt(this.editComponent.getInterWindowSpacingField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.maximumWindows, this.editComponent.getMaxWindowsField().getText())) {
            try {
                this.maximumWindows = Integer.parseInt(this.editComponent.getMaxWindowsField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.minImageWindowSizeWidth, this.editComponent.getMinImageWindowWidthField().getText())) {
            try {
                this.minImageWindowSizeWidth = Integer.parseInt(this.editComponent.getMinImageWindowWidthField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.minImageWindowSizeHeight, this.editComponent.getMinImageWindowHeightField().getText())) {
            try {
                this.minImageWindowSizeHeight = Integer.parseInt(this.editComponent.getMinImageWindowHeightField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.menuXPosition, this.editComponent.getMenuPositionXField().getText())) {
            try {
                this.menuXPosition = Integer.parseInt(this.editComponent.getMenuPositionXField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.macWidthAdjustment, this.editComponent.getMacWidthAdjustmentField().getText())) {
            try {
                this.macWidthAdjustment = Integer.parseInt(this.editComponent.getMacWidthAdjustmentField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServerConfiguration.getCollection().getServer().commitDataObject(this);
        } else {
            this.collectionServerConfiguration.getCollection().getServer().cancelEdit(this);
        }
        if (this.colorChooserEditDialog != null) {
            this.colorChooserEditDialog.cancel();
        }
    }

    public void cancel() {
        CollectionServerConfigurationVisualAttributes.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServerConfiguration.getCollection().getServer().cancelEdit(this);
        if (this.colorChooserEditDialog != null) {
            this.colorChooserEditDialog.cancel();
        }
    }

    public String getEditWindowTitle() {
        return (this.collectionServerConfiguration != null ? this.collectionServerConfiguration.collectionName : "") + " - Visual Attributes";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-configurations-node-icon.gif");
    }

    public boolean equals(Object object) {
        if (object instanceof CollectionServerConfigurationVisualAttributes) {
            CollectionServerConfigurationVisualAttributes collectionServerConfigurationVisualAttributes = (CollectionServerConfigurationVisualAttributes)object;
            return this.collectionServerConfiguration.equals(collectionServerConfigurationVisualAttributes.collectionServerConfiguration);
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CollectionServerConfigurationVisualAttributes) {
            CollectionServerConfigurationVisualAttributes collectionServerConfigurationVisualAttributes = (CollectionServerConfigurationVisualAttributes)databaseRecord;
            return this.backgroundColorR == collectionServerConfigurationVisualAttributes.backgroundColorR && this.backgroundColorG == collectionServerConfigurationVisualAttributes.backgroundColorG && this.backgroundColorB == collectionServerConfigurationVisualAttributes.backgroundColorB && this.verticalBarX == collectionServerConfigurationVisualAttributes.verticalBarX && this.horizontalBarY == collectionServerConfigurationVisualAttributes.horizontalBarY && CollectionServerConfigurationVisualAttributes.stringsAreEqual(this.bgUrl, collectionServerConfigurationVisualAttributes.bgUrl) && this.menuXPosition == collectionServerConfigurationVisualAttributes.menuXPosition && this.maximumWindows == collectionServerConfigurationVisualAttributes.maximumWindows && this.interWindowSpacing == collectionServerConfigurationVisualAttributes.interWindowSpacing && this.minImageWindowSizeWidth == collectionServerConfigurationVisualAttributes.minImageWindowSizeWidth && this.minImageWindowSizeHeight == collectionServerConfigurationVisualAttributes.minImageWindowSizeHeight && this.macWidthAdjustment == collectionServerConfigurationVisualAttributes.macWidthAdjustment && this.defaultViewResolution == collectionServerConfigurationVisualAttributes.defaultViewResolution && this.groupTopInset == collectionServerConfigurationVisualAttributes.groupTopInset && this.groupLeftInset == collectionServerConfigurationVisualAttributes.groupLeftInset && this.groupSpacingH == collectionServerConfigurationVisualAttributes.groupSpacingH && this.groupSpacingV == collectionServerConfigurationVisualAttributes.groupSpacingV;
        }
        return false;
    }

    public void chooseBgColor() {
        if (this.colorChooserEditDialog == null) {
            String string = "";
            if (this.collectionServerConfiguration != null) {
                string = this.collectionServerConfiguration.collectionName + " - ";
            }
            string = string + "Background Color";
            this.colorChooserEditDialog = new EditDialog(null, false, new ColorChooser(this, string, ""));
            this.colorChooserEditDialog.show();
        } else {
            InsightAdministrator.getInsightAdministrator().setSelectedFrame(this.colorChooserEditDialog);
        }
    }

    public Color getColor(ColorChooser colorChooser) {
        Color color = null;
        try {
            color = new Color(this.candidateBackgroundColorR, this.candidateBackgroundColorG, this.candidateBackgroundColorB);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            color = Color.black;
        }
        return color;
    }

    public void setNewColor(ColorChooser colorChooser, Color color) {
        if (color != null) {
            this.candidateBackgroundColorR = color.getRed();
            this.candidateBackgroundColorG = color.getGreen();
            this.candidateBackgroundColorB = color.getBlue();
            this.editComponent.getBgColorDisplayPanel().setBackground(color);
            String string = "[" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + "]";
            this.editComponent.getBgColorRGBLabel().setText(string);
        }
    }

    public void cancelColorChooserEdit(ColorChooser colorChooser) {
        this.colorChooserEditDialog = null;
    }

    public static void debugOut(String string) {
        CollectionServerConfigurationVisualAttributes.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerConfigurationVisualAttributes: " + string, n);
    }
}

