/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.config;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.profile.CollectionServerProfile;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class CollectionServerConfigurationRecordHandler
extends DatabaseRecordHandler {
    protected boolean localeEditingEnabled = false;
    protected boolean copyrightStatementExists = false;
    protected boolean forceCollectionNameExists = false;

    public CollectionServerConfigurationRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CollectionServerConfigurationRecordHandler";
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        this.setLocaleEditingEnabled(databaseConnector);
        try {
            this.copyrightStatementExists = SqlQueryGenerator.doesColumnExist(databaseConnector, "CopyrightStatement", "IRCOLLECTIONCONFIGURATIONINFO", true);
        }
        catch (Exception exception) {
            this.copyrightStatementExists = false;
        }
        try {
            this.forceCollectionNameExists = SqlQueryGenerator.doesColumnExist(databaseConnector, "ForceCollectionNameDisplay", "IRCOLLECTIONCONFIGURATIONINFO", true);
        }
        catch (Exception exception) {
            this.forceCollectionNameExists = false;
        }
        databaseConnector.close();
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        Serializable serializable;
        CollectionServerConfiguration collectionServerConfiguration;
        try {
            collectionServerConfiguration = (CollectionServerConfiguration)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            StringBuffer stringBuffer = new StringBuffer();
            serializable = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, (StringBuffer)serializable, collectionServerConfiguration.getUniqueCollectionID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "InstitutionID", 1, (StringBuffer)serializable, collectionServerConfiguration.institutionID);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CollectionID", 1, (StringBuffer)serializable, collectionServerConfiguration.collectionID);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "VCID", 1, (StringBuffer)serializable, collectionServerConfiguration.vcID);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CollectionName", 1, (StringBuffer)serializable, collectionServerConfiguration.collectionName);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "InitialActivity", 2, (StringBuffer)serializable, collectionServerConfiguration.initialActivity);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "InitialGroupOpen", 1, (StringBuffer)serializable, collectionServerConfiguration.initialGroupOpen);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "NativeStandardID", 2, (StringBuffer)serializable, collectionServerConfiguration.nativeStandardID);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DisplayArtistStories", 2, (StringBuffer)serializable, collectionServerConfiguration.displayArtistStories);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "VerticalBarX", 2, (StringBuffer)serializable, collectionServerConfiguration.getVerticalBarX());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HorizontalBarY", 2, (StringBuffer)serializable, collectionServerConfiguration.getHorizontalBarY());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BackgroundColorR", 2, (StringBuffer)serializable, collectionServerConfiguration.getBackgroundColorR());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BackgroundColorG", 2, (StringBuffer)serializable, collectionServerConfiguration.getBackgroundColorG());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BackgroundColorB", 2, (StringBuffer)serializable, collectionServerConfiguration.getBackgroundColorB());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UserCollection", 2, (StringBuffer)serializable, collectionServerConfiguration.getUserCollection());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LargeThumbnailThreshold", 2, (StringBuffer)serializable, collectionServerConfiguration.largeThumbnailThreshold);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DefaultViewResolution", 2, (StringBuffer)serializable, collectionServerConfiguration.getDefaultViewResolution());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupTopInset", 2, (StringBuffer)serializable, collectionServerConfiguration.getGroupTopInset());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupLeftInset", 2, (StringBuffer)serializable, collectionServerConfiguration.getGroupLeftInset());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupSpacingH", 2, (StringBuffer)serializable, collectionServerConfiguration.getGroupSpacingH());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "GroupSpacingV", 2, (StringBuffer)serializable, collectionServerConfiguration.getGroupSpacingV());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MenuXPosition", 2, (StringBuffer)serializable, collectionServerConfiguration.getMenuXPosition());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MaximumWindows", 2, (StringBuffer)serializable, collectionServerConfiguration.getMaximumWindows());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "InterWindowSpacing", 2, (StringBuffer)serializable, collectionServerConfiguration.getInterWindowSpacing());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MinImageWindowSizeWidth", 2, (StringBuffer)serializable, collectionServerConfiguration.getMinImageWindowSizeWidth());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MinImageWindowSizeHeight", 2, (StringBuffer)serializable, collectionServerConfiguration.getMinImageWindowSizeHeight());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DragSpeedCoeffecient", 2, (StringBuffer)serializable, collectionServerConfiguration.dragSpeedCoefficient);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DefaultSortField1", 1, (StringBuffer)serializable, collectionServerConfiguration.getSort1FieldID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DefaultSortField2", 1, (StringBuffer)serializable, collectionServerConfiguration.getSort2FieldID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DefaultSortField3", 1, (StringBuffer)serializable, collectionServerConfiguration.getSort3FieldID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DefaultSortField4", 1, (StringBuffer)serializable, collectionServerConfiguration.getSort4FieldID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "InitialGroupROnly", 2, (StringBuffer)serializable, collectionServerConfiguration.initialGroupROnly);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HelpGroup", 1, (StringBuffer)serializable, collectionServerConfiguration.helpGroup);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "HelpImage", 1, (StringBuffer)serializable, collectionServerConfiguration.helpImage);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SimultaneousIWLoads", 2, (StringBuffer)serializable, collectionServerConfiguration.simultaneousIWLoads);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SimultaneousGWLoads", 2, (StringBuffer)serializable, collectionServerConfiguration.simultaneousGWLoads);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RemoteLaunchBaseURL", 1, (StringBuffer)serializable, collectionServerConfiguration.remoteLaunchBaseURL);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "RemoteLaunchHyperlinkTemplate", 1, (StringBuffer)serializable, collectionServerConfiguration.remoteLaunchHyperlinkTemplate);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MacWidthAdjustment", 2, (StringBuffer)serializable, collectionServerConfiguration.getMacWidthAdjustment());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ThumbnailDataField1", 1, (StringBuffer)serializable, collectionServerConfiguration.getThumbnail1FieldID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ThumbnailDataField2", 1, (StringBuffer)serializable, collectionServerConfiguration.getThumbnail2FieldID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ThumbnailDataField3", 1, (StringBuffer)serializable, collectionServerConfiguration.getThumbnail3FieldID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ThumbnailDataField4", 1, (StringBuffer)serializable, collectionServerConfiguration.getThumbnail4FieldID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BGURL", 1, (StringBuffer)serializable, collectionServerConfiguration.getBgUrl());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "FastScaling", 2, (StringBuffer)serializable, collectionServerConfiguration.fastScaling);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ShortDescription", 1, (StringBuffer)serializable, collectionServerConfiguration.shortDescription);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LongDescriptionURL", 1, (StringBuffer)serializable, collectionServerConfiguration.longDescriptionUrl);
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserRTLURL", 1, (StringBuffer)serializable, collectionServerConfiguration.getRtlUrl());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserRTLImage", 1, (StringBuffer)serializable, collectionServerConfiguration.getRtlImage());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ThumbCacheProfileID", 2, (StringBuffer)serializable, collectionServerConfiguration.getThumbCacheProfileId());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGLoading", 1, (StringBuffer)serializable, collectionServerConfiguration.getBgLoading());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGMenu", 1, (StringBuffer)serializable, collectionServerConfiguration.getBgMenu());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGProgressOn", 1, (StringBuffer)serializable, collectionServerConfiguration.getBgProgressOn());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGProgressOff", 1, (StringBuffer)serializable, collectionServerConfiguration.getBgProgressOff());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGGroupLeft", 1, (StringBuffer)serializable, collectionServerConfiguration.getBgGroupLeft());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGGroupLeftNS", 1, (StringBuffer)serializable, collectionServerConfiguration.getBgGroupLeftNS());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGGroupRight", 1, (StringBuffer)serializable, collectionServerConfiguration.getBgGroupRight());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGGWBottom", 1, (StringBuffer)serializable, collectionServerConfiguration.getBgGWBottom());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGGWTop", 1, (StringBuffer)serializable, collectionServerConfiguration.getBgGWTop());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserBGGroupLeftHtml", 1, (StringBuffer)serializable, collectionServerConfiguration.getBgGroupLeftHtml());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BrowserSecurity", 2, (StringBuffer)serializable, collectionServerConfiguration.getBrowserSecurity() ? "1" : "0");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "IsPersonalCollection", 2, (StringBuffer)serializable, collectionServerConfiguration.isPersonalCollection() ? "1" : "0");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PcOwnerID", 2, (StringBuffer)serializable, collectionServerConfiguration.getPcOwnerID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PcOwnerUserGroupID", 2, (StringBuffer)serializable, collectionServerConfiguration.getPcOwnerUserGroupID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PcUserGroupMemberPrivs", 2, (StringBuffer)serializable, collectionServerConfiguration.getPcUserGroupMemberPrivs());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PcNonUserGroupMemberPrivs", 2, (StringBuffer)serializable, collectionServerConfiguration.getPcNonUserGroupMemberPrivs());
            if (this.localeEditingEnabled) {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LanguageCode", 1, (StringBuffer)serializable, collectionServerConfiguration.languageCode);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CountryCode", 1, (StringBuffer)serializable, collectionServerConfiguration.countryCode);
            }
            if (this.copyrightStatementExists) {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CopyrightStatement", 1, (StringBuffer)serializable, collectionServerConfiguration.getCopyrightStmt());
            }
            if (this.forceCollectionNameExists) {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ForceCollectionNameDisplay", 2, (StringBuffer)serializable, collectionServerConfiguration.forceCollectionName() ? "1" : "0");
            }
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CreatedTimestamp", 1, (StringBuffer)serializable, collectionServerConfiguration.createdTimestamp);
            databaseConnector.setQuery("INSERT INTO IRCOLLECTIONCONFIGURATIONINFO (" + stringBuffer.toString() + ")" + " VALUES (" + ((StringBuffer)serializable).toString() + ")");
            this.debugOut("Insert config query query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
        try {
            collectionServerConfiguration = (CollectionServerConfiguration)databaseRecord;
            if (collectionServerConfiguration.originalCollectionID.equals("0") && !collectionServerConfiguration.collectionID.equals("0")) {
                int n = Integer.parseInt(collectionServerConfiguration.originalCollectionID);
                int n2 = Integer.parseInt(collectionServerConfiguration.collectionID);
                serializable = ((CollectionServerConnector)this.serverConnector).getProfileRecords(n);
                for (int i = 0; i < serializable.size(); ++i) {
                    CollectionServerProfile collectionServerProfile = (CollectionServerProfile)serializable.get(i);
                    collectionServerProfile.collectionId = n2;
                    ((CollectionServerConnector)this.serverConnector).commitRecord(collectionServerProfile);
                    collectionServerProfile.collectionId = n;
                    ((CollectionServerConnector)this.serverConnector).deleteRecord(collectionServerProfile);
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("doInsert(): caught exception trying to update collection ID for new profile: \n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        try {
            String string = ((CollectionServerConfiguration)databaseRecord).institutionID;
            String string2 = ((CollectionServerConfiguration)databaseRecord).collectionID;
            String string3 = ((CollectionServerConfiguration)databaseRecord).vcID;
            String string4 = ((CollectionServerConfiguration)databaseRecord).originalInstitutionID;
            String string5 = ((CollectionServerConfiguration)databaseRecord).originalCollectionID;
            String string6 = ((CollectionServerConfiguration)databaseRecord).originalVcID;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string7 = "DELETE FROM IRCOLLECTIONCONFIGURATIONINFO WHERE (InstitutionID = '" + string4 + "' AND CollectionID = '" + string5 + "' AND VCID = '" + string6 + "')";
            databaseConnector.setQuery(string7);
            this.debugOut("deleteConfigurationQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public Vector getRecords() {
        return this.getRecords(null, false);
    }

    public Vector getRecords(Integer n, boolean bl) {
        this.debugOut("in getRecords()");
        Vector vector = new Vector();
        try {
            Object object;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, "*");
            if (n != null) {
                sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
            }
            if (bl) {
                sqlQueryGenerator.appendToWhere("IsPersonalCollection = 0");
            }
            sqlQueryGenerator.addOrderBy("IRCOLLECTIONCONFIGURATIONINFO", "InstitutionID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Configurations query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    object = new Hashtable();
                    Integer n2 = new Integer(databaseConnector.getIntegerFieldByName("UniqueCollectionID"));
                    this.putInHashTable((Hashtable)object, "institutionID", databaseConnector.getFieldByName("InstitutionID"));
                    this.putInHashTable((Hashtable)object, "collectionID", databaseConnector.getFieldByName("CollectionID"));
                    this.putInHashTable((Hashtable)object, "vcID", databaseConnector.getFieldByName("VCID"));
                    this.putInHashTable((Hashtable)object, "collectionName", databaseConnector.getFieldByName("CollectionName"));
                    this.putInHashTable((Hashtable)object, "initialActivity", new Integer(databaseConnector.getIntegerFieldByName("InitialActivity")));
                    this.putInHashTable((Hashtable)object, "initialGroupOpen", databaseConnector.getFieldByName("InitialGroupOpen"));
                    this.putInHashTable((Hashtable)object, "nativeStandardID", new Integer(databaseConnector.getIntegerFieldByName("NativeStandardID")));
                    this.putInHashTable((Hashtable)object, "displayArtistStories", new Integer(databaseConnector.getIntegerFieldByName("DisplayArtistStories")));
                    this.putInHashTable((Hashtable)object, "verticalBarX", new Integer(databaseConnector.getIntegerFieldByName("VerticalBarX")));
                    this.putInHashTable((Hashtable)object, "horizontalBarY", new Integer(databaseConnector.getIntegerFieldByName("HorizontalBarY")));
                    this.putInHashTable((Hashtable)object, "backgroundColorR", new Integer(databaseConnector.getIntegerFieldByName("BackgroundColorR")));
                    this.putInHashTable((Hashtable)object, "backgroundColorG", new Integer(databaseConnector.getIntegerFieldByName("BackgroundColorG")));
                    this.putInHashTable((Hashtable)object, "backgroundColorB", new Integer(databaseConnector.getIntegerFieldByName("BackgroundColorB")));
                    this.putInHashTable((Hashtable)object, "userCollection", new Integer(databaseConnector.getIntegerFieldByName("UserCollection")));
                    this.putInHashTable((Hashtable)object, "largeThumbnailThreshold", new Integer(databaseConnector.getIntegerFieldByName("LargeThumbnailThreshold")));
                    this.putInHashTable((Hashtable)object, "defaultViewResolution", new Integer(databaseConnector.getIntegerFieldByName("DefaultViewResolution")));
                    this.putInHashTable((Hashtable)object, "groupTopInset", new Integer(databaseConnector.getIntegerFieldByName("GroupTopInset")));
                    this.putInHashTable((Hashtable)object, "groupLeftInset", new Integer(databaseConnector.getIntegerFieldByName("GroupLeftInset")));
                    this.putInHashTable((Hashtable)object, "groupSpacingH", new Integer(databaseConnector.getIntegerFieldByName("GroupSpacingH")));
                    this.putInHashTable((Hashtable)object, "groupSpacingV", new Integer(databaseConnector.getIntegerFieldByName("GroupSpacingV")));
                    this.putInHashTable((Hashtable)object, "menuXPosition", new Integer(databaseConnector.getIntegerFieldByName("MenuXPosition")));
                    this.putInHashTable((Hashtable)object, "maximumWindows", new Integer(databaseConnector.getIntegerFieldByName("MaximumWindows")));
                    this.putInHashTable((Hashtable)object, "interWindowSpacing", new Integer(databaseConnector.getIntegerFieldByName("InterWindowSpacing")));
                    this.putInHashTable((Hashtable)object, "minImageWindowSizeWidth", new Integer(databaseConnector.getIntegerFieldByName("MinImageWindowSizeWidth")));
                    this.putInHashTable((Hashtable)object, "minImageWindowSizeHeight", new Integer(databaseConnector.getIntegerFieldByName("MinImageWindowSizeHeight")));
                    this.putInHashTable((Hashtable)object, "dragSpeedCoefficient", new Integer(databaseConnector.getIntegerFieldByName("DragSpeedCoeffecient")));
                    this.putInHashTable((Hashtable)object, "initialGroupROnly", new Integer(databaseConnector.getIntegerFieldByName("InitialGroupROnly")));
                    this.putInHashTable((Hashtable)object, "helpGroup", databaseConnector.getFieldByName("HelpGroup"));
                    this.putInHashTable((Hashtable)object, "helpImage", databaseConnector.getFieldByName("HelpImage"));
                    this.putInHashTable((Hashtable)object, "simultaneousIWLoads", new Integer(databaseConnector.getIntegerFieldByName("SimultaneousIWLoads")));
                    this.putInHashTable((Hashtable)object, "simultaneousGWLoads", new Integer(databaseConnector.getIntegerFieldByName("SimultaneousGWLoads")));
                    this.putInHashTable((Hashtable)object, "remoteLaunchBaseURL", databaseConnector.getFieldByName("RemoteLaunchBaseURL"));
                    this.putInHashTable((Hashtable)object, "remoteLaunchHyperlinkTemplate", databaseConnector.getFieldByName("RemoteLaunchHyperlinkTemplate"));
                    this.putInHashTable((Hashtable)object, "macWidthAdjustment", new Integer(databaseConnector.getIntegerFieldByName("MacWidthAdjustment")));
                    this.putInHashTable((Hashtable)object, "bgUrl", databaseConnector.getFieldByName("BGURL"));
                    this.putInHashTable((Hashtable)object, "fastScaling", new Integer(databaseConnector.getIntegerFieldByName("FastScaling")));
                    this.putInHashTable((Hashtable)object, "shortDescription", databaseConnector.getFieldByName("ShortDescription"));
                    this.putInHashTable((Hashtable)object, "longDescriptionUrl", databaseConnector.getFieldByName("LongDescriptionURL"));
                    this.putInHashTable((Hashtable)object, "thumbCacheProfileId", new Integer(databaseConnector.getIntegerFieldByName("ThumbCacheProfileID")));
                    this.putInHashTable((Hashtable)object, "thumbnail1FieldID", new Integer(databaseConnector.getIntegerFieldByName("ThumbnailDataField1")));
                    this.putInHashTable((Hashtable)object, "thumbnail2FieldID", new Integer(databaseConnector.getIntegerFieldByName("ThumbnailDataField2")));
                    this.putInHashTable((Hashtable)object, "thumbnail3FieldID", new Integer(databaseConnector.getIntegerFieldByName("ThumbnailDataField3")));
                    this.putInHashTable((Hashtable)object, "thumbnail4FieldID", new Integer(databaseConnector.getIntegerFieldByName("ThumbnailDataField4")));
                    this.putInHashTable((Hashtable)object, "sort1FieldID", new Integer(databaseConnector.getIntegerFieldByName("DefaultSortField1")));
                    this.putInHashTable((Hashtable)object, "sort2FieldID", new Integer(databaseConnector.getIntegerFieldByName("DefaultSortField2")));
                    this.putInHashTable((Hashtable)object, "sort3FieldID", new Integer(databaseConnector.getIntegerFieldByName("DefaultSortField3")));
                    this.putInHashTable((Hashtable)object, "sort4FieldID", new Integer(databaseConnector.getIntegerFieldByName("DefaultSortField4")));
                    this.putInHashTable((Hashtable)object, "rtlUrl", databaseConnector.getFieldByName("BrowserRTLURL"));
                    this.putInHashTable((Hashtable)object, "rtlImage", databaseConnector.getFieldByName("BrowserRTLImage"));
                    this.putInHashTable((Hashtable)object, "bgLoading", databaseConnector.getFieldByName("BrowserBGLoading"));
                    this.putInHashTable((Hashtable)object, "bgMenu", databaseConnector.getFieldByName("BrowserBGMenu"));
                    this.putInHashTable((Hashtable)object, "bgProgressOn", databaseConnector.getFieldByName("BrowserBGProgressOn"));
                    this.putInHashTable((Hashtable)object, "bgProgressOff", databaseConnector.getFieldByName("BrowserBGProgressOff"));
                    this.putInHashTable((Hashtable)object, "bgGroupLeft", databaseConnector.getFieldByName("BrowserBGGroupLeft"));
                    this.putInHashTable((Hashtable)object, "bgGroupLeftNS", databaseConnector.getFieldByName("BrowserBGGroupLeftNS"));
                    this.putInHashTable((Hashtable)object, "bgGroupRight", databaseConnector.getFieldByName("BrowserBGGroupRight"));
                    this.putInHashTable((Hashtable)object, "bgGWBottom", databaseConnector.getFieldByName("BrowserBGGWBottom"));
                    this.putInHashTable((Hashtable)object, "bgGWTop", databaseConnector.getFieldByName("BrowserBGGWTop"));
                    this.putInHashTable((Hashtable)object, "bgGroupLeftHtml", databaseConnector.getFieldByName("BrowserBGGroupLeftHtml"));
                    this.putInHashTable((Hashtable)object, "browserSecurity", new Boolean(databaseConnector.getIntegerFieldByName("BrowserSecurity") == 1));
                    this.putInHashTable((Hashtable)object, "isPersonalCollection", new Boolean(databaseConnector.getBooleanField("IsPersonalCollection")));
                    this.putInHashTable((Hashtable)object, "pcOwnerID", new Integer(databaseConnector.getIntegerFieldByName("PcOwnerID")));
                    this.putInHashTable((Hashtable)object, "pcOwnerUserGroupID", new Integer(databaseConnector.getIntegerFieldByName("PcOwnerUserGroupID")));
                    this.putInHashTable((Hashtable)object, "pcUserGroupMemberPrivs", new Integer(databaseConnector.getIntegerFieldByName("PcUserGroupMemberPrivs")));
                    this.putInHashTable((Hashtable)object, "pcNonUserGroupMemberPrivs", new Integer(databaseConnector.getIntegerFieldByName("PcNonUserGroupMemberPrivs")));
                    this.putInHashTable((Hashtable)object, "createdTimestamp", databaseConnector.getFieldByName("CreatedTimestamp"));
                    if (this.localeEditingEnabled) {
                        this.putInHashTable((Hashtable)object, "localeEditingEnabled", new Boolean(true));
                        this.putInHashTable((Hashtable)object, "languageCode", databaseConnector.getFieldByName("LanguageCode"));
                        this.putInHashTable((Hashtable)object, "countryCode", databaseConnector.getFieldByName("CountryCode"));
                    }
                    if (this.copyrightStatementExists) {
                        this.putInHashTable((Hashtable)object, "CopyrightStmtEnabled", new Boolean(true));
                        this.putInHashTable((Hashtable)object, "CopyrightStatement", databaseConnector.getStringField("CopyrightStatement"));
                    }
                    if (this.forceCollectionNameExists) {
                        this.putInHashTable((Hashtable)object, "ForceCollectionNameEnabled", new Boolean(true));
                        this.putInHashTable((Hashtable)object, "ForceCollectionNameDisplay", new Boolean(databaseConnector.getBooleanField("ForceCollectionNameDisplay")));
                    }
                    Collection collection = ((CollectionServer)this.serverConnector.getAdministeredServer()).getServerNode().getCollectionNode(n2).getCollection();
                    CollectionServerConfiguration collectionServerConfiguration = new CollectionServerConfiguration(n2, collection, (Hashtable)object);
                    hashtable.put(collectionServerConfiguration.institutionID + "-" + collectionServerConfiguration.collectionID + "-" + collectionServerConfiguration.vcID, collectionServerConfiguration);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            if (bl) {
                object = new CollectionServerConfiguration("Personal Collections", 0);
                hashtable.put("personalcollections", object);
            }
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception + "NOT necessarily a problem.");
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        String string = ((CollectionServerConfiguration)databaseRecord).originalInstitutionID;
        String string2 = ((CollectionServerConfiguration)databaseRecord).originalCollectionID;
        String string3 = ((CollectionServerConfiguration)databaseRecord).originalVcID;
        return this.getTheRecord(string, string2, string3);
    }

    public DatabaseRecord getUpdatedRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getUpdatedRecord()");
        String string = ((CollectionServerConfiguration)databaseRecord).institutionID;
        String string2 = ((CollectionServerConfiguration)databaseRecord).collectionID;
        String string3 = ((CollectionServerConfiguration)databaseRecord).vcID;
        return this.getTheRecord(string, string2, string3);
    }

    protected DatabaseRecord getTheRecord(String string, String string2, String string3) {
        CollectionServerConfiguration collectionServerConfiguration = null;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, "*");
            sqlQueryGenerator.appendToWhere("InstitutionID = '" + string + "' AND CollectionID = '" + string2 + "' AND VCID = '" + string3 + "'");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Configuration query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                Hashtable hashtable = new Hashtable();
                Integer n = new Integer(databaseConnector.getIntegerField("UniqueCollectionID"));
                this.putInHashTable(hashtable, "institutionID", databaseConnector.getFieldByName("InstitutionID"));
                this.putInHashTable(hashtable, "collectionID", databaseConnector.getFieldByName("CollectionID"));
                this.putInHashTable(hashtable, "vcID", databaseConnector.getFieldByName("VCID"));
                this.putInHashTable(hashtable, "collectionName", databaseConnector.getFieldByName("CollectionName"));
                this.putInHashTable(hashtable, "initialActivity", new Integer(databaseConnector.getIntegerFieldByName("InitialActivity")));
                this.putInHashTable(hashtable, "initialGroupOpen", databaseConnector.getFieldByName("InitialGroupOpen"));
                this.putInHashTable(hashtable, "nativeStandardID", new Integer(databaseConnector.getIntegerFieldByName("NativeStandardID")));
                this.putInHashTable(hashtable, "displayArtistStories", new Integer(databaseConnector.getIntegerFieldByName("DisplayArtistStories")));
                this.putInHashTable(hashtable, "verticalBarX", new Integer(databaseConnector.getIntegerFieldByName("VerticalBarX")));
                this.putInHashTable(hashtable, "horizontalBarY", new Integer(databaseConnector.getIntegerFieldByName("HorizontalBarY")));
                this.putInHashTable(hashtable, "backgroundColorR", new Integer(databaseConnector.getIntegerFieldByName("BackgroundColorR")));
                this.putInHashTable(hashtable, "backgroundColorG", new Integer(databaseConnector.getIntegerFieldByName("BackgroundColorG")));
                this.putInHashTable(hashtable, "backgroundColorB", new Integer(databaseConnector.getIntegerFieldByName("BackgroundColorB")));
                this.putInHashTable(hashtable, "userCollection", new Integer(databaseConnector.getIntegerFieldByName("UserCollection")));
                this.putInHashTable(hashtable, "largeThumbnailThreshold", new Integer(databaseConnector.getIntegerFieldByName("LargeThumbnailThreshold")));
                this.putInHashTable(hashtable, "defaultViewResolution", new Integer(databaseConnector.getIntegerFieldByName("DefaultViewResolution")));
                this.putInHashTable(hashtable, "groupTopInset", new Integer(databaseConnector.getIntegerFieldByName("GroupTopInset")));
                this.putInHashTable(hashtable, "groupLeftInset", new Integer(databaseConnector.getIntegerFieldByName("GroupLeftInset")));
                this.putInHashTable(hashtable, "groupSpacingH", new Integer(databaseConnector.getIntegerFieldByName("GroupSpacingH")));
                this.putInHashTable(hashtable, "groupSpacingV", new Integer(databaseConnector.getIntegerFieldByName("GroupSpacingV")));
                this.putInHashTable(hashtable, "menuXPosition", new Integer(databaseConnector.getIntegerFieldByName("MenuXPosition")));
                this.putInHashTable(hashtable, "maximumWindows", new Integer(databaseConnector.getIntegerFieldByName("MaximumWindows")));
                this.putInHashTable(hashtable, "interWindowSpacing", new Integer(databaseConnector.getIntegerFieldByName("InterWindowSpacing")));
                this.putInHashTable(hashtable, "minImageWindowSizeWidth", new Integer(databaseConnector.getIntegerFieldByName("MinImageWindowSizeWidth")));
                this.putInHashTable(hashtable, "minImageWindowSizeHeight", new Integer(databaseConnector.getIntegerFieldByName("MinImageWindowSizeHeight")));
                this.putInHashTable(hashtable, "dragSpeedCoefficient", new Integer(databaseConnector.getIntegerFieldByName("DragSpeedCoeffecient")));
                this.putInHashTable(hashtable, "initialGroupROnly", new Integer(databaseConnector.getIntegerFieldByName("InitialGroupROnly")));
                this.putInHashTable(hashtable, "helpGroup", databaseConnector.getFieldByName("HelpGroup"));
                this.putInHashTable(hashtable, "helpImage", databaseConnector.getFieldByName("HelpImage"));
                this.putInHashTable(hashtable, "simultaneousIWLoads", new Integer(databaseConnector.getIntegerFieldByName("SimultaneousIWLoads")));
                this.putInHashTable(hashtable, "simultaneousGWLoads", new Integer(databaseConnector.getIntegerFieldByName("SimultaneousGWLoads")));
                this.putInHashTable(hashtable, "remoteLaunchBaseURL", databaseConnector.getFieldByName("RemoteLaunchBaseURL"));
                this.putInHashTable(hashtable, "remoteLaunchHyperlinkTemplate", databaseConnector.getFieldByName("RemoteLaunchHyperlinkTemplate"));
                this.putInHashTable(hashtable, "macWidthAdjustment", new Integer(databaseConnector.getIntegerFieldByName("MacWidthAdjustment")));
                this.putInHashTable(hashtable, "bgUrl", databaseConnector.getFieldByName("BGURL"));
                this.putInHashTable(hashtable, "fastScaling", new Integer(databaseConnector.getIntegerFieldByName("FastScaling")));
                this.putInHashTable(hashtable, "shortDescription", databaseConnector.getFieldByName("ShortDescription"));
                this.putInHashTable(hashtable, "longDescriptionUrl", databaseConnector.getFieldByName("LongDescriptionURL"));
                this.putInHashTable(hashtable, "thumbCacheProfileId", new Integer(databaseConnector.getIntegerFieldByName("ThumbCacheProfileID")));
                this.putInHashTable(hashtable, "thumbnail1FieldID", new Integer(databaseConnector.getIntegerFieldByName("ThumbnailDataField1")));
                this.putInHashTable(hashtable, "thumbnail2FieldID", new Integer(databaseConnector.getIntegerFieldByName("ThumbnailDataField2")));
                this.putInHashTable(hashtable, "thumbnail3FieldID", new Integer(databaseConnector.getIntegerFieldByName("ThumbnailDataField3")));
                this.putInHashTable(hashtable, "thumbnail4FieldID", new Integer(databaseConnector.getIntegerFieldByName("ThumbnailDataField4")));
                this.putInHashTable(hashtable, "sort1FieldID", new Integer(databaseConnector.getIntegerFieldByName("DefaultSortField1")));
                this.putInHashTable(hashtable, "sort2FieldID", new Integer(databaseConnector.getIntegerFieldByName("DefaultSortField2")));
                this.putInHashTable(hashtable, "sort3FieldID", new Integer(databaseConnector.getIntegerFieldByName("DefaultSortField3")));
                this.putInHashTable(hashtable, "sort4FieldID", new Integer(databaseConnector.getIntegerFieldByName("DefaultSortField4")));
                this.putInHashTable(hashtable, "rtlUrl", databaseConnector.getFieldByName("BrowserRTLURL"));
                this.putInHashTable(hashtable, "rtlImage", databaseConnector.getFieldByName("BrowserRTLImage"));
                this.putInHashTable(hashtable, "bgLoading", databaseConnector.getFieldByName("BrowserBGLoading"));
                this.putInHashTable(hashtable, "bgMenu", databaseConnector.getFieldByName("BrowserBGMenu"));
                this.putInHashTable(hashtable, "bgProgressOn", databaseConnector.getFieldByName("BrowserBGProgressOn"));
                this.putInHashTable(hashtable, "bgProgressOff", databaseConnector.getFieldByName("BrowserBGProgressOff"));
                this.putInHashTable(hashtable, "bgGroupLeft", databaseConnector.getFieldByName("BrowserBGGroupLeft"));
                this.putInHashTable(hashtable, "bgGroupLeftNS", databaseConnector.getFieldByName("BrowserBGGroupLeftNS"));
                this.putInHashTable(hashtable, "bgGroupRight", databaseConnector.getFieldByName("BrowserBGGroupRight"));
                this.putInHashTable(hashtable, "bgGWBottom", databaseConnector.getFieldByName("BrowserBGGWBottom"));
                this.putInHashTable(hashtable, "bgGWTop", databaseConnector.getFieldByName("BrowserBGGWTop"));
                this.putInHashTable(hashtable, "bgGroupLeftHtml", databaseConnector.getFieldByName("BrowserBGGroupLeftHtml"));
                this.putInHashTable(hashtable, "browserSecurity", new Boolean(databaseConnector.getIntegerFieldByName("BrowserSecurity") == 1));
                this.putInHashTable(hashtable, "isPersonalCollection", new Boolean(databaseConnector.getBooleanField("IsPersonalCollection")));
                this.putInHashTable(hashtable, "pcOwnerID", new Integer(databaseConnector.getIntegerFieldByName("PcOwnerID")));
                this.putInHashTable(hashtable, "pcOwnerUserGroupID", new Integer(databaseConnector.getIntegerFieldByName("PcOwnerUserGroupID")));
                this.putInHashTable(hashtable, "pcUserGroupMemberPrivs", new Integer(databaseConnector.getIntegerFieldByName("PcUserGroupMemberPrivs")));
                this.putInHashTable(hashtable, "pcNonUserGroupMemberPrivs", new Integer(databaseConnector.getIntegerFieldByName("PcNonUserGroupMemberPrivs")));
                this.putInHashTable(hashtable, "createdTimestamp", databaseConnector.getFieldByName("CreatedTimestamp"));
                if (this.localeEditingEnabled) {
                    this.putInHashTable(hashtable, "localeEditingEnabled", new Boolean(true));
                    this.putInHashTable(hashtable, "languageCode", databaseConnector.getFieldByName("LanguageCode"));
                    this.putInHashTable(hashtable, "countryCode", databaseConnector.getFieldByName("CountryCode"));
                }
                if (this.copyrightStatementExists) {
                    this.putInHashTable(hashtable, "CopyrightStmtEnabled", new Boolean(true));
                    this.putInHashTable(hashtable, "CopyrightStatement", databaseConnector.getStringField("CopyrightStatement"));
                }
                if (this.forceCollectionNameExists) {
                    this.putInHashTable(hashtable, "ForceCollectionNameEnabled", new Boolean(true));
                    this.putInHashTable(hashtable, "ForceCollectionNameDisplay", new Boolean(databaseConnector.getBooleanField("ForceCollectionNameDisplay")));
                }
                Collection collection = ((CollectionServer)this.serverConnector.getAdministeredServer()).getServerNode().getCollectionNode(n).getCollection();
                collectionServerConfiguration = new CollectionServerConfiguration(n, collection, hashtable);
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord(): " + exception);
        }
        return collectionServerConfiguration;
    }

    public String getNextValidIDQuery() {
        return "";
    }

    protected void putInHashTable(Hashtable hashtable, String string, Object object) {
        if (object != null && string != null) {
            hashtable.put(string, object);
        }
    }

    protected void setLocaleEditingEnabled(DatabaseConnector databaseConnector) {
        if (databaseConnector == null) {
            databaseConnector = this.getDatabaseConnector();
        }
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, new String[]{"LanguageCode", "CountryCode"});
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Locale editing support query: " + databaseConnector.getQuery());
            this.localeEditingEnabled = true;
            try {
                databaseConnector.runQuery();
                String string = databaseConnector.getFieldByName("LanguageCode");
                String string2 = databaseConnector.getFieldByName("CountryCode");
            }
            catch (Exception exception) {
                this.debugOut("setLocaleEditingEnabled(): database query failed, so setting localeEditingEnabled=false.");
                this.localeEditingEnabled = false;
            }
        }
        catch (Exception exception) {
            this.localeEditingEnabled = false;
        }
        databaseConnector.close();
    }

    public void updateMaxIDValue(long l) {
    }
}

