/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.config;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationInstitutionIDEditComponent;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroup;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CollectionServerConfigurationInstitutionID
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    public CollectionServerConfiguration collectionServerConfiguration;
    protected String newIID = "";
    protected CollectionServerConfigurationInstitutionIDEditComponent editComponent = null;

    public CollectionServerConfigurationInstitutionID(CollectionServerConfiguration collectionServerConfiguration) {
        this.collectionServerConfiguration = collectionServerConfiguration;
    }

    public CollectionServerConfigurationInstitutionID(CollectionServerConfiguration collectionServerConfiguration, String string) {
        this.collectionServerConfiguration = collectionServerConfiguration;
        this.newIID = string;
    }

    public String toString() {
        return this.collectionServerConfiguration != null ? this.collectionServerConfiguration.institutionID : "";
    }

    public String getName() {
        return this.collectionServerConfiguration != null ? this.collectionServerConfiguration.collectionName : "";
    }

    public int getIndex() {
        int n = 0;
        try {
            n = Integer.parseInt(this.collectionServerConfiguration.collectionID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public String getUniqueIdentifier() {
        if (this.collectionServerConfiguration != null) {
            return this.collectionServerConfiguration.institutionID + "-" + this.collectionServerConfiguration.collectionID + "-" + this.collectionServerConfiguration.vcID + "-I";
        }
        return "";
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CollectionServerConfigurationInstitutionIDEditComponent();
        Vector vector = this.collectionServerConfiguration.getCollection().getServer().getFields(new Integer(this.collectionServerConfiguration.nativeStandardID));
        this.editComponent.getNewIIDField().setText(this.newIID);
        return this.editComponent;
    }

    public void save() {
        CollectionServerConfigurationInstitutionID.debugOut("Save...", 3);
        this.requiresCommit = true;
        CollectionServerConfiguration collectionServerConfiguration = new CollectionServerConfiguration();
        collectionServerConfiguration = this.collectionServerConfiguration;
        this.collectionServerConfiguration.getCollection().getServer().cancelEdit(this);
        String string = collectionServerConfiguration.vcID;
        collectionServerConfiguration.institutionID = this.editComponent.getNewIIDField().getText();
        collectionServerConfiguration.originalInstitutionID = this.editComponent.getNewIIDField().getText();
        collectionServerConfiguration.vcID = "NA";
        if (collectionServerConfiguration.institutionID != null && collectionServerConfiguration.institutionID.trim().length() < 1) {
            this.requiresCommit = false;
        }
        if (this.requiresCommit) {
            CsMediaGroup csMediaGroup = this.collectionServerConfiguration.getCollection().getServer().getMediaGroup(this.collectionServerConfiguration.uniqueCollectionID, string);
            CsMediaGroup csMediaGroup2 = new CsMediaGroup(this.collectionServerConfiguration.getCollection().getServer(), csMediaGroup.getUniqueCollectionID(), csMediaGroup.getGroupID(), csMediaGroup.getName(), 0, 1, "NA", null, null);
            this.collectionServerConfiguration.getCollection().getServer().commitDataObject(collectionServerConfiguration);
            this.collectionServerConfiguration.getCollection().getServer().commitDataObject(csMediaGroup2);
        } else {
            this.collectionServerConfiguration.getCollection().getServer().cancelEdit(collectionServerConfiguration);
        }
    }

    public void cancel() {
        CollectionServerConfigurationInstitutionID.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServerConfiguration.getCollection().getServer().cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return (this.collectionServerConfiguration != null ? this.collectionServerConfiguration.collectionName : "") + " - New Institution ID for VC";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-configurations-node-icon.gif");
    }

    public boolean equals(Object object) {
        if (object instanceof CollectionServerConfigurationInstitutionID) {
            CollectionServerConfigurationInstitutionID collectionServerConfigurationInstitutionID = (CollectionServerConfigurationInstitutionID)object;
            return this.collectionServerConfiguration.equals(collectionServerConfigurationInstitutionID.collectionServerConfiguration);
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CollectionServerConfigurationInstitutionID) {
            CollectionServerConfigurationInstitutionID collectionServerConfigurationInstitutionID = (CollectionServerConfigurationInstitutionID)databaseRecord;
            return CollectionServerConfigurationInstitutionID.stringsAreEqual(this.newIID, collectionServerConfigurationInstitutionID.newIID);
        }
        return false;
    }

    public static void debugOut(String string) {
        CollectionServerConfigurationInstitutionID.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerConfigurationBrowserAttributes: " + string, n);
    }
}

