/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.config;

import com.luna.insight.admin.AdministeredServer;
import com.luna.insight.admin.AdministeredServerConfigurationFileProperties;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationFilePropertiesEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.ImageIcon;

public class CollectionServerConfigurationFileProperties
extends AdministeredServerConfigurationFileProperties {
    protected CollectionServerConfigurationFilePropertiesEditComponent editComponent = null;
    protected String serverName = null;
    protected String serverShortName = null;
    protected String port = null;
    protected String timeoutMinutes = null;
    protected String userGroupUpdateMinutes = null;
    protected String logFileName = null;
    protected String debugLevel = null;
    protected String connectString = null;
    protected String msAccessMode = null;
    protected String lowerCaseMode = null;
    protected String useDistinctKeyword = null;
    protected String useDistinctInCount = null;
    protected String useCountToCheckThreshold = null;
    protected String sqlLevel = null;
    protected String characterWildcard = null;
    protected String stringWildcard = null;
    protected String leftEscapeDelimiter = null;
    protected String rightEscapeDelimiter = null;
    protected String databaseConnector = null;
    protected String jdbcDriverName = null;
    protected String jdbcUrlPrefix = null;
    protected String username = null;
    protected String password = null;
    protected String debugFilename = null;
    protected String debugModeOn = null;
    protected String defaultDatabaseConnector = null;
    protected String defaultJdbcDriverName = null;
    protected String defaultJdbcUrlPrefix = null;
    protected String defaultUsername = null;
    protected String defaultPassword = null;
    protected String defaultDebugFilename = null;
    protected String defaultDebugModeOn = null;
    protected String presFilePath = null;
    protected String mviFilePath = null;
    protected String linkFilePath = null;
    protected String searchQueryLogFileName = null;
    protected String fuzzyDateHelpFilePath = null;
    protected String outdatedClientMessage = null;
    protected String clientUrl = null;
    protected String jarFileUrl = null;
    protected String mediaInfoTableName = null;
    protected String exportLogFilename = null;
    protected String allowCollectionSortMax = null;
    protected String userConnectString = null;
    protected String ucbDatabase = null;
    protected String mipPropsFile = null;
    protected String ucbTableNamesFile = null;
    protected String medeCommitChangesMinutes = null;
    protected String medeHelpLink = null;
    protected String medeFileMenuHelpLink = null;
    protected String medeEditMenuHelpLink = null;
    protected String medeWindowMenuHelpLink = null;
    protected String medeHelpMenuHelpLink = null;
    protected String medeSearchViewHelpLink = null;
    protected String medeEditorViewHelpLink = null;
    protected String medeThumbnailViewHelpLink = null;
    protected String medeTableViewHelpLink = null;
    protected String medePreferencesViewHelpLink = null;
    protected String medeEntityMediaMapHelpLink = null;
    protected String medeSearchReplaceHelpLink = null;
    protected String medeInboxHelpLink = null;
    protected String medeFuzzyDateHelpLink = null;
    protected String mediaSecurityEnabled = null;
    protected String mediaSecurityServletUrl = null;
    protected String mediaTicketDuration = null;
    protected String mediaSecuritySecretKey = null;

    public CollectionServerConfigurationFileProperties(AdministeredServer administeredServer, String string) {
        super(administeredServer, string);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void commit() {
        block11: {
            CollectionServerConfigurationFileProperties.debugOut("in commit()");
            EnhancedProperties enhancedProperties = new EnhancedProperties();
            CollectionServerConfigurationFileProperties.setRequiredProperty(enhancedProperties, "ServerName", this.serverName, "ServerName - the name of this server.");
            CollectionServerConfigurationFileProperties.setRequiredProperty(enhancedProperties, "ServerShortName", this.serverShortName, "ServerShortName - an abbreviated name for this server (three letters or less).");
            CollectionServerConfigurationFileProperties.setRequiredProperty(enhancedProperties, "PortNumber", this.port, "PortNumber - the port number that the Insight Smart Server should listen to.  Default is 2845.  (Note: the port number for the user server cannot be configured.)");
            CollectionServerConfigurationFileProperties.setRequiredProperty(enhancedProperties, "TimeoutMinutes", this.timeoutMinutes, "TimeoutMinutes - a number of minutes before this server expires a user's session automatically.  This will allow a server to not be held up by user sessions that abnormally terminated.");
            CollectionServerConfigurationFileProperties.setRequiredProperty(enhancedProperties, "UserGroupUpdateMinutes", this.userGroupUpdateMinutes, "UserGroupUpdateMinutes - indicates how often the server will dynamically update the user groups and connection pools with the current DB settings.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DebugLevel", this.debugLevel, "DebugLevel - The level of debugging information provided on the server's console.  0 = off, 1 = low, 2 = medium, 3 = high.  This can be overridden with the -d [#] command-line parameter, as in \"serve -d 3\".");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "LogFilename", this.logFileName, "LogFilename - the name of a text file to log activity to.  Default is insight-server-log.txt");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "SearchQueryLogFilename", this.searchQueryLogFileName, "SearchQueryLogFilename - the name of a text file to log search query activity to. Not specifying a log filename will disable the search query logger.");
            CollectionServerConfigurationFileProperties.setRequiredProperty(enhancedProperties, "DatabaseConnect", this.connectString, "DatabaseConnect - the database connect string for the Insight Smart Server. The Insight ADO connector does not expect \"DSN=\" to be at the front of a DSN, while the RDO connector does.  Note that in this configuration file, every single \\ needs to be typed as \\\\.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MSAccessMode", this.msAccessMode, "MSAccessMode - Setting this value to 1 indicates that the DB should be optimized for MS Access.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "UseLowerCaseCommand", this.lowerCaseMode, "UseLowerCaseCommand - Setting this value to 1 indicates that LOWER() command should be used when generating search queries. The default is 0.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "UseDistinctKeyword", this.useDistinctKeyword, "UseDistinctKeyword - Setting this value to 1 indicates that the use of the DISTINCT keywords is authorized.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "UseDistinctInCount", this.useDistinctInCount, "UseDistinctInCount - Setting this value to 1 indicates that the use of the DISTINCT keyword within a COUNT command is authorized.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "UseSqlCountToCheckThreshold", this.useCountToCheckThreshold, "UseSqlCountToCheckThreshold - When generating a unique list, setting this value to 1 indicates that the Insight backend should use the SQL COUNT command to determine if the number of values will violate the threshold constraint.  The default is on.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DatabaseQueryMode", this.sqlLevel, "DatabaseQueryMode - The level of SQL 92 compilance that the host database implements. 0 = ENTRY_LEVEL_SQL_92, 1 = INTERMEDIATE_LEVEL_SQL_92.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "CharacterWildcard", this.characterWildcard, "CharacterWildcard, StringWildcard - The single character and string wildcard symbols used for the database. The defaults are: \"%\" for the string wildcard and \"_\" for the single character wildcard. NOTE: For Access DB -> Set CharacterWildcard to \"?\" and StringWildcard to \"*\"");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "StringWildcard", this.stringWildcard);
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "LeftEscapeDelimiter", this.leftEscapeDelimiter, "LeftEscapeDelimiter, RightEscapeDelimiter - The left and right delimiter to use for escaping special reserved characters. The defaults are: \"[\" for the left escape delimiter and \"]\" for the right escape delimiter.  Note: For Oracle DB -> Set LeftEscapeDelimiter to \"\\\" and RightEscapeDelimiter to \"\" (empty string).  Also note: The use of these delimiters can be \"turned off\" by simply including the property but not assigning it to any value. i.e. Setting the value of each to \"\" (empty string).");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "RightEscapeDelimiter", this.rightEscapeDelimiter);
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DatabaseConnector", this.databaseConnector, "DatabaseConnector - Specify the database connection to use.  Available options are JDBC, RDO (default), and ADO.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "JDBCDriverName", this.jdbcDriverName, "Classname of the JDBC driver to use if the DatabaseConnector is set to JDBC.  If the DatabaseConnector is set to anything else, this will be ignored.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "JDBCUrlPrefix", this.jdbcUrlPrefix);
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DefaultUsername", this.username, "Default username and password used to establish a database connection.  If this parameter is not specified, the connection will be made using DSN properties.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DefaultPassword", this.password);
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DatabaseDebugFilename", this.debugFilename, "DatabaseDebugFilename - the location of the text file to log database connection activity. Default is c:\\\\temp\\\\DatabaseConnector.txt");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DatabaseDebugMode", this.debugModeOn, "DatabaseDebugMode - indicates whether debug is active.  0 -> off, 1 -> on.  The default is on.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "PresFilePath", this.presFilePath, "PresFilePath - the path to the presentation files on the server. Note: If there is more that one server running on a machine then this property must include the collection name.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MVIFilePath", this.mviFilePath, "MVIFilePath - the path to the Multi-view image files on the server. Note: If there is more that one server running on a machine then this property must include the collection name.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "LinkFilePath", this.linkFilePath, "LinkFilePath - the path to the file files on the server.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "FuzzyDateHelpFile", this.fuzzyDateHelpFilePath, "FuzzyDateHelpFile - Specify the path to the text file that contains the message that should be displayed for Fuzzy Dates.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "OutdatedMessage", this.outdatedClientMessage, "OutdatedMessage - A message to show to the user if their client is out of date.  Note that this message is only customizable on Insight v2.12 and above.  Use \"\\n\" to insert a carriage return into the text.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "ClientURL", this.clientUrl, "ClientURL - A URL to a suitable Insight client.  This will be reported to the client if it fails to pass the version verification process.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "InsightJAR", this.jarFileUrl, "InsightJAR - A URL to the latest client JAR file.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MediaInfoTableName", this.mediaInfoTableName, "MediaInfoTableName - Specifies the name of the media meta information table that the server will use for displaying supplemental media information in the data window.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "ExportLogFilename", this.exportLogFilename, "ExportLogFilename - Determines the first part of the CSV filname for tracking image exporting.  This value is suffixed by a date string of the form \"-YYYYMMDD\" and the appropriate file extension.  Not specifying a log filename will disable the export logger.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "AllowCollectionSortMax", this.allowCollectionSortMax, "AllowCollectionSortMax - Ignore sorts and thumbnail label changes on entire collections groups with more records than this number (if 0, allow always).");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "UserDatabaseConnect", this.userConnectString, "UserDatabaseConnect - the database connect string for the Insight User Server.  An empty parameter here will tell this server to not run a user server.  Providing a DSN will override the User Server's DSN that it will read from InsightUserServer.dat.  A value of \"default\" will use the DSN provided in InsightUserServer.dat.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "UCBDatabase", this.ucbDatabase, "UCBDatabase - Setting this value to 1 indicates that the DB is a UCB database.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MipPropsFile", this.mipPropsFile, "MipPropsFile - The location of the UCB/MIP properties file.  If this file does not exist, the server sets itself to not be a UCB/MIP-capable server.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "UcbTableNames", this.ucbTableNamesFile, "UcbTableNames - The location of the UCB/MIP table names file.  If this file does not exist, the names for the LUCI database will be used.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MedeCommitChangesMinutes", this.medeCommitChangesMinutes, "MedeCommitChangesMinutes - Indicates how often the server will attempt to process and commit eligible data changes to the live data (in minutes). Default is 5 minutes.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "InscribeHelp", this.medeHelpLink, "InscribeHelp - The link for \"Inscribe Help\" in the Help menu");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "FileMenuHelp", this.medeFileMenuHelpLink, "File menu help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "EditMenuHelp", this.medeEditMenuHelpLink, "Edit menu help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "WindowMenuHelp", this.medeWindowMenuHelpLink, "Window menu help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "HelpMenuHelp", this.medeHelpMenuHelpLink, "Help menu help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "SearchViewHelp", this.medeSearchViewHelpLink, "Search view/tab help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "EditorViewHelp", this.medeEditorViewHelpLink, "Editor view/tab help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "ThumbnailViewHelp", this.medeThumbnailViewHelpLink, "Thumbnail/Selection view/tab help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "TableViewHelp", this.medeTableViewHelpLink, "Table view/tab help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "PreferencesViewHelp", this.medePreferencesViewHelpLink, "Preferences view/tab help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "EntityMediaMapHelp", this.medeEntityMediaMapHelpLink, "Entity to media mapping window help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "SearchReplaceHelp", this.medeSearchReplaceHelpLink, "Search and replace window help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "InboxHelp", this.medeInboxHelpLink, "Inbox outbox window help filename");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "FuzzyDateHelp", this.medeFuzzyDateHelpLink, "Fuzzy Date help link");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MediaSecurityEnabled", this.mediaSecurityEnabled, "MediaSecurityEnabled - Turns media security on or off.  Note: Enabling media security will have no effect unless the media SPS entries are directed to a correctly configured media security servlet.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MediaSecurityServletUrl", this.mediaSecurityServletUrl, "MediaSecurityServletUrl - The base URL for the media security servlet.");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MediaTicketDuration", this.mediaTicketDuration, "MediaTicketDuration - How long does a media ticket last? (in minutes).");
            CollectionServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MediaSecuritySecretKey", this.mediaSecuritySecretKey, "MediaSecuritySecretKey - The secret key password to use for encrypting and decrypting ticket numbers.  This password must be the same in both the collection server and servlet environments.");
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(this.configFileName);
            enhancedProperties.store(fileOutputStream, "InsightServer" + this.serverName + " Configuration");
            fileOutputStream.close();
            Object var5_3 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block11;
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (Exception exception) {
                    CollectionServerConfigurationFileProperties.debugOut("Exception while trying to write user server data to disc: " + exception);
                    Object var5_4 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block11;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void refresh() {
        Object object;
        CollectionServerConfigurationFileProperties.debugOut("in refresh()");
        EnhancedProperties enhancedProperties = new EnhancedProperties();
        try {
            CollectionServerConfigurationFileProperties.debugOut("Configuration file is " + this.configFileName + ".");
            object = new FileInputStream(this.configFileName);
            enhancedProperties.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (IOException iOException) {
            CollectionServerConfigurationFileProperties.debugOut("Cannot read configuration file!");
        }
        if (enhancedProperties != null) {
            this.serverName = enhancedProperties.getProperty("ServerName", this.serverName);
            this.serverShortName = enhancedProperties.getProperty("ServerShortName", this.serverShortName);
            this.port = enhancedProperties.getProperty("PortNumber", this.port);
            this.timeoutMinutes = enhancedProperties.getProperty("TimeoutMinutes", this.timeoutMinutes);
            this.userGroupUpdateMinutes = enhancedProperties.getProperty("UserGroupUpdateMinutes", this.userGroupUpdateMinutes);
            this.debugLevel = enhancedProperties.getProperty("DebugLevel", this.debugLevel);
            this.logFileName = enhancedProperties.getProperty("LogFilename", this.logFileName);
            this.searchQueryLogFileName = enhancedProperties.getProperty("SearchQueryLogFilename", this.searchQueryLogFileName);
            this.connectString = enhancedProperties.getProperty("DatabaseConnect", this.connectString);
            this.msAccessMode = enhancedProperties.getProperty("MSAccessMode", this.msAccessMode);
            this.lowerCaseMode = enhancedProperties.getProperty("UseLowerCaseCommand", this.lowerCaseMode);
            this.useDistinctKeyword = enhancedProperties.getProperty("UseDistinctKeyword", this.useDistinctKeyword);
            this.useDistinctInCount = enhancedProperties.getProperty("UseDistinctInCount", this.useDistinctInCount);
            this.useCountToCheckThreshold = enhancedProperties.getProperty("UseSqlCountToCheckThreshold", this.useCountToCheckThreshold);
            this.sqlLevel = enhancedProperties.getProperty("DatabaseQueryMode", this.sqlLevel);
            this.characterWildcard = enhancedProperties.getProperty("CharacterWildcard", this.characterWildcard);
            this.stringWildcard = enhancedProperties.getProperty("StringWildcard", this.stringWildcard);
            this.leftEscapeDelimiter = enhancedProperties.getProperty("LeftEscapeDelimiter", this.leftEscapeDelimiter);
            this.rightEscapeDelimiter = enhancedProperties.getProperty("RightEscapeDelimiter", this.rightEscapeDelimiter);
            this.databaseConnector = enhancedProperties.getProperty("DatabaseConnector", this.databaseConnector);
            this.debugFilename = enhancedProperties.getProperty("DatabaseDebugFilename", this.debugFilename);
            this.debugModeOn = enhancedProperties.getProperty("DatabaseDebugMode", this.debugModeOn);
            this.jdbcDriverName = enhancedProperties.getProperty("JDBCDriverName", this.jdbcDriverName);
            this.jdbcUrlPrefix = enhancedProperties.getProperty("JDBCUrlPrefix", this.jdbcUrlPrefix);
            this.username = enhancedProperties.getProperty("DefaultUsername", this.username);
            this.password = enhancedProperties.getProperty("DefaultPassword", this.password);
            this.presFilePath = enhancedProperties.getProperty("PresFilePath", this.presFilePath);
            this.mviFilePath = enhancedProperties.getProperty("MVIFilePath", this.mviFilePath);
            this.linkFilePath = enhancedProperties.getProperty("LinkFilePath", this.linkFilePath);
            this.searchQueryLogFileName = enhancedProperties.getProperty("SearchQueryLogFilename", this.searchQueryLogFileName);
            this.fuzzyDateHelpFilePath = enhancedProperties.getProperty("FuzzyDateHelpFile", this.fuzzyDateHelpFilePath);
            this.outdatedClientMessage = enhancedProperties.getProperty("OutdatedMessage", this.outdatedClientMessage);
            this.clientUrl = enhancedProperties.getProperty("ClientURL", this.clientUrl);
            this.jarFileUrl = enhancedProperties.getProperty("InsightJAR", this.jarFileUrl);
            this.mediaInfoTableName = enhancedProperties.getProperty("MediaInfoTableName", this.mediaInfoTableName);
            this.exportLogFilename = enhancedProperties.getProperty("ExportLogFilename", this.exportLogFilename);
            this.allowCollectionSortMax = enhancedProperties.getProperty("AllowCollectionSortMax", this.allowCollectionSortMax);
            this.userConnectString = enhancedProperties.getProperty("UserDatabaseConnect", this.userConnectString);
            this.ucbDatabase = enhancedProperties.getProperty("UCBDatabase", this.ucbDatabase);
            this.mipPropsFile = enhancedProperties.getProperty("MipPropsFile", this.mipPropsFile);
            this.ucbTableNamesFile = enhancedProperties.getProperty("UcbTableNames", this.ucbTableNamesFile);
            this.medeCommitChangesMinutes = enhancedProperties.getProperty("MedeCommitChangesMinutes", this.medeCommitChangesMinutes);
            this.medeHelpLink = enhancedProperties.getProperty("InscribeHelp", this.medeHelpLink);
            this.medeFileMenuHelpLink = enhancedProperties.getProperty("FileMenuHelp", this.medeFileMenuHelpLink);
            this.medeEditMenuHelpLink = enhancedProperties.getProperty("EditMenuHelp", this.medeEditMenuHelpLink);
            this.medeWindowMenuHelpLink = enhancedProperties.getProperty("WindowMenuHelp", this.medeWindowMenuHelpLink);
            this.medeHelpMenuHelpLink = enhancedProperties.getProperty("HelpMenuHelp", this.medeHelpMenuHelpLink);
            this.medeSearchViewHelpLink = enhancedProperties.getProperty("SearchViewHelp", this.medeSearchViewHelpLink);
            this.medeEditorViewHelpLink = enhancedProperties.getProperty("EditorViewHelp", this.medeEditorViewHelpLink);
            this.medeThumbnailViewHelpLink = enhancedProperties.getProperty("ThumbnailViewHelp", this.medeThumbnailViewHelpLink);
            this.medeTableViewHelpLink = enhancedProperties.getProperty("TableViewHelp", this.medeTableViewHelpLink);
            this.medePreferencesViewHelpLink = enhancedProperties.getProperty("PreferencesViewHelp", this.medePreferencesViewHelpLink);
            this.medeEntityMediaMapHelpLink = enhancedProperties.getProperty("EntityMediaMapHelp", this.medeEntityMediaMapHelpLink);
            this.medeSearchReplaceHelpLink = enhancedProperties.getProperty("SearchReplaceHelp", this.medeSearchReplaceHelpLink);
            this.medeInboxHelpLink = enhancedProperties.getProperty("InboxHelp", this.medeInboxHelpLink);
            this.medeFuzzyDateHelpLink = enhancedProperties.getProperty("FuzzyDateHelp", this.medeFuzzyDateHelpLink);
            this.mediaSecurityEnabled = enhancedProperties.getProperty("MediaSecurityEnabled", this.mediaSecurityEnabled);
            this.mediaSecurityServletUrl = enhancedProperties.getProperty("MediaSecurityServletUrl", this.mediaSecurityServletUrl);
            this.mediaTicketDuration = enhancedProperties.getProperty("MediaTicketDuration", this.mediaTicketDuration);
            this.mediaSecuritySecretKey = enhancedProperties.getProperty("MediaSecuritySecretKey", this.mediaSecuritySecretKey);
        }
        try {
            object = new File(this.configFileName);
            String string = ((File)object).getParent() + File.separator + "InsightBackend.dat";
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
            this.defaultDatabaseConnector = properties.getProperty("DatabaseConnector");
            this.defaultJdbcDriverName = properties.getProperty("JDBCDriverName");
            this.defaultJdbcUrlPrefix = properties.getProperty("JDBCUrlPrefix");
            this.defaultUsername = properties.getProperty("DefaultUsername");
            this.defaultPassword = properties.getProperty("DefaultPassword");
            this.defaultDebugFilename = properties.getProperty("DatabaseDebugFilename");
            this.defaultDebugModeOn = properties.getProperty("DatabaseDebugMode");
        }
        catch (Exception exception) {
            CollectionServerConfigurationFileProperties.debugOut("Exception while loading InsightBackend.dat: " + exception);
        }
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CollectionServerConfigurationFilePropertiesEditComponent();
        this.editComponent.getServerNameField().setText(this.serverName);
        this.editComponent.getServerShortNameField().setText(this.serverShortName);
        this.editComponent.getPortField().setText(this.port);
        this.editComponent.getTimeoutMinutesField().setText(this.timeoutMinutes);
        this.editComponent.getUserGroupUpdateMinutesField().setText(this.userGroupUpdateMinutes);
        this.editComponent.getLogFileNameField().setText(this.logFileName);
        try {
            this.editComponent.getDebugLevelComboBox().setSelectedIndex(Integer.parseInt(this.debugLevel));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editComponent.getDatabaseConnectStringField().setText(this.connectString);
        this.editComponent.getMsAccessModeCheckBox().setSelected("1".equals(this.msAccessMode));
        this.editComponent.getLowerCaseModeCheckBox().setSelected("1".equals(this.lowerCaseMode));
        this.editComponent.getUseDistinctKeywordCheckBox().setSelected("1".equals(this.useDistinctKeyword));
        this.editComponent.getUseDistinctInCountCheckBox().setSelected("1".equals(this.useDistinctInCount));
        this.editComponent.getUseSqlCountCheckBox().setSelected("1".equals(this.useCountToCheckThreshold));
        try {
            this.editComponent.getSqlLevelComboBox().setSelectedIndex(Integer.parseInt(this.sqlLevel));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editComponent.getCharacterWildcardField().setText(this.characterWildcard);
        this.editComponent.getStringWildcardField().setText(this.stringWildcard);
        this.editComponent.getLeftEscapeDelimiterField().setText(this.leftEscapeDelimiter);
        this.editComponent.getRightEscapeDelimiterField().setText(this.rightEscapeDelimiter);
        this.editComponent.getDatabaseConnectorComboBox().setSelectedItem(this.databaseConnector == null ? this.defaultDatabaseConnector : this.databaseConnector);
        this.editComponent.getEnableDatabaseConnectorCheckBox().setSelected(this.databaseConnector != null);
        this.editComponent.getJdbcDriverNameField().setText(this.jdbcDriverName == null ? this.defaultJdbcDriverName : this.jdbcDriverName);
        this.editComponent.getEnableJdbcDriverNameCheckBox().setSelected(this.jdbcDriverName != null);
        this.editComponent.getJdbcUrlPrefixField().setText(this.jdbcUrlPrefix == null ? this.defaultJdbcUrlPrefix : this.jdbcUrlPrefix);
        this.editComponent.getEnableJdbcUrlPrefixCheckBox().setSelected(this.jdbcUrlPrefix != null);
        this.editComponent.getUsernameField().setText(this.username == null ? this.defaultUsername : this.username);
        this.editComponent.getEnableUsernameCheckBox().setSelected(this.username != null);
        this.editComponent.getPasswordField().setText(this.password == null ? this.defaultPassword : this.password);
        this.editComponent.getEnablePasswordCheckBox().setSelected(this.password != null);
        this.editComponent.getDebugFilenameField().setText(this.debugFilename == null ? this.defaultDebugFilename : this.debugFilename);
        this.editComponent.getEnableDebugFilenameCheckBox().setSelected(this.debugFilename != null);
        this.editComponent.getDebugModeCheckBox().setSelected("1".equals(this.debugModeOn == null ? this.defaultDebugModeOn : this.debugModeOn));
        this.editComponent.getEnableDebugModeCheckBox().setSelected(this.debugModeOn != null);
        this.editComponent.getPresFilePathField().setText(this.presFilePath);
        this.editComponent.getMviFilePathField().setText(this.mviFilePath);
        this.editComponent.getLinkFilePathField().setText(this.linkFilePath);
        this.editComponent.getSearchQueryLogFileField().setText(this.searchQueryLogFileName);
        this.editComponent.getFuzzyDateHelpFileField().setText(this.fuzzyDateHelpFilePath);
        this.editComponent.getOutdatedClientMessageField().setText(this.outdatedClientMessage);
        this.editComponent.getClientUrlField().setText(this.clientUrl);
        this.editComponent.getJarFileUrlField().setText(this.jarFileUrl);
        this.editComponent.getExportLogFilenameField().setText(this.exportLogFilename);
        this.editComponent.getAllowCollectionSortMaxField().setText(this.allowCollectionSortMax);
        this.editComponent.getMediaInfoTableNameField().setText(this.mediaInfoTableName);
        if (this.userConnectString != null && this.userConnectString.length() > 0) {
            this.editComponent.getUserServerConnectStringField().setText(this.userConnectString);
            this.editComponent.getRunUserServerCheckBox().setSelected(true);
        }
        this.editComponent.getIsUcbCheckBox().setSelected("1".equals(this.ucbDatabase));
        this.editComponent.getMipPropsFileField().setText(this.mipPropsFile);
        this.editComponent.getUcbTableNamesFileField().setText(this.ucbTableNamesFile);
        this.editComponent.getMedeCommitChangesMinutesField().setText(this.medeCommitChangesMinutes);
        this.editComponent.getMedeHelpLinkField().setText(this.medeHelpLink);
        this.editComponent.getMedeFileMenuHelpLinkField().setText(this.medeFileMenuHelpLink);
        this.editComponent.getMedeEditMenuHelpLinkField().setText(this.medeEditMenuHelpLink);
        this.editComponent.getMedeWindowMenuHelpLinkField().setText(this.medeWindowMenuHelpLink);
        this.editComponent.getMedeHelpMenuHelpLinkField().setText(this.medeHelpMenuHelpLink);
        this.editComponent.getMedeSearchViewHelpLinkField().setText(this.medeSearchViewHelpLink);
        this.editComponent.getMedeEditorViewHelpLinkField().setText(this.medeEditorViewHelpLink);
        this.editComponent.getMedeThumbnailViewHelpLinkField().setText(this.medeThumbnailViewHelpLink);
        this.editComponent.getMedeTableViewHelpLinkField().setText(this.medeTableViewHelpLink);
        this.editComponent.getMedePreferencesViewHelpLinkField().setText(this.medePreferencesViewHelpLink);
        this.editComponent.getMedeEntityMediaMapHelpLinkField().setText(this.medeEntityMediaMapHelpLink);
        this.editComponent.getMedeSearchReplaceHelpLinkField().setText(this.medeSearchReplaceHelpLink);
        this.editComponent.getMedeInboxHelpLinkField().setText(this.medeInboxHelpLink);
        this.editComponent.getMedeFuzzyDateHelpLinkField().setText(this.medeFuzzyDateHelpLink);
        this.editComponent.getEditDefaultPropertiesButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CollectionServerConfigurationFileProperties.this.getAdministeredServer().editDefaultConfigurationFileProperties();
            }
        });
        this.editComponent.getDatabaseConnectStringField().selectAll();
        this.editComponent.setOptionalFieldsEnabledAppropriately();
        return this.editComponent;
    }

    public void save() {
        CollectionServerConfigurationFileProperties.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.serverName, this.editComponent.getServerNameField().getText())) {
            this.serverName = this.editComponent.getServerNameField().getText();
        }
        if (this.hasChanged(this.serverShortName, this.editComponent.getServerShortNameField().getText())) {
            this.serverShortName = this.editComponent.getServerShortNameField().getText();
        }
        if (this.hasChanged(this.port, this.editComponent.getPortField().getText())) {
            this.port = this.editComponent.getPortField().getText();
        }
        if (this.hasChanged(this.timeoutMinutes, this.editComponent.getTimeoutMinutesField().getText())) {
            this.timeoutMinutes = this.editComponent.getTimeoutMinutesField().getText();
        }
        if (this.hasChanged(this.userGroupUpdateMinutes, this.editComponent.getUserGroupUpdateMinutesField().getText())) {
            this.userGroupUpdateMinutes = this.editComponent.getUserGroupUpdateMinutesField().getText();
        }
        if (this.hasChanged(this.logFileName, this.editComponent.getLogFileNameField().getText())) {
            this.logFileName = this.editComponent.getLogFileNameField().getText();
        }
        if (this.hasChanged(this.debugLevel, "" + this.editComponent.getDebugLevelComboBox().getSelectedIndex())) {
            this.debugLevel = "" + this.editComponent.getDebugLevelComboBox().getSelectedIndex();
        }
        if (this.hasChanged(this.connectString, this.editComponent.getDatabaseConnectStringField().getText())) {
            this.connectString = this.editComponent.getDatabaseConnectStringField().getText();
        }
        if (this.hasChanged("1".equals(this.msAccessMode), this.editComponent.getMsAccessModeCheckBox().isSelected())) {
            String string = this.msAccessMode = this.editComponent.getMsAccessModeCheckBox().isSelected() ? "1" : "0";
        }
        if (this.hasChanged("1".equals(this.lowerCaseMode), this.editComponent.getLowerCaseModeCheckBox().isSelected())) {
            String string = this.lowerCaseMode = this.editComponent.getLowerCaseModeCheckBox().isSelected() ? "1" : "0";
        }
        if (this.hasChanged("1".equals(this.useDistinctKeyword), this.editComponent.getUseDistinctKeywordCheckBox().isSelected())) {
            String string = this.useDistinctKeyword = this.editComponent.getUseDistinctKeywordCheckBox().isSelected() ? "1" : "0";
        }
        if (this.hasChanged("1".equals(this.useDistinctInCount), this.editComponent.getUseDistinctInCountCheckBox().isSelected())) {
            String string = this.useDistinctInCount = this.editComponent.getUseDistinctInCountCheckBox().isSelected() ? "1" : "0";
        }
        if (this.hasChanged("1".equals(this.useCountToCheckThreshold), this.editComponent.getUseSqlCountCheckBox().isSelected())) {
            String string = this.useCountToCheckThreshold = this.editComponent.getUseSqlCountCheckBox().isSelected() ? "1" : "0";
        }
        if (this.hasChanged(this.sqlLevel, "" + this.editComponent.getSqlLevelComboBox().getSelectedIndex())) {
            this.sqlLevel = "" + this.editComponent.getSqlLevelComboBox().getSelectedIndex();
        }
        if (this.hasChanged(this.characterWildcard, this.editComponent.getCharacterWildcardField().getText())) {
            this.characterWildcard = this.editComponent.getCharacterWildcardField().getText();
        }
        if (this.hasChanged(this.stringWildcard, this.editComponent.getStringWildcardField().getText())) {
            this.stringWildcard = this.editComponent.getStringWildcardField().getText();
        }
        if (this.hasChanged(this.leftEscapeDelimiter, this.editComponent.getLeftEscapeDelimiterField().getText())) {
            this.leftEscapeDelimiter = this.editComponent.getLeftEscapeDelimiterField().getText();
        }
        if (this.hasChanged(this.rightEscapeDelimiter, this.editComponent.getRightEscapeDelimiterField().getText())) {
            this.rightEscapeDelimiter = this.editComponent.getRightEscapeDelimiterField().getText();
        }
        String string = null;
        string = this.editComponent.getEnableDatabaseConnectorCheckBox().isSelected() ? (String)this.editComponent.getDatabaseConnectorComboBox().getSelectedItem() : null;
        if (this.hasChanged(this.databaseConnector, string)) {
            this.databaseConnector = string;
        }
        String string2 = null;
        string2 = this.editComponent.getEnableJdbcDriverNameCheckBox().isSelected() ? this.editComponent.getJdbcDriverNameField().getText() : null;
        if (this.hasChanged(this.jdbcDriverName, string2)) {
            this.jdbcDriverName = string2;
        }
        String string3 = null;
        string3 = this.editComponent.getEnableJdbcUrlPrefixCheckBox().isSelected() ? this.editComponent.getJdbcUrlPrefixField().getText() : null;
        if (this.hasChanged(this.jdbcUrlPrefix, string3)) {
            this.jdbcUrlPrefix = string3;
        }
        String string4 = null;
        string4 = this.editComponent.getEnableUsernameCheckBox().isSelected() ? this.editComponent.getUsernameField().getText() : null;
        if (this.hasChanged(this.username, string4)) {
            this.username = string4;
        }
        String string5 = null;
        string5 = this.editComponent.getEnablePasswordCheckBox().isSelected() ? this.editComponent.getPasswordField().getText() : null;
        if (this.hasChanged(this.password, string5)) {
            this.password = string5;
        }
        String string6 = null;
        string6 = this.editComponent.getEnableDebugFilenameCheckBox().isSelected() ? this.editComponent.getDebugFilenameField().getText() : null;
        if (this.hasChanged(this.debugFilename, string6)) {
            this.debugFilename = string6;
        }
        String string7 = null;
        string7 = this.editComponent.getEnableDebugModeCheckBox().isSelected() ? (this.editComponent.getDebugModeCheckBox().isSelected() ? "1" : "0") : null;
        if (this.hasChanged(this.debugModeOn, string7)) {
            this.debugModeOn = string7;
        }
        if (this.hasChanged(this.presFilePath, this.editComponent.getPresFilePathField().getText())) {
            this.presFilePath = this.editComponent.getPresFilePathField().getText();
        }
        if (this.hasChanged(this.mviFilePath, this.editComponent.getMviFilePathField().getText())) {
            this.mviFilePath = this.editComponent.getMviFilePathField().getText();
        }
        if (this.hasChanged(this.linkFilePath, this.editComponent.getLinkFilePathField().getText())) {
            this.linkFilePath = this.editComponent.getLinkFilePathField().getText();
        }
        if (this.hasChanged(this.searchQueryLogFileName, this.editComponent.getSearchQueryLogFileField().getText())) {
            this.searchQueryLogFileName = this.editComponent.getSearchQueryLogFileField().getText();
        }
        if (this.hasChanged(this.fuzzyDateHelpFilePath, this.editComponent.getFuzzyDateHelpFileField().getText())) {
            this.fuzzyDateHelpFilePath = this.editComponent.getFuzzyDateHelpFileField().getText();
        }
        if (this.hasChanged(this.outdatedClientMessage, this.editComponent.getOutdatedClientMessageField().getText())) {
            this.outdatedClientMessage = this.editComponent.getOutdatedClientMessageField().getText();
        }
        if (this.hasChanged(this.clientUrl, this.editComponent.getClientUrlField().getText())) {
            this.clientUrl = this.editComponent.getClientUrlField().getText();
        }
        if (this.hasChanged(this.jarFileUrl, this.editComponent.getJarFileUrlField().getText())) {
            this.jarFileUrl = this.editComponent.getJarFileUrlField().getText();
        }
        if (this.hasChanged(this.mediaInfoTableName, this.editComponent.getMediaInfoTableNameField().getText())) {
            this.mediaInfoTableName = this.editComponent.getMediaInfoTableNameField().getText();
        }
        if (this.hasChanged(this.exportLogFilename, this.editComponent.getExportLogFilenameField().getText())) {
            this.exportLogFilename = this.editComponent.getExportLogFilenameField().getText();
        }
        if (this.hasChanged(this.allowCollectionSortMax, this.editComponent.getAllowCollectionSortMax())) {
            this.allowCollectionSortMax = this.editComponent.getAllowCollectionSortMax();
        }
        String string8 = null;
        if (this.editComponent.getRunUserServerCheckBox().isSelected()) {
            string8 = this.editComponent.getUserServerConnectStringField().getText();
        }
        if (this.hasChanged(this.userConnectString, string8)) {
            this.userConnectString = string8;
        }
        if (this.hasChanged("1".equals(this.ucbDatabase), this.editComponent.getIsUcbCheckBox().isSelected())) {
            String string9 = this.ucbDatabase = this.editComponent.getIsUcbCheckBox().isSelected() ? "1" : "0";
        }
        if (this.hasChanged(this.medeCommitChangesMinutes, this.editComponent.getMedeCommitChangesMinutesField().getText())) {
            this.medeCommitChangesMinutes = this.editComponent.getMedeCommitChangesMinutesField().getText();
        }
        if (this.hasChanged(this.medeHelpLink, this.editComponent.getMedeHelpLinkField().getText())) {
            this.medeHelpLink = this.editComponent.getMedeHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeFileMenuHelpLink, this.editComponent.getMedeFileMenuHelpLinkField().getText())) {
            this.medeFileMenuHelpLink = this.editComponent.getMedeFileMenuHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeEditMenuHelpLink, this.editComponent.getMedeEditMenuHelpLinkField().getText())) {
            this.medeEditMenuHelpLink = this.editComponent.getMedeEditMenuHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeWindowMenuHelpLink, this.editComponent.getMedeWindowMenuHelpLinkField().getText())) {
            this.medeWindowMenuHelpLink = this.editComponent.getMedeWindowMenuHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeHelpMenuHelpLink, this.editComponent.getMedeHelpMenuHelpLinkField().getText())) {
            this.medeHelpMenuHelpLink = this.editComponent.getMedeHelpMenuHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeSearchViewHelpLink, this.editComponent.getMedeSearchViewHelpLinkField().getText())) {
            this.medeSearchViewHelpLink = this.editComponent.getMedeSearchViewHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeEditorViewHelpLink, this.editComponent.getMedeEditorViewHelpLinkField().getText())) {
            this.medeEditorViewHelpLink = this.editComponent.getMedeEditorViewHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeThumbnailViewHelpLink, this.editComponent.getMedeThumbnailViewHelpLinkField().getText())) {
            this.medeThumbnailViewHelpLink = this.editComponent.getMedeThumbnailViewHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeTableViewHelpLink, this.editComponent.getMedeTableViewHelpLinkField().getText())) {
            this.medeTableViewHelpLink = this.editComponent.getMedeTableViewHelpLinkField().getText();
        }
        if (this.hasChanged(this.medePreferencesViewHelpLink, this.editComponent.getMedePreferencesViewHelpLinkField().getText())) {
            this.medePreferencesViewHelpLink = this.editComponent.getMedePreferencesViewHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeEntityMediaMapHelpLink, this.editComponent.getMedeEntityMediaMapHelpLinkField().getText())) {
            this.medeEntityMediaMapHelpLink = this.editComponent.getMedeEntityMediaMapHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeSearchReplaceHelpLink, this.editComponent.getMedeSearchReplaceHelpLinkField().getText())) {
            this.medeSearchReplaceHelpLink = this.editComponent.getMedeSearchReplaceHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeInboxHelpLink, this.editComponent.getMedeInboxHelpLinkField().getText())) {
            this.medeInboxHelpLink = this.editComponent.getMedeInboxHelpLinkField().getText();
        }
        if (this.hasChanged(this.medeFuzzyDateHelpLink, this.editComponent.getMedeFuzzyDateHelpLinkField().getText())) {
            this.medeFuzzyDateHelpLink = this.editComponent.getMedeFuzzyDateHelpLinkField().getText();
        }
        String string10 = null;
        String string11 = null;
        if (this.editComponent.getIsUcbCheckBox().isSelected()) {
            string10 = this.editComponent.getMipPropsFileField().getText();
            string11 = this.editComponent.getUcbTableNamesFileField().getText();
        }
        if (this.hasChanged(this.mipPropsFile, string10)) {
            this.mipPropsFile = string10;
        }
        if (this.hasChanged(this.ucbTableNamesFile, string11)) {
            this.ucbTableNamesFile = string11;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.server.commitConfigurationFileProperties();
        } else {
            this.server.cancelConfigurationFilePropertiesEdit();
        }
    }

    public void cancel() {
        CollectionServerConfigurationFileProperties.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.server.cancelConfigurationFilePropertiesEdit();
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-node-icon.gif");
    }

    public static void debugOut(String string) {
        CollectionServerConfigurationFileProperties.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerConfigurationFileProperties: " + string, n);
    }
}

