/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.config;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.NodeChildDeterminant;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationBrowserAttributes;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationEditComponent;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationInstitutionID;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationVisualAttributes;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroup;
import com.luna.insight.admin.collserver.profile.CollectionServerProfile;
import com.luna.insight.client.DefaultCollectionConfiguration;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CollectionServerConfiguration
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
NodeChildDeterminant {
    protected static final String[] initialActivityOptions = new String[]{"0 - None", "1 - Search Menu"};
    public static final int MAX_LOCALE_CODE_LENGTH = 5;
    public static final String NEW_COLLECTION_ID = "0";
    protected Collection collection;
    protected Integer uniqueCollectionID;
    public String institutionID = "";
    public String collectionID = "0";
    public String vcID = "NA";
    public String originalInstitutionID = "";
    public String originalCollectionID = "0";
    public String originalVcID = "NA";
    public int nativeStandardID = 0;
    public String collectionName = DefaultCollectionConfiguration.COLLECTION_NAME;
    public int initialActivity = DefaultCollectionConfiguration.INITIAL_ACTIVITY;
    public String initialGroupOpen = DefaultCollectionConfiguration.INITIAL_GROUP_OPEN;
    public int displayArtistStories = DefaultCollectionConfiguration.DISPLAY_ARTIST_STORIES ? 1 : 0;
    private int userCollection = 0;
    public int largeThumbnailThreshold = DefaultCollectionConfiguration.LARGE_THUMBNAIL_THRESHOLD;
    public int dragSpeedCoefficient = DefaultCollectionConfiguration.DRAG_SPEED_COEFFICIENT;
    public int initialGroupROnly = DefaultCollectionConfiguration.INITIAL_GROUP_RONLY ? 1 : 0;
    public String helpGroup = DefaultCollectionConfiguration.HELP_GROUP;
    public String helpImage = DefaultCollectionConfiguration.HELP_IMAGE;
    public int simultaneousIWLoads = DefaultCollectionConfiguration.SIMULTANEOUS_IW_LOADS;
    public int simultaneousGWLoads = DefaultCollectionConfiguration.SIMULTANEOUS_GW_LOADS;
    public int fastScaling = DefaultCollectionConfiguration.IMAGE_SCALE_MODE == 2 ? 1 : 0;
    public String shortDescription = DefaultCollectionConfiguration.SHORT_DESCRIPTION;
    public String longDescriptionUrl = DefaultCollectionConfiguration.LONG_DESCRIPTION_URL;
    private int thumbCacheProfileId = 0;
    public String remoteLaunchBaseURL = "";
    public String remoteLaunchHyperlinkTemplate = "";
    public boolean localeEditingEnabled = true;
    public String languageCode = "en";
    public String countryCode = "US";
    public boolean copyrightStmtEnabled = true;
    public String copyrightStmt = "";
    public boolean forceCollectionNameEnabled = true;
    public boolean forceCollectionName = false;
    private boolean isPersonalCollection = false;
    private int pcOwnerID = 0;
    private int pcOwnerUserGroupID = 0;
    private int pcUserGroupMemberPrivs = 0;
    private int pcNonUserGroupMemberPrivs = 0;
    public String createdTimestamp = "";
    public CollectionServerConfigurationVisualAttributes visualAttributes = null;
    public CollectionServerConfigurationBrowserAttributes browserAttributes = null;
    public CollectionServerConfigurationEditComponent editComponent = null;
    public CollectionServerConfigurationInstitutionID newIID = null;
    protected CollectionServerProfile newProfile = null;
    protected boolean fromProperties = false;

    public CollectionServerConfiguration() {
    }

    public CollectionServerConfiguration(Collection collection) {
        this.uniqueCollectionID = collection.getUniqueCollectionID();
        this.originalCollectionID = this.collectionID = collection.getCollectionID().toString();
        this.nativeStandardID = collection.getTemplateID();
        this.collection = collection;
        this.visualAttributes = new CollectionServerConfigurationVisualAttributes(this);
        this.browserAttributes = new CollectionServerConfigurationBrowserAttributes(this);
        this.setUserCollection(collection.getUserCollectionID());
        this.createdTimestamp = new SimpleDate().get();
        this.newIID = new CollectionServerConfigurationInstitutionID(this);
    }

    public CollectionServerConfiguration(Integer n, Collection collection, Hashtable hashtable) {
        this.uniqueCollectionID = n;
        this.collection = collection;
        this.visualAttributes = new CollectionServerConfigurationVisualAttributes(this);
        this.browserAttributes = new CollectionServerConfigurationBrowserAttributes(this);
        this.newIID = new CollectionServerConfigurationInstitutionID(this);
        this.setConfigurationProperties(hashtable);
    }

    public CollectionServerConfiguration(String string, int n) {
        this.collectionName = string;
        this.setUserCollection(n);
        this.createdTimestamp = new SimpleDate().get();
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public int getNativeStandardID() {
        return this.nativeStandardID;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public void setConfigurationProperties(Hashtable hashtable) {
        this.fromProperties = true;
        this.visualAttributes.setVisualAttributes(hashtable);
        this.browserAttributes.setBrowserAttributes(hashtable);
        this.institutionID = hashtable.get("institutionID") != null ? (String)hashtable.get("institutionID") : "";
        this.collectionID = hashtable.get("collectionID") != null ? (String)hashtable.get("collectionID") : NEW_COLLECTION_ID;
        this.vcID = hashtable.get("vcID") != null ? (String)hashtable.get("vcID") : "NA";
        this.originalInstitutionID = this.institutionID;
        this.originalCollectionID = this.collectionID;
        this.originalVcID = this.vcID;
        this.collectionName = hashtable.get("collectionName") != null ? (String)hashtable.get("collectionName") : "";
        this.initialActivity = hashtable.get("initialActivity") != null ? (Integer)hashtable.get("initialActivity") : 0;
        this.initialGroupOpen = hashtable.get("initialGroupOpen") != null ? (String)hashtable.get("initialGroupOpen") : "";
        this.nativeStandardID = hashtable.get("nativeStandardID") != null ? (Integer)hashtable.get("nativeStandardID") : 0;
        this.displayArtistStories = hashtable.get("displayArtistStories") != null ? (Integer)hashtable.get("displayArtistStories") : 0;
        this.setUserCollection(hashtable.get("userCollection") != null ? (Integer)hashtable.get("userCollection") : 0);
        this.largeThumbnailThreshold = hashtable.get("largeThumbnailThreshold") != null ? (Integer)hashtable.get("largeThumbnailThreshold") : 0;
        this.dragSpeedCoefficient = hashtable.get("dragSpeedCoefficient") != null ? (Integer)hashtable.get("dragSpeedCoefficient") : 0;
        this.initialGroupROnly = hashtable.get("initialGroupROnly") != null ? (Integer)hashtable.get("initialGroupROnly") : 0;
        this.helpGroup = hashtable.get("helpGroup") != null ? (String)hashtable.get("helpGroup") : "";
        this.helpImage = hashtable.get("helpImage") != null ? (String)hashtable.get("helpImage") : "";
        this.simultaneousIWLoads = hashtable.get("simultaneousIWLoads") != null ? (Integer)hashtable.get("simultaneousIWLoads") : 0;
        this.simultaneousGWLoads = hashtable.get("simultaneousGWLoads") != null ? (Integer)hashtable.get("simultaneousGWLoads") : 0;
        this.remoteLaunchBaseURL = hashtable.get("remoteLaunchBaseURL") != null ? (String)hashtable.get("remoteLaunchBaseURL") : "";
        this.remoteLaunchHyperlinkTemplate = hashtable.get("remoteLaunchHyperlinkTemplate") != null ? (String)hashtable.get("remoteLaunchHyperlinkTemplate") : "";
        this.fastScaling = hashtable.get("fastScaling") != null ? (Integer)hashtable.get("fastScaling") : 0;
        this.shortDescription = hashtable.get("shortDescription") != null ? (String)hashtable.get("shortDescription") : "";
        this.longDescriptionUrl = hashtable.get("longDescriptionUrl") != null ? (String)hashtable.get("longDescriptionUrl") : "";
        this.setThumbCacheProfileId(hashtable.get("thumbCacheProfileId") != null ? (Integer)hashtable.get("thumbCacheProfileId") : 0);
        this.localeEditingEnabled = hashtable.get("localeEditingEnabled") != null ? (Boolean)hashtable.get("localeEditingEnabled") : false;
        this.languageCode = hashtable.get("languageCode") != null ? (String)hashtable.get("languageCode") : "";
        this.countryCode = hashtable.get("countryCode") != null ? (String)hashtable.get("countryCode") : "";
        this.copyrightStmtEnabled = hashtable.get("CopyrightStmtEnabled") != null ? (Boolean)hashtable.get("CopyrightStmtEnabled") : false;
        this.copyrightStmt = hashtable.get("CopyrightStatement") != null ? (String)hashtable.get("CopyrightStatement") : "";
        this.forceCollectionNameEnabled = hashtable.get("ForceCollectionNameEnabled") != null ? (Boolean)hashtable.get("ForceCollectionNameEnabled") : false;
        this.forceCollectionName = hashtable.get("ForceCollectionNameDisplay") != null ? (Boolean)hashtable.get("ForceCollectionNameDisplay") : false;
        this.setPersonalCollection(hashtable.get("isPersonalCollection") != null ? (Boolean)hashtable.get("isPersonalCollection") : false);
        this.setPcOwnerID(hashtable.get("pcOwnerID") != null ? (Integer)hashtable.get("pcOwnerID") : 0);
        this.setPcOwnerUserGroupID(hashtable.get("pcOwnerUserGroupID") != null ? (Integer)hashtable.get("pcOwnerUserGroupID") : 0);
        this.setPcUserGroupMemberPrivs(hashtable.get("pcUserGroupMemberPrivs") != null ? (Integer)hashtable.get("pcUserGroupMemberPrivs") : 0);
        this.setPcNonUserGroupMemberPrivs(hashtable.get("pcNonUserGroupMemberPrivs") != null ? (Integer)hashtable.get("pcNonUserGroupMemberPrivs") : 0);
        this.createdTimestamp = hashtable.get("createdTimestamp") != null ? (String)hashtable.get("createdTimestamp") : new SimpleDate().get();
    }

    public String toString() {
        return this.institutionID;
    }

    public String getName() {
        return this.collectionName;
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        return this.vcID;
    }

    public int getIndex() {
        int n = 0;
        try {
            n = Integer.parseInt(this.collectionID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public String getNodeChildName() {
        return this.collectionName;
    }

    public int getNodeChildIndex() {
        return this.getUserCollection();
    }

    public String getUniqueIdentifier() {
        return this.institutionID + "-" + this.collectionID + "-" + this.vcID;
    }

    public String getOriginalUniqueIdentifier() {
        return this.originalInstitutionID + "-" + this.originalCollectionID + "-" + this.originalVcID;
    }

    public EditComponent getEditComponent() {
        Object object;
        int n;
        this.editComponent = new CollectionServerConfigurationEditComponent(this);
        this.editComponent.getInstitutionIdField().setText(this.institutionID);
        this.editComponent.getCollectionIdField().setText(this.collectionID);
        this.editComponent.getVCIdField().setText(this.vcID);
        this.editComponent.getCollectionNameField().setText(this.collectionName);
        this.editComponent.getShortDescriptionField().setText(this.shortDescription);
        this.editComponent.getLongDescriptionUrlField().setText(this.longDescriptionUrl);
        for (int i = 0; i < initialActivityOptions.length; ++i) {
            this.editComponent.getInitialActivityComboBox().addItem(initialActivityOptions[i]);
        }
        if (this.initialActivity >= 0 && this.initialActivity < initialActivityOptions.length) {
            this.editComponent.getInitialActivityComboBox().setSelectedItem(initialActivityOptions[this.initialActivity]);
        }
        Vector vector = this.collection.getServer().getMediaGroups(this.uniqueCollectionID, 1);
        for (n = 0; n < vector.size(); ++n) {
            object = ((CsMediaGroup)vector.elementAt(n)).getName();
            this.editComponent.getInitialGroupOpenComboBox().addItem(object);
            if (!this.initialGroupOpen.equals(object)) continue;
            this.editComponent.getInitialGroupOpenComboBox().setSelectedItem(this.initialGroupOpen);
        }
        this.editComponent.getInitialGroupReadOnlyCheckBox().setSelected(this.initialGroupROnly == 1);
        this.editComponent.getDisplayArtistStoriesCheckBox().setSelected(this.displayArtistStories == 1);
        this.editComponent.getLargeThumbnailThresholdField().setText("" + this.largeThumbnailThreshold);
        this.editComponent.getDragSpeedCoefficientField().setText("" + this.dragSpeedCoefficient);
        this.editComponent.getHelpGroupField().setText(this.helpGroup);
        this.editComponent.getHelpImageField().setText(this.helpImage);
        this.editComponent.getSimultaneousIWLoadsField().setText("" + this.simultaneousIWLoads);
        this.editComponent.getSimultaneousGWLoadsField().setText("" + this.simultaneousGWLoads);
        this.editComponent.getRemoteLaunchBaseURLField().setText(this.remoteLaunchBaseURL);
        this.editComponent.getRemoteLaunchHyperlinkTemplateField().setText(this.remoteLaunchHyperlinkTemplate);
        n = -1;
        try {
            n = Integer.parseInt(this.collectionID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.collection.getServer().getProfiles(n);
        if (object != null && ((Vector)object).size() > 0) {
            this.editComponent.removeCreateProfileButton();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                String string = ((CollectionServerProfile)((Vector)object).elementAt(i)).getProfileId() + "";
                this.editComponent.getThumbCacheProfileIdComboBox().addItem(string);
                if (!string.equals(this.getThumbCacheProfileId() + "")) continue;
                this.editComponent.getThumbCacheProfileIdComboBox().setSelectedItem(string);
            }
        }
        this.editComponent.getFastScalingCheckBox().setSelected(this.fastScaling == 1);
        if (this.localeEditingEnabled) {
            this.editComponent.getLanguageCodeField().setText(this.languageCode);
            this.editComponent.getCountryCodeField().setText(this.countryCode);
        } else {
            this.editComponent.removeLocaleFields();
        }
        if (this.copyrightStmtEnabled) {
            this.editComponent.getCopyrightStmtField().setText(this.copyrightStmt);
        } else {
            this.editComponent.removeCopyrightStmtFields();
        }
        if (this.forceCollectionNameEnabled) {
            this.editComponent.getForceCollectionNameCheckBox().setSelected(this.forceCollectionName);
        } else {
            this.editComponent.removeForceCollectionNameFields();
        }
        this.editComponent.getCollectionNameField().selectAll();
        return this.editComponent;
    }

    public void save() {
        Object object;
        int n;
        CollectionServerConfiguration.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.institutionID, this.editComponent.getInstitutionIdField().getText())) {
            this.institutionID = this.editComponent.getInstitutionIdField().getText();
        }
        if (this.hasChanged(this.collectionID, this.editComponent.getCollectionIdField().getText())) {
            this.collectionID = this.editComponent.getCollectionIdField().getText();
            try {
                this.setUserCollection(Integer.parseInt(this.editComponent.getCollectionIdField().getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged(this.vcID, this.editComponent.getVCIdField().getText())) {
            this.vcID = this.editComponent.getVCIdField().getText();
        }
        if (this.hasChanged(this.collectionName, this.editComponent.getCollectionNameField().getText())) {
            this.collectionName = this.editComponent.getCollectionNameField().getText();
        }
        if (this.hasChanged(this.shortDescription, this.editComponent.getShortDescriptionField().getText())) {
            this.shortDescription = this.editComponent.getShortDescriptionField().getText();
        }
        if (this.hasChanged(this.longDescriptionUrl, this.editComponent.getLongDescriptionUrlField().getText())) {
            this.longDescriptionUrl = this.editComponent.getLongDescriptionUrlField().getText();
        }
        if (this.hasChanged("" + this.initialActivity, this.editComponent.getInitialActivityComboBox().getSelectedIndex() + "") && (n = this.editComponent.getInitialActivityComboBox().getSelectedIndex()) >= 0 && n < initialActivityOptions.length) {
            this.initialActivity = n;
        }
        if (this.hasChanged((Object)this.initialGroupOpen, this.editComponent.getInitialGroupOpenComboBox().getSelectedItem())) {
            this.initialGroupOpen = (String)this.editComponent.getInitialGroupOpenComboBox().getSelectedItem();
        }
        if (this.hasChanged("" + this.initialGroupROnly, this.editComponent.getInitialGroupReadOnlyCheckBox().isSelected() ? "1" : NEW_COLLECTION_ID)) {
            this.initialGroupROnly = this.editComponent.getInitialGroupReadOnlyCheckBox().isSelected() ? 1 : 0;
        }
        if (this.hasChanged("" + this.displayArtistStories, this.editComponent.getDisplayArtistStoriesCheckBox().isSelected() ? "1" : NEW_COLLECTION_ID)) {
            int n2 = this.displayArtistStories = this.editComponent.getDisplayArtistStoriesCheckBox().isSelected() ? 1 : 0;
        }
        if (this.hasChanged("" + this.largeThumbnailThreshold, this.editComponent.getLargeThumbnailThresholdField().getText())) {
            object = this.editComponent.getLargeThumbnailThresholdField().getText();
            try {
                this.largeThumbnailThreshold = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.dragSpeedCoefficient, this.editComponent.getDragSpeedCoefficientField().getText())) {
            object = this.editComponent.getDragSpeedCoefficientField().getText();
            try {
                this.dragSpeedCoefficient = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged(this.helpGroup, this.editComponent.getHelpGroupField().getText())) {
            this.helpGroup = this.editComponent.getHelpGroupField().getText();
        }
        if (this.hasChanged(this.helpImage, this.editComponent.getHelpImageField().getText())) {
            this.helpImage = this.editComponent.getHelpImageField().getText();
        }
        if (this.hasChanged("" + this.simultaneousIWLoads, this.editComponent.getSimultaneousIWLoadsField().getText())) {
            object = this.editComponent.getSimultaneousIWLoadsField().getText();
            try {
                this.simultaneousIWLoads = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.simultaneousGWLoads, this.editComponent.getSimultaneousGWLoadsField().getText())) {
            object = this.editComponent.getSimultaneousGWLoadsField().getText();
            try {
                this.simultaneousGWLoads = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged(this.remoteLaunchBaseURL, this.editComponent.getRemoteLaunchBaseURLField().getText())) {
            this.remoteLaunchBaseURL = this.editComponent.getRemoteLaunchBaseURLField().getText();
        }
        if (this.hasChanged(this.remoteLaunchHyperlinkTemplate, this.editComponent.getRemoteLaunchHyperlinkTemplateField().getText())) {
            this.remoteLaunchHyperlinkTemplate = this.editComponent.getRemoteLaunchHyperlinkTemplateField().getText();
        }
        if (this.hasChanged((Object)(this.getThumbCacheProfileId() + ""), this.editComponent.getThumbCacheProfileIdComboBox().getSelectedItem())) {
            object = (String)this.editComponent.getThumbCacheProfileIdComboBox().getSelectedItem();
            try {
                this.setThumbCacheProfileId(Integer.parseInt((String)object));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasChanged("" + this.fastScaling, this.editComponent.getFastScalingCheckBox().isSelected() ? "1" : NEW_COLLECTION_ID)) {
            int n3 = this.fastScaling = this.editComponent.getFastScalingCheckBox().isSelected() ? 1 : 0;
        }
        if (this.localeEditingEnabled) {
            if (this.hasChanged(this.languageCode, this.editComponent.getLanguageCodeField().getText())) {
                this.languageCode = this.editComponent.getLanguageCodeField().getText();
            }
            if (this.hasChanged(this.countryCode, this.editComponent.getCountryCodeField().getText())) {
                this.countryCode = this.editComponent.getCountryCodeField().getText();
            }
        }
        if (this.copyrightStmtEnabled && this.hasChanged(this.copyrightStmt, this.editComponent.getCopyrightStmtField().getText())) {
            this.copyrightStmt = this.editComponent.getCopyrightStmtField().getText();
        }
        if (this.forceCollectionNameEnabled && this.hasChanged(this.forceCollectionName, this.editComponent.getForceCollectionNameCheckBox().isSelected())) {
            this.forceCollectionName = this.editComponent.getForceCollectionNameCheckBox().isSelected();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collection.getServer().commitDataObject(this);
        } else {
            this.collection.getServer().cancelEdit(this);
        }
        if (this.visualAttributes != null && (object = (EditDialog)this.collection.getServer().getEditDialogCache(this.visualAttributes).get(this.visualAttributes.getUniqueIdentifier())) != null) {
            ((EditDialog)object).cancel();
        }
        if (this.browserAttributes != null && (object = (EditDialog)this.collection.getServer().getEditDialogCache(this.browserAttributes).get(this.browserAttributes.getUniqueIdentifier())) != null) {
            ((EditDialog)object).cancel();
        }
    }

    public void cancel() {
        EditDialog editDialog;
        CollectionServerConfiguration.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collection.getServer().cancelEdit(this);
        if (this.visualAttributes != null && (editDialog = (EditDialog)this.collection.getServer().getEditDialogCache(this.visualAttributes).get(this.visualAttributes.getUniqueIdentifier())) != null) {
            editDialog.cancel();
        }
        if (this.browserAttributes != null && (editDialog = (EditDialog)this.collection.getServer().getEditDialogCache(this.browserAttributes).get(this.browserAttributes.getUniqueIdentifier())) != null) {
            editDialog.cancel();
        }
        if (this.newProfile != null) {
            editDialog = (EditDialog)this.collection.getServer().getEditDialogCache(this.newProfile).get(this.newProfile.getUniqueIdentifier());
            if (editDialog != null) {
                editDialog.cancel();
            }
            this.newProfile = null;
        }
    }

    public String getEditWindowTitle() {
        return this.collectionName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-configurations-node-icon.gif");
    }

    public void showVisualAttributesDialog() {
        this.collection.getServer().editDataObject(this.visualAttributes);
    }

    public void showBrowserAttributesDialog() {
        this.collection.getServer().editDataObject(this.browserAttributes);
    }

    public void showNewInstitutionIDDialog() {
        this.collection.getServer().editDataObject(this.newIID);
        EditDialog editDialog = (EditDialog)this.collection.getServer().getEditDialogCache(this).get(this.getUniqueIdentifier());
        if (editDialog != null) {
            editDialog.cancel();
        }
    }

    public void createNewProfileButtonPressed() {
        int n = 0;
        try {
            n = Integer.parseInt(this.collectionID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = this.collection.getServer().getCollectionServerConnector().getNextValidProfileID();
        this.newProfile = new CollectionServerProfile(this.collection.getServer(), n2, n, true, true);
        this.newProfile.configurationEditComponent = this.editComponent;
        this.collection.getServer().addDataObject(this.newProfile);
    }

    public boolean equals(Object object) {
        if (object instanceof CollectionServerConfiguration) {
            CollectionServerConfiguration collectionServerConfiguration = (CollectionServerConfiguration)object;
            return this.collectionID == collectionServerConfiguration.collectionID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CollectionServerConfiguration) {
            CollectionServerConfiguration collectionServerConfiguration = (CollectionServerConfiguration)databaseRecord;
            boolean bl = true;
            if (this.localeEditingEnabled) {
                bl = CollectionServerConfiguration.stringsAreEqual(this.languageCode, collectionServerConfiguration.languageCode) && CollectionServerConfiguration.stringsAreEqual(this.countryCode, collectionServerConfiguration.countryCode);
            }
            return CollectionServerConfiguration.stringsAreEqual(this.institutionID, collectionServerConfiguration.institutionID) && CollectionServerConfiguration.stringsAreEqual(this.collectionID, collectionServerConfiguration.collectionID) && CollectionServerConfiguration.stringsAreEqual(this.vcID, collectionServerConfiguration.vcID) && CollectionServerConfiguration.stringsAreEqual(this.collectionName, collectionServerConfiguration.collectionName) && this.initialActivity == collectionServerConfiguration.initialActivity && CollectionServerConfiguration.stringsAreEqual(this.initialGroupOpen, collectionServerConfiguration.initialGroupOpen) && this.displayArtistStories == collectionServerConfiguration.displayArtistStories && this.getUserCollection() == collectionServerConfiguration.getUserCollection() && this.largeThumbnailThreshold == collectionServerConfiguration.largeThumbnailThreshold && this.dragSpeedCoefficient == collectionServerConfiguration.dragSpeedCoefficient && this.initialGroupROnly == collectionServerConfiguration.initialGroupROnly && CollectionServerConfiguration.stringsAreEqual(this.helpGroup, collectionServerConfiguration.helpGroup) && CollectionServerConfiguration.stringsAreEqual(this.helpImage, collectionServerConfiguration.helpImage) && this.simultaneousIWLoads == collectionServerConfiguration.simultaneousIWLoads && this.simultaneousGWLoads == collectionServerConfiguration.simultaneousGWLoads && CollectionServerConfiguration.stringsAreEqual(this.remoteLaunchBaseURL, collectionServerConfiguration.remoteLaunchBaseURL) && CollectionServerConfiguration.stringsAreEqual(this.remoteLaunchHyperlinkTemplate, collectionServerConfiguration.remoteLaunchHyperlinkTemplate) && this.fastScaling == collectionServerConfiguration.fastScaling && CollectionServerConfiguration.stringsAreEqual(this.shortDescription, collectionServerConfiguration.shortDescription) && CollectionServerConfiguration.stringsAreEqual(this.longDescriptionUrl, collectionServerConfiguration.longDescriptionUrl) && this.getThumbCacheProfileId() == collectionServerConfiguration.getThumbCacheProfileId() && bl && this.visualAttributes.equalsRecord(collectionServerConfiguration.visualAttributes) && this.browserAttributes.equalsRecord(collectionServerConfiguration.browserAttributes) && CollectionServerConfiguration.stringsAreEqual(this.createdTimestamp, collectionServerConfiguration.createdTimestamp);
        }
        return false;
    }

    public int getVerticalBarX() {
        return this.visualAttributes != null ? this.visualAttributes.verticalBarX : 0;
    }

    public int getHorizontalBarY() {
        return this.visualAttributes != null ? this.visualAttributes.horizontalBarY : 0;
    }

    public int getBackgroundColorR() {
        return this.visualAttributes != null ? this.visualAttributes.backgroundColorR : 0;
    }

    public int getBackgroundColorG() {
        return this.visualAttributes != null ? this.visualAttributes.backgroundColorG : 0;
    }

    public int getBackgroundColorB() {
        return this.visualAttributes != null ? this.visualAttributes.backgroundColorB : 0;
    }

    public int getDefaultViewResolution() {
        return this.visualAttributes != null ? this.visualAttributes.defaultViewResolution : 0;
    }

    public int getGroupTopInset() {
        return this.visualAttributes != null ? this.visualAttributes.groupTopInset : 0;
    }

    public int getGroupLeftInset() {
        return this.visualAttributes != null ? this.visualAttributes.groupLeftInset : 0;
    }

    public int getGroupSpacingH() {
        return this.visualAttributes != null ? this.visualAttributes.groupSpacingH : 0;
    }

    public int getGroupSpacingV() {
        return this.visualAttributes != null ? this.visualAttributes.groupSpacingV : 0;
    }

    public int getMenuXPosition() {
        return this.visualAttributes != null ? this.visualAttributes.menuXPosition : 0;
    }

    public int getMaximumWindows() {
        return this.visualAttributes != null ? this.visualAttributes.maximumWindows : 0;
    }

    public int getInterWindowSpacing() {
        return this.visualAttributes != null ? this.visualAttributes.interWindowSpacing : 0;
    }

    public int getMinImageWindowSizeWidth() {
        return this.visualAttributes != null ? this.visualAttributes.minImageWindowSizeWidth : 0;
    }

    public int getMinImageWindowSizeHeight() {
        return this.visualAttributes != null ? this.visualAttributes.minImageWindowSizeHeight : 0;
    }

    public String getBgUrl() {
        return this.visualAttributes != null ? this.visualAttributes.bgUrl : "";
    }

    public int getMacWidthAdjustment() {
        return this.visualAttributes != null ? this.visualAttributes.macWidthAdjustment : 0;
    }

    public int getSort1FieldID() {
        return this.browserAttributes != null ? this.browserAttributes.sort1FieldID : 0;
    }

    public int getSort2FieldID() {
        return this.browserAttributes != null ? this.browserAttributes.sort2FieldID : 0;
    }

    public int getSort3FieldID() {
        return this.browserAttributes != null ? this.browserAttributes.sort3FieldID : 0;
    }

    public int getSort4FieldID() {
        return this.browserAttributes != null ? this.browserAttributes.sort4FieldID : 0;
    }

    public int getThumbnail1FieldID() {
        return this.browserAttributes != null ? this.browserAttributes.thumbnail1FieldID : 0;
    }

    public int getThumbnail2FieldID() {
        return this.browserAttributes != null ? this.browserAttributes.thumbnail2FieldID : 0;
    }

    public int getThumbnail3FieldID() {
        return this.browserAttributes != null ? this.browserAttributes.thumbnail3FieldID : 0;
    }

    public int getThumbnail4FieldID() {
        return this.browserAttributes != null ? this.browserAttributes.thumbnail4FieldID : 0;
    }

    public String getRtlUrl() {
        return this.browserAttributes != null ? this.browserAttributes.rtlUrl : "";
    }

    public String getRtlImage() {
        return this.browserAttributes != null ? this.browserAttributes.rtlImage : "";
    }

    public String getBgLoading() {
        return this.browserAttributes != null ? this.browserAttributes.bgLoading : "";
    }

    public String getBgMenu() {
        return this.browserAttributes != null ? this.browserAttributes.bgMenu : "";
    }

    public String getBgProgressOn() {
        return this.browserAttributes != null ? this.browserAttributes.bgProgressOn : "";
    }

    public String getBgProgressOff() {
        return this.browserAttributes != null ? this.browserAttributes.bgProgressOff : "";
    }

    public String getBgGroupLeft() {
        return this.browserAttributes != null ? this.browserAttributes.bgGroupLeft : "";
    }

    public String getBgGroupLeftNS() {
        return this.browserAttributes != null ? this.browserAttributes.bgGroupLeftNS : "";
    }

    public String getBgGroupRight() {
        return this.browserAttributes != null ? this.browserAttributes.bgGroupRight : "";
    }

    public String getBgGWBottom() {
        return this.browserAttributes != null ? this.browserAttributes.bgGWBottom : "";
    }

    public String getBgGWTop() {
        return this.browserAttributes != null ? this.browserAttributes.bgGWTop : "";
    }

    public String getBgGroupLeftHtml() {
        return this.browserAttributes != null ? this.browserAttributes.bgGroupLeftHtml : "";
    }

    public boolean getBrowserSecurity() {
        return this.browserAttributes != null ? this.browserAttributes.browserSecurity : false;
    }

    public String getCopyrightStmt() {
        return this.copyrightStmt;
    }

    public boolean forceCollectionName() {
        return this.forceCollectionName;
    }

    public static void debugOut(String string) {
        CollectionServerConfiguration.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerConfiguration: " + string, n);
    }

    public void setPcOwnerID(int n) {
        this.pcOwnerID = n;
    }

    public int getPcOwnerID() {
        return this.pcOwnerID;
    }

    public void setPcOwnerUserGroupID(int n) {
        this.pcOwnerUserGroupID = n;
    }

    public int getPcOwnerUserGroupID() {
        return this.pcOwnerUserGroupID;
    }

    public void setPcUserGroupMemberPrivs(int n) {
        this.pcUserGroupMemberPrivs = n;
    }

    public int getPcUserGroupMemberPrivs() {
        return this.pcUserGroupMemberPrivs;
    }

    public void setPcNonUserGroupMemberPrivs(int n) {
        this.pcNonUserGroupMemberPrivs = n;
    }

    public int getPcNonUserGroupMemberPrivs() {
        return this.pcNonUserGroupMemberPrivs;
    }

    public void setPersonalCollection(boolean bl) {
        this.isPersonalCollection = bl;
    }

    public boolean isPersonalCollection() {
        return this.isPersonalCollection;
    }

    public void setUserCollection(int n) {
        this.userCollection = n;
    }

    public int getUserCollection() {
        return this.userCollection;
    }

    public void setThumbCacheProfileId(int n) {
        this.thumbCacheProfileId = n;
    }

    public int getThumbCacheProfileId() {
        return this.thumbCacheProfileId;
    }
}

