/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.collection;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerUser;
import com.luna.insight.admin.collserver.collection.CollectionNode;
import com.luna.insight.admin.collserver.collection.PersonalCollectionAccessSettingsConfiguration;
import com.luna.insight.admin.collserver.collection.PersonalCollectionAccessSettingsConfigurationEditComponent;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.usergroup.PersonalCollectionServerUserGroup;
import com.luna.insight.admin.userserver.usergroup.UserServerUser;
import com.luna.insight.client.IconMaker;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class PersonalCollectionSettingsNode
extends TableDisplayControlPanelNode {
    public static final String NO_GROUP_LIT = "NONE";
    public static final String NO_USER_LIT = "INVALID DATA";
    public static final int NO_INDEX = -1;
    public static final String NO_ACCESS_LIT = "";
    public static final String READ_ONLY_LIT = "read only";
    public static final String EDIT_LIT = "read + edit";
    protected CollectionNode collectionNode;
    protected PersonalCollectionAccessSettingsConfiguration config;
    protected List personalCollectionUserGroups;
    protected List collectionServerUsers;
    protected int currentGroupIndex = -1;
    protected int currentUserIndex = -1;

    public PersonalCollectionSettingsNode(CollectionNode collectionNode) {
        super(collectionNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), "Access Control Settings", false);
        this.collectionNode = collectionNode;
        this.columnNames = new Object[]{"Collection Owner", "Collection User Group", "Group Member Rights", "Non Group Member Rights"};
    }

    public void updateInformationDisplay() {
        Object object;
        CollectionServerConfiguration collectionServerConfiguration = (CollectionServerConfiguration)this.collectionNode.getCollectionServerNode().getCollectionServer().getConfigurations(this.collectionNode.getCollection().getUniqueCollectionID(), false).get(0);
        this.config = new PersonalCollectionAccessSettingsConfiguration(collectionServerConfiguration, this);
        this.personalCollectionUserGroups = this.collectionNode.getCollectionServerNode().getCollectionServer().getCollectionServerConnector().getUserGroupRecords(new Integer(-1));
        Collections.sort(this.personalCollectionUserGroups, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((PersonalCollectionServerUserGroup)object).getName().compareTo(((PersonalCollectionServerUserGroup)object2).getName());
            }
        });
        String string = NO_GROUP_LIT;
        this.currentGroupIndex = -1;
        if (this.personalCollectionUserGroups != null) {
            for (int i = 0; i < this.personalCollectionUserGroups.size(); ++i) {
                PersonalCollectionServerUserGroup personalCollectionServerUserGroup = (PersonalCollectionServerUserGroup)this.personalCollectionUserGroups.get(i);
                if (personalCollectionServerUserGroup.getGroupID() != this.config.getPcOwnerUserGroupID()) continue;
                string = personalCollectionServerUserGroup.getName();
                this.currentGroupIndex = i;
                break;
            }
        }
        this.collectionServerUsers = this.collectionNode.getCollectionServerNode().getCollectionServer().getCollectionServerConnector().getCollectionServerUserList();
        Collections.sort(this.collectionServerUsers, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((CollectionServerUser)object).getName().compareTo(((CollectionServerUser)object2).getName());
            }
        });
        String string2 = NO_USER_LIT;
        this.currentUserIndex = -1;
        for (int i = 0; i < this.collectionServerUsers.size(); ++i) {
            object = (CollectionServerUser)this.collectionServerUsers.get(i);
            if (((UserServerUser)object).getUserId() != this.config.getPcOwnerID()) continue;
            string2 = ((UserServerUser)object).getName();
            this.currentUserIndex = i;
            break;
        }
        String string3 = NO_ACCESS_LIT;
        object = NO_ACCESS_LIT;
        if (PersonalCollectionAccessSettingsConfigurationEditComponent.hasPermissionSetting(this.config.getPcUserGroupMemberPrivs(), 2)) {
            string3 = EDIT_LIT;
        } else if (PersonalCollectionAccessSettingsConfigurationEditComponent.hasPermissionSetting(this.config.getPcUserGroupMemberPrivs(), 1)) {
            string3 = READ_ONLY_LIT;
        }
        if (PersonalCollectionAccessSettingsConfigurationEditComponent.hasPermissionSetting(this.config.getPcNonUserGroupMemberPrivs(), 2)) {
            object = EDIT_LIT;
        } else if (PersonalCollectionAccessSettingsConfigurationEditComponent.hasPermissionSetting(this.config.getPcNonUserGroupMemberPrivs(), 1)) {
            object = READ_ONLY_LIT;
        }
        Object[][] objectArray = new Object[1][this.columnNames.length];
        objectArray[0][0] = string2;
        objectArray[0][1] = string;
        objectArray[0][2] = string3;
        objectArray[0][3] = object;
        this.tableModel.setDataVector(objectArray, this.columnNames);
        try {
            this.collectionNode.getCollectionServerNode().profileNode.refreshChildNodes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasReadPermission() {
        return this.collectionNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.collectionNode.getCollectionServerNode().getAdminAccount(), null, "Edit PC Access Settings Command", null);
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("Edit PC Access Settings Command")) {
            this.collectionNode.getCollectionServerNode().editPCAccessSettings(this.config);
        }
    }

    public void defaultItemAction(Object object) {
    }

    public void defaultItemAction() {
        this.collectionNode.getCollectionServerNode().editPCAccessSettings(this.config);
    }

    public JPopupMenu getPopup() {
        return null;
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-configurations-node-icon.gif");
        }
        return this.treeIcon;
    }

    public int getCurrentGroupIndex() {
        return this.currentGroupIndex;
    }

    public List getPersonalCollectionUserGroups() {
        return this.personalCollectionUserGroups;
    }

    public List getCollectionServerUsers() {
        return this.collectionServerUsers;
    }

    public int getCurrentUserIndex() {
        return this.currentUserIndex;
    }
}

