/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.collection;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.collserver.CollectionServerUser;
import com.luna.insight.admin.collserver.collection.PersonalCollectionAccessSettingsConfiguration;
import com.luna.insight.admin.collserver.usergroup.PersonalCollectionServerUserGroup;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class PersonalCollectionAccessSettingsConfigurationEditComponent
extends EditComponent
implements ActionListener {
    public static final int PRIV_READ = 1;
    public static final int PRIV_WRITE = 2;
    public static final int PRIV_EDIT = 3;
    public static final int PRIV_DELETE = 5;
    protected PersonalCollectionAccessSettingsConfiguration pcConfiguration = null;
    private JPanel pcOwnerPanel = new JPanel();
    private JLabel pcOwnerLabel = new JLabel("Personal Collection Owner:");
    private JComboBox pcOwnerComboBox = new JComboBox();
    private JLabel pcGroupLabel = new JLabel("Personal Collection User Group:");
    private JComboBox pcGroupComboBox = new JComboBox();
    private JPanel pcReadPanel = new JPanel();
    private ButtonGroup pcReadButtonGroup = new ButtonGroup();
    private JRadioButton pcReadOwnerRadioButton = new JRadioButton("Private (owner access only)");
    private JRadioButton pcReadGroupRadioButton = new JRadioButton("Allow all User Group members read access");
    private JRadioButton pcReadOtherRadioButton = new JRadioButton("Allow anyone read access to the personal collection");
    private JPanel pcEditPanel = new JPanel();
    private ButtonGroup pcEditButtonGroup = new ButtonGroup();
    private JRadioButton pcEditOwnerRadioButton = new JRadioButton("Allow editing by owner only");
    private JRadioButton pcEditGroupRadioButton = new JRadioButton("Allow editing by owner and User Group members");
    private JRadioButton pcEditOtherRadioButton = new JRadioButton("Allow editing by everyone");
    private int groupPrivs;
    private int otherPrivs;

    public PersonalCollectionAccessSettingsConfigurationEditComponent(PersonalCollectionAccessSettingsConfiguration personalCollectionAccessSettingsConfiguration) {
        this.pcConfiguration = personalCollectionAccessSettingsConfiguration;
        this.pcReadButtonGroup.add(this.pcReadOwnerRadioButton);
        this.pcReadButtonGroup.add(this.pcReadGroupRadioButton);
        this.pcReadButtonGroup.add(this.pcReadOtherRadioButton);
        this.pcEditButtonGroup.add(this.pcEditOwnerRadioButton);
        this.pcEditButtonGroup.add(this.pcEditGroupRadioButton);
        this.pcEditButtonGroup.add(this.pcEditOtherRadioButton);
        this.pcReadOtherRadioButton.addActionListener(this);
        this.pcReadGroupRadioButton.addActionListener(this);
        this.pcReadOwnerRadioButton.addActionListener(this);
        this.pcEditOtherRadioButton.addActionListener(this);
        this.pcEditGroupRadioButton.addActionListener(this);
        this.pcEditOwnerRadioButton.addActionListener(this);
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(3, 3, 3, 3);
        this.setFont(new Font("Dialog", 1, 12));
        this.pcOwnerPanel.setLayout(new GridBagLayout());
        this.pcOwnerPanel.setBorder(new TitledBorder("ownership"));
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 13;
        this.pcOwnerPanel.add((Component)this.pcOwnerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets;
        this.pcOwnerPanel.add((Component)this.pcOwnerComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 13;
        this.pcOwnerPanel.add((Component)this.pcGroupLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = insets;
        this.pcOwnerPanel.add((Component)this.pcGroupComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pcOwnerPanel, gridBagConstraints);
        this.pcReadPanel.setLayout(new GridBagLayout());
        this.pcReadPanel.setBorder(new TitledBorder("collection access"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        this.pcReadPanel.add((Component)this.pcReadOwnerRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        this.pcReadPanel.add((Component)this.pcReadGroupRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        this.pcReadPanel.add((Component)this.pcReadOtherRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pcReadPanel, gridBagConstraints);
        this.pcEditPanel.setLayout(new GridBagLayout());
        this.pcEditPanel.setBorder(new TitledBorder("collection editing"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        this.pcEditPanel.add((Component)this.pcEditOwnerRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        this.pcEditPanel.add((Component)this.pcEditGroupRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        this.pcEditPanel.add((Component)this.pcEditOtherRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pcEditPanel, gridBagConstraints);
    }

    protected void setUserGroups(List list, int n) {
        this.pcGroupComboBox.removeAllItems();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.pcGroupComboBox.addItem(list.get(i));
            }
            if (n != -1 && n >= 0 && n < list.size()) {
                this.pcGroupComboBox.setSelectedIndex(n);
            }
        }
    }

    protected void setUsers(List list, int n) {
        this.pcOwnerComboBox.removeAllItems();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.pcOwnerComboBox.addItem(list.get(i));
            }
            if (n != -1 && n >= 0 && n < list.size()) {
                this.pcOwnerComboBox.setSelectedIndex(n);
            }
        }
    }

    protected static boolean hasPermissionSetting(int n, int n2) {
        return (n & n2) == n2;
    }

    protected void setPermissions(int n, int n2) {
        this.groupPrivs = n;
        this.otherPrivs = n2;
        if (PersonalCollectionAccessSettingsConfigurationEditComponent.hasPermissionSetting(n2, 1)) {
            this.setReadOther();
        } else if (PersonalCollectionAccessSettingsConfigurationEditComponent.hasPermissionSetting(n, 1)) {
            this.setReadGroup();
        } else {
            this.setReadOwner();
        }
        if (PersonalCollectionAccessSettingsConfigurationEditComponent.hasPermissionSetting(n2, 2)) {
            this.pcEditOtherRadioButton.doClick();
        } else if (PersonalCollectionAccessSettingsConfigurationEditComponent.hasPermissionSetting(n, 2)) {
            this.pcEditGroupRadioButton.doClick();
        } else {
            this.pcEditOwnerRadioButton.doClick();
        }
    }

    private void setReadOther() {
        this.otherPrivs |= 1;
        this.groupPrivs |= 1;
        this.pcReadOtherRadioButton.setSelected(true);
        this.setEditEnabledStates(true, true);
    }

    private void setReadGroup() {
        this.otherPrivs &= 0xFFFE;
        this.groupPrivs |= 1;
        this.pcReadGroupRadioButton.setSelected(true);
        this.setEditEnabledStates(true, false);
    }

    private void setReadOwner() {
        this.otherPrivs &= 0xFFFE;
        this.groupPrivs &= 0xFFFE;
        this.pcReadOwnerRadioButton.setSelected(true);
        this.setEditEnabledStates(false, false);
    }

    private void setEditEnabledStates(boolean bl, boolean bl2) {
        this.pcEditOtherRadioButton.setEnabled(bl2);
        if (!this.pcEditOtherRadioButton.isEnabled() && this.pcEditOtherRadioButton.isSelected()) {
            this.pcEditGroupRadioButton.doClick();
        }
        this.pcEditGroupRadioButton.setEnabled(bl);
        if (!this.pcEditGroupRadioButton.isEnabled() && this.pcEditGroupRadioButton.isSelected()) {
            this.pcEditOwnerRadioButton.doClick();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
        if (jRadioButton == this.pcReadOtherRadioButton) {
            this.setReadOther();
        } else if (jRadioButton == this.pcReadGroupRadioButton) {
            this.setReadGroup();
        } else if (jRadioButton == this.pcReadOwnerRadioButton) {
            this.setReadOwner();
        } else if (jRadioButton == this.pcEditOtherRadioButton) {
            this.otherPrivs |= 3;
            this.groupPrivs |= 3;
        } else if (jRadioButton == this.pcEditGroupRadioButton) {
            this.otherPrivs &= 0xFFFD;
            this.groupPrivs |= 3;
        } else if (jRadioButton == this.pcEditOwnerRadioButton) {
            this.otherPrivs &= 0xFFFD;
            this.groupPrivs &= 0xFFFD;
        }
    }

    public int getSelectedOwnerId() {
        return ((CollectionServerUser)this.pcOwnerComboBox.getSelectedItem()).getUserId();
    }

    public int getSelectedGroupId() {
        return ((PersonalCollectionServerUserGroup)this.pcGroupComboBox.getSelectedItem()).getGroupID();
    }

    public int getGroupPrivs() {
        return this.groupPrivs;
    }

    public int getOtherPrivs() {
        return this.otherPrivs;
    }
}

