/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.collection;

import com.luna.insight.admin.ControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.collection.PersonalCollectionSettingsNode;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationNode;
import com.luna.insight.admin.collserver.indexer.CsTasksInvokeIndexerNode;
import com.luna.insight.admin.collserver.inscribe.CcMedeApprovalLevelsNode;
import com.luna.insight.admin.collserver.join.CcJoinsNode;
import com.luna.insight.admin.collserver.measurement.CsMeasurementToolSettingsNode;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchesNode;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroupsNode;
import com.luna.insight.admin.collserver.mpd.CsMpdNode;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectMediaMapNode;
import com.luna.insight.admin.collserver.table.CcTableRecordsNode;
import com.luna.insight.admin.collserver.task.CsTasksNode;
import com.luna.insight.admin.collserver.usergroup.CollectionServerUserGroupsNode;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class CollectionNode
extends ControlPanelNode
implements ActionListener {
    public static final String CONVERT_TO_INSTITUTIONAL_CAPTION = "Convert to institutional collection";
    public static final String COMMAND_NEW_MEDIA_GROUP = "New Media Group Command";
    public static final String COMMAND_DELETE_MEDIA_GROUP = "Delete Media Group Command";
    public static final String COMMAND_EDIT_MEDIA_GROUP = "Edit Media Group Command";
    public static final String COMMAND_CONVERT_TO_INSTITUTIONAL = "New Configuration Conversion Command";
    public static final String COMMAND_NEW_CONFIGURATION = "New Configuration Command";
    public static final String COMMAND_DELETE_CONFIGURATION = "Delete Configuration Command";
    public static final String COMMAND_EDIT_CONFIGURATION = "Edit Configuration Command";
    public static final String COMMAND_EDIT_PC_ACCESS_SETTINGS = "Edit PC Access Settings Command";
    public static final String COMMAND_NEW_USER_GROUP = "New User Group Command";
    public static final String COMMAND_DELETE_USER_GROUP = "Delete User Group Command";
    public static final String COMMAND_EDIT_USER_GROUP = "Edit User Group Command";
    public static final String COMMAND_NEW_MPD = "New Mpd Command";
    public static final String COMMAND_DELETE_MPD = "Delete Mpd Command";
    public static final String COMMAND_EDIT_MPD = "Edit Mpd Command";
    public static final String COMMAND_NEW_MPDT = "New Mpdt Command";
    public static final String COMMAND_EDIT_MEDE_APPROVAL_LEVELS = "Edit MEDE Approval Levels Command";
    public static final String COMMAND_EDIT_TASK_SET_INDEXER = "Edit set-indexer";
    public static final String COMMAND_EDIT_TASK_INVOKE_INDEXER = "Edit invoke-indexer";
    public static final String COMMAND_NEW_MEDIA_BATCH = "New-media-batch";
    public static final String COMMAND_EDIT_MEDIA_BATCH = "Edit-media-batch";
    public static final String COMMAND_DELETE_MEDIA_BATCH = "Delete-media-batch";
    public static final String COMMAND_EDIT_TASK_OBJECT_IMAGE_MAP = "Edit-map-objects-images";
    public static final String COMMAND_EDIT_MEASUREMENT_TOOL_SETTINGS = "Edit-measurement-tool-settings";
    public static final String COMMAND_NEW_TABLE_RECORD = "New Table Record Command";
    public static final String COMMAND_DELETE_TABLE_RECORD = "Delete Table Record Command";
    public static final String COMMAND_EDIT_TABLE_RECORD = "Edit Table Record Command";
    public static final String COMMAND_EDIT_TASK_INSIGHT_JOINS = "Edit-insight-joins";
    public static final String COMMAND_EDIT_TASK_INSCRIBE_JOINS = "Edit-inscribe-joins";
    protected String labelText;
    protected Collection collection;
    public CsMediaGroupsNode mediaGroupsNode = null;
    public CollectionServerConfigurationNode configurationsNode = null;
    public PersonalCollectionSettingsNode pcSettingsNode = null;
    public CollectionServerUserGroupsNode userGroupsNode = null;
    public CsMpdNode mpdNode = null;
    public CcMedeApprovalLevelsNode medeApprovalLevelsNode = null;
    public CsTasksNode tasksNode = null;
    public CsTasksInvokeIndexerNode indexerNode = null;
    public CcMediaBatchesNode mediaBatchesNode = null;
    public CcObjectMediaMapNode objectImageMapNode = null;
    public CsMeasurementToolSettingsNode measurementToolSettingsNode = null;
    public CcTableRecordsNode tableRecordsNode = null;
    public CcJoinsNode joinsNode = null;

    public CollectionNode(Collection collection) {
        super(collection.getServer().getInsightAdministrator(), collection.getName(), true);
        this.collection = collection;
        this.configurationsNode = new CollectionServerConfigurationNode(this);
        this.add(this.configurationsNode);
        if (collection.isPersonalCollection()) {
            this.pcSettingsNode = new PersonalCollectionSettingsNode(this);
            this.add(this.pcSettingsNode);
        }
        if (!collection.isPersonalCollection()) {
            this.userGroupsNode = new CollectionServerUserGroupsNode(this);
            this.add(this.userGroupsNode);
        }
        this.mediaGroupsNode = new CsMediaGroupsNode(this);
        this.add(this.mediaGroupsNode);
        if (!collection.isPersonalCollection()) {
            this.tableRecordsNode = new CcTableRecordsNode(this);
            this.add(this.tableRecordsNode);
            this.joinsNode = new CcJoinsNode(this, 0);
            this.add(this.joinsNode);
        }
        if (collection.getServer().getCollectionServerVersion() >= 3.5f) {
            this.mpdNode = new CsMpdNode(this);
            this.add(this.mpdNode);
        }
        if (collection.getServer().isMedeEnabled()) {
            this.medeApprovalLevelsNode = new CcMedeApprovalLevelsNode(this);
            this.add(this.medeApprovalLevelsNode);
        }
        this.measurementToolSettingsNode = new CsMeasurementToolSettingsNode(this);
        this.add(this.measurementToolSettingsNode);
        if (!collection.isPersonalCollection() && this.getCollectionServerNode().getAdminAccount().hasServerPermission(17)) {
            this.tasksNode = new CsTasksNode(this);
            this.add(this.tasksNode);
            this.indexerNode = new CsTasksInvokeIndexerNode(this.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), this, "Invoke Indexer", 0, false);
            this.tasksNode.add(this.indexerNode);
            this.mediaBatchesNode = new CcMediaBatchesNode(this);
            this.tasksNode.add(this.mediaBatchesNode);
            this.objectImageMapNode = new CcObjectMediaMapNode(this, 0);
            this.tasksNode.add(this.objectImageMapNode);
        }
    }

    public Collection getCollection() {
        return this.collection;
    }

    public CollectionServerNode getCollectionServerNode() {
        return this.collection.getServer().getServerNode();
    }

    public JPopupMenu getPopup() {
        return new JPopupMenu();
    }

    public JComponent getDisplayComponent() {
        if (this.labelText == null) {
            this.createInformationModel();
        }
        return new JLabel(this.labelText);
    }

    protected void createInformationModel() {
        this.labelText = "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        CollectionNode.debugOut("Received action: " + string);
        if (string.equals(COMMAND_NEW_MEDIA_GROUP)) {
            this.getCollectionServerNode().createNewMediaGroup(this.collection.getUniqueCollectionID());
        } else if (string.equals(COMMAND_NEW_CONFIGURATION)) {
            this.getCollectionServerNode().createNewConfiguration(this.collection.getUniqueCollectionID());
        } else if (string.equals(COMMAND_NEW_USER_GROUP)) {
            this.getCollectionServerNode().createNewUserGroup(this.collection.getUniqueCollectionID());
        } else if (string.equals(COMMAND_NEW_MPD)) {
            this.getCollectionServerNode().createNewMpd(this.collection.getUniqueCollectionID());
        } else if (string.equals(COMMAND_NEW_MPDT)) {
            this.getCollectionServerNode().createNewMpdTemplate(this.collection.getUniqueCollectionID());
        } else if (string.equals(COMMAND_EDIT_TASK_SET_INDEXER)) {
            this.getCollectionServerNode().manageSetIndexer(this.collection.getUniqueCollectionID());
        } else if (string.equals(COMMAND_EDIT_TASK_INVOKE_INDEXER)) {
            this.getCollectionServerNode().editInvokeIndexer(this.collection.getUniqueCollectionID());
        } else if (string.equals(COMMAND_NEW_MEDIA_BATCH)) {
            this.getCollectionServerNode().createNewMediaBatch(this.collection.getUniqueCollectionID());
        } else if (string.equals(COMMAND_EDIT_TASK_OBJECT_IMAGE_MAP)) {
            this.getCollectionServerNode().getCollectionServer().manageObjectImageMappings(this.collection.getUniqueCollectionID());
        } else if (string.equals(COMMAND_NEW_TABLE_RECORD)) {
            this.getCollectionServerNode().createNewTableRecord(this.collection.getUniqueCollectionID());
        } else if (string.equals(COMMAND_EDIT_TASK_INSCRIBE_JOINS)) {
            this.getCollectionServerNode().getCollectionServer().editInscribeJoins(this.collection);
        } else if (string.equals(COMMAND_EDIT_TASK_INSIGHT_JOINS)) {
            this.getCollectionServerNode().getCollectionServer().editInsightJoins(this.collection);
        }
    }

    public static void debugOut(String string) {
        CollectionNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionNode: " + string, n);
    }
}

