/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.ProgressListener;
import com.luna.insight.admin.RecordCommitFailedException;
import com.luna.insight.admin.RecordDeleteFailedException;
import com.luna.insight.admin.catalog.CatalogTemplate;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerTableNames;
import com.luna.insight.admin.collserver.CollectionServerUser;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationBrowserAttributes;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationRecordHandler;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationVisualAttributes;
import com.luna.insight.admin.collserver.field.CollectionServerField;
import com.luna.insight.admin.collserver.field.CollectionServerFieldGroup;
import com.luna.insight.admin.collserver.field.CollectionServerFieldGroupRecordHandler;
import com.luna.insight.admin.collserver.field.CollectionServerFieldRecordHandler;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandard;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardField;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardFieldRecordHandler;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardRecordHandler;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardsManager;
import com.luna.insight.admin.collserver.indexer.CsTasksIndexerRecordHandler;
import com.luna.insight.admin.collserver.inscribe.CcMedeApprovalLevels;
import com.luna.insight.admin.collserver.inscribe.CcMedeApprovalLevelsRecordHandler;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityField;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityFieldRecordHandler;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityRelationship;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityRelationshipRecordHandler;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityType;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityTypeRecordHandler;
import com.luna.insight.admin.collserver.join.CcJoinManager;
import com.luna.insight.admin.collserver.join.CcJoinRecord;
import com.luna.insight.admin.collserver.join.CcJoinRecordHandler;
import com.luna.insight.admin.collserver.lps.CcLpsData;
import com.luna.insight.admin.collserver.lps.CcLpsDataRecordHandler;
import com.luna.insight.admin.collserver.maxid.CsMaxIDs;
import com.luna.insight.admin.collserver.maxid.CsMaxIDsRecordHandler;
import com.luna.insight.admin.collserver.measurement.CsMeasurementToolSettings;
import com.luna.insight.admin.collserver.measurement.CsMeasurementToolSettingsRecordHandler;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfile;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileRecordHandler;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolution;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolutionRecordHandler;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchElement;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchElementRecordHandler;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchRecordHandler;
import com.luna.insight.admin.collserver.mediacreation.CsMediaFile;
import com.luna.insight.admin.collserver.mediacreation.CsMediaFileRecordHandler;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroup;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroupRecordHandler;
import com.luna.insight.admin.collserver.mpd.CsMpd;
import com.luna.insight.admin.collserver.mpd.CsMpdRecordHandler;
import com.luna.insight.admin.collserver.mpd.CsMpdTemplate;
import com.luna.insight.admin.collserver.mpd.CsMpdtRecordHandler;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaRecord;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectMediaMappingManager;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectRecord;
import com.luna.insight.admin.collserver.profile.CollectionServerProfile;
import com.luna.insight.admin.collserver.profile.CollectionServerProfileRecordHandler;
import com.luna.insight.admin.collserver.sps.CcSpsData;
import com.luna.insight.admin.collserver.sps.CcSpsDataRecordHandler;
import com.luna.insight.admin.collserver.stoplist.CcStopWord;
import com.luna.insight.admin.collserver.stoplist.CcStopWordRecordHandler;
import com.luna.insight.admin.collserver.table.CcTableRecord;
import com.luna.insight.admin.collserver.table.CcTableRecordHandler;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.admin.collserver.task.CcTaskItemRecordHandler;
import com.luna.insight.admin.collserver.task.CcTaskLockFailedException;
import com.luna.insight.admin.collserver.task.CcTaskRecord;
import com.luna.insight.admin.collserver.task.CcTaskRecordHandler;
import com.luna.insight.admin.collserver.usergroup.CollectionServerConnectionPool;
import com.luna.insight.admin.collserver.usergroup.CollectionServerConnectionPoolRecordHandler;
import com.luna.insight.admin.collserver.usergroup.CollectionServerUserGroup;
import com.luna.insight.admin.collserver.usergroup.CollectionServerUserGroupRecordHandler;
import com.luna.insight.admin.collserver.usergroup.PersonalCollectionServerUserGroup;
import com.luna.insight.admin.collserver.vocab.CsVocabValue;
import com.luna.insight.admin.collserver.vocab.CsVocabValueRecordHandler;
import com.luna.insight.admin.manytomanymap.MapRecord;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldValue;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import com.luna.insight.server.backend.JdbcConnectorError;
import com.luna.insight.server.backend.SqlBatchController;
import com.luna.insight.server.backend.SqlQueryGenerator;
import com.luna.insight.server.backend.TrinityConnector;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class CollectionServerConnector
extends AdministeredServerConnector
implements CollectionServerTableNames {
    public static int DEFAULT_OBJ_ENTITY_TYPE_ID = 1;
    public CollectionServerConfigurationRecordHandler configurationHandler = null;
    public CollectionServerProfileRecordHandler profileHandler = null;
    public CsFieldStandardRecordHandler fieldStandardHandler = null;
    public CsFieldStandardFieldRecordHandler fieldStandardFieldHandler = null;
    public CollectionServerConnectionPoolRecordHandler connectionPoolHandler = null;
    public CollectionServerUserGroupRecordHandler userGroupHandler = null;
    public CollectionServerFieldRecordHandler fieldHandler = null;
    public CollectionServerFieldGroupRecordHandler fieldGroupHandler = null;
    public CsMediaGroupRecordHandler mediaGroupHandler = null;
    public CsMediaFileRecordHandler mediaFileHandler = null;
    public CsVocabValueRecordHandler vocabValueHandler = null;
    public CsTasksIndexerRecordHandler taskIndexerHandler = null;
    public CcLpsDataRecordHandler lpsDataHandler = null;
    public CcSpsDataRecordHandler spsDataHandler = null;
    public CsMpdRecordHandler mpdHandler = null;
    public CsMpdtRecordHandler mpdtHandler = null;
    public CcTableRecordHandler tableRecordHandler = null;
    public CcJoinRecordHandler joinRecordHandler = null;
    public CcStopWordRecordHandler stopWordRecordHandler = null;
    public CcBatchProfileRecordHandler batchProfileRecordHandler = null;
    public CcBatchProfileResolutionRecordHandler resolutionRecordHandler = null;
    public CcMediaBatchRecordHandler mediaBatchRh = null;
    public CcMediaBatchElementRecordHandler mediaBatchElementRh = null;
    public CcTaskRecordHandler taskRecordHandler = null;
    public CcTaskItemRecordHandler taskItemRecordHandler = null;
    public CsMeasurementToolSettingsRecordHandler measurementToolSettingsHandler = null;
    public CsMaxIDsRecordHandler maxIDsHandler = null;
    public CcMedeEntityFieldRecordHandler entityFieldHandler = null;
    public CcMedeApprovalLevelsRecordHandler medeApprovalLevelsHandler = null;
    public CcMedeEntityTypeRecordHandler medeEntityTypeHandler = null;
    public CcMedeEntityRelationshipRecordHandler medeEntityRelationshipHandler = null;

    public CollectionServerConnector(CollectionServer collectionServer, Properties properties) {
        this.COMPONENT_CODE = "CollectionServerConnector";
        this.server = collectionServer;
        this.dbConnectorGenerator = DatabaseConnectorGenerator.getCustomGenerator(properties);
        this.setConnectString(properties.getProperty(collectionServer.getConnectStringKey()));
        if (this.msAccessMode) {
            this.distinctKeyword = "DISTINCTROW";
        }
        if (!this.useDistinctKeyword) {
            this.distinctKeyword = "";
        }
        this.configurationHandler = new CollectionServerConfigurationRecordHandler(this);
        this.profileHandler = new CollectionServerProfileRecordHandler(this);
        this.fieldStandardHandler = new CsFieldStandardRecordHandler(this);
        this.fieldStandardFieldHandler = new CsFieldStandardFieldRecordHandler(this);
        this.connectionPoolHandler = new CollectionServerConnectionPoolRecordHandler(this);
        this.userGroupHandler = new CollectionServerUserGroupRecordHandler(this);
        this.fieldHandler = new CollectionServerFieldRecordHandler(this);
        this.fieldGroupHandler = new CollectionServerFieldGroupRecordHandler(this);
        this.mediaGroupHandler = new CsMediaGroupRecordHandler(this);
        this.mediaFileHandler = new CsMediaFileRecordHandler(this);
        this.vocabValueHandler = new CsVocabValueRecordHandler(this);
        this.taskIndexerHandler = new CsTasksIndexerRecordHandler(this);
        this.lpsDataHandler = new CcLpsDataRecordHandler(this);
        this.spsDataHandler = new CcSpsDataRecordHandler(this);
        this.mpdHandler = new CsMpdRecordHandler(this);
        this.mpdtHandler = new CsMpdtRecordHandler(this);
        this.tableRecordHandler = new CcTableRecordHandler(this);
        this.joinRecordHandler = new CcJoinRecordHandler(this);
        this.stopWordRecordHandler = new CcStopWordRecordHandler(this);
        this.resolutionRecordHandler = new CcBatchProfileResolutionRecordHandler(this);
        this.batchProfileRecordHandler = new CcBatchProfileRecordHandler(this);
        this.mediaBatchRh = new CcMediaBatchRecordHandler(this);
        this.mediaBatchElementRh = new CcMediaBatchElementRecordHandler(this);
        this.taskRecordHandler = new CcTaskRecordHandler(this);
        this.taskItemRecordHandler = new CcTaskItemRecordHandler(this);
        this.entityFieldHandler = new CcMedeEntityFieldRecordHandler(this);
        this.measurementToolSettingsHandler = new CsMeasurementToolSettingsRecordHandler(this);
        this.maxIDsHandler = new CsMaxIDsRecordHandler(this);
        this.medeApprovalLevelsHandler = new CcMedeApprovalLevelsRecordHandler(this);
        this.medeEntityTypeHandler = new CcMedeEntityTypeRecordHandler(this);
        this.medeEntityRelationshipHandler = new CcMedeEntityRelationshipRecordHandler(this);
    }

    public void commitRecord(DatabaseRecord databaseRecord) throws RecordCommitFailedException {
        if (databaseRecord != null) {
            if (databaseRecord instanceof CollectionServerConfiguration) {
                this.configurationHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CollectionServerConfigurationVisualAttributes) {
                this.configurationHandler.commitRecord(((CollectionServerConfigurationVisualAttributes)databaseRecord).collectionServerConfiguration);
            } else if (databaseRecord instanceof CollectionServerConfigurationBrowserAttributes) {
                this.configurationHandler.commitRecord(((CollectionServerConfigurationBrowserAttributes)databaseRecord).collectionServerConfiguration);
            } else if (databaseRecord instanceof CollectionServerProfile) {
                this.profileHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CsFieldStandard) {
                this.fieldStandardHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CsFieldStandardField) {
                this.fieldStandardFieldHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CollectionServerConnectionPool) {
                this.connectionPoolHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CollectionServerUserGroup || databaseRecord instanceof PersonalCollectionServerUserGroup) {
                this.userGroupHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CollectionServerField) {
                this.fieldHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CollectionServerFieldGroup) {
                this.fieldGroupHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CsMediaGroup) {
                this.mediaGroupHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CsMediaFile) {
                this.mediaFileHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CsVocabValue) {
                this.vocabValueHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcLpsData) {
                this.lpsDataHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcSpsData) {
                this.spsDataHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcTableRecord) {
                this.tableRecordHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcJoinRecord) {
                this.joinRecordHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcStopWord) {
                this.stopWordRecordHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcMediaBatch) {
                this.mediaBatchRh.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcMediaBatchElement) {
                this.mediaBatchElementRh.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcBatchProfileResolution) {
                this.resolutionRecordHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcBatchProfile) {
                this.batchProfileRecordHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcTaskRecord) {
                this.taskRecordHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CsMpd) {
                this.mpdHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CsMpdTemplate) {
                this.mpdtHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcMedeEntityField) {
                this.entityFieldHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CsMeasurementToolSettings) {
                this.measurementToolSettingsHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CsMaxIDs) {
                this.maxIDsHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcMedeApprovalLevels) {
                this.medeApprovalLevelsHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcMedeEntityType) {
                this.medeEntityTypeHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof CcMedeEntityRelationship) {
                this.medeEntityRelationshipHandler.commitRecord(databaseRecord);
            } else {
                super.commitRecord(databaseRecord);
            }
        }
    }

    public void deleteRecord(DatabaseRecord databaseRecord) throws RecordDeleteFailedException {
        if (databaseRecord != null) {
            if (databaseRecord instanceof CollectionServerConfiguration) {
                this.configurationHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CollectionServerProfile) {
                this.profileHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CsFieldStandard) {
                this.fieldStandardHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CsFieldStandardField) {
                this.fieldStandardFieldHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CollectionServerConnectionPool) {
                this.connectionPoolHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CollectionServerUserGroup || databaseRecord instanceof PersonalCollectionServerUserGroup) {
                this.userGroupHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CollectionServerField) {
                this.fieldHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CollectionServerFieldGroup) {
                this.fieldGroupHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CsMediaGroup) {
                this.mediaGroupHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CsMediaFile) {
                this.mediaFileHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CsVocabValue) {
                this.vocabValueHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcLpsData) {
                this.lpsDataHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcSpsData) {
                this.spsDataHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcTableRecord) {
                this.tableRecordHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcJoinRecord) {
                this.joinRecordHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcStopWord) {
                this.stopWordRecordHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcMediaBatch) {
                this.mediaBatchRh.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcMediaBatchElement) {
                this.mediaBatchElementRh.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcBatchProfileResolution) {
                this.resolutionRecordHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcBatchProfile) {
                this.batchProfileRecordHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcTaskRecord) {
                this.taskRecordHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CsMpd) {
                this.mpdHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcMedeEntityType) {
                this.medeEntityTypeHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcMedeEntityField) {
                this.entityFieldHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof CcMedeEntityRelationship) {
                this.medeEntityRelationshipHandler.deleteRecord(databaseRecord);
            } else {
                super.deleteRecord(databaseRecord);
            }
        }
    }

    public Vector getConfigurationRecords(Integer n, boolean bl) {
        return this.configurationHandler.getRecords(n, bl);
    }

    public Vector getProfileRecords() {
        return this.profileHandler.getRecords();
    }

    public Vector getProfileRecords(int n) {
        return this.profileHandler.getRecords(n);
    }

    public boolean getSupportsMpd() {
        return this.profileHandler.getSupportsMpd();
    }

    public int getNextValidProfileID() {
        return this.profileHandler.getNextValidID();
    }

    public void putConfigProperty(Hashtable hashtable, String string, Object object) {
        if (object != null && string != null) {
            hashtable.put(string, object);
        }
    }

    public Vector getFieldRecords(Integer n) {
        return this.fieldHandler.getRecords(n);
    }

    public int getNextValidFieldID() {
        return this.fieldHandler.getNextValidID();
    }

    public Vector getFieldGroupRecords(Integer n) {
        return this.fieldGroupHandler.getRecords(n);
    }

    public int getNextValidFieldGroupID() {
        return this.fieldGroupHandler.getNextValidID();
    }

    public Vector getJoinRecords(int n) {
        return this.joinRecordHandler.getRecords(n);
    }

    public CcJoinManager getJoinManager(Collection collection, int n) {
        return this.joinRecordHandler.getJoinManager(collection, n);
    }

    public int getNextJoinID() {
        return this.joinRecordHandler.getJoinManager(null, 0).getNextJoinID();
    }

    public void saveJoins(CcJoinManager ccJoinManager) {
        this.joinRecordHandler.saveJoins(ccJoinManager);
    }

    public Vector getTableRecords(Collection collection) {
        return this.tableRecordHandler.getRecords(collection);
    }

    public int getNextValidTableRecordID() {
        return this.tableRecordHandler.getNextValidID();
    }

    public Vector getFieldStandardRecords() {
        return this.fieldStandardHandler.getRecords();
    }

    public int getNextValidFieldStandardID() {
        return this.fieldStandardHandler.getNextValidID();
    }

    public int getNextValidFieldStandardDisplayOrder() {
        return this.fieldStandardHandler.getNextValidDisplayOrder();
    }

    public Vector getFieldStandardFieldRecords(CsFieldStandard csFieldStandard) {
        return new CsFieldStandardFieldRecordHandler(this, csFieldStandard).getRecords();
    }

    public int getNextValidFieldStandardFieldID(CsFieldStandard csFieldStandard) {
        return new CsFieldStandardFieldRecordHandler(this, csFieldStandard).getNextValidID();
    }

    public CsFieldStandardsManager getFieldStandardsManager() {
        return this.fieldStandardHandler.getFieldStandardsManager();
    }

    public boolean saveStandardFieldMappings(CsFieldStandardsManager csFieldStandardsManager) {
        return this.fieldStandardHandler.saveStandardFieldMappings(csFieldStandardsManager);
    }

    public Vector getConnectionPoolRecords() {
        return this.connectionPoolHandler.getRecords();
    }

    public int getNextValidConnectionPoolID() {
        return this.connectionPoolHandler.getNextValidID();
    }

    public Vector getUserGroupRecords(Integer n) {
        return this.userGroupHandler.getRecords(n);
    }

    public int getNextValidUserGroupID() {
        return this.userGroupHandler.getNextValidID();
    }

    public CsMediaGroup getMediaGroupRecord(CsMediaGroup csMediaGroup) {
        return (CsMediaGroup)this.mediaGroupHandler.getRecord(csMediaGroup);
    }

    public Vector getMediaGroupRecords(Integer n, int n2) {
        return this.mediaGroupHandler.getRecords(n, n2);
    }

    public int getNextValidMediaGroupID() {
        return this.mediaGroupHandler.getNextValidID();
    }

    public Vector getMediaFileRecords(Integer n) {
        return this.mediaFileHandler.getRecords(n);
    }

    public Vector getEntityFieldRecords(Integer n) {
        return this.entityFieldHandler.getRecords(n);
    }

    public int getNextValidEntityFieldID() {
        return this.entityFieldHandler.getNextValidID();
    }

    public Vector getMedeProfileRecords(int n) {
        return this.profileHandler.getRecords(n, true);
    }

    public Vector getMedeApprovalLevelRecords(Integer n) {
        return this.medeApprovalLevelsHandler.getRecords(n);
    }

    public Vector getMedeEntityTypeRecords(Integer n) {
        return this.medeEntityTypeHandler.getRecords(n);
    }

    public int getNextValidMedeEntityTypeID() {
        return this.medeEntityTypeHandler.getNextValidID();
    }

    public List getUnmappedFieldGroups() {
        return this.medeEntityTypeHandler.getUnmappedFieldGroups();
    }

    public Vector getMedeEntityRelationshipRecords(Integer n) {
        return this.medeEntityRelationshipHandler.getRecords(n);
    }

    public void commitMediaFiles(Vector vector) {
        this.mediaFileHandler.insertMultipleRecords(vector);
    }

    public boolean verifyBatchDatabaseEntries(List list) {
        return this.mediaFileHandler.verifyBatchDatabaseEntries(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCollectionServerUserList() {
        DatabaseConnector databaseConnector = null;
        ArrayList<CollectionServerUser> arrayList = new ArrayList<CollectionServerUser>();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            databaseConnector = this.getDatabaseConnector();
            sqlQueryGenerator.addTable("IRUSERS", null, "*");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                CollectionServerUser collectionServerUser = new CollectionServerUser(databaseConnector.getIntegerFieldByName("UserID"), databaseConnector.getFieldByName("LoginName"), databaseConnector.getFieldByName("Organization"), databaseConnector.getFieldByName("Email"), databaseConnector.getFieldByName("Phone"), databaseConnector.getFieldByName("Address"), databaseConnector.getFieldByName("City"), databaseConnector.getFieldByName("State"), databaseConnector.getFieldByName("PostalCode"), databaseConnector.getFieldByName("Country"), databaseConnector.getFieldByName("FirstName"), databaseConnector.getFieldByName("LastName"), databaseConnector.getFieldByName("CreatedTimestamp"));
                arrayList.add(collectionServerUser);
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollectionServerUserList(): " + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return arrayList;
    }

    public int getNextMediaBatchID() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        int n = 1;
        try {
            databaseConnector.setQuery("SELECT MaxBatchID FROM IRMAXIDS");
            this.debugOut("Get next batch ID query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            int n2 = 0;
            if (databaseConnector.more()) {
                n2 = databaseConnector.getIntegerField("MaxBatchID");
            }
            databaseConnector.close();
            if (n2 <= 0) {
                n2 = (int)this.lpsDataHandler.getMaxID();
            }
            n = n2 + 1;
            databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxBatchID = " + n);
            this.debugOut("Set max batch ID:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextMediaBatchID(): " + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return n;
    }

    public long getNextMediaID() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        long l = 1L;
        try {
            databaseConnector.setQuery("SELECT MaxMediaID FROM IRMAXIDS");
            this.debugOut("Get next media ID query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            long l2 = 0L;
            if (databaseConnector.more()) {
                l2 = databaseConnector.getLongField("MaxMediaID");
            }
            databaseConnector.close();
            if (l2 <= 0L) {
                l2 = this.mediaFileHandler.getMaxID();
            }
            l = l2 + 1L;
            databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxMediaID = " + l);
            this.debugOut("Set max media ID:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextMediaID(): " + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextAvailableMediaID(long l) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        long l2 = l;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        try {
            databaseConnector.setQuery("SELECT ImageID FROM IRIMAGEFILES WHERE ImageID >= " + l);
            this.debugOut("Get in use media ID query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                hashtable.put(databaseConnector.getLongField("ImageID") + "", "");
                databaseConnector.next();
            }
            databaseConnector.setQuery("SELECT ReservedMediaID FROM IRRESERVEDMEDIAIDS WHERE ReservedMediaID >= " + l);
            this.debugOut("Get reserved media ID query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                hashtable2.put(databaseConnector.getLongField("ReservedMediaID") + "", "");
                databaseConnector.next();
            }
            l2 = l;
            while (hashtable.containsKey(l2 + "") || hashtable2.containsKey(l2 + "")) {
                ++l2;
            }
            databaseConnector.setQuery("UPDATE IRRESERVEDMEDIAIDS SET ReservedMediaID = " + l2);
            this.debugOut("Add reserved media ID query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.setQuery("SELECT MaxMediaID FROM IRMAXIDS");
            this.debugOut("Get max media ID query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            long l3 = 0L;
            if (databaseConnector.more()) {
                l3 = databaseConnector.getLongField("MaxMediaID");
            }
            if (l2 > l3 && l3 != 0L) {
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxMediaID = " + l2);
                this.debugOut("Set max media ID:\n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextAvailableMediaID(): " + InsightUtilities.getStackTrace(exception));
            l2 = this.getNextMediaID();
        }
        finally {
            databaseConnector.close();
        }
        return l2;
    }

    public CollectionServerFieldRecordHandler getFieldHandler() {
        return this.fieldHandler;
    }

    public CsFieldStandardFieldRecordHandler getFieldStandardFieldHandler() {
        return this.fieldStandardFieldHandler;
    }

    public CcMedeEntityTypeRecordHandler getEntityTypeHandler() {
        return this.medeEntityTypeHandler;
    }

    public Vector getVocabValueRecords(int n) {
        return this.vocabValueHandler.getRecords(n);
    }

    public int getNextValidVocabValueID(int n) {
        return this.vocabValueHandler.getNextValidID(n);
    }

    public Vector getLpsDataRecords() {
        return this.lpsDataHandler.getRecords();
    }

    public int getNextValidLpsDataID() {
        return this.lpsDataHandler.getNextValidID();
    }

    public Vector getSpsDataRecords() {
        return this.spsDataHandler.getRecords();
    }

    public Vector getSpsDataRecordsBySpsNum() {
        return this.spsDataHandler.getRecords(true);
    }

    public Vector getSpsDataRecordsForPublishDialog() {
        return this.spsDataHandler.getRecordsForPublishDialog();
    }

    public int getValidSpsNumber() {
        return this.spsDataHandler.getValidSpsNumber();
    }

    public int getNextValidSpsDataID() {
        return this.spsDataHandler.getNextValidID();
    }

    public Vector getStopWordRecords() {
        return this.stopWordRecordHandler.getRecords();
    }

    public int getNextValidBatchProfileID() {
        return this.batchProfileRecordHandler.getNextValidID();
    }

    public CcBatchProfile createNewBatchProfile() {
        return new CcBatchProfile(this.getNextValidBatchProfileID(), (CollectionServer)this.server);
    }

    public Vector getBatchProfileRecords() {
        return this.batchProfileRecordHandler.getRecords();
    }

    public CcBatchProfile getBatchProfileRecord(int n) {
        return this.batchProfileRecordHandler.getBatchProfileRecord(n);
    }

    public Vector getMeasurementToolSettingsRecords(Integer n) {
        return this.measurementToolSettingsHandler.getRecords(n);
    }

    public Vector getMaxIDsRecords() {
        return this.maxIDsHandler.getRecords();
    }

    public int getNextValidStopWordID() {
        return this.stopWordRecordHandler.getNextValidID();
    }

    public Vector getTaskRecords() {
        return this.taskRecordHandler.getRecords();
    }

    public void lockTask(CcTaskRecord ccTaskRecord, AdminAccount adminAccount) throws CcTaskLockFailedException {
        this.taskRecordHandler.lockTask(ccTaskRecord, adminAccount);
    }

    public void unlockTask(CcTaskRecord ccTaskRecord, AdminAccount adminAccount) {
        if (adminAccount.hasServerPermission(17) || ccTaskRecord.isTaskLocked() && ccTaskRecord.getTaskLocker() != null && ccTaskRecord.getTaskLocker().getIndex() == adminAccount.getIndex()) {
            this.taskRecordHandler.unlockTask(ccTaskRecord);
        }
    }

    public int getNextValidTaskRecordID() {
        return this.taskRecordHandler.getNextValidID();
    }

    public void updateTaskStartTime(CcTaskRecord ccTaskRecord) {
        this.taskRecordHandler.updateTaskStartTime(ccTaskRecord);
    }

    public void updateTaskCompletionTime(CcTaskRecord ccTaskRecord) {
        this.taskRecordHandler.updateTaskCompletionTime(ccTaskRecord);
    }

    public int getNextValidTaskItemID() {
        return this.taskItemRecordHandler.getNextValidID();
    }

    public void updateTaskItemStartTime(CcTaskItem ccTaskItem) {
        this.taskItemRecordHandler.updateTaskItemStartTime(ccTaskItem);
    }

    public void updateTaskItemCompletionTime(CcTaskItem ccTaskItem) {
        this.taskItemRecordHandler.updateTaskItemCompletionTime(ccTaskItem);
    }

    public List getMediaBatches(Integer n) {
        return this.mediaBatchRh.getRecords(n);
    }

    public long getNextValidMediaBatchElementID(int n) {
        return this.mediaBatchElementRh.getNextBatchElementID(n);
    }

    public List getMediaBatchElements(CcMediaBatch ccMediaBatch) {
        return this.mediaBatchElementRh.getRecords(ccMediaBatch);
    }

    public void clearBatchElementRecords(int n) {
        this.mediaBatchElementRh.clearRecords(n);
    }

    public List getMediaBatchesReferencingProfile(CcBatchProfile ccBatchProfile) {
        return this.mediaBatchRh.getRecordsReferencingProfile(ccBatchProfile);
    }

    public Vector getResolutionRecords(int n) {
        return this.resolutionRecordHandler.getRecordsForProfile(n);
    }

    public void clearResolutionRecords(int n) {
        this.resolutionRecordHandler.clearRecords(n);
    }

    public void publishMediaBatch(CcMediaBatch ccMediaBatch, CsMediaGroup csMediaGroup) {
        this.mediaBatchRh.publishMediaBatch(ccMediaBatch, csMediaGroup);
    }

    public Vector getMpds(Integer n) {
        return this.mpdHandler.getRecords(n);
    }

    public Vector getMpdsToIndex(Integer n) {
        return this.taskIndexerHandler.getMpdsToIndex(n);
    }

    public Vector getMpdLevelData(int n) {
        return this.mpdHandler.getMpdLevelData(n);
    }

    public Vector getMpdGroupList(Integer n) {
        return this.mpdHandler.getMpdGroupList(n);
    }

    public int getMpdGroupId(int n) {
        return this.mpdHandler.getGroupId(n);
    }

    public Vector getMpdFieldList(Integer n) {
        return this.mpdHandler.getFieldList(n);
    }

    public Vector getMpdLevelFieldList(Integer n) {
        return this.mpdHandler.getLevelFieldList(n);
    }

    public int getNextValidMpdId() {
        return this.mpdHandler.getNextValidID();
    }

    public List getFieldList(Integer n) {
        Vector<Field> vector;
        DatabaseConnector databaseConnector;
        block11: {
            databaseConnector = this.getDatabaseConnector();
            vector = new Vector<Field>();
            try {
                this.debugOut("in getFieldList().");
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IRFIELDS", null, "*");
                sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
                sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
                sqlQueryGenerator.addJoin("IRFIELDS", "FieldID", "SLSTANDARDFIELDS", "StandardFieldID", 0);
                sqlQueryGenerator.appendToWhere("SLSTANDARDFIELDS.StandardID IN (SELECT NativeStandardID FROM IRCOLLECTIONCONFIGURATIONINFO WHERE IRCOLLECTIONCONFIGURATIONINFO.UniqueCollectionID = " + n + " AND " + "IRCOLLECTIONCONFIGURATIONINFO" + ".VCID = " + sqlQueryGenerator.prepStringForQuery("NA") + ")");
                sqlQueryGenerator.appendToWhere("(NOT IRFIELDS.FieldType = 0)");
                sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayName");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Field list query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                if (!databaseConnector.more()) break block11;
                while (databaseConnector.more()) {
                    Field field = new Field();
                    field.fieldID = databaseConnector.getIntegerFieldByName("FieldId");
                    field.fieldName = databaseConnector.getFieldByName("FieldName");
                    field.fieldDisplayName = databaseConnector.getFieldByName("DisplayName");
                    field.typeCode = databaseConnector.getFieldByName("TypeCode");
                    field.stringType = databaseConnector.getIntegerFieldByName("LongString");
                    field.pickable = databaseConnector.getBooleanField("SearchPick");
                    field.vocabulary = databaseConnector.getBooleanField("VocabField");
                    field.multiValue = databaseConnector.getBooleanField("MultiValue");
                    try {
                        field.date = databaseConnector.getBooleanField("IsDate");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        field.fieldType = Integer.parseInt(databaseConnector.getFieldByName("FieldType"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        field.fieldType = 0;
                    }
                    try {
                        field.keywordSearchable = databaseConnector.getBooleanField("KeywordSearchable");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        field.hierarchyMode = databaseConnector.getIntegerFieldByName("HierarchyMode");
                    }
                    catch (Exception exception) {
                        field.hierarchyMode = Field.HIERARCHY_MODE_NONE;
                    }
                    field.hierarchyName = "";
                    vector.add(field);
                    databaseConnector.next();
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in getFieldList(): " + InsightUtilities.getStackTrace(exception));
            }
        }
        databaseConnector.close();
        return vector;
    }

    public CcObjectMediaMappingManager populateObjectImageMappingManager(CcObjectMediaMappingManager ccObjectMediaMappingManager) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        this.addObjectImageMappings(ccObjectMediaMappingManager, databaseConnector);
        this.addObjectRecords(ccObjectMediaMappingManager, databaseConnector);
        this.setObjectFieldValues(ccObjectMediaMappingManager, databaseConnector);
        this.addImageRecords(ccObjectMediaMappingManager, databaseConnector);
        databaseConnector.close();
        return ccObjectMediaMappingManager;
    }

    public void addObjectImageMappings(CcObjectMediaMappingManager ccObjectMediaMappingManager, DatabaseConnector databaseConnector) {
        try {
            SqlQueryGenerator sqlQueryGenerator;
            Object object;
            ProgressListener progressListener;
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            if ((progressListener = ccObjectMediaMappingManager.getProgressListener()) != null) {
                progressListener.setMessage("Adding object-media mappings...");
            }
            String string = null;
            if (ccObjectMediaMappingManager.getMediaGroup() instanceof CsMediaGroup) {
                object = (CsMediaGroup)ccObjectMediaMappingManager.getMediaGroup();
                sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IROBJECTIMAGEMAP", null, "*");
                sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "IRGROUPIMAGEMAP", "ImageID", 0);
                sqlQueryGenerator.appendToWhere("IRGROUPIMAGEMAP.GroupID = " + ((CsMediaGroup)object).getGroupID());
                string = sqlQueryGenerator.getQuery();
            } else if (ccObjectMediaMappingManager.getMediaGroup() instanceof CcMediaBatch) {
                object = (CcMediaBatch)ccObjectMediaMappingManager.getMediaGroup();
                sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("IROBJECTIMAGEMAP", null, "*");
                sqlQueryGenerator.addJoin("IROBJECTIMAGEMAP", "ImageID", "CCMEDIABATCHELEMENTS", "DestMediaID", 0);
                sqlQueryGenerator.appendToWhere("CCMEDIABATCHELEMENTS.BatchID = " + ((CcMediaBatch)object).getBatchID());
                string = sqlQueryGenerator.getQuery();
            } else {
                object = this.getQueryGenerator();
                ((SqlQueryGenerator)object).addTable("IROBJECTIMAGEMAP", null, "*");
                ((SqlQueryGenerator)object).addJoin("IROBJECTIMAGEMAP", "ObjectID", "ISCOLLECTIONENTITYMAP", "EntityID", 0);
                ((SqlQueryGenerator)object).appendToWhere("UniqueCollectionID = " + ccObjectMediaMappingManager.getUniqueCollectionID());
                string = ((SqlQueryGenerator)object).getQuery();
            }
            int n = this.getRecordCount(databaseConnector, string, false, false);
            databaseConnector.setQuery(string);
            this.debugOut("Get object/image mappings query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (databaseConnector.more()) {
                if (progressListener != null) {
                    progressListener.setProgress(0, n, n2);
                }
                ccObjectMediaMappingManager.addObjectImageMapping(databaseConnector.getLongField("ObjectID"), databaseConnector.getLongField("ImageID"), true);
                ++n2;
                databaseConnector.next();
            }
            if (progressListener != null) {
                progressListener.progressComplete();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in addObjectImageMappings():\n" + InsightUtilities.getStackTrace(exception));
        }
        if (databaseConnector != null) {
            databaseConnector.close();
        }
    }

    public void addObjectRecords(CcObjectMediaMappingManager ccObjectMediaMappingManager, DatabaseConnector databaseConnector) {
        try {
            ProgressListener progressListener;
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            if ((progressListener = ccObjectMediaMappingManager.getProgressListener()) != null) {
                progressListener.setMessage("Adding object records...");
            }
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", null, new String[]{"EntityID"});
            sqlQueryGenerator.addJoin("DTVALUETOENTITYMAP", "ISENTITYTYPES", "EntityTypeID", 0);
            sqlQueryGenerator.appendToWhere("ISENTITYTYPES.IsPreferredEntity = 1");
            sqlQueryGenerator.appendToWhere("DTVALUETOENTITYMAP.UniqueCollectionID = " + ccObjectMediaMappingManager.getUniqueCollectionID());
            String string = sqlQueryGenerator.getQuery();
            int n = this.getRecordCount(databaseConnector, string, true, true);
            databaseConnector.setQuery(string);
            this.debugOut("Get object records query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            int n2 = 0;
            while (databaseConnector.more()) {
                if (progressListener != null) {
                    progressListener.setProgress(0, n, n2);
                }
                CcObjectRecord ccObjectRecord = new CcObjectRecord(databaseConnector.getLongField("EntityID"));
                ccObjectMediaMappingManager.addObjectRecord(ccObjectRecord);
                ++n2;
                databaseConnector.next();
            }
            if (progressListener != null) {
                progressListener.progressComplete();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in addObjectRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
        if (databaseConnector != null) {
            databaseConnector.close();
        }
    }

    public void setObjectFieldValues(CcObjectMediaMappingManager ccObjectMediaMappingManager) {
        this.setObjectFieldValues(ccObjectMediaMappingManager, null);
    }

    public void setObjectFieldValues(CcObjectMediaMappingManager ccObjectMediaMappingManager, DatabaseConnector databaseConnector) {
        try {
            ProgressListener progressListener;
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            if ((progressListener = ccObjectMediaMappingManager.getProgressListener()) != null) {
                progressListener.setMessage("Setting object field values...");
            }
            ccObjectMediaMappingManager.setObjectRecordFields();
            Field[] fieldArray = ccObjectMediaMappingManager.getFields();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("DTVALUETOENTITYMAP", null, new String[]{"EntityID"});
            sqlQueryGenerator.addTable("DTVALUES", null, new String[]{"ValueText", "ValueNumber"});
            sqlQueryGenerator.addTable("IRFIELDS", null, "FieldID");
            sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
            sqlQueryGenerator.addJoin("DTVALUETOENTITYMAP", "DTVALUES", "ValueID", 0);
            sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", "FieldID", 0);
            sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
            sqlQueryGenerator.appendToWhere(TrinityConnector.createFieldIDClause("DTVALUES", fieldArray));
            sqlQueryGenerator.appendToWhere("DTVALUES.UniqueCollectionID = " + ccObjectMediaMappingManager.getUniqueCollectionID());
            String string = sqlQueryGenerator.getQuery();
            int n = this.getRecordCount(databaseConnector, string, false, false);
            databaseConnector.setQuery(string);
            this.debugOut("Get field values query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            int n2 = 0;
            while (databaseConnector.more()) {
                if (progressListener != null) {
                    progressListener.setProgress(0, n, n2);
                }
                ccObjectMediaMappingManager.setFieldValue(databaseConnector.getLongField("EntityID"), databaseConnector.getIntegerField("FieldID"), TrinityConnector.getFieldValue(databaseConnector));
                ++n2;
                databaseConnector.next();
            }
            if (progressListener != null) {
                progressListener.setMessage("Sorting object records...");
            }
            ccObjectMediaMappingManager.sortObjectRecords();
            if (progressListener != null) {
                progressListener.progressComplete();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in setObjectFieldValues():\n" + InsightUtilities.getStackTrace(exception));
        }
        if (databaseConnector != null) {
            databaseConnector.close();
        }
    }

    public void addImageRecords(CcObjectMediaMappingManager ccObjectMediaMappingManager, DatabaseConnector databaseConnector) {
        try {
            Object object;
            ProgressListener progressListener;
            if (databaseConnector == null) {
                databaseConnector = this.getDatabaseConnector();
            }
            if ((progressListener = ccObjectMediaMappingManager.getProgressListener()) != null) {
                progressListener.setMessage("Adding media records...");
            }
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            sqlQueryGenerator.addTable("IRIMAGEFILES", null, new String[]{"ImageID", "Filename", "ResolutionSize", "MediaType"});
            sqlQueryGenerator.addTable("IRSPS", null, new String[]{"URL"});
            sqlQueryGenerator.addTable("IRLPS", null, new String[]{"LPS"});
            sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRLPS", "LPSid", 0);
            sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRSPS", new String[]{"ResolutionSize", "Format", "MediaType"}, 0);
            sqlQueryGenerator.appendToWhere("(IRIMAGEFILES.ResolutionSize = 0 OR (IRIMAGEFILES.ResolutionSize = 2 AND IRIMAGEFILES.MediaType <> 1))");
            if (ccObjectMediaMappingManager.getMediaGroup() instanceof CcMediaBatch) {
                object = (CcMediaBatch)ccObjectMediaMappingManager.getMediaGroup();
                sqlQueryGenerator.addJoin("IRIMAGEFILES", "ImageID", "CCMEDIABATCHELEMENTS", "DestMediaID", 0);
                sqlQueryGenerator.appendToWhere("CCMEDIABATCHELEMENTS.BatchID = " + ((CcMediaBatch)object).getBatchID());
            } else if (ccObjectMediaMappingManager.getMediaGroup() instanceof CsMediaGroup) {
                object = (CsMediaGroup)ccObjectMediaMappingManager.getMediaGroup();
                sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRGROUPIMAGEMAP", "ImageID", 0);
                sqlQueryGenerator.appendToWhere("IRGROUPIMAGEMAP.GroupID = " + ((CsMediaGroup)object).getGroupID());
            } else {
                sqlQueryGenerator.addJoin("IRIMAGEFILES", "ImageID", "IRCOLLECTIONMEDIAMAP", "MediaID", 0);
                sqlQueryGenerator.appendToWhere("IRCOLLECTIONMEDIAMAP.UniqueCollectionID = " + ccObjectMediaMappingManager.getUniqueCollectionID());
            }
            sqlQueryGenerator.addOrderBy("IRIMAGEFILES", "ResolutionSize");
            object = sqlQueryGenerator.getQuery();
            int n = this.getRecordCount(databaseConnector, (String)object, true, true);
            databaseConnector.setQuery((String)object);
            this.debugOut("Get image records query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            int n2 = 0;
            CcMediaBatch ccMediaBatch = null;
            while (databaseConnector.more()) {
                String string;
                if (progressListener != null) {
                    progressListener.setProgress(0, n, n2);
                }
                long l = databaseConnector.getLongField("ImageID");
                String string2 = databaseConnector.getFieldByName("Filename");
                int n3 = databaseConnector.getIntegerField("MediaType");
                int n4 = databaseConnector.getIntegerField("ResolutionSize");
                if (ccObjectMediaMappingManager.getMediaGroup() instanceof CcMediaBatch) {
                    ccMediaBatch = (CcMediaBatch)ccObjectMediaMappingManager.getMediaGroup();
                    string = ((CcMediaBatch)ccObjectMediaMappingManager.getMediaGroup()).getDestDir() + File.separator + ((CcBatchProfileResolution)((CcMediaBatch)ccObjectMediaMappingManager.getMediaGroup()).getResolutions().get(0)).getRelativeDirectoryPath(n3) + File.separator + databaseConnector.getFieldByName("LPS") + File.separator + string2;
                    CcMediaBatchElement ccMediaBatchElement = ccMediaBatch.getBatchElement(l);
                    if (ccMediaBatchElement != null) {
                        string2 = ccMediaBatchElement.getSrcFilename();
                    }
                } else {
                    ccMediaBatch = null;
                    string = databaseConnector.getFieldByName("URL") + "/" + databaseConnector.getFieldByName("LPS") + "/" + string2;
                }
                if (n4 > 0 && n3 != 1) {
                    string = "";
                }
                CcMediaRecord ccMediaRecord = ccObjectMediaMappingManager.setImageData(l, n3, string, string2, true);
                ccMediaRecord.setMediaBatch(ccMediaBatch);
                ++n2;
                databaseConnector.next();
            }
            if (progressListener != null) {
                progressListener.setMessage("Sorting media records...");
            }
            ccObjectMediaMappingManager.sortImageRecords();
            if (progressListener != null) {
                progressListener.progressComplete();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in addImageRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
        if (databaseConnector != null) {
            databaseConnector.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPreferredEntityTypeID(Integer n) {
        int n2 = DEFAULT_OBJ_ENTITY_TYPE_ID;
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            n2 = TrinityConnector.getPreferredEntityTypeID(n, databaseConnector, sqlQueryGenerator);
        }
        catch (Exception exception) {
            this.debugOut("Exception while getting \"preferred\" entity type ID:\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return n2;
    }

    public boolean saveObjectImageMappings(CcObjectMediaMappingManager ccObjectMediaMappingManager) {
        this.debugOut("in saveObjectImageMappings()");
        try {
            boolean bl;
            SqlBatchController sqlBatchController = new SqlBatchController(this.getDatabaseConnector(), 100);
            List list = ccObjectMediaMappingManager.getChanges();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            int n = DEFAULT_OBJ_ENTITY_TYPE_ID;
            boolean bl2 = bl = ((CollectionServer)this.server).isMedeEnabled() && ((CollectionServer)this.server).getCollectionServerInscribeCompliant();
            if (bl) {
                n = this.getPreferredEntityTypeID(ccObjectMediaMappingManager.getUniqueCollectionID());
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CcMediaRecord ccMediaRecord;
                MapRecord mapRecord = (MapRecord)iterator.next();
                CcObjectRecord ccObjectRecord = mapRecord.getObjectA() instanceof CcObjectRecord ? (CcObjectRecord)mapRecord.getObjectA() : (CcObjectRecord)mapRecord.getObjectB();
                CcMediaRecord ccMediaRecord2 = ccMediaRecord = mapRecord.getObjectA() instanceof CcMediaRecord ? (CcMediaRecord)mapRecord.getObjectA() : (CcMediaRecord)mapRecord.getObjectB();
                if (mapRecord.getMappingType() == 0) {
                    this.debugOut("Mapping ObjectID: " + ccObjectRecord.getObjectID() + " to ImageID: " + ccMediaRecord.getImageID());
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectID", 2, stringBuffer2, ccObjectRecord.getObjectID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, ccMediaRecord.getImageID() + "");
                    sqlBatchController.postSqlCommand("INSERT INTO IROBJECTIMAGEMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                    if (!bl) continue;
                    this.debugOut("Mapping EntityID: " + ccObjectRecord.getObjectID() + " to MediaID: " + ccMediaRecord.getImageID());
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityTypeID", 2, stringBuffer2, n + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EntityID", 2, stringBuffer2, ccObjectRecord.getObjectID() + "");
                    sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MediaID", 2, stringBuffer2, ccMediaRecord.getImageID() + "");
                    sqlBatchController.postSqlCommand("INSERT INTO IRENTITYMEDIAMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                    continue;
                }
                if (mapRecord.getMappingType() != 1) continue;
                this.debugOut("Unmapping ObjectID: " + ccObjectRecord.getObjectID() + " to ImageID: " + ccMediaRecord.getImageID());
                sqlBatchController.postSqlCommand("DELETE FROM IROBJECTIMAGEMAP WHERE ObjectID = " + ccObjectRecord.getObjectID() + " AND ImageID = " + ccMediaRecord.getImageID());
                if (!bl) continue;
                this.debugOut("Unmapping EntityID: " + ccObjectRecord.getObjectID() + " to MediaID: " + ccMediaRecord.getImageID());
                sqlBatchController.postSqlCommand("DELETE FROM IRENTITYMEDIAMAP WHERE EntityID = " + ccObjectRecord.getObjectID() + " AND MediaID = " + ccMediaRecord.getImageID());
            }
            sqlBatchController.executeRemainingCommands();
            return true;
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveObjectImageMappings(): " + InsightUtilities.getStackTrace(exception));
            return false;
        }
    }

    public void updateObjectImageMappings(CcMediaBatch ccMediaBatch) {
        try {
            boolean bl;
            int n;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
            String string = "nvarchar";
            int n2 = 50;
            databaseConnector.setQuery("SELECT ObjectKey FROM CCMEDIABATCHELEMENTS WHERE CCMEDIABATCHELEMENTS.BatchID = " + ccMediaBatch.getBatchID());
            databaseConnector.runQuery();
            String[] stringArray = databaseConnector.getColumnTypeNames();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                this.debugOut("columnTypeNames[" + i + "]: " + stringArray[i]);
            }
            if (stringArray != null && stringArray.length > 0) {
                string = stringArray[0];
            }
            int[] nArray = databaseConnector.getColumnSizes();
            for (n = 0; nArray != null && n < nArray.length; ++n) {
                this.debugOut("columnSizes[" + n + "]: " + nArray[n]);
            }
            if (nArray != null && nArray.length > 0) {
                n2 = nArray[0];
            }
            databaseConnector.close();
            n = DEFAULT_OBJ_ENTITY_TYPE_ID;
            boolean bl2 = bl = ((CollectionServer)this.server).isMedeEnabled() && ((CollectionServer)this.server).getCollectionServerInscribeCompliant();
            if (bl) {
                n = this.getPreferredEntityTypeID(ccMediaBatch.getUniqueCollectionID());
            }
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            sqlQueryGenerator.addTable("CCMEDIABATCHELEMENTS", null, "DestMediaID");
            sqlQueryGenerator.addTable("DTVALUETOOBJECT", null, "ObjectID");
            sqlQueryGenerator.addJoin("CCMEDIABATCHELEMENTS", "ObjectKeyFieldID", "DTVALUES", "FieldID", 0);
            sqlQueryGenerator.addJoin("DTVALUES", "DTVALUETOOBJECT", "ValueID", 0);
            sqlQueryGenerator.appendToWhere("CCMEDIABATCHELEMENTS.BatchID = " + ccMediaBatch.getBatchID());
            sqlQueryGenerator.appendToWhere("DTVALUES.UniqueCollectionID = " + ccMediaBatch.getUniqueCollectionID());
            int n3 = sqlQueryGenerator.appendToWhere("CCMEDIABATCHELEMENTS.ObjectKey IN (DTVALUES.ValueText, TRIM(CAST(CAST(DTVALUES.ValueNumber AS CHAR (" + n2 + ")) AS " + string + " (" + n2 + "))))");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get mappings query:\n" + databaseConnector.getQuery());
            try {
                databaseConnector.runQuerySafe();
            }
            catch (JdbcConnectorError jdbcConnectorError) {
                this.debugOut("TRIM is not supported.  Trying the query without TRIM");
                sqlQueryGenerator.removeWhereAppendage(n3);
                n3 = sqlQueryGenerator.appendToWhere("CCMEDIABATCHELEMENTS.ObjectKey IN (DTVALUES.ValueText, CAST(CAST(DTVALUES.ValueNumber AS CHAR (" + n2 + ")) AS " + string + " (" + n2 + ")))");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery(true));
                this.debugOut("Get mappings query:\n" + databaseConnector.getQuery());
                try {
                    databaseConnector.runQuerySafe();
                }
                catch (JdbcConnectorError jdbcConnectorError2) {
                    this.debugOut("CAST is not supported.  Trying the query without CAST");
                    sqlQueryGenerator.removeWhereAppendage(n3);
                    sqlQueryGenerator.appendToWhere("CCMEDIABATCHELEMENTS.ObjectKey IN (DTVALUES.ValueText, DTVALUES.ValueNumber)");
                    databaseConnector.setQuery(sqlQueryGenerator.getQuery(true));
                    this.debugOut("Get mappings query:\n" + databaseConnector.getQuery());
                    databaseConnector.runQuery();
                }
            }
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    long l = databaseConnector.getLongField("ObjectID");
                    long l2 = databaseConnector.getLongField("DestMediaID");
                    databaseConnector2.setQuery("INSERT INTO IROBJECTIMAGEMAP(ObjectID, ImageID) VALUES (" + l + ", " + l2 + ")");
                    databaseConnector2.runUpdateQuery();
                    databaseConnector2.close();
                    if (bl) {
                        databaseConnector2.setQuery("INSERT INTO IRENTITYMEDIAMAP(EntityTypeID, EntityID, MediaID) VALUES (" + n + ", " + l + ", " + l2 + ")");
                        databaseConnector2.runUpdateQuery();
                        databaseConnector2.close();
                    }
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateImageObjectMappings():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public List getObjectData(CcObjectRecord ccObjectRecord) {
        Vector<FieldValue> vector = new Vector<FieldValue>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("DTVALUETOOBJECT", null, new String[]{"ObjectID"});
            sqlQueryGenerator.addTable("DTVALUES", null, new String[]{"ValueText", "ValueNumber"});
            sqlQueryGenerator.addTable("IRFIELDS", null, new String[]{"FieldID", "DisplayName"});
            sqlQueryGenerator.addTable("IRTYPES", null, "TypeCode");
            sqlQueryGenerator.addJoin("DTVALUETOOBJECT", "DTVALUES", "ValueID", 0);
            sqlQueryGenerator.addJoin("DTVALUES", "IRFIELDS", "FieldID", 0);
            sqlQueryGenerator.addJoin("IRFIELDS", "FieldType", "IRTYPES", "TypeID", 0);
            sqlQueryGenerator.appendToWhere("DTVALUETOOBJECT.ObjectID = " + ccObjectRecord.getObjectID());
            sqlQueryGenerator.addOrderBy("IRFIELDS", "DisplayOrder");
            sqlQueryGenerator.addOrderBy("IRFIELDS", "FieldID");
            String string = sqlQueryGenerator.getQuery();
            databaseConnector.setQuery(string);
            this.debugOut("Get object data query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                vector.add(new FieldValue(databaseConnector.getFieldByName("DisplayName"), TrinityConnector.getFieldValue(databaseConnector), false));
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getObjectData():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return vector;
    }

    public String getImageFileUrl(CcMediaRecord ccMediaRecord, int n) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        String string = "";
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.setDistinctKeyword("DISTINCT");
            sqlQueryGenerator.addTable("IRIMAGEFILES", null, new String[]{"ImageID", "Filename", "MediaType"});
            sqlQueryGenerator.addTable("IRSPS", null, new String[]{"URL"});
            sqlQueryGenerator.addTable("IRLPS", null, new String[]{"LPS"});
            sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRLPS", "LPSid", 0);
            sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRSPS", new String[]{"ResolutionSize", "Format", "MediaType"}, 0);
            sqlQueryGenerator.appendToWhere("IRIMAGEFILES.ResolutionSize = " + n);
            sqlQueryGenerator.appendToWhere("IRIMAGEFILES.ImageID = " + ccMediaRecord.getImageID());
            String string2 = sqlQueryGenerator.getQuery();
            databaseConnector.setQuery(string2);
            this.debugOut("Get image records query:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                int n2 = databaseConnector.getIntegerField("MediaType");
                string = ccMediaRecord.getMediaBatch() != null ? ccMediaRecord.getMediaBatch().getDestDir() + File.separator + ((CcBatchProfileResolution)ccMediaRecord.getMediaBatch().getResolutions().get(n)).getRelativeDirectoryPath(n2) + File.separator + databaseConnector.getFieldByName("LPS") + File.separator + databaseConnector.getFieldByName("Filename") : databaseConnector.getFieldByName("URL") + "/" + databaseConnector.getFieldByName("LPS") + "/" + databaseConnector.getFieldByName("Filename");
                this.debugOut("Image url: " + string);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getImageFileUrl():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        return string;
    }

    public void removeImageRecord(Integer n, CcMediaRecord ccMediaRecord) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            boolean bl;
            if (ccMediaRecord.getMediaBatch() != null) {
                String string;
                Vector<String> vector = new Vector<String>(1);
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.setDistinctKeyword("DISTINCT");
                sqlQueryGenerator.addTable("IRIMAGEFILES", null, new String[]{"ImageID", "MediaType", "ResolutionSize", "Filename"});
                sqlQueryGenerator.addTable("IRSPS", null, new String[]{"URL"});
                sqlQueryGenerator.addTable("IRLPS", null, new String[]{"LPS"});
                sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRLPS", "LPSid", 0);
                sqlQueryGenerator.addJoin("IRIMAGEFILES", "IRSPS", new String[]{"ResolutionSize", "Format", "MediaType"}, 0);
                sqlQueryGenerator.appendToWhere("IRIMAGEFILES.ImageID = " + ccMediaRecord.getImageID());
                sqlQueryGenerator.addOrderBy("IRIMAGEFILES", "ResolutionSize");
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Get image file paths query:\n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                List list = ccMediaRecord.getMediaBatch().getResolutions();
                while (databaseConnector.more()) {
                    int n2 = databaseConnector.getIntegerField("MediaType");
                    int n3 = databaseConnector.getIntegerField("ResolutionSize");
                    string = null;
                    if (n3 >= 0 && n3 < list.size()) {
                        string = ccMediaRecord.getMediaBatch().getDestDir() + File.separator + ((CcBatchProfileResolution)list.get(n3)).getRelativeDirectoryPath(n2) + File.separator + databaseConnector.getFieldByName("LPS") + File.separator + databaseConnector.getFieldByName("Filename");
                    }
                    if (string != null && !vector.contains(string)) {
                        this.debugOut("Found image file: " + string);
                        vector.add(string);
                    }
                    databaseConnector.next();
                }
                databaseConnector.close();
                boolean bl2 = false;
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    try {
                        bl2 = new File(string).delete();
                        this.debugOut("Deleted image file: \"" + string + "\": " + bl2);
                    }
                    catch (Exception exception) {
                        this.debugOut("Deleted image file: \"" + string + "\": exc: " + InsightUtilities.getStackTrace(exception));
                    }
                }
            }
            databaseConnector.setQuery("DELETE FROM CCMEDIABATCHELEMENTS WHERE DestMediaID = " + ccMediaRecord.getImageID());
            this.debugOut("Delete from CCMEDIABATCHELEMENTS query:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            databaseConnector.setQuery("DELETE FROM IRCOLLECTIONMEDIAMAP WHERE MediaID = " + ccMediaRecord.getImageID());
            this.debugOut("Delete from IRCOLLECTIONMEDIAMAP query:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            databaseConnector.setQuery("DELETE FROM IRIMAGEFILES WHERE ImageID = " + ccMediaRecord.getImageID());
            this.debugOut("Delete from IRIMAGEFILES query:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            databaseConnector.setQuery("DELETE FROM IROBJECTIMAGEMAP WHERE ImageID = " + ccMediaRecord.getImageID());
            this.debugOut("Delete from IROBJECTIMAGEMAP query:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            boolean bl3 = bl = ((CollectionServer)this.server).isMedeEnabled() && ((CollectionServer)this.server).getCollectionServerInscribeCompliant();
            if (bl) {
                int n4 = this.getPreferredEntityTypeID(n);
                databaseConnector.setQuery("DELETE FROM IRENTITYMEDIAMAP WHERE MediaID = " + ccMediaRecord.getImageID());
                this.debugOut("Delete from IRENTITYMEDIAMAP query:\n" + databaseConnector.getQuery());
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
            databaseConnector.setQuery("DELETE FROM IRGROUPIMAGEMAP WHERE ImageID = " + ccMediaRecord.getImageID());
            this.debugOut("Delete from IRGROUPIMAGEMAP query:\n" + databaseConnector.getQuery());
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in removeImageRecord():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCollections() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        ArrayList<Collection> arrayList = new ArrayList<Collection>();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRCOLLECTIONCONFIGURATIONINFO", null, "*");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                arrayList.add(new Collection(new Integer(databaseConnector.getIntegerFieldByName("UniqueCollectionID")), new Integer(Integer.parseInt(databaseConnector.getFieldByName("CollectionID"))), new Integer(databaseConnector.getIntegerFieldByName("UserCollection")), new Integer(databaseConnector.getIntegerFieldByName("NativeStandardID")), databaseConnector.getFieldByName("CollectionName"), databaseConnector.getBooleanField("IsPersonalCollection"), databaseConnector.getFieldByName("VCID"), (CollectionServer)this.server));
                databaseConnector.next();
            }
            ArrayList<Collection> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCollections():\n" + InsightUtilities.getStackTrace(exception));
            ArrayList<Collection> arrayList3 = arrayList;
            return arrayList3;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCatalogTemplates() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        ArrayList<CatalogTemplate> arrayList = new ArrayList<CatalogTemplate>();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("SLSTANDARDSLOOKUP", null, "*");
            sqlQueryGenerator.appendToWhere("Standard_Type = 1");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuerySafe();
            while (databaseConnector.more()) {
                arrayList.add(new CatalogTemplate(new Integer(databaseConnector.getIntegerFieldByName("StandardID")), databaseConnector.getFieldByName("StandardName"), (CollectionServer)this.server));
                databaseConnector.next();
            }
            ArrayList<CatalogTemplate> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCatalogTemplates():\n" + InsightUtilities.getStackTrace(exception));
            ArrayList<CatalogTemplate> arrayList3 = arrayList;
            return arrayList3;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPersonalCollectionServer() {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        boolean bl = false;
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRVERSION", null, "*");
            sqlQueryGenerator.appendToWhere("IsPersonalCollectionServer <> 0");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in isPersonalCollectionServer():\n" + InsightUtilities.getStackTrace(exception));
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return bl;
    }

    public void setGenerateDocumentFlag(Object[] objectArray) {
        this.taskIndexerHandler.setGenerateDocumentFlag(objectArray);
    }

    public void resetGenerateDocumentFlag() {
        this.taskIndexerHandler.resetGenerateDocumentFlag();
    }

    public int getRecordCount(DatabaseConnector databaseConnector, String string) {
        return this.getRecordCount(databaseConnector, string, false, false);
    }

    public int getRecordCount(DatabaseConnector databaseConnector, String string, boolean bl, boolean bl2) {
        int n = 0;
        if (databaseConnector != null) {
            try {
                databaseConnector.setQuery(SqlQueryGenerator.getCountQuery(string, "ValueCount", bl, bl2));
                databaseConnector.runQuery();
                n = databaseConnector.getIntegerField("ValueCount");
            }
            catch (Exception exception) {
                n = 0;
                this.debugOut("Exception getting record count:\n" + InsightUtilities.getStackTrace(exception));
            }
            databaseConnector.close();
        }
        return n;
    }

    protected void debugOut(String string, int n) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, n);
    }

    protected void debugOut(String string) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, 3);
    }
}

