/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver;

import com.luna.insight.admin.AdministeredServer;
import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.AdministeredServerEditComponent;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.RecordCommitFailedException;
import com.luna.insight.admin.RecordDeleteFailedException;
import com.luna.insight.admin.SaveCancelDialog;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.collection.CollectionNode;
import com.luna.insight.admin.collserver.collection.PersonalCollectionAccessSettingsConfiguration;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationBrowserAttributes;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationFileProperties;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationInstitutionID;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationVisualAttributes;
import com.luna.insight.admin.collserver.field.CollectionServerField;
import com.luna.insight.admin.collserver.field.CollectionServerFieldGroup;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandard;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardField;
import com.luna.insight.admin.collserver.fieldstd.CsFieldStandardsManager;
import com.luna.insight.admin.collserver.fieldstd.CsStandardFieldMappingEditComponent;
import com.luna.insight.admin.collserver.indexer.CsSetIndexerEditComponent;
import com.luna.insight.admin.collserver.indexer.CsTasksInvokeIndexerNode;
import com.luna.insight.admin.collserver.inscribe.CcMedeApprovalLevels;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityField;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityRelationship;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityType;
import com.luna.insight.admin.collserver.inscribe.CcMedeProfile;
import com.luna.insight.admin.collserver.join.CcJoinManager;
import com.luna.insight.admin.collserver.join.CcJoinsEditComponent;
import com.luna.insight.admin.collserver.lps.CcLpsData;
import com.luna.insight.admin.collserver.maxid.CsMaxIDs;
import com.luna.insight.admin.collserver.measurement.CsMeasurementToolSettings;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfile;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchLpsDirStructure;
import com.luna.insight.admin.collserver.mediacreation.CcPublishMediaBatchDialog;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroup;
import com.luna.insight.admin.collserver.mpd.CsMpd;
import com.luna.insight.admin.collserver.mpd.CsMpdTemplate;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectMediaMappingEditComponent;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectMediaMappingManager;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectRecordFieldsSelector;
import com.luna.insight.admin.collserver.profile.CollectionServerProfile;
import com.luna.insight.admin.collserver.sps.CcSpsData;
import com.luna.insight.admin.collserver.stoplist.CcStopWord;
import com.luna.insight.admin.collserver.table.CcTableRecord;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.admin.collserver.task.CcTaskRecord;
import com.luna.insight.admin.collserver.usergroup.CollectionServerConnectionPool;
import com.luna.insight.admin.collserver.usergroup.CollectionServerUserGroup;
import com.luna.insight.admin.collserver.usergroup.PersonalCollectionServerUserGroup;
import com.luna.insight.admin.collserver.vocab.CsVocabValue;
import com.luna.insight.admin.verifier.NonDuplicateJTextComponentVerifier;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.profile.CollectionProfile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class CollectionServer
extends AdministeredServer {
    public static String COLLECTION_CONNECT_STRING_KEY = "DatabaseConnect";
    protected Hashtable configurationsTable = new Hashtable();
    protected Hashtable configurationsVAttributesTable = new Hashtable();
    protected Hashtable configurationsBAttributesTable = new Hashtable();
    protected Hashtable configurationsNewIIDTable = new Hashtable();
    protected Hashtable profileTable = new Hashtable();
    protected Hashtable connectionPoolsTable = new Hashtable();
    protected Hashtable userGroupsTable = new Hashtable();
    protected Hashtable mediaGroupsTable = new Hashtable();
    protected Hashtable fieldsTable = new Hashtable();
    protected Hashtable vocabValuesTable = new Hashtable();
    protected Hashtable fieldGroupsTable = new Hashtable();
    protected Hashtable fieldStandardsTable = new Hashtable();
    protected Hashtable fieldStandardFieldsTable = new Hashtable();
    protected Hashtable mediaBatchTable = new Hashtable();
    protected Hashtable batchProfileTable = new Hashtable();
    protected Hashtable lpsDataTable = new Hashtable();
    protected Hashtable spsDataTable = new Hashtable();
    protected Hashtable stopWordsTable = new Hashtable();
    protected Hashtable tableRecordsTable = new Hashtable();
    protected Hashtable mpdRecordsTable = new Hashtable();
    protected Hashtable mpdtRecordsTable = new Hashtable();
    protected Hashtable taskRecordsTable = new Hashtable();
    protected Hashtable entityFieldsTable = new Hashtable();
    protected Hashtable medeProfilesTable = new Hashtable();
    protected Hashtable medeApprovalLevelsTable = new Hashtable();
    protected Hashtable medeEntityTypesTable = new Hashtable();
    protected Hashtable medeEntityRelationshipsTable = new Hashtable();
    protected Hashtable objImgMappingTable = new Hashtable();
    protected Hashtable publishBatchDialogTable = new Hashtable();
    protected Hashtable mediaBatchLpsDirTable = new Hashtable();
    protected Hashtable measurementToolSettingsTable = new Hashtable();
    protected Hashtable maxIDsTable = new Hashtable();
    protected SaveCancelDialog stdFieldMappingDialog = null;
    protected CcObjectRecordFieldsSelector fieldSelector = null;
    protected SaveCancelDialog editInsightJoinsDialog = null;
    protected SaveCancelDialog editInscribeJoinsDialog = null;
    protected SaveCancelDialog mpdtDialog = null;
    protected float collectionServerVersion = 0.0f;
    protected boolean medeEnabled = false;
    protected boolean measurementToolSettingEnabled = false;
    protected boolean maxIDsEnabled = false;
    protected boolean collectionServerInscribeCompliant = false;
    protected SaveCancelDialog setIndexerDialog = null;

    public CollectionServer(String string, InsightAdministrator insightAdministrator) {
        super(string, insightAdministrator);
    }

    public String getConnectStringKey() {
        return COLLECTION_CONNECT_STRING_KEY;
    }

    public void setNode(CollectionServerNode collectionServerNode) {
        this.parentNode = collectionServerNode;
    }

    public CollectionServerNode getServerNode() {
        return (CollectionServerNode)this.parentNode;
    }

    public void edit() {
        if (this.editDialog == null) {
            this.oldName = this.getName();
            this.editDialog = new EditDialog(this.insightAdministrator.getFrame(), true, this);
            this.editDialog.show();
        } else {
            this.insightAdministrator.setSelectedFrame(this.editDialog);
        }
    }

    public void commitEdit() {
        if (this.creationCompleted) {
            this.insightAdministrator.removeCollectionServerFromStore(this.oldName);
            this.insightAdministrator.registerNewCollectionServer(this);
            this.parentNode.refreshData();
        }
    }

    public AdministeredServerConnector getServerConnector() {
        return this.getCollectionServerConnector();
    }

    public void saveToDisk() {
        if (this.creationCompleted) {
            this.insightAdministrator.removeCollectionServerFromStore(this.getName());
        }
        if (this.creationCompleted) {
            this.insightAdministrator.registerNewCollectionServer(this);
        }
    }

    public CollectionServerConnector getCollectionServerConnector() {
        if (this.serverConnector == null) {
            Properties properties = new Properties();
            properties.setProperty("DefaultUsername", this.databaseUsername);
            properties.setProperty("DefaultPassword", this.databasePassword);
            properties.setProperty("DatabaseConnector", this.databaseConnector);
            properties.setProperty("JDBCDriverName", this.jdbcDriverName);
            properties.setProperty("JDBCUrlPrefix", this.jdbcUrlPrefix);
            properties.setProperty(this.getConnectStringKey(), this.connectString);
            properties.setProperty("LogBatchCommands", this.logBatchCommands ? "1" : "0");
            this.serverConnector = new CollectionServerConnector(this, properties);
        }
        return (CollectionServerConnector)this.serverConnector;
    }

    public EditComponent getEditComponent() {
        CollectionServer.debugOut("in getEditComponent");
        this.editComponent = new AdministeredServerEditComponent(this);
        JLabel jLabel = this.editComponent.getNameLabel();
        jLabel.setText("Collection Manager Name:");
        JTextField jTextField = this.editComponent.getNameField();
        jTextField.setInputVerifier(new NonDuplicateJTextComponentVerifier(InsightAdministrator.getExistingCollectionServerNames(this.name)));
        this.editComponent.getNameField().setText(this.getName());
        if (this.getConnectString() != null && this.getConnectString().length() > 0) {
            this.editComponent.getConnectStringField().setText(this.getConnectString());
        }
        if (this.databaseUsername != null && this.databaseUsername.length() > 0) {
            this.editComponent.getDatabaseUsernameField().setText(this.databaseUsername);
        }
        if (this.databasePassword != null && this.databasePassword.length() > 0) {
            this.editComponent.getDatabasePasswordField().setText(this.databasePassword);
        }
        if (this.databaseConnector != null && this.databaseConnector.length() > 0) {
            this.editComponent.getDatabaseConnectorComboBox().setSelectedItem(this.databaseConnector);
        }
        if (this.globalEscapeDelimiter != null && this.globalEscapeDelimiter.length() > 0) {
            this.editComponent.getGlobalEscapeDelimiterField().setText(this.globalEscapeDelimiter);
        }
        if (this.unicodeFieldPrefix != null && this.unicodeFieldPrefix.length() > 0) {
            this.editComponent.getUnicodeFieldPrefixField().setText(this.unicodeFieldPrefix);
        }
        if (this.jdbcDriverName != null && this.jdbcDriverName.length() > 0) {
            this.editComponent.getJdbcDriverNameField().setText(this.jdbcDriverName);
        }
        if (this.jdbcUrlPrefix != null && this.jdbcUrlPrefix.length() > 0) {
            this.editComponent.getJdbcUrlPrefixField().setText(this.jdbcUrlPrefix);
        }
        if (this.configFilePath != null && this.configFilePath.length() > 0) {
            this.editComponent.getConfigFileNameField().setText(this.configFilePath);
        }
        if (this.queryMode > -1) {
            this.editComponent.getSqlLevelComboBox().setSelectedIndex(this.queryMode);
        }
        this.editComponent.getLogBatchCommandsCheckBox().setSelected(this.logBatchCommands);
        this.editComponent.setJdbcFieldsAppropriately();
        this.editComponent.getNameField().selectAll();
        this.editComponent.getConfigFileNameField().setCaretPosition(0);
        return this.editComponent;
    }

    public String getSaveButtonText() {
        if (this.isNew()) {
            return "Save";
        }
        return "Save";
    }

    public boolean isNew() {
        return "".equals(this.getName());
    }

    public String getEditWindowTitle() {
        if (this.isNew()) {
            return "Register New Collection Manager";
        }
        return "Edit Collection Manager - " + this.getName();
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return this.name;
    }

    public Hashtable getEditDialogCache(EditableDataObject editableDataObject) {
        if (editableDataObject != null) {
            if (editableDataObject instanceof CollectionServerConfiguration) {
                return this.configurationsTable;
            }
            if (editableDataObject instanceof CollectionServerConfigurationVisualAttributes) {
                return this.configurationsVAttributesTable;
            }
            if (editableDataObject instanceof CollectionServerConfigurationBrowserAttributes) {
                return this.configurationsBAttributesTable;
            }
            if (editableDataObject instanceof CollectionServerConfigurationInstitutionID) {
                return this.configurationsNewIIDTable;
            }
            if (editableDataObject instanceof CollectionServerProfile && !(editableDataObject instanceof CcMedeProfile)) {
                return this.profileTable;
            }
            if (editableDataObject instanceof CollectionServerConnectionPool) {
                return this.connectionPoolsTable;
            }
            if (editableDataObject instanceof CollectionServerUserGroup || editableDataObject instanceof PersonalCollectionServerUserGroup) {
                return this.userGroupsTable;
            }
            if (editableDataObject instanceof CsMediaGroup) {
                return this.mediaGroupsTable;
            }
            if (editableDataObject instanceof CollectionServerField) {
                return this.fieldsTable;
            }
            if (editableDataObject instanceof CsVocabValue) {
                return this.vocabValuesTable;
            }
            if (editableDataObject instanceof CollectionServerFieldGroup) {
                return this.fieldGroupsTable;
            }
            if (editableDataObject instanceof CsFieldStandard) {
                return this.fieldStandardsTable;
            }
            if (editableDataObject instanceof CsFieldStandardField) {
                return this.fieldStandardFieldsTable;
            }
            if (editableDataObject instanceof CcMediaBatch) {
                return this.mediaBatchTable;
            }
            if (editableDataObject instanceof CcBatchProfile) {
                return this.batchProfileTable;
            }
            if (editableDataObject instanceof CcLpsData) {
                return this.lpsDataTable;
            }
            if (editableDataObject instanceof CcSpsData) {
                return this.spsDataTable;
            }
            if (editableDataObject instanceof CcStopWord) {
                return this.stopWordsTable;
            }
            if (editableDataObject instanceof CcTableRecord) {
                return this.tableRecordsTable;
            }
            if (editableDataObject instanceof CsMpd) {
                return this.mpdRecordsTable;
            }
            if (editableDataObject instanceof CsMpdTemplate) {
                return this.mpdtRecordsTable;
            }
            if (editableDataObject instanceof CcTaskRecord) {
                return this.taskRecordsTable;
            }
            if (editableDataObject instanceof CcMediaBatchLpsDirStructure) {
                return this.mediaBatchLpsDirTable;
            }
            if (editableDataObject instanceof CcMedeEntityField) {
                return this.entityFieldsTable;
            }
            if (editableDataObject instanceof CcMedeProfile) {
                return this.medeProfilesTable;
            }
            if (editableDataObject instanceof CcMedeApprovalLevels) {
                return this.medeApprovalLevelsTable;
            }
            if (editableDataObject instanceof CcMedeEntityType) {
                return this.medeEntityTypesTable;
            }
            if (editableDataObject instanceof CcMedeEntityRelationship) {
                return this.medeEntityRelationshipsTable;
            }
            if (editableDataObject instanceof CsMeasurementToolSettings) {
                return this.measurementToolSettingsTable;
            }
            if (editableDataObject instanceof CsMaxIDs) {
                return this.maxIDsTable;
            }
            return super.getEditDialogCache(editableDataObject);
        }
        return null;
    }

    public void updateParentNode(EditableDataObject editableDataObject) {
        if (editableDataObject != null) {
            if (editableDataObject instanceof PersonalCollectionAccessSettingsConfiguration) {
                ((PersonalCollectionAccessSettingsConfiguration)editableDataObject).getSettingsNode().updateInformationDisplay();
            } else if (editableDataObject instanceof CollectionServerConfiguration) {
                ((CollectionServerNode)this.parentNode).getCollectionNode((Integer)((CollectionServerConfiguration)editableDataObject).getUniqueCollectionID()).configurationsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CollectionServerProfile && !(editableDataObject instanceof CcMedeProfile)) {
                if (((CollectionServerProfile)editableDataObject).configurationEditComponent == null) {
                    ((CollectionServerNode)this.parentNode).profileNode.updateNodeChild((CollectionServerProfile)editableDataObject);
                } else {
                    ((CollectionServerProfile)editableDataObject).configurationEditComponent.addNewProfileToComboBox((CollectionServerProfile)editableDataObject);
                }
            } else if (editableDataObject instanceof CollectionServerConnectionPool) {
                ((CollectionServerNode)this.parentNode).connectionPoolsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CollectionServerUserGroup) {
                ((CollectionServerNode)this.parentNode).getCollectionNode((Integer)((CollectionServerUserGroup)editableDataObject).getUniqueCollectionID()).userGroupsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof PersonalCollectionServerUserGroup) {
                ((CollectionServerNode)this.parentNode).personalCollectionsUserGroupsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CsMediaGroup) {
                ((CollectionServerNode)this.parentNode).getCollectionNode((Integer)((CsMediaGroup)editableDataObject).getUniqueCollectionID()).mediaGroupsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CollectionServerField) {
                ((CollectionServerNode)this.parentNode).getCatalogTemplateNode((Integer)((CollectionServerField)editableDataObject).getTemplate().getTemplateID()).fieldNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CsVocabValue) {
                ((CollectionServerNode)this.parentNode).vocabulariesNode.updateNodeChild((CsVocabValue)editableDataObject);
            } else if (editableDataObject instanceof CollectionServerFieldGroup) {
                ((CollectionServerNode)this.parentNode).getCatalogTemplateNode((Integer)((CollectionServerFieldGroup)editableDataObject).getTemplate().getTemplateID()).fieldGroupsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CsFieldStandard) {
                ((CollectionServerNode)this.parentNode).fieldStandardsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CsFieldStandardField) {
                ((CollectionServerNode)this.parentNode).fieldStandardsNode.updateFieldStandardParentNode((CsFieldStandardField)editableDataObject);
            } else if (editableDataObject instanceof CcMediaBatch) {
                ((CollectionServerNode)this.parentNode).getCollectionNode((Integer)((CcMediaBatch)editableDataObject).getUniqueCollectionID()).mediaBatchesNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CcLpsData) {
                ((CollectionServerNode)this.parentNode).lpsDataNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CcSpsData) {
                ((CollectionServerNode)this.parentNode).spsDataNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CcStopWord) {
                ((CollectionServerNode)this.parentNode).stopListNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CcTableRecord) {
                ((CollectionServerNode)this.parentNode).getCollectionNode((Integer)((CcTableRecord)editableDataObject).getCollection().getUniqueCollectionID()).tableRecordsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CsMpd) {
                ((CollectionServerNode)this.parentNode).getCollectionNode((Integer)((CsMpd)editableDataObject).getUniqueCollectionID()).mpdNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CsMpdTemplate) {
                ((CollectionServerNode)this.parentNode).getCollectionNode((Integer)((CsMpdTemplate)editableDataObject).getUniqueCollectionID()).mpdNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CcMedeEntityField) {
                ((CollectionServerNode)this.parentNode).getCatalogTemplateNode((Integer)((CcMedeEntityField)editableDataObject).getTemplate().getTemplateID()).entityFieldsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CcMedeProfile) {
                ((CollectionServerNode)this.parentNode).medeProfileNode.updateNodeChild((CcMedeProfile)editableDataObject);
            } else if (editableDataObject instanceof CcMedeApprovalLevels) {
                ((CollectionServerNode)this.parentNode).getCollectionNode((Integer)((CcMedeApprovalLevels)editableDataObject).getUniqueCollectionID()).medeApprovalLevelsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CcMedeEntityType) {
                ((CollectionServerNode)this.parentNode).getCatalogTemplateNode((Integer)((CcMedeEntityType)editableDataObject).getTemplate().getTemplateID()).medeEntityTypesNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CcMedeEntityRelationship) {
                ((CollectionServerNode)this.parentNode).getCatalogTemplateNode((Integer)((CcMedeEntityRelationship)editableDataObject).getTemplate().getTemplateID()).medeEntityRelationshipsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CsMeasurementToolSettings) {
                ((CollectionServerNode)this.parentNode).getCollectionNode((Integer)((CsMeasurementToolSettings)editableDataObject).getUniqueCollectionID()).measurementToolSettingsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof CsMaxIDs) {
                ((CollectionServerNode)this.parentNode).maxIDsNode.updateInformationDisplay();
            } else {
                super.updateParentNode(editableDataObject);
            }
        }
    }

    public Vector getConfigurations(boolean bl) {
        return this.getConfigurations(null, bl);
    }

    public Vector getConfigurations(Integer n, boolean bl) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getConfigurationRecords(n, bl);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public CollectionServerConfiguration getConfiguration(Integer n, String string) {
        Vector vector = this.getConfigurations(n, false);
        for (int i = 0; i < vector.size(); ++i) {
            CollectionServerConfiguration collectionServerConfiguration = (CollectionServerConfiguration)vector.elementAt(i);
            if (!collectionServerConfiguration.equals(string)) continue;
            return collectionServerConfiguration;
        }
        return null;
    }

    public Vector getProfiles() {
        if (this.hasServerReadPermission(true)) {
            return this.getCollectionServerConnector().getProfileRecords();
        }
        return new Vector();
    }

    public Vector getProfiles(int n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getProfileRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getFields(Integer n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getFieldRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getFieldGroups(Integer n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getFieldGroupRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getFieldStandards() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getFieldStandardRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector(0);
    }

    public Vector getFieldStandardFields(CsFieldStandard csFieldStandard) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getFieldStandardFieldRecords(csFieldStandard);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void convertPersonalToInstitutionalCollection(CollectionServerConfiguration collectionServerConfiguration) {
        block24: {
            CollectionServerUserGroup collectionServerUserGroup;
            CollectionServerConnector collectionServerConnector;
            ArrayList<EditableDataObject> arrayList;
            String string;
            String string2;
            block23: {
                Iterator iterator;
                string2 = "Unable to convert to institutional collection";
                string = null;
                arrayList = new ArrayList<EditableDataObject>();
                collectionServerConnector = this.getCollectionServerConnector();
                collectionServerUserGroup = null;
                try {
                    this.insightAdministrator.showWaitCursor(true);
                    Integer n = collectionServerConfiguration.getUniqueCollectionID();
                    collectionServerConfiguration.setPersonalCollection(false);
                    collectionServerConfiguration.setUserCollection(n);
                    int n2 = collectionServerConnector.getNextValidProfileID();
                    CollectionServerProfile collectionServerProfile = new CollectionServerProfile(new CollectionProfile(n2++, 1, 0, collectionServerConfiguration.getName(), n), n);
                    collectionServerConfiguration.setThumbCacheProfileId(collectionServerProfile.getProfileId());
                    CollectionServerProfile collectionServerProfile2 = new CollectionServerProfile(new CollectionProfile(n2++, 1, 1, collectionServerConfiguration.getName(), n), n);
                    CollectionServerProfile collectionServerProfile3 = new CollectionServerProfile(new CollectionProfile(n2++, 1, 2, collectionServerConfiguration.getName(), n), n);
                    CollectionServerProfile collectionServerProfile4 = new CollectionServerProfile(new CollectionProfile(n2++, 1, 3, collectionServerConfiguration.getName(), n), n);
                    CollectionServerProfile collectionServerProfile5 = new CollectionServerProfile(new CollectionProfile(n2++, 1, 4, collectionServerConfiguration.getName(), n), n);
                    collectionServerUserGroup = new CollectionServerUserGroup(n, collectionServerConfiguration.getCollection(), collectionServerConnector.getNextValidUserGroupID(), collectionServerProfile.getDisplayName(), "admin", 0, 1, "0.0.0.0 - 255.255.255.255", "0.0.0.0 - 255.255.255.255", collectionServerProfile.getProfileId(), null);
                    try {
                        collectionServerConnector.commitRecord(collectionServerUserGroup);
                        arrayList.add(collectionServerUserGroup);
                    }
                    catch (RecordCommitFailedException recordCommitFailedException) {
                        string = "Failed to create the required new user group.  No changes have been made to the database.";
                    }
                    if (string == null) {
                        try {
                            collectionServerConnector.commitRecord(collectionServerProfile5);
                            arrayList.add(collectionServerProfile5);
                            collectionServerProfile4.profileId = collectionServerConnector.getNextValidProfileID();
                            collectionServerConnector.commitRecord(collectionServerProfile4);
                            arrayList.add(collectionServerProfile4);
                            collectionServerProfile3.profileId = collectionServerConnector.getNextValidProfileID();
                            collectionServerConnector.commitRecord(collectionServerProfile3);
                            arrayList.add(collectionServerProfile3);
                            collectionServerProfile2.profileId = collectionServerConnector.getNextValidProfileID();
                            collectionServerConnector.commitRecord(collectionServerProfile2);
                            arrayList.add(collectionServerProfile2);
                            collectionServerProfile.profileId = collectionServerConnector.getNextValidProfileID();
                            collectionServerConnector.commitRecord(collectionServerProfile);
                            arrayList.add(collectionServerProfile);
                        }
                        catch (RecordCommitFailedException recordCommitFailedException) {
                            string = "Failed to create a required profile.  No changes have been made to the database.";
                        }
                    }
                    if (string == null) {
                        try {
                            collectionServerConnector.commitRecord(collectionServerConfiguration);
                            arrayList.add(collectionServerConfiguration);
                        }
                        catch (RecordCommitFailedException recordCommitFailedException) {
                            string = "Failed to convert to institutional collection.  No changes have been made to the database.";
                        }
                    }
                    Object var16_19 = null;
                    this.insightAdministrator.showWaitCursor(false);
                    if (string == null) break block23;
                    iterator = arrayList.iterator();
                }
                catch (Throwable throwable) {
                    Object var16_21 = null;
                    this.insightAdministrator.showWaitCursor(false);
                    if (string != null) {
                        Iterator iterator2 = arrayList.iterator();
                        while (iterator2.hasNext()) {
                            try {
                                collectionServerConnector.deleteRecord((DatabaseRecord)iterator2.next());
                            }
                            catch (RecordDeleteFailedException recordDeleteFailedException) {
                                string = "Failed to convert to institutional collection.";
                            }
                        }
                        this.insightAdministrator.showWarningDialog(string, string2);
                    } else {
                        this.insightAdministrator.showWarningDialog("The personal collection '" + collectionServerConfiguration.collectionName + "' has been converted into an institutional collection.\n\n" + "***IMPORTANT***\nTo enable access to this collection, you will need to add a Collection entry and a User Group entry to your User Manager.\n" + "Record the following information for your User Manager.\n\n" + "Collection Name: " + collectionServerConfiguration.collectionName + "\n" + "Institution ID: " + collectionServerConfiguration.getInstitutionID() + "\n" + "Collection ID: " + collectionServerConfiguration.getCollectionID() + "\n\n" + "User Group: " + collectionServerUserGroup.getName() + "\n" + "Code Key: admin", "Conversion successful");
                        this.getServerNode().removeAllChildren();
                        this.getServerNode().refreshData();
                        this.getServerNode().fullRefresh();
                        this.getServerNode().refreshData();
                        this.insightAdministrator.getTopmostControlWindow().getControlTree().setSelectionRow(0);
                    }
                    throw throwable;
                }
                while (iterator.hasNext()) {
                    try {
                        collectionServerConnector.deleteRecord((DatabaseRecord)iterator.next());
                    }
                    catch (RecordDeleteFailedException recordDeleteFailedException) {
                        string = "Failed to convert to institutional collection.";
                    }
                }
                this.insightAdministrator.showWarningDialog(string, string2);
                break block24;
            }
            this.insightAdministrator.showWarningDialog("The personal collection '" + collectionServerConfiguration.collectionName + "' has been converted into an institutional collection.\n\n" + "***IMPORTANT***\nTo enable access to this collection, you will need to add a Collection entry and a User Group entry to your User Manager.\n" + "Record the following information for your User Manager.\n\n" + "Collection Name: " + collectionServerConfiguration.collectionName + "\n" + "Institution ID: " + collectionServerConfiguration.getInstitutionID() + "\n" + "Collection ID: " + collectionServerConfiguration.getCollectionID() + "\n\n" + "User Group: " + collectionServerUserGroup.getName() + "\n" + "Code Key: admin", "Conversion successful");
            this.getServerNode().removeAllChildren();
            this.getServerNode().refreshData();
            this.getServerNode().fullRefresh();
            this.getServerNode().refreshData();
            this.insightAdministrator.getTopmostControlWindow().getControlTree().setSelectionRow(0);
            {
                break block24;
                catch (Exception exception) {
                    System.out.println(exception);
                    System.out.println(exception.getStackTrace());
                    Object var16_20 = null;
                    this.insightAdministrator.showWaitCursor(false);
                    if (string != null) {
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            try {
                                collectionServerConnector.deleteRecord((DatabaseRecord)iterator.next());
                            }
                            catch (RecordDeleteFailedException recordDeleteFailedException) {
                                string = "Failed to convert to institutional collection.";
                            }
                        }
                        this.insightAdministrator.showWarningDialog(string, string2);
                    } else {
                        this.insightAdministrator.showWarningDialog("The personal collection '" + collectionServerConfiguration.collectionName + "' has been converted into an institutional collection.\n\n" + "***IMPORTANT***\nTo enable access to this collection, you will need to add a Collection entry and a User Group entry to your User Manager.\n" + "Record the following information for your User Manager.\n\n" + "Collection Name: " + collectionServerConfiguration.collectionName + "\n" + "Institution ID: " + collectionServerConfiguration.getInstitutionID() + "\n" + "Collection ID: " + collectionServerConfiguration.getCollectionID() + "\n\n" + "User Group: " + collectionServerUserGroup.getName() + "\n" + "Code Key: admin", "Conversion successful");
                        this.getServerNode().removeAllChildren();
                        this.getServerNode().refreshData();
                        this.getServerNode().fullRefresh();
                        this.getServerNode().refreshData();
                        this.insightAdministrator.getTopmostControlWindow().getControlTree().setSelectionRow(0);
                    }
                }
            }
        }
    }

    public void manageStandardFieldMappings() {
        if (this.hasServerEditPermission(true)) {
            if (this.stdFieldMappingDialog == null) {
                CsFieldStandardsManager csFieldStandardsManager = this.getCollectionServerConnector().getFieldStandardsManager();
                this.stdFieldMappingDialog = new SaveCancelDialog(this.insightAdministrator.getFrame(), true, new CsStandardFieldMappingEditComponent(csFieldStandardsManager));
                this.stdFieldMappingDialog.show();
            } else {
                this.insightAdministrator.setSelectedFrame(this.stdFieldMappingDialog);
            }
        }
    }

    public void cancelEditStandardFieldMappings() {
        this.stdFieldMappingDialog = null;
    }

    public Vector getConnectionPools() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getConnectionPoolRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getUserGroups(Integer n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getUserGroupRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public CsMediaGroup getMediaGroup(CsMediaGroup csMediaGroup) {
        if (this.hasServerReadPermission(true)) {
            return this.getCollectionServerConnector().getMediaGroupRecord(csMediaGroup);
        }
        return null;
    }

    public CsMediaGroup getMediaGroup(Integer n, String string) {
        Vector vector = this.getMediaGroups(n, 1);
        for (int i = 0; i < vector.size(); ++i) {
            CsMediaGroup csMediaGroup = (CsMediaGroup)vector.elementAt(i);
            if (!csMediaGroup.getVCID().equals(string)) continue;
            return csMediaGroup;
        }
        return null;
    }

    public Vector getMediaGroups(Integer n) {
        return this.getMediaGroups(n, -1);
    }

    public Vector getMediaGroups(Integer n, int n2) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getMediaGroupRecords(n, n2);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getMediaFiles(Integer n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getMediaFileRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getEntityFields(Integer n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getEntityFieldRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getMeasurementToolSettings(Integer n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getMeasurementToolSettingsRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getMaxIDs() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getMaxIDsRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getMedeProfiles(int n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getMedeProfileRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getMedeApprovalLevels(Integer n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getMedeApprovalLevelRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getMedeEntityTypes(Integer n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getMedeEntityTypeRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getMedeEntityRelationships(Integer n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getMedeEntityRelationshipRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public void commitMediaFiles(Vector vector) {
        if (this.hasServerAddPermission(true)) {
            this.getCollectionServerConnector().commitMediaFiles(vector);
        }
    }

    public boolean verifyBatchDatabaseEntries(List list) {
        return this.getCollectionServerConnector().verifyBatchDatabaseEntries(list);
    }

    public Vector getVocabValues(int n) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getVocabValueRecords(n);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getLpsData() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getLpsDataRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public boolean commitLpsRecord(CcLpsData ccLpsData) {
        boolean bl = false;
        try {
            if (this.hasServerAddPermission(true) && ccLpsData != null) {
                this.getServerConnector().commitRecord(ccLpsData);
                bl = true;
            }
        }
        catch (RecordCommitFailedException recordCommitFailedException) {
            this.insightAdministrator.showWarningDialog(recordCommitFailedException.getWarningMessage(), recordCommitFailedException.getWarningTitle());
        }
        return bl;
    }

    public Vector getSpsData() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getSpsDataRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getSpsDataBySpsNum() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getSpsDataRecordsBySpsNum();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public boolean commitSpsRecords(Vector vector) {
        boolean bl = false;
        try {
            if (this.hasServerAddPermission(true)) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    CcSpsData ccSpsData = (CcSpsData)enumeration.nextElement();
                    if (ccSpsData == null) continue;
                    this.getServerConnector().commitRecord(ccSpsData);
                }
                bl = true;
            }
        }
        catch (RecordCommitFailedException recordCommitFailedException) {
            this.insightAdministrator.showWarningDialog(recordCommitFailedException.getWarningMessage(), recordCommitFailedException.getWarningTitle());
            bl = false;
        }
        return bl;
    }

    public Vector getStopWords() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getStopWordRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getTableRecords(Collection collection) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getTableRecords(collection);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getTaskRecords() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getCollectionServerConnector().getTaskRecords();
            if (!this.getAdminAccount().hasServerPermission(17)) {
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    if (((CcTaskRecord)iterator.next()).isAssignedUser(this.getAdminAccount())) continue;
                    iterator.remove();
                }
            }
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public void refreshConfigurationFileProperties() {
        CollectionServer.debugOut("in refreshConfigurationInformation()...");
        this.insightAdministrator.showWaitCursor(true);
        this.configFileProperties = new CollectionServerConfigurationFileProperties(this, this.configFilePath);
        this.configFileProperties.refresh();
        this.insightAdministrator.showWaitCursor(false);
    }

    public Vector getMpds(Integer n) {
        if (this.hasServerReadPermission(true)) {
            CollectionServer.debugOut("has read permission");
            return this.getCollectionServerConnector().getMpds(n);
        }
        CollectionServer.debugOut("Does not have read permission");
        return new Vector();
    }

    public Vector getMpdsToIndex(Integer n) {
        if (this.hasServerReadPermission(true)) {
            return this.getCollectionServerConnector().getMpdsToIndex(n);
        }
        return new Vector();
    }

    public Vector getBatchProfiles() {
        if (this.hasServerReadPermission(true)) {
            Vector vector = this.getCollectionServerConnector().getBatchProfileRecords();
            return vector;
        }
        return new Vector();
    }

    public void setGenerateDocumentFlag(Object[] objectArray) {
        if (this.hasServerReadPermission(true)) {
            this.getCollectionServerConnector().setGenerateDocumentFlag(objectArray);
        }
    }

    public void resetGenerateDocumentFlag() {
        if (this.hasServerReadPermission(true)) {
            this.getCollectionServerConnector().resetGenerateDocumentFlag();
        }
    }

    public Vector getMpdLevelData(int n) {
        Vector vector = this.getCollectionServerConnector().getMpdLevelData(n);
        return vector;
    }

    public void openTask(CcTaskRecord ccTaskRecord) {
        ccTaskRecord.setIsOpeningTask(true);
        if (!this.getEditDialogCache(ccTaskRecord).containsKey(ccTaskRecord.getUniqueIdentifier())) {
            EditDialog editDialog = new EditDialog(this.insightAdministrator.getFrame(), true, ccTaskRecord);
            this.getEditDialogCache(ccTaskRecord).put(ccTaskRecord.getUniqueIdentifier(), editDialog);
            editDialog.show();
        } else {
            this.insightAdministrator.setSelectedFrame((EditDialog)this.getEditDialogCache(ccTaskRecord).get(ccTaskRecord.getUniqueIdentifier()));
        }
        ccTaskRecord.setIsOpeningTask(false);
    }

    public void closeTask(CcTaskRecord ccTaskRecord) {
        this.getCollectionServerConnector().unlockTask(ccTaskRecord, this.getAdminAccount());
    }

    public void showPublishMediaBatchDialog(CcMediaBatch ccMediaBatch) {
        if (ccMediaBatch != null) {
            String string = this.getObjectImageMappingToolKey(ccMediaBatch.getUniqueCollectionID(), ccMediaBatch);
            CcPublishMediaBatchDialog ccPublishMediaBatchDialog = (CcPublishMediaBatchDialog)this.publishBatchDialogTable.get(string);
            if (ccPublishMediaBatchDialog == null) {
                ccPublishMediaBatchDialog = new CcPublishMediaBatchDialog(this, ccMediaBatch);
                this.publishBatchDialogTable.put(string, ccPublishMediaBatchDialog);
                ccPublishMediaBatchDialog.show();
            } else {
                this.insightAdministrator.setSelectedFrame(ccPublishMediaBatchDialog);
            }
        }
    }

    public void publishMediaBatchDialogClosed(CcMediaBatch ccMediaBatch) {
        this.publishBatchDialogTable.remove(this.getObjectImageMappingToolKey(ccMediaBatch.getUniqueCollectionID(), ccMediaBatch));
    }

    protected String getObjectImageMappingToolKey(Integer n, Object object) {
        if (object instanceof CcMediaBatch) {
            return "UID-" + n + "-Batch-" + ((CcMediaBatch)object).getBatchID();
        }
        if (object instanceof CsMediaGroup) {
            return "UID-" + n + "-Group-" + ((CsMediaGroup)object).getGroupID();
        }
        return "Main-Tool";
    }

    public void manageObjectImageMappings(Integer n) {
        this.manageObjectImageMappings(n, null, null);
    }

    public void manageObjectImageMappings(Integer n, CcTaskItem ccTaskItem) {
        this.manageObjectImageMappings(n, ccTaskItem, null);
    }

    public void manageObjectImageMappings(Integer n, Object object) {
        this.manageObjectImageMappings(n, null, object);
    }

    public void manageObjectImageMappings(Integer n, CcTaskItem ccTaskItem, Object object) {
        if (ccTaskItem != null || object != null || this.hasServerEditPermission(true)) {
            String string = this.getObjectImageMappingToolKey(n, object);
            SaveCancelDialog saveCancelDialog = (SaveCancelDialog)this.objImgMappingTable.get(string);
            if (saveCancelDialog == null) {
                List list = this.getCollectionServerConnector().getFieldList(n);
                if (this.fieldSelector == null) {
                    this.fieldSelector = new CcObjectRecordFieldsSelector(list);
                } else {
                    this.fieldSelector.updateFieldList(list);
                }
                CcObjectMediaMappingManager ccObjectMediaMappingManager = new CcObjectMediaMappingManager(n, this);
                ccObjectMediaMappingManager.setMediaGroup(object);
                CcObjectMediaMappingEditComponent ccObjectMediaMappingEditComponent = new CcObjectMediaMappingEditComponent(ccObjectMediaMappingManager, this.fieldSelector);
                ccObjectMediaMappingEditComponent.setTaskItem(ccTaskItem);
                saveCancelDialog = new SaveCancelDialog(this.insightAdministrator.getFrame(), true, ccObjectMediaMappingEditComponent);
                this.objImgMappingTable.put(string, saveCancelDialog);
                saveCancelDialog.show();
            } else {
                this.insightAdministrator.setSelectedFrame(saveCancelDialog);
            }
        }
    }

    public void cancelEditObjectImageMappings(Integer n, Object object) {
        this.objImgMappingTable.remove(this.getObjectImageMappingToolKey(n, object));
    }

    public void manageSetIndexer(Integer n) {
        if (this.hasServerEditPermission(true)) {
            if (this.parentNode != null && this.parentNode instanceof CollectionServerNode && ((CollectionServerNode)this.parentNode).getCollectionNode((Integer)n).indexerNode != null && ((CollectionServerNode)this.parentNode).getCollectionNode((Integer)n).indexerNode.isIndexerDisplayOpen()) {
                this.insightAdministrator.showWarningDialog("Please complete the invoke indexer task", "Indexer setting Warning");
            } else if (this.setIndexerDialog == null) {
                this.setIndexerDialog = new SaveCancelDialog(this.insightAdministrator.getFrame(), true, new CsSetIndexerEditComponent(this));
                this.setIndexerDialog.show();
            } else {
                this.insightAdministrator.setSelectedFrame(this.setIndexerDialog);
            }
        }
    }

    public void cancelEditSetIndexer() {
        this.setIndexerDialog = null;
    }

    public void editInvokeIndexer(Integer n) {
        this.editInvokeIndexer(n, null);
    }

    public void editInvokeIndexer(Integer n, CcTaskItem ccTaskItem) {
        CollectionServer.debugOut("editInvokeIndexer");
        if (this.setIndexerDialog != null) {
            this.insightAdministrator.showWarningDialog("Please complete setting Indexer mode", "Indexer setting Warning");
            this.insightAdministrator.setSelectedFrame(this.setIndexerDialog);
            return;
        }
        if (this.parentNode == null) {
            CollectionServer.debugOut("Could not start indexer becuase parentNode: " + this.parentNode);
        } else if (this.parentNode instanceof CollectionServerNode) {
            CollectionNode collectionNode = ((CollectionServerNode)this.parentNode).getCollectionNode(n);
            if (collectionNode.indexerNode == null) {
                collectionNode.indexerNode = new CsTasksInvokeIndexerNode(this.getInsightAdministrator(), collectionNode, "Invoke Indexer", 0, false);
            }
            if (collectionNode.indexerNode != null) {
                collectionNode.indexerNode.launchIndexerSetup(ccTaskItem);
            } else {
                CollectionServer.debugOut("Could not create indexerNode");
            }
        }
    }

    public void editImageCreation() {
        this.editImageCreation(null);
    }

    public void editImageCreation(CcTaskItem ccTaskItem) {
        CollectionServer.debugOut("Editing Image Creation");
    }

    public void editInsightJoins(Collection collection) {
        if (this.hasServerEditPermission(true)) {
            if (this.editInsightJoinsDialog == null) {
                if (this.editInscribeJoinsDialog != null) {
                    this.insightAdministrator.showWarningDialog("Please complete managing Record joins", "Join Management Warning");
                    this.insightAdministrator.setSelectedFrame(this.editInscribeJoinsDialog);
                    return;
                }
                CcJoinManager ccJoinManager = this.getCollectionServerConnector().getJoinManager(collection, 1);
                this.editInsightJoinsDialog = new SaveCancelDialog(this.insightAdministrator.getFrame(), true, new CcJoinsEditComponent(this, ccJoinManager));
                this.editInsightJoinsDialog.show();
            } else {
                this.insightAdministrator.setSelectedFrame(this.editInsightJoinsDialog);
            }
        }
    }

    public void cancelEditInsightJoins() {
        this.editInsightJoinsDialog = null;
    }

    public void editInscribeJoins(Collection collection) {
        if (this.hasServerEditPermission(true)) {
            if (this.editInscribeJoinsDialog == null) {
                if (this.editInsightJoinsDialog != null) {
                    this.insightAdministrator.showWarningDialog("Please complete managing Insight joins", "Join Management Warning");
                    this.insightAdministrator.setSelectedFrame(this.editInsightJoinsDialog);
                    return;
                }
                CcJoinManager ccJoinManager = this.getCollectionServerConnector().getJoinManager(collection, 2);
                this.editInscribeJoinsDialog = new SaveCancelDialog(this.insightAdministrator.getFrame(), true, new CcJoinsEditComponent(this, ccJoinManager));
                this.editInscribeJoinsDialog.show();
            } else {
                this.insightAdministrator.setSelectedFrame(this.editInscribeJoinsDialog);
            }
        }
    }

    public void cancelEditInscribeJoins() {
        this.editInscribeJoinsDialog = null;
    }

    public void setCollectionServerVersion(float f) {
        this.collectionServerVersion = f;
    }

    public float getCollectionServerVersion() {
        return this.collectionServerVersion;
    }

    public void setMedeEnabled(boolean bl) {
        this.medeEnabled = bl;
    }

    public boolean isMedeEnabled() {
        return this.medeEnabled;
    }

    public void setMeasurementToolSettingEnabled(boolean bl) {
        this.measurementToolSettingEnabled = bl;
    }

    public boolean isMeasurementToolSettingEnabled() {
        return this.measurementToolSettingEnabled;
    }

    public void setMaxIDsEnabled(boolean bl) {
        this.maxIDsEnabled = bl;
    }

    public boolean isMaxIDsEnabled() {
        return this.maxIDsEnabled;
    }

    public void setCollectionServerInscribeCompliant(boolean bl) {
        this.collectionServerInscribeCompliant = bl;
    }

    public boolean getCollectionServerInscribeCompliant() {
        return this.collectionServerInscribeCompliant;
    }

    public static void debugOut(String string) {
        CollectionServer.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServer: " + string, n);
    }
}

