/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.catalog;

import com.luna.insight.admin.ControlPanelNode;
import com.luna.insight.admin.catalog.CatalogTemplate;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.field.CollectionServerFieldGroupsNode;
import com.luna.insight.admin.collserver.field.CollectionServerFieldNode;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityFieldsNode;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityRelationshipsNode;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityTypesNode;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class CatalogTemplateNode
extends ControlPanelNode
implements ActionListener {
    public static final String COMMAND_NEW_ENTITY_TYPE = "New Entity Type Command";
    public static final String COMMAND_DELETE_ENTITY_TYPE = "Delete Entity Type Command";
    public static final String COMMAND_EDIT_ENTITY_TYPE = "Edit Entity Type Command";
    public static final String COMMAND_DELETE_ENTITY_FIELD = "Delete Entity Field Command";
    public static final String COMMAND_EDIT_ENTITY_FIELD = "Edit Entity Field Command";
    public static final String COMMAND_NEW_ENTITY_RELATIONSHIP = "New Entity Relationship Command";
    public static final String COMMAND_DELETE_ENTITY_RELATIONSHIP = "Delete Entity Relationship Command";
    public static final String COMMAND_EDIT_ENTITY_RELATIONSHIP = "Edit Entity Relationship Command";
    public static final String COMMAND_NEW_FIELD = "New Field Command";
    public static final String COMMAND_DELETE_FIELD = "Delete Field Command";
    public static final String COMMAND_EDIT_FIELD = "Edit Field Command";
    public static final String COMMAND_NEW_FIELD_GROUP = "New Field Group Command";
    public static final String COMMAND_DELETE_FIELD_GROUP = "Delete Field Group Command";
    public static final String COMMAND_EDIT_FIELD_GROUP = "Edit Field Group Command";
    protected String labelText;
    protected CatalogTemplate template;
    public CcMedeEntityTypesNode medeEntityTypesNode = null;
    public CcMedeEntityFieldsNode entityFieldsNode = null;
    public CcMedeEntityRelationshipsNode medeEntityRelationshipsNode = null;
    public CollectionServerFieldNode fieldNode = null;
    public CollectionServerFieldGroupsNode fieldGroupsNode = null;

    public CatalogTemplateNode(CatalogTemplate catalogTemplate) {
        super(catalogTemplate.getServer().getInsightAdministrator(), catalogTemplate.getName(), true);
        this.template = catalogTemplate;
        this.fieldGroupsNode = new CollectionServerFieldGroupsNode(this);
        this.add(this.fieldGroupsNode);
        this.medeEntityTypesNode = new CcMedeEntityTypesNode(this);
        this.add(this.medeEntityTypesNode);
        this.fieldNode = new CollectionServerFieldNode(this);
        this.add(this.fieldNode);
        this.entityFieldsNode = new CcMedeEntityFieldsNode(this);
        this.add(this.entityFieldsNode);
        this.medeEntityRelationshipsNode = new CcMedeEntityRelationshipsNode(this);
        this.add(this.medeEntityRelationshipsNode);
    }

    public CatalogTemplate getTemplate() {
        return this.template;
    }

    public CollectionServerNode getCollectionServerNode() {
        return this.template.getServer().getServerNode();
    }

    public JPopupMenu getPopup() {
        return new JPopupMenu();
    }

    public JComponent getDisplayComponent() {
        if (this.labelText == null) {
            this.createInformationModel();
        }
        return new JLabel(this.labelText);
    }

    protected void createInformationModel() {
        this.labelText = "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        CatalogTemplateNode.debugOut("Received action: " + string);
        if (string.equals(COMMAND_NEW_ENTITY_TYPE)) {
            this.getCollectionServerNode().createNewMedeEntityType(this.template.getTemplateID());
        }
        if (string.equals(COMMAND_NEW_ENTITY_RELATIONSHIP)) {
            this.getCollectionServerNode().createNewMedeEntityRelationship(this.template.getTemplateID());
        } else if (string.equals(COMMAND_NEW_FIELD)) {
            this.getCollectionServerNode().createNewField(this.template.getTemplateID());
        } else if (string.equals(COMMAND_NEW_FIELD_GROUP)) {
            this.getCollectionServerNode().createNewFieldGroup(this.template.getTemplateID());
        }
    }

    public static void debugOut(String string) {
        CatalogTemplateNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CatalogTemplateNode: " + string, n);
    }
}

