/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.AdminDesktopPane;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.SaveCancelController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class SaveCancelDialog
extends JInternalFrame
implements KeyListener,
FocusListener {
    protected JScrollPane fieldPane = null;
    protected JPanel buttonPanel = null;
    protected JButton saveButton = null;
    protected JButton cancelButton = null;
    protected SaveCancelController controller = null;
    protected EditComponent editComponent = null;

    public SaveCancelDialog(Frame frame, boolean bl, SaveCancelController saveCancelController) {
        this(frame, saveCancelController.getWindowTitle(), bl, saveCancelController);
    }

    public SaveCancelDialog(Frame frame, String string, boolean bl, SaveCancelController saveCancelController) {
        super(string, true, true, true, true);
        this.controller = saveCancelController;
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                SaveCancelDialog.this.cancel();
            }
        });
        ImageIcon imageIcon = saveCancelController.getWindowIcon();
        if (imageIcon != null) {
            this.setFrameIcon(imageIcon);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.fieldPane = new JScrollPane();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        Dimension dimension = new Dimension(100, 29);
        this.saveButton = new JButton(saveCancelController.getSaveButtonText());
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveCancelDialog.this.save();
            }
        });
        this.saveButton.setPreferredSize(dimension);
        this.cancelButton = new JButton(saveCancelController.getCancelButtonText());
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveCancelDialog.this.cancel();
            }
        });
        this.cancelButton.setPreferredSize(dimension);
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.cancelButton);
        this.addKeyListener(this);
        this.getContentPane().add((Component)this.fieldPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.editComponent = saveCancelController.getEditComponent();
        this.addFocusListeners(this.editComponent);
        this.fieldPane.setViewportView(this.editComponent);
        this.editComponent.addKeyListener(this);
        ColorUIResource colorUIResource = MetalLookAndFeel.getControlDarkShadow();
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            MetalLookAndFeel cfr_ignored_0 = (MetalLookAndFeel)UIManager.getLookAndFeel();
            colorUIResource = MetalLookAndFeel.getControlDarkShadow();
        }
        this.fieldPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, colorUIResource));
        this.pack();
        Dimension dimension2 = this.getPreferredSize();
        int n = new JScrollBar().getPreferredSize().width;
        this.setPreferredSize(new Dimension(dimension2.width + n, dimension2.height + n));
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof Component) {
            Component component = (Component)object;
            Rectangle rectangle = component.getBounds();
            Rectangle rectangle2 = SwingUtilities.convertRectangle(component.getParent(), rectangle, this.fieldPane.getViewport());
            this.fieldPane.getViewport().scrollRectToVisible(rectangle2);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected void addFocusListeners(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                this.addFocusListeners((Container)component);
                continue;
            }
            if (component == null) continue;
            component.addFocusListener(this);
        }
        if (container != null) {
            container.addFocusListener(this);
        }
    }

    public void show() {
        AdminDesktopPane adminDesktopPane = InsightAdministrator.getInsightAdministrator().getDesktop();
        adminDesktopPane.add(this);
        super.show();
    }

    public void setSelected(boolean bl) {
        try {
            super.setSelected(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestFocus();
    }

    public void cancel() {
        this.controller.cancel();
        this.closeDialog(null);
    }

    public void save() {
        if (!this.editComponent.verify()) {
            return;
        }
        this.controller.save();
        this.closeDialog(null);
    }

    protected void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.saveButton.doClick();
        } else if (keyEvent.getKeyCode() == 27) {
            this.cancelButton.doClick();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

