/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.server.InsightUtilities;
import java.io.File;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class InsightAdministratorHelp {
    public static final String WEB_HELP = "http://www.lunaimaging.com/admin/help.html";
    public static final String LUNA_HOME = "http://www.lunaimaging.com/";

    public boolean launchHelp() {
        return this.startBrowser(InsightAdministrator.HELP_FILE);
    }

    public boolean launchLunaHome() {
        return this.startBrowser(LUNA_HOME);
    }

    public boolean startBrowser(String string) {
        if (!string.toLowerCase().startsWith("http")) {
            string = System.getProperty("user.dir") + File.separator + "doc" + File.separator + string;
        }
        try {
            if (System.getProperty("os.name").startsWith("Windows")) {
                Runtime.getRuntime().exec("cmd /c start iexplore " + string);
            } else if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                Runtime.getRuntime().exec("open file://" + InsightAdministratorHelp.spaceAndUrlEncode(string));
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println("Exception while opening browser with URL or file: " + exception);
            return false;
        }
    }

    public static String spaceAndUrlEncode(String string) {
        if (string.startsWith("/")) {
            return "/" + InsightUtilities.replaceSubstrings(URLEncoder.encode(InsightAdministratorHelp.encode(string.substring(1))), "%2520", "%20", false);
        }
        return InsightUtilities.replaceSubstrings(URLEncoder.encode(InsightAdministratorHelp.encode(string)), "%2520", "%20", false);
    }

    public static String encode(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) {
                stringBuffer.append("%20");
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

