/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.AdminDesktopPane;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.InsightAdministrator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class EditDialog
extends JInternalFrame
implements KeyListener,
FocusListener {
    protected JScrollPane fieldPane = null;
    protected JPanel buttonPanel = null;
    protected JButton saveButton = null;
    protected JButton cancelButton = null;
    protected EditableDataObject dataObject = null;
    protected EditComponent editComponent = null;

    public EditDialog(Frame frame, boolean bl, EditableDataObject editableDataObject) {
        this(frame, editableDataObject.getEditWindowTitle(), bl, editableDataObject);
    }

    public EditDialog(Frame frame, String string, boolean bl, EditableDataObject editableDataObject) {
        super(string, true, true, true, true);
        this.dataObject = editableDataObject;
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                EditDialog.this.cancel();
            }
        });
        ImageIcon imageIcon = editableDataObject.getEditWindowIcon();
        if (imageIcon != null) {
            this.setFrameIcon(imageIcon);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.fieldPane = new JScrollPane();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        Dimension dimension = new Dimension(100, 29);
        this.saveButton = new JButton(editableDataObject.getSaveButtonText());
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditDialog.this.save();
            }
        });
        this.saveButton.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    EditDialog.this.saveButton.doClick();
                } else if (keyEvent.getKeyCode() == 27) {
                    EditDialog.this.cancelButton.doClick();
                }
            }
        });
        this.saveButton.setPreferredSize(dimension);
        this.cancelButton = new JButton(editableDataObject.getCancelButtonText());
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditDialog.this.cancel();
            }
        });
        this.cancelButton.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 27) {
                    EditDialog.this.cancelButton.doClick();
                }
            }
        });
        this.cancelButton.setPreferredSize(dimension);
        if (editableDataObject.getShowSaveButton()) {
            this.buttonPanel.add(this.saveButton);
        }
        this.buttonPanel.add(this.cancelButton);
        this.addKeyListener(this);
        this.getContentPane().add((Component)this.fieldPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.editComponent = editableDataObject.getEditComponent();
        this.addFocusListeners(this.editComponent);
        editableDataObject.requiresCommit = false;
        this.fieldPane.setViewportView(this.editComponent);
        this.editComponent.addKeyListener(this);
        ColorUIResource colorUIResource = MetalLookAndFeel.getControlDarkShadow();
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            colorUIResource = MetalLookAndFeel.getControlDarkShadow();
        }
        this.fieldPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, colorUIResource));
        this.pack();
        Dimension dimension2 = this.getPreferredSize();
        int n = new JScrollBar().getPreferredSize().width;
        this.setPreferredSize(new Dimension(dimension2.width + n, dimension2.height + n));
    }

    public EditComponent getEditComponent() {
        return this.editComponent;
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof Component) {
            Component component = (Component)object;
            Rectangle rectangle = component.getBounds();
            Rectangle rectangle2 = SwingUtilities.convertRectangle(component.getParent(), rectangle, this.fieldPane.getViewport());
            this.fieldPane.getViewport().scrollRectToVisible(rectangle2);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void addFocusListeners(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                this.addFocusListeners((Container)component);
                continue;
            }
            if (component == null) continue;
            component.addFocusListener(this);
        }
        if (container != null) {
            container.addFocusListener(this);
        }
    }

    public void show() {
        AdminDesktopPane adminDesktopPane = InsightAdministrator.getInsightAdministrator().getDesktop();
        adminDesktopPane.add(this);
        super.show();
    }

    public void setSelected(boolean bl) {
        try {
            super.setSelected(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestFocus();
    }

    public void cancel() {
        this.dataObject.cancel();
        this.closeDialog(null);
    }

    public void save() {
        if (!this.editComponent.verify()) {
            return;
        }
        this.dataObject.save();
        this.closeDialog(null);
    }

    public void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.saveButton.doClick();
        } else if (keyEvent.getKeyCode() == 27) {
            this.cancelButton.doClick();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

