/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.AdministeredServer;
import com.luna.insight.admin.AdministeredServerConfigurationFileProperties;
import com.luna.insight.admin.DefaultConfigurationFilePropertiesEditComponent;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.ImageIcon;

public class DefaultConfigurationFileProperties
extends AdministeredServerConfigurationFileProperties {
    protected DefaultConfigurationFilePropertiesEditComponent editComponent = null;
    protected String databaseConnector = "";
    protected String globalEscapeDelimiter = "";
    protected String unicodeFieldPrefix = "";
    protected String jdbcDriverName = "";
    protected String jdbcUrlPrefix = "";
    protected String username = "";
    protected String password = "";
    protected String debugFilename = "";
    protected String debugModeOn = "";

    public DefaultConfigurationFileProperties(AdministeredServer administeredServer, String string) {
        super(administeredServer, string);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void commit() {
        block11: {
            DefaultConfigurationFileProperties.debugOut("in commit()");
            Properties properties = new Properties();
            properties.setProperty("DatabaseConnector", this.databaseConnector);
            properties.setProperty("GlobalEscapeDelimiter", this.globalEscapeDelimiter);
            properties.setProperty("UnicodeFieldPrefix", this.unicodeFieldPrefix);
            properties.setProperty("JDBCDriverName", this.jdbcDriverName);
            properties.setProperty("JDBCUrlPrefix", this.jdbcUrlPrefix);
            properties.setProperty("DefaultUsername", this.username);
            properties.setProperty("DefaultPassword", this.password);
            properties.setProperty("DatabaseDebugFilename", this.debugFilename);
            properties.setProperty("DatabaseDebugMode", this.debugModeOn);
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(this.configFileName);
            properties.store(fileOutputStream, "InsightBackend Configuration");
            fileOutputStream.close();
            Object var5_3 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block11;
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (Exception exception) {
                    DefaultConfigurationFileProperties.debugOut("Exception while trying to write user server data to disc: " + exception);
                    Object var5_4 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block11;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void refresh() {
        DefaultConfigurationFileProperties.debugOut("in refresh()");
        EnhancedProperties enhancedProperties = new EnhancedProperties();
        try {
            DefaultConfigurationFileProperties.debugOut("Configuration file is " + this.configFileName + ".");
            FileInputStream fileInputStream = new FileInputStream(this.configFileName);
            enhancedProperties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            DefaultConfigurationFileProperties.debugOut("Cannot read configuration file!");
        }
        if (enhancedProperties != null) {
            this.databaseConnector = enhancedProperties.getProperty("DatabaseConnector", this.databaseConnector);
            this.debugFilename = enhancedProperties.getProperty("DatabaseDebugFilename", this.debugFilename);
            this.debugModeOn = enhancedProperties.getProperty("DatabaseDebugMode", this.debugModeOn);
            this.globalEscapeDelimiter = enhancedProperties.getProperty("GlobalEscapeDelimiter", this.globalEscapeDelimiter);
            this.unicodeFieldPrefix = enhancedProperties.getProperty("UnicodeFieldPrefix", this.unicodeFieldPrefix);
            this.jdbcDriverName = enhancedProperties.getProperty("JDBCDriverName", this.jdbcDriverName);
            this.jdbcUrlPrefix = enhancedProperties.getProperty("JDBCUrlPrefix", this.jdbcUrlPrefix);
            this.username = enhancedProperties.getProperty("DefaultUsername", this.username);
            this.password = enhancedProperties.getProperty("DefaultPassword", this.password);
        }
    }

    public EditComponent getEditComponent() {
        this.editComponent = new DefaultConfigurationFilePropertiesEditComponent();
        this.editComponent.getDatabaseConnectorComboBox().setSelectedItem(this.databaseConnector);
        this.editComponent.getGlobalEscapeDelimiterField().setText(this.globalEscapeDelimiter);
        this.editComponent.getUnicodeFieldPrefixField().setText(this.unicodeFieldPrefix);
        this.editComponent.getJdbcDriverNameField().setText(this.jdbcDriverName);
        this.editComponent.getJdbcUrlPrefixField().setText(this.jdbcUrlPrefix);
        this.editComponent.getUsernameField().setText(this.username);
        this.editComponent.getPasswordField().setText(this.password);
        this.editComponent.getDebugFilenameField().setText(this.debugFilename);
        this.editComponent.getDebugModeCheckBox().setSelected("1".equals(this.debugModeOn));
        return this.editComponent;
    }

    public void save() {
        DefaultConfigurationFileProperties.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged((Object)this.databaseConnector, this.editComponent.getDatabaseConnectorComboBox().getSelectedItem())) {
            this.databaseConnector = (String)this.editComponent.getDatabaseConnectorComboBox().getSelectedItem();
        }
        if (this.hasChanged(this.globalEscapeDelimiter, this.editComponent.getGlobalEscapeDelimiterField().getText())) {
            this.globalEscapeDelimiter = this.editComponent.getGlobalEscapeDelimiterField().getText();
        }
        if (this.hasChanged(this.unicodeFieldPrefix, this.editComponent.getUnicodeFieldPrefixField().getText())) {
            this.unicodeFieldPrefix = this.editComponent.getUnicodeFieldPrefixField().getText();
        }
        if (this.hasChanged(this.jdbcDriverName, this.editComponent.getJdbcDriverNameField().getText())) {
            this.jdbcDriverName = this.editComponent.getJdbcDriverNameField().getText();
        }
        if (this.hasChanged(this.jdbcUrlPrefix, this.editComponent.getJdbcUrlPrefixField().getText())) {
            this.jdbcUrlPrefix = this.editComponent.getJdbcUrlPrefixField().getText();
        }
        if (this.hasChanged(this.username, this.editComponent.getUsernameField().getText())) {
            this.username = this.editComponent.getUsernameField().getText();
        }
        if (this.hasChanged(this.password, this.editComponent.getPasswordField().getText())) {
            this.password = this.editComponent.getPasswordField().getText();
        }
        if (this.hasChanged(this.debugFilename, this.editComponent.getDebugFilenameField().getText())) {
            this.debugFilename = this.editComponent.getDebugFilenameField().getText();
        }
        if (this.hasChanged("1".equals(this.debugModeOn), this.editComponent.getDebugModeCheckBox().isSelected())) {
            this.debugModeOn = this.editComponent.getDebugModeCheckBox().isSelected() ? "1" : "0";
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.server.commitDefaultConfigurationFileProperties();
        } else {
            this.server.cancelDefaultConfigurationFilePropertiesEdit();
        }
    }

    public void cancel() {
        DefaultConfigurationFileProperties.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.server.cancelDefaultConfigurationFilePropertiesEdit();
    }

    public String getEditWindowTitle() {
        return "Edit Props File - " + this.configFileName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/default-config-file-properites-icon.gif");
    }

    public static void debugOut(String string) {
        DefaultConfigurationFileProperties.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("DefaultConfigurationFileProperties: " + string, n);
    }
}

