/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.RecordCommitFailedException;
import com.luna.insight.admin.RecordDeleteFailedException;
import com.luna.insight.server.Debug;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Vector;

public abstract class DatabaseRecordHandler {
    public String COMPONENT_CODE = "DatabaseRecordHandler";
    public static final int DEBUG_LEVEL = 3;
    protected AdministeredServerConnector serverConnector = null;

    public DatabaseRecordHandler(AdministeredServerConnector administeredServerConnector) {
        this.serverConnector = administeredServerConnector;
    }

    public abstract void doInsert(DatabaseRecord var1);

    public abstract void doDelete(DatabaseRecord var1);

    public abstract Vector getRecords();

    public Vector getRecords(int n) {
        return this.getRecords();
    }

    public abstract DatabaseRecord getRecord(DatabaseRecord var1);

    public DatabaseRecord getUpdatedRecord(DatabaseRecord databaseRecord) {
        return this.getRecord(databaseRecord);
    }

    public final void commitRecord(DatabaseRecord databaseRecord) throws RecordCommitFailedException {
        this.debugOut("in commitRecord().");
        this.debugOut("Getting backup record.");
        DatabaseRecord databaseRecord2 = this.getRecord(databaseRecord);
        this.debugOut("Deleting current record.");
        this.doDelete(databaseRecord);
        this.debugOut("Inserting new record.");
        this.doInsert(databaseRecord);
        this.debugOut("Retrieving updated record.");
        DatabaseRecord databaseRecord3 = this.getUpdatedRecord(databaseRecord);
        if (databaseRecord3 == null || !databaseRecord3.equalsRecord(databaseRecord)) {
            if (databaseRecord3 == null) {
                this.debugOut("Updated record: " + databaseRecord3);
            } else {
                this.debugOut("updatedRecord.equalsRecord(record): " + databaseRecord3.equalsRecord(databaseRecord));
            }
            if (databaseRecord2 != null) {
                this.debugOut("Commit failed, restoring backup record.");
                this.doInsert(databaseRecord2);
            } else {
                this.debugOut("Record could not be created.");
            }
            throw new RecordCommitFailedException(databaseRecord, databaseRecord2);
        }
    }

    public final void deleteRecord(DatabaseRecord databaseRecord) throws RecordDeleteFailedException {
        this.doDelete(databaseRecord);
        DatabaseRecord databaseRecord2 = this.getRecord(databaseRecord);
        if (databaseRecord2 != null) {
            this.debugOut("Record could not be deleted.");
            throw new RecordDeleteFailedException(databaseRecord);
        }
    }

    public abstract String getNextValidIDQuery();

    public abstract void updateMaxIDValue(long var1);

    public String getNextValidIDQuery(int n) {
        return this.getNextValidIDQuery();
    }

    public final int getNextValidID() {
        return this.getNextValidID(-1);
    }

    public final int getNextValidID(int n) {
        this.debugOut("in getNextValidID()");
        int n2 = 0;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(this.getNextValidIDQuery(n));
            databaseConnector.runQuery();
            Vector<Integer> vector = new Vector<Integer>();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    vector.addElement(new Integer(databaseConnector.getIntegerFieldByName(AdministeredServerConnector.CANDIDATE_INDEX_NAME)));
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            n2 = this.serverConnector.findFirstAvailableIndex(vector);
            this.updateMaxIDValue(n2);
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextValidID(): " + exception);
        }
        return n2;
    }

    public DatabaseConnector getDatabaseConnector() {
        return this.serverConnector.getDatabaseConnector();
    }

    public SqlQueryGenerator getQueryGenerator() {
        return this.serverConnector.getQueryGenerator();
    }

    public SqlQueryGenerator getQueryGeneratorUtil() {
        return this.serverConnector.getQueryGeneratorUtil();
    }

    public int convertToInt(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    public boolean convertToBoolean(int n) {
        return n == 1;
    }

    public String prepForInsertQuery(String string) {
        return this.getQueryGeneratorUtil().prepStringForQuery(string);
    }

    protected void debugOut(String string, int n) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, n);
    }

    protected void debugOut(String string) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, 3);
    }
}

