/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.ControlTreeRenderable;
import com.luna.insight.admin.InsightAdministrator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.tree.TreeCellRenderer;

public class ControlTreeRenderer
extends JPanel
implements TreeCellRenderer {
    ImageIcon mDefaultIcon;
    JLabel mLabelText;
    JLabel mLabelIcon;
    Color mTextColor;
    Color mTextHighlightBackground;
    Color mTextHighlightForeground;
    Border mSelectedBorder;
    Border mUnselectedBorder;

    public ControlTreeRenderer() {
        this.setLayout(new BorderLayout());
        this.mDefaultIcon = InsightAdministrator.DEFAULT_NODE_ICON;
        this.mLabelIcon = new JLabel();
        this.mLabelIcon.setOpaque(true);
        this.mLabelIcon.setIcon(this.mDefaultIcon);
        this.add((Component)this.mLabelIcon, "West");
        this.mLabelText = new JLabel();
        this.mLabelText.setText("empty");
        this.mLabelText.setOpaque(true);
        this.mLabelText.setFont(UIManager.getFont("Tree.font"));
        this.add((Component)this.mLabelText, "Center");
        this.mTextColor = UIManager.getColor("Tree.textForeground");
        this.mTextHighlightBackground = SystemColor.textHighlight;
        this.mTextHighlightForeground = SystemColor.textHighlightText;
        this.mSelectedBorder = new MatteBorder(0, 5, 0, 5, this.mTextHighlightBackground);
        this.mUnselectedBorder = new EmptyBorder(0, 5, 0, 5);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.mLabelIcon.setBackground(jTree.getBackground());
        Color color = this.mTextColor;
        Color color2 = jTree.getBackground();
        if (object instanceof ControlTreeRenderable) {
            ControlTreeRenderable controlTreeRenderable = (ControlTreeRenderable)object;
            this.mLabelIcon.setIcon(controlTreeRenderable.getIcon());
            this.mLabelText.setText(controlTreeRenderable.getText());
            Color color3 = controlTreeRenderable.getTextColor();
            if (color3 != null) {
                color = color3;
            }
            if ((color3 = controlTreeRenderable.getBackgroundColor()) != null) {
                color2 = color3;
            }
        } else {
            this.mLabelText.setText(object.toString());
        }
        this.setEnabled(jTree.isEnabled());
        this.setBackground(jTree.getBackground());
        if (bl) {
            this.mLabelText.setForeground(this.mTextHighlightForeground);
            this.mLabelText.setBackground(this.mTextHighlightBackground);
            this.mLabelText.setBorder(this.mSelectedBorder);
        } else {
            this.mLabelText.setForeground(color);
            this.mLabelText.setBackground(color2);
            this.mLabelText.setBorder(this.mUnselectedBorder);
        }
        return this;
    }
}

