/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.AdminAccountsNode;
import com.luna.insight.admin.AdministeredServer;
import com.luna.insight.admin.ControlPanelNode;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AdministeredServerNode
extends ControlPanelNode
implements ActionListener {
    public static final String OPEN_CMD_PREFIX = "Open";
    public static final String NEW_CMD_PREFIX = "New";
    public static final String EDT_CMD_PREFIX = "Edit";
    public static final String DEL_CMD_PREFIX = "Delete";
    public static final String DEFAULT_NEW_CAPTION = "New";
    public static final String DEFAULT_EDIT_CAPTION = "Edit";
    public static final String DEFAULT_DELETE_CAPTION = "Delete";
    protected static final String COMMAND_CONNECT = "Connect Command";
    protected static final String COMMAND_DISCONNECT = "Disconnect Command";
    protected static final String COMMAND_EDIT = "Edit Command";
    protected static final String COMMAND_REMOVE = "Remove Command";
    protected static final String COMMAND_EDIT_CONFIGURATION = "Edit Configuration Command";
    protected static final String COMMAND_NEW_ADMIN_ACCOUNT = "New Admin Account Command";
    protected static final String COMMAND_DELETE_ADMIN_ACCOUNT = "Delete Admin Account Command";
    protected static final String COMMAND_EDIT_ADMIN_ACCOUNT = "Edit Admin Account Command";
    protected AdministeredServer server = null;
    protected String labelText = "";
    protected AdminAccountsNode adminAccountsNode = null;
    protected ImageIcon disconnectedIcon = null;
    protected String username = null;
    protected String password = null;

    public AdministeredServerNode(AdministeredServer administeredServer) {
        super(administeredServer.getInsightAdministrator(), administeredServer.getName(), true);
        this.server = administeredServer;
    }

    protected abstract void createInformationModel();

    public abstract void connect();

    public abstract void disconnect();

    public abstract void edit();

    public void refreshData() {
        this.setText(this.server.getName());
        this.server.getInsightAdministrator().reloadTreeModel(this);
    }

    public AdministeredServer getAdministeredServer() {
        return this.server;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(COMMAND_CONNECT)) {
            this.connect();
        } else if (actionEvent.getActionCommand().equals(COMMAND_DISCONNECT)) {
            this.disconnect();
        } else if (actionEvent.getActionCommand().equals(COMMAND_EDIT)) {
            this.edit();
        } else if (actionEvent.getActionCommand().equals(COMMAND_EDIT_CONFIGURATION)) {
            AdministeredServerNode.debugOut("Edit configuration information.");
            this.getAdministeredServer().editConfigurationFileProperties();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_ADMIN_ACCOUNT)) {
            AdministeredServerNode.debugOut("Add a new admin account.");
            this.createNewAdminAccount();
        }
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Connect");
        jMenuItem.setActionCommand(COMMAND_CONNECT);
        jMenuItem.setEnabled(!this.server.isConnected());
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Disconnect");
        jMenuItem.setActionCommand(COMMAND_DISCONNECT);
        jMenuItem.setEnabled(this.server.isConnected());
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Edit");
        jMenuItem.setActionCommand(COMMAND_EDIT);
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Remove");
        jMenuItem.setActionCommand(COMMAND_REMOVE);
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public JComponent getDisplayComponent() {
        if (this.labelText == null) {
            this.createInformationModel();
        }
        return new JLabel(this.labelText);
    }

    public abstract ImageIcon getIcon();

    public void createNewAdminAccount() {
        this.server.addDataObject(new AdminAccount(this.server.getServerConnector().getNextValidAdminAccountID(), this.server));
    }

    public void removeAdminAccounts(Vector vector) {
        AdministeredServerNode.debugOut("Removing admin accounts: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected administrators?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.server.removeDataObject((AdminAccount)vector.elementAt(i));
            }
            this.adminAccountsNode.updateInformationDisplay();
        }
    }

    public void editAdminAccount(AdminAccount adminAccount) {
        AdministeredServerNode.debugOut("Editing admin account: " + adminAccount);
        this.server.editDataObject(adminAccount);
    }

    public static JPopupMenu createServerNodePopupMenu(ActionListener actionListener, int n, AdminAccount adminAccount, String string, String string2, String string3) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, adminAccount, "New", string, "Edit", string2, "Delete", string3);
    }

    public static JPopupMenu createServerNodePopupMenu(ActionListener actionListener, int n, AdminAccount adminAccount, String string, String string2, String string3, String string4, String string5, String string6) {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (string2 != null) {
            jMenuItem = adminAccount.createPermittedServerMenuItem(string, string2, actionListener);
            jPopupMenu.add(jMenuItem);
        }
        if (string4 != null) {
            jMenuItem = adminAccount.createPermittedServerMenuItem(string3, string4, actionListener);
            if (n != 1) {
                jMenuItem.setEnabled(false);
            }
            jPopupMenu.add(jMenuItem);
        }
        if (string6 != null) {
            jMenuItem = adminAccount.createPermittedServerMenuItem(string5, string6, actionListener);
            if (n == 0) {
                jMenuItem.setEnabled(false);
            }
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    public static JPopupMenu createAdminAccountNodePopupMenu(ActionListener actionListener, int n, AdminAccount adminAccount, String string, String string2, String string3) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = adminAccount.createPermittedAdminAccountMenuItem("New", string, actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = adminAccount.createPermittedAdminAccountMenuItem("Edit", string2, actionListener);
        if (n != 1) {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        jMenuItem = adminAccount.createPermittedAdminAccountMenuItem("Delete", string3, actionListener);
        if (n == 0) {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public static void debugOut(String string) {
        AdministeredServerNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("AdministeredServerNode: " + string, n);
    }
}

