/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class AdminAccountsNode
extends TableDisplayControlPanelNode {
    protected AdministeredServerNode serverNode = null;

    public AdminAccountsNode(AdministeredServerNode administeredServerNode) {
        super(administeredServerNode.getAdministeredServer().getInsightAdministrator(), "Admin Accounts", false);
        this.serverNode = administeredServerNode;
        this.columnNames = new Object[]{"Admin Name", "Created"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.serverNode.getAdministeredServer().getAdminAccounts()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        if (vector == null) {
            return new Object[0][0];
        }
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            AdminAccount adminAccount = (AdminAccount)vector.elementAt(i);
            objectArray[i][0] = adminAccount;
            objectArray[i][1] = new SimpleDate(adminAccount.createdTimestamp).getFull();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.serverNode.getAdministeredServer().getAdminAccount().createPermittedAdminAccountMenuItem("New...", "New Admin Account Command", this.serverNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.serverNode.getAdministeredServer().getAdminAccount().hasAccountPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/administered-server-accounts-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createAdminAccountNodePopupMenu(actionListener, n, this.serverNode.getAdministeredServer().getAdminAccount(), "New Admin Account Command", "Edit Admin Account Command", "Delete Admin Account Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Admin Account Command")) {
            this.serverNode.createNewAdminAccount();
        } else if (string.equals("Delete Admin Account Command")) {
            if (vector != null && vector.size() > 0) {
                this.serverNode.removeAdminAccounts(vector);
            }
        } else if (string.equals("Edit Admin Account Command") && vector != null && vector.size() == 1) {
            this.serverNode.editAdminAccount((AdminAccount)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.serverNode.editAdminAccount((AdminAccount)object);
        }
    }

    public static void debugOut(String string) {
        AdminAccountsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("AdminAccountsNode: " + string, n);
    }
}

