/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.security;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;

public class InsightSecuritySettings
extends Properties
implements Serializable {
    static final long serialVersionUID = -5107941128025261182L;
    public static final String DEFAULT_AUTHENTICATION_HANDLER = "com.luna.insight.client.security.DefaultAuthenticationHandler";
    public static final String DEFAULT_AUTHORIZATION_HANDLER = "com.luna.insight.client.security.DefaultAuthorizationHandler";
    public static final String AUTHEN_HNDLR_KEY = "AuthenticationHandler";
    public static final String AUTHOR_HNDLR_KEY = "AuthorizationHandler";
    public static final String LDAP_SECURITY_PRINCIPAL = "LdapSecurityPrincipal";
    public static final String LDAP_SECURITY_PRINCIPAL_ATTRIBUTES = "LdapSecurityPrincipalAttributes";
    public static final String LDAP_SEARCH_FILTER = "LdapSearchFilter";
    public static final String LDAP_SEARCH_ATTRIBUTES = "LdapSearchAttributes";
    public static final String USER_ATTRIBUTE_NAME_KEY = "UserAttributeName";
    public static final String BASE_DN_KEY = "BaseDN";
    public static final String TARGET_ATTRIBUTE_NAME_KEY = "TargetAttributeName";
    public static final String ORG_ATTRIBUTE_NAME_KEY = "OrganizationAttributeName";
    public static final String EMAIL_ATTRIBUTE_NAME_KEY = "EmailAttributeName";
    public static final String PHONE_ATTRIBUTE_NAME_KEY = "PhoneAttributeName";
    public static final String LDAP_URL_KEY = "LdapURL";
    public static final String LDAP_USER_PATH_KEY = "LdapUserPath";
    public static final String LDAP_USER_ATTRIB_KEY = "LdapUserAttribute";
    public static final String LDAP_USER_PATH_N_KEY = "LdapUserPathN";
    public static final String LDAP_LOGIN_SSL_KEY = "LoginSSL";
    public static final String KERBEROS_CONF_KEY = "KerberosConf";
    public static final String KERBEROS_REALM = "KerberosRealm";
    public static final String KERBEROS_SERVER = "KerberosServer";
    public static final String KERBEROS_TEMPLATE = "Krb5-Template.conf";
    public static final String KERBEROS_REALM_MACRO = "<KERBEROS_REALM>";
    public static final String KERBEROS_REALM_LC_MACRO = "<KERBEROS_REALM_LC>";
    public static final String KERBEROS_SERVER_MACRO = "<KERBEROS_SERVER>";
    public static final String LOGIN_MODULE_NAME = "Insight";
    public static final String LOGIN_MODULE_CONF_KEY = "LoginModuleConf";
    public static final String LOGIN_MODULE_CONF_STR = "Insight {\n  com.sun.security.auth.module.Krb5LoginModule required client=TRUE;\n};";

    public static void debugOut(String string) {
        InsightSecuritySettings.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut((String)("InsightSecuritySettings: " + string), (int)n);
    }

    public InsightSecuritySettings() {
        this((Properties)null);
    }

    public InsightSecuritySettings(Properties properties) {
        this.put(AUTHEN_HNDLR_KEY, DEFAULT_AUTHENTICATION_HANDLER);
        this.put(AUTHOR_HNDLR_KEY, DEFAULT_AUTHORIZATION_HANDLER);
        if (properties != null) {
            String string = properties.getProperty(AUTHEN_HNDLR_KEY);
            String string2 = properties.getProperty(AUTHOR_HNDLR_KEY);
            if (string == null || string2 == null) {
                string = DEFAULT_AUTHENTICATION_HANDLER;
                string2 = DEFAULT_AUTHORIZATION_HANDLER;
            }
            try {
                if (string.indexOf("KerberosAuthenticationHandler") > -1) {
                    String string3 = properties.getProperty(USER_ATTRIBUTE_NAME_KEY);
                    String string4 = properties.getProperty(BASE_DN_KEY);
                    String string5 = properties.getProperty(TARGET_ATTRIBUTE_NAME_KEY);
                    String string6 = properties.getProperty(LDAP_URL_KEY);
                    String string7 = properties.getProperty(KERBEROS_REALM);
                    String string8 = properties.getProperty(KERBEROS_SERVER);
                    String string9 = properties.getProperty(ORG_ATTRIBUTE_NAME_KEY, "");
                    String string10 = properties.getProperty(EMAIL_ATTRIBUTE_NAME_KEY, "");
                    String string11 = properties.getProperty(PHONE_ATTRIBUTE_NAME_KEY, "");
                    if (string3 == null || string4 == null || string5 == null || string6 == null || string7 == null || string8 == null) {
                        throw new Exception();
                    }
                    String string12 = new String(InsightUtilities.importResourceFileBytes((String)KERBEROS_TEMPLATE));
                    String string13 = string7.toLowerCase();
                    String string14 = InsightUtilities.replaceSubstrings((String)string12, (String[])new String[]{KERBEROS_REALM_MACRO, KERBEROS_REALM_LC_MACRO, KERBEROS_SERVER_MACRO}, (String[])new String[]{string7, string13, string8});
                    byte[] byArray = string14.getBytes();
                    byte[] byArray2 = LOGIN_MODULE_CONF_STR.getBytes();
                    if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
                        throw new Exception();
                    }
                    this.put(USER_ATTRIBUTE_NAME_KEY, string3);
                    this.put(BASE_DN_KEY, string4);
                    this.put(TARGET_ATTRIBUTE_NAME_KEY, string5);
                    this.put(ORG_ATTRIBUTE_NAME_KEY, string9);
                    this.put(EMAIL_ATTRIBUTE_NAME_KEY, string10);
                    this.put(PHONE_ATTRIBUTE_NAME_KEY, string11);
                    this.put(LDAP_URL_KEY, string6);
                    this.put(KERBEROS_CONF_KEY, byArray);
                    this.put(LOGIN_MODULE_CONF_KEY, byArray2);
                } else if (string.indexOf("LDAPAuthenticationSearchHandler") > -1) {
                    this.prepareLDAPAuthenticationSearchHandlerSetting(properties);
                } else if (string.indexOf("SimpleLDAPAuthenticationHandler") > -1) {
                    this.put(LDAP_URL_KEY, properties.getProperty(LDAP_URL_KEY, ""));
                    this.put(LDAP_USER_PATH_KEY, properties.getProperty(LDAP_USER_PATH_KEY, ""));
                    this.put(LDAP_USER_ATTRIB_KEY, properties.getProperty(LDAP_USER_ATTRIB_KEY, ""));
                    String string15 = properties.getProperty(LDAP_LOGIN_SSL_KEY);
                    if (string15 == null || !string15.equals("1") && !string15.equalsIgnoreCase("true") && !string15.equalsIgnoreCase("yes")) {
                        this.put(LDAP_LOGIN_SSL_KEY, Boolean.FALSE);
                    } else {
                        this.put(LDAP_LOGIN_SSL_KEY, Boolean.TRUE);
                    }
                    TreeMap<String, String[]> treeMap = new TreeMap<String, String[]>();
                    String string16 = this.getProperty(LDAP_USER_ATTRIB_KEY);
                    Iterator<Object> iterator = properties.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string17 = (String)iterator.next();
                        if (!string17.substring(0, string17.length() - 1).equals(LDAP_USER_PATH_KEY)) continue;
                        try {
                            int n = Integer.parseInt(string17.substring(string17.length() - 1, string17.length()));
                            treeMap.put(string17, new String[]{properties.getProperty(string17, ""), properties.getProperty(LDAP_USER_ATTRIB_KEY + n, string16)});
                        }
                        catch (NumberFormatException numberFormatException) {
                            InsightSecuritySettings.debugOut("Unrecognized LDAP property '" + string17 + "'.  Skipping.");
                        }
                    }
                    this.put(LDAP_USER_PATH_N_KEY, treeMap);
                }
            }
            catch (Exception exception) {
                InsightSecuritySettings.debugOut("Problem setting authentication settings, use default security handlers:\n" + InsightUtilities.getStackTrace((Throwable)exception));
                string = DEFAULT_AUTHENTICATION_HANDLER;
                string2 = DEFAULT_AUTHORIZATION_HANDLER;
            }
            this.put(AUTHEN_HNDLR_KEY, string);
            this.put(AUTHOR_HNDLR_KEY, string2);
        }
        InsightSecuritySettings.debugOut("Authentication handler: " + this.get(AUTHEN_HNDLR_KEY));
        InsightSecuritySettings.debugOut("Authorization handler: " + this.get(AUTHOR_HNDLR_KEY));
    }

    protected void prepareLDAPAuthenticationSearchHandlerSetting(Properties properties) throws Exception {
        InsightSecuritySettings.debugOut("prepareLDAPAuthenticationSearchHandlerSetting");
        String string = properties.getProperty(LDAP_USER_ATTRIB_KEY, "insightUser");
        String string2 = properties.getProperty(LDAP_LOGIN_SSL_KEY);
        String string3 = properties.getProperty(LDAP_URL_KEY);
        String string4 = properties.getProperty(BASE_DN_KEY);
        String string5 = properties.getProperty(LDAP_SECURITY_PRINCIPAL);
        String string6 = properties.getProperty(LDAP_SECURITY_PRINCIPAL_ATTRIBUTES);
        InsightSecuritySettings.debugOut("prepareLDAPAuthenticationSearchHandlerSetting: loginSSL = " + string2);
        InsightSecuritySettings.debugOut("prepareLDAPAuthenticationSearchHandlerSetting: ldapURL = " + string3);
        InsightSecuritySettings.debugOut("prepareLDAPAuthenticationSearchHandlerSetting: baseDN = " + string4);
        InsightSecuritySettings.debugOut("prepareLDAPAuthenticationSearchHandlerSetting: ldapSecurityPrincipal = " + string5);
        InsightSecuritySettings.debugOut("prepareLDAPAuthenticationSearchHandlerSetting: ldapSecurityPrincipalAttributes = " + string6);
        if (string4 == null) {
            throw new Exception("Setting LDAPAuthenticationSearchHandler");
        }
        if (string2 == null || !string2.equals("1") && !string2.equalsIgnoreCase("true") && !string2.equalsIgnoreCase("yes")) {
            this.put(LDAP_LOGIN_SSL_KEY, Boolean.FALSE);
        } else {
            this.put(LDAP_LOGIN_SSL_KEY, Boolean.TRUE);
        }
        this.put(LDAP_USER_ATTRIB_KEY, string);
        this.put(LDAP_URL_KEY, string3);
        this.put(BASE_DN_KEY, string4);
        if (string5 != null) {
            this.put(LDAP_SECURITY_PRINCIPAL, string5);
        }
        if (string6 != null) {
            this.put(LDAP_SECURITY_PRINCIPAL_ATTRIBUTES, string6);
        }
        int n = 1;
        String string7 = null;
        do {
            string7 = properties.getProperty("LdapSearchFilter_" + n);
            String string8 = properties.getProperty("LdapSearchAttributes_" + n);
            if (string7 == null) break;
            InsightSecuritySettings.debugOut("prepareLDAPAuthenticationSearchHandlerSetting: ldapSearchFilter_" + n + " = " + string7);
            InsightSecuritySettings.debugOut("prepareLDAPAuthenticationSearchHandlerSetting: ldapSearchAttribute_" + n + " = " + string8);
            this.put("LdapSearchFilter_" + n, string7);
            this.put("LdapSearchAttributes_" + n, string8);
            ++n;
        } while (string7 != null);
    }
}

