/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.security.ldap;

import com.luna.insight.server.Debug;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;

public class SearchAttributes {
    protected Attributes attributes = null;
    protected String searchFilter = null;
    protected String searchAttributes = null;
    protected String ldaptUserAttribute = null;
    protected String username = null;
    protected String dn = null;
    protected boolean debug = false;

    public SearchAttributes(String string, String string2) {
        this.ldaptUserAttribute = string;
        this.username = string2;
    }

    public SearchAttributes(String string, String string2, String string3, String string4) {
        this(string, string2);
        this.searchFilter = string3;
        this.searchAttributes = string4;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public String getSearchAttributes() {
        return this.searchAttributes;
    }

    protected String getAttributeValue(Attribute attribute, String string, Map map) throws Exception {
        String string2 = null;
        if (attribute != null) {
            Object v = map.get(string);
            int n = 0;
            if (v == null) {
                string2 = (String)attribute.get(0);
            } else {
                n = (Integer)v;
                if (attribute.size() > n) {
                    string2 = (String)attribute.get(n);
                }
            }
            if (string2 != null) {
                map.put(string, new Integer(n + 1));
            }
        } else if (this.ldaptUserAttribute != null && this.ldaptUserAttribute.equals(string)) {
            string2 = this.username;
        } else if ("dn".equalsIgnoreCase(string)) {
            string2 = this.dn;
        }
        return string2;
    }

    public Object[] values(String string) throws Exception {
        String[] stringArray;
        Object[] objectArray = null;
        HashMap hashMap = new HashMap();
        if (string != null && (stringArray = string.split(",")) != null && stringArray.length > 0) {
            objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringArray[i] = stringArray[i].trim();
                Attribute attribute = null;
                if (this.attributes != null) {
                    attribute = this.attributes.get(stringArray[i]);
                }
                objectArray[i] = this.getAttributeValue(attribute, stringArray[i], hashMap);
                SearchAttributes.debugOut("values(..): attribute name = " + stringArray[i] + ", value = " + objectArray[i]);
            }
        }
        return objectArray;
    }

    protected void printSearchValues(NamingEnumeration namingEnumeration) {
        SearchAttributes.debugOut("<< The following values were found in Active Directory (LDAP) >>");
        try {
            while (namingEnumeration.hasMore()) {
                Object t = namingEnumeration.next();
                if (t == null) continue;
                SearchAttributes.debugOut(t.toString());
            }
        }
        catch (Exception exception) {
            SearchAttributes.debugOut("Error: printSearchValues(..): " + exception.getMessage(), 3);
        }
    }

    public boolean hasAttributeValue(String string, Pattern pattern) throws Exception {
        boolean bl = false;
        SearchAttributes.debugOut("hasAttributeValue(..): attributeName = " + string + ", conditionPattern = " + pattern.pattern());
        if (this.attributes != null && pattern != null) {
            Object[] objectArray = this.values(string);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (object == null) continue;
                    String string2 = (String)object;
                    SearchAttributes.debugOut("hasAttributeValue(..): searchValue = " + string2 + " attributeName = " + string + ", conditionPattern = " + pattern.pattern());
                    Matcher matcher = pattern.matcher(string2);
                    SearchAttributes.debugOut("hasAttributeValue(..): matcher = " + ((Object)matcher).toString() + ", searchValue = " + string2);
                    if (matcher.find()) {
                        SearchAttributes.debugOut("matcher: found: pattern = " + ((Object)pattern).toString() + ", value = " + string2);
                        bl = true;
                        break;
                    }
                    SearchAttributes.debugOut("matcher: not found: pattern = " + ((Object)pattern).toString() + ", value = " + string2);
                }
            } else if (this.ldaptUserAttribute != null && this.ldaptUserAttribute.equals(string)) {
                bl = true;
            }
        } else {
            SearchAttributes.debugOut("hasAttributeValue(..): attribute = " + this.attributes + ", conditionPattern = " + pattern.pattern());
        }
        return bl;
    }

    public void populateAttributeValues(NamingEnumeration namingEnumeration, String string) throws Exception {
        try {
            if (namingEnumeration.hasMore()) {
                SearchResult searchResult = (SearchResult)namingEnumeration.next();
                searchResult.setRelative(true);
                this.dn = searchResult.getName() + ',' + string;
                System.out.println("Searched DN = " + this.dn);
                SearchAttributes.debugOut("populateAttributeValues(..): attribute name = " + searchResult.getName() + ", attributes = " + searchResult.getAttributes());
                this.attributes = searchResult.getAttributes();
            }
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
    }

    public static void debugOut(String string) {
        System.out.println(string);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut((String)("SearchAttributes: " + string), (int)n);
    }
}

