/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.security.ldap;

import com.luna.insight.client.security.ldap.LDAPAuthenticationSearch;
import com.luna.insight.client.security.ldap.SearchAttributes;
import com.sun.jndi.ldap.LdapCtxFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;

public class LDAPAuthenticationSearchImpl
implements LDAPAuthenticationSearch {
    protected String ldapUserAttribute = "insightUser";
    protected String ldapURL = null;
    protected String baseDN = null;
    protected Boolean loginSSL = null;
    protected String ldapSecurityPrincipal = null;
    protected String ldapSecurityPrincipalAttributes = null;
    protected String trustStorePath = null;
    protected List ldapSearchFilters = null;
    protected List ldapAttributes = null;
    protected Pattern domianNamePattern = Pattern.compile("dc\\s*=\\s*(\\w+)\\s*,\\s*dc\\s*=\\s*(\\w+)");
    protected boolean activeDirectory = false;
    protected String domainNameForActiveDirectory = null;

    public void setLdapSearchFilters(List list) {
        this.ldapSearchFilters = list;
    }

    public List getLdapSearchFilters() {
        return this.ldapSearchFilters;
    }

    public void setLdapSearchAttributes(List list) {
        this.ldapAttributes = list;
    }

    public List getLdapSearchAttributes() {
        return this.ldapAttributes;
    }

    public void setLdapUserAttribute(String string) {
        this.ldapUserAttribute = string;
    }

    public String getLdapUserAttribute() {
        return this.ldapUserAttribute;
    }

    public String getLdapURL() {
        return this.ldapURL;
    }

    public void setLdapURL(String string) {
        this.ldapURL = string;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public Boolean getLoginSSL() {
        return this.loginSSL;
    }

    public void setLoginSSL(Boolean bl) {
        this.loginSSL = bl;
    }

    public void setBaseDN(String string) {
        this.baseDN = string;
    }

    public String getLdapSecurityPrincipal() {
        return this.ldapSecurityPrincipal;
    }

    public void setLdapSecurityPrincipal(String string) {
        this.ldapSecurityPrincipal = string;
    }

    public String getLdapSecurityPrincipalAttributes() {
        return this.ldapSecurityPrincipalAttributes;
    }

    public void setLdapSecurityPrincipalAttributes(String string) {
        this.ldapSecurityPrincipalAttributes = string;
    }

    public void setTrustStorePath(String string) {
        this.trustStorePath = string;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public boolean addFilter(String string, String string2) {
        boolean bl = false;
        if (this.ldapSearchFilters == null) {
            this.ldapSearchFilters = new ArrayList();
        }
        LDAPAuthenticationSearchImpl.debugOut("addFilter(..): ldapSearchFilter = " + string + ", ldapSearchAttribute = " + string2);
        bl = this.ldapSearchFilters.add(string);
        if (bl) {
            if (this.ldapAttributes == null) {
                this.ldapAttributes = new ArrayList();
            }
            bl = this.ldapAttributes.add(string2);
        }
        return bl;
    }

    protected boolean addSearchAttributes(List list, String string, String string2, String string3) {
        SearchAttributes searchAttributes = new SearchAttributes(this.ldapUserAttribute, string, string2, string3);
        boolean bl = this.addSearchAttributes(list, searchAttributes);
        return bl;
    }

    protected void addFilters(List list, String string, List list2, List list3) {
        if (list2 != null && list3 != null) {
            if (list2.size() > list3.size()) {
                LDAPAuthenticationSearchImpl.debugOut("Error: LDAP Filters / attributes inconsistent", 3);
            } else {
                for (int i = 0; i < list2.size(); ++i) {
                    Object e = list2.get(i);
                    Object e2 = list3.get(i);
                    if (e == null || e2 == null) continue;
                    this.addSearchAttributes(list, string, (String)e, (String)e2);
                }
            }
        }
    }

    public boolean addSearchAttributes(List list, SearchAttributes searchAttributes) {
        return list.add(searchAttributes);
    }

    public void setActiveDirectory(boolean bl) {
        this.activeDirectory = bl;
    }

    public boolean getActiveDirectory() {
        return this.activeDirectory;
    }

    protected SearchAttributes getLastSearchAttributes(List list) {
        int n = list.size() - 2;
        n = n < 0 ? 0 : n;
        LDAPAuthenticationSearchImpl.debugOut("getLastSearchAttributes(..) index = " + n);
        Object var3_3 = null;
        if (list != null) {
            var3_3 = list.get(n);
        }
        LDAPAuthenticationSearchImpl.debugOut("getLastSearchAttributes(..): obj = " + var3_3);
        return var3_3 == null ? null : (SearchAttributes)var3_3;
    }

    protected List getSearchAttributesList(List list) {
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void precedingSearches(List list, Hashtable hashtable) throws Exception {
        LDAPAuthenticationSearchImpl.debugOut("precedingSearches(..)");
        InitialDirContext initialDirContext = null;
        try {
            initialDirContext = new InitialDirContext(hashtable);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                SearchAttributes searchAttributes = (SearchAttributes)list.get(i);
                if (searchAttributes.getSearchFilter() == null) continue;
                Object[] objectArray = null;
                if (i == 0) {
                    objectArray = searchAttributes.values(searchAttributes.getSearchAttributes());
                } else {
                    object = (SearchAttributes)list.get(i - 1);
                    objectArray = ((SearchAttributes)object).values(searchAttributes.getSearchAttributes());
                }
                LDAPAuthenticationSearchImpl.debugOut("precedingSearches(..): LdapSearchFilter_ " + i + " = " + searchAttributes.getSearchFilter());
                object = initialDirContext.search(this.baseDN, searchAttributes.getSearchFilter(), objectArray, searchControls);
                searchAttributes.populateAttributeValues((NamingEnumeration)object, this.baseDN);
            }
        }
        finally {
            if (initialDirContext != null) {
                initialDirContext.close();
            }
        }
    }

    protected void searchWithCredential(List list, Hashtable hashtable, boolean bl) throws Exception {
        LDAPAuthenticationSearchImpl.debugOut("searchWithCredential(..): Security Settings: \nldapUserAttribute = " + this.ldapUserAttribute + ", ldapURL = " + this.ldapURL + ", loginSSL = " + this.loginSSL.toString() + ", baseDN = " + this.baseDN + ", ldapSecurityPrincipal = " + this.ldapSecurityPrincipal + ", ldapSecurityPrincipalAttributes = " + this.ldapSecurityPrincipalAttributes);
        if (this.ldapSecurityPrincipal == null || this.ldapSecurityPrincipalAttributes == null) {
            LDAPAuthenticationSearchImpl.debugOut("searchWithCredential(..): ldapSecurityPrincipal or ldapSecurityPrincipalAttributes not specified in the config.");
            return;
        }
        InitialContext initialContext = null;
        SearchAttributes searchAttributes = this.getLastSearchAttributes(list);
        try {
            String string = MessageFormat.format(this.ldapSecurityPrincipal, searchAttributes.values(this.ldapSecurityPrincipalAttributes));
            LDAPAuthenticationSearchImpl.debugOut("searchWithCredential(..): bound with principal = " + string);
            if (!bl) {
                hashtable.put("java.naming.security.principal", string);
            }
            initialContext = new InitialDirContext(hashtable);
            LDAPAuthenticationSearchImpl.debugOut("searchWithCredential(..): login sueccessful");
        }
        catch (AuthenticationException authenticationException) {
            LDAPAuthenticationSearchImpl.debugOut("Checks the ldapAuthenticationSearch properties of the configuration.", 3);
            throw authenticationException;
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
        }
    }

    protected void checkTrustStorePath() {
        if (this.trustStorePath != null && this.trustStorePath.length() > 0) {
            System.setProperty("javax.net.ssl.trustStore", this.trustStorePath);
        }
    }

    protected void populateSearchConditions(List list, String string) {
        if (this.ldapSearchFilters != null && this.ldapSearchFilters.size() > 0) {
            this.addFilters(list, string, this.ldapSearchFilters, this.ldapAttributes);
        }
        if (list.size() == 0) {
            SearchAttributes searchAttributes = new SearchAttributes(this.ldapUserAttribute, string);
            this.addSearchAttributes(list, searchAttributes);
        }
    }

    public boolean authenticate(String string, String string2) {
        boolean bl = false;
        this.checkTrustStorePath();
        boolean bl2 = this.loginActiveDirectory(string, string2);
        if (bl2) {
            if (this.ldapSearchFilters == null || this.ldapSearchFilters.size() == 0) {
                bl = true;
            }
        } else {
            bl = this.ldapSearchFilters == null || this.ldapSearchFilters.size() == 0 ? false : this.loginWithSearch(string, string2, bl2);
        }
        return bl;
    }

    public static void debugOut(String string) {
        System.out.println(string);
    }

    public static void debugOut(String string, int n) {
        System.out.println(string);
    }

    protected void initEnvForLoginWithSearch(String string, String string2, boolean bl, Hashtable hashtable, List list) {
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        if (this.loginSSL.equals(Boolean.TRUE)) {
            hashtable.put("java.naming.security.protocol", "ssl");
        }
        hashtable.put("java.naming.provider.url", this.ldapURL);
        if (bl) {
            this.prepareActiveDirectoryEnv(hashtable, string, string2);
        }
        hashtable.put("java.naming.security.credentials", string2);
        hashtable.put("java.naming.referral", "follow");
    }

    protected boolean loginWithSearch(String string, String string2, boolean bl) {
        LDAPAuthenticationSearchImpl.debugOut("loginWithSearch");
        boolean bl2 = false;
        Hashtable hashtable = new Hashtable();
        ArrayList arrayList = new ArrayList();
        this.populateSearchConditions(arrayList, string);
        this.initEnvForLoginWithSearch(string, string2, bl, hashtable, arrayList);
        try {
            this.precedingSearches(arrayList, hashtable);
            this.searchWithCredential(arrayList, hashtable, bl);
            bl2 = true;
        }
        catch (Exception exception) {
            System.out.println("LDAPAuthenticationSearchImpl: authenticate(..): Error: message = " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl2;
    }

    protected void prepareActiveDirectoryEnv(Hashtable hashtable, String string, String string2) {
        this.createDomainName();
        String string3 = string + '@' + this.domainNameForActiveDirectory;
        hashtable.put("java.naming.security.principal", string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDomainName() {
        LDAPAuthenticationSearchImpl lDAPAuthenticationSearchImpl = this;
        synchronized (lDAPAuthenticationSearchImpl) {
            if (this.domainNameForActiveDirectory == null) {
                Matcher matcher;
                if (this.baseDN == null) {
                    System.out.println("Error: baseDN is not specified.");
                }
                if ((matcher = this.domianNamePattern.matcher(this.baseDN)).find()) {
                    if (matcher.group(1) != null && matcher.group(2) != null) {
                        this.domainNameForActiveDirectory = matcher.group(1).trim() + '.' + matcher.group(2).trim();
                    } else {
                        System.out.println("Error: incorrect baseDN = " + this.baseDN);
                    }
                } else {
                    System.out.println("Error: incorrect baseDN = " + this.baseDN);
                }
            }
        }
        LDAPAuthenticationSearchImpl.debugOut("Domain name: " + this.domainNameForActiveDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loginActiveDirectory(String string, String string2) {
        boolean bl = false;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.prepareActiveDirectoryEnv(hashtable, string, string2);
        hashtable.put("java.naming.security.credentials", string2);
        if (this.loginSSL.equals(Boolean.TRUE)) {
            hashtable.put("java.naming.security.protocol", "ssl");
        }
        hashtable.put("java.naming.referral", "follow");
        Context context = null;
        try {
            context = LdapCtxFactory.getLdapCtxInstance(this.ldapURL + '/', hashtable);
            this.activeDirectory = true;
            bl = true;
            LDAPAuthenticationSearchImpl.debugOut("loginActiveDirectory(..): authenticated with Active Directory");
        }
        catch (NamingException namingException) {
            System.out.println("Could not bind to Active Directory for user:  " + string);
            System.out.println("Tries to access as OpenLDAP");
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }
}

