/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.security;

import com.luna.insight.client.security.DefaultAuthorizationHandler;
import com.luna.insight.client.security.InsightUserManager;
import com.luna.insight.client.security.SimpleLDAPAuthenticationHandler;
import com.luna.insight.client.security.iface.AuthorizationException;
import com.luna.insight.client.security.iface.IAuthenticationHandler;
import com.luna.insight.client.security.iface.IAuthorizationHandler;
import com.luna.insight.client.security.iface.SecurityServerConnectionException;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUserClient;
import java.util.List;
import java.util.Vector;

public class SimpleLDAPAuthorizationHandler
extends DefaultAuthorizationHandler
implements IAuthorizationHandler {
    public static void debugOut(String string) {
        SimpleLDAPAuthorizationHandler.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut((String)("SimpleLDAPAuthorizationHandler: " + string), (int)n);
    }

    public List getCollections(IAuthenticationHandler iAuthenticationHandler, boolean bl) throws AuthorizationException, SecurityServerConnectionException {
        if (!(iAuthenticationHandler instanceof SimpleLDAPAuthenticationHandler)) {
            throw new AuthorizationException();
        }
        SimpleLDAPAuthenticationHandler simpleLDAPAuthenticationHandler = (SimpleLDAPAuthenticationHandler)iAuthenticationHandler;
        String string = simpleLDAPAuthenticationHandler.getUsername();
        SimpleLDAPAuthorizationHandler.debugOut("Authorize: " + string);
        Vector vector = null;
        InsightUserClient insightUserClient = new InsightUserClient(InsightUserManager.USER_SERVER_ADDRESS);
        if (insightUserClient.isConnectionGood()) {
            vector = bl ? insightUserClient.getAvailableMedeCollections(string, null) : insightUserClient.getAvailableCollections(string, null);
        } else {
            throw new SecurityServerConnectionException(false, true);
        }
        insightUserClient.closeConnection();
        SimpleLDAPAuthorizationHandler.debugOut("Received " + vector.size() + " collection(s).");
        if (vector == null || vector.size() < 1) {
            throw new AuthorizationException();
        }
        return vector;
    }
}

