/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.security;

import com.luna.insight.client.security.DefaultAuthenticationHandler;
import com.luna.insight.client.security.InsightUserManager;
import com.luna.insight.client.security.iface.AuthenticationException;
import com.luna.insight.client.security.iface.IAuthenticationHandler;
import com.luna.insight.client.security.iface.SecurityCallbackHandler;
import com.luna.insight.client.security.iface.SecurityServerConnectionException;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.security.InsightSecuritySettings;
import com.sun.net.ssl.internal.ssl.Provider;
import java.security.Security;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class SimpleLDAPAuthenticationHandler
extends DefaultAuthenticationHandler
implements IAuthenticationHandler {
    public static void debugOut(String string) {
        SimpleLDAPAuthenticationHandler.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut((String)("SimpleLDAPAuthenticationHandler: " + string), (int)n);
    }

    public void authenticate(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, SecurityServerConnectionException {
        this.username = securityCallbackHandler.getUsername();
        this.password = securityCallbackHandler.getPassword();
        SimpleLDAPAuthenticationHandler.debugOut("Check " + this.username);
        if (this.username.length() > 0 && this.password.length() > 0) {
            this.isAuthenticated = this.authenticateUsingSimpleLDAP(this.username, this.password);
        }
        SimpleLDAPAuthenticationHandler.debugOut("authenticate " + this.isAuthenticated);
        if (!this.isAuthenticated) {
            throw new AuthenticationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected boolean authenticateUsingSimpleLDAP(String string, String string2) {
        Context context = null;
        SimpleLDAPAuthenticationHandler.debugOut("in authenticateSimpleLDAP()");
        InsightSecuritySettings insightSecuritySettings = InsightUserManager.LOGIN_PROPS;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.provider.url", insightSecuritySettings.getProperty("LdapURL"));
        String string3 = insightSecuritySettings.getProperty("LdapUserAttribute") + " = " + string + ", " + insightSecuritySettings.getProperty("LdapUserPath");
        hashtable.put("java.naming.security.principal", string3);
        hashtable.put("java.naming.security.credentials", string2);
        if (((Boolean)insightSecuritySettings.get("LoginSSL")).equals(Boolean.TRUE)) {
            hashtable.put("java.naming.security.protocol", "ssl");
        }
        SimpleLDAPAuthenticationHandler.debugOut("URL: " + insightSecuritySettings.getProperty("LdapURL", ""));
        SimpleLDAPAuthenticationHandler.debugOut("principal: " + string3);
        SimpleLDAPAuthenticationHandler.debugOut("protocol: " + hashtable.get("java.naming.security.protocol"));
        context = new InitialDirContext(new Hashtable(hashtable));
        boolean bl = true;
        Object var16_9 = null;
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException namingException) {
            SimpleLDAPAuthenticationHandler.debugOut("exception closing DirContext during LDAP authentication." + InsightUtilities.getStackTrace((Throwable)namingException));
        }
        {
            return bl;
            catch (NamingException namingException) {
                Map map = (Map)insightSecuritySettings.get("LdapUserPathN");
                if (map != null) {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        boolean bl2;
                        String[] stringArray = (String[])map.get(iterator.next());
                        String string4 = stringArray[0];
                        String string5 = stringArray[1];
                        if (string4 == null || string4.equals("")) continue;
                        Hashtable<String, String> hashtable2 = new Hashtable<String, String>(hashtable);
                        string3 = string5 + " = " + string + ", " + string4;
                        hashtable2.put("java.naming.security.principal", string3);
                        try {
                            context = new InitialDirContext(hashtable2);
                            bl2 = true;
                        }
                        catch (NamingException namingException2) {
                            continue;
                        }
                        Object var16_10 = null;
                        try {
                            if (context != null) {
                                context.close();
                            }
                        }
                        catch (NamingException namingException3) {
                            SimpleLDAPAuthenticationHandler.debugOut("exception closing DirContext during LDAP authentication." + InsightUtilities.getStackTrace((Throwable)namingException3));
                        }
                        return bl2;
                    }
                }
                SimpleLDAPAuthenticationHandler.debugOut("NamingException in authenticateUsingSimpleLDAP():\n " + InsightUtilities.getStackTrace((Throwable)namingException));
                boolean bl3 = false;
                Object var16_11 = null;
                try {
                    if (context != null) {
                        context.close();
                    }
                }
                catch (NamingException namingException4) {
                    SimpleLDAPAuthenticationHandler.debugOut("exception closing DirContext during LDAP authentication." + InsightUtilities.getStackTrace((Throwable)namingException4));
                }
                return bl3;
            }
        }
        catch (Throwable throwable) {
            Object var16_12 = null;
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (NamingException namingException) {
                SimpleLDAPAuthenticationHandler.debugOut("exception closing DirContext during LDAP authentication." + InsightUtilities.getStackTrace((Throwable)namingException));
            }
            throw throwable;
        }
    }

    static {
        String string = System.getProperty("java.version");
        if (string != null && string.length() > 0 && string.startsWith("1.3") && Security.getProvider("SunJSSE") == null) {
            Security.addProvider((java.security.Provider)new Provider());
        }
    }
}

