/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.security;

import com.luna.insight.client.security.InsightUserManager;
import com.luna.insight.client.security.KerberosAuthenticationHandler;
import com.luna.insight.client.security.ManagedInsightAuthorizationEntityKey;
import com.luna.insight.client.security.iface.AuthenticationException;
import com.luna.insight.client.security.iface.AuthorizationException;
import com.luna.insight.client.security.iface.IAuthenticationHandler;
import com.luna.insight.client.security.iface.IAuthorizationEntityKey;
import com.luna.insight.client.security.iface.IAuthorizationGroup;
import com.luna.insight.client.security.iface.IAuthorizationHandler;
import com.luna.insight.client.security.iface.IShare;
import com.luna.insight.client.security.iface.IShareAuthorizationKey;
import com.luna.insight.client.security.iface.IUser;
import com.luna.insight.client.security.iface.SecurityCallbackHandler;
import com.luna.insight.client.security.iface.SecurityServerConnectionException;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUserClient;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.security.InsightSecuritySettings;
import com.luna.insight.server.usergroup.ShareFolder;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

public class LDAPAuthorizationHandler
implements IAuthorizationHandler,
PrivilegedAction {
    protected String userName = "";
    protected String userGroupProfiles = "";
    protected InsightUser insightUser = new InsightUser();
    protected LoginContext lc = null;
    protected Exception ldapException = null;
    static /* synthetic */ Class class$com$luna$insight$client$security$ManagedUserGroup;

    public static void debugOut(String string) {
        LDAPAuthorizationHandler.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut((String)("LDAPAuthorizationHandler: " + string), (int)n);
    }

    public List getCollections(IAuthenticationHandler iAuthenticationHandler, boolean bl) throws AuthorizationException, SecurityServerConnectionException {
        if (!(iAuthenticationHandler instanceof KerberosAuthenticationHandler)) {
            throw new AuthorizationException();
        }
        KerberosAuthenticationHandler kerberosAuthenticationHandler = (KerberosAuthenticationHandler)iAuthenticationHandler;
        this.lc = kerberosAuthenticationHandler.getLoginContext();
        Subject.doAs(this.lc.getSubject(), this);
        LDAPAuthorizationHandler.debugOut("User group profiles: " + this.userGroupProfiles);
        if (this.userGroupProfiles == null || this.userGroupProfiles.length() == 0) {
            if (this.ldapException != null && this.ldapException instanceof SecurityServerConnectionException) {
                throw (SecurityServerConnectionException)this.ldapException;
            }
            throw new AuthorizationException();
        }
        Vector vector = new Vector();
        InsightUserClient insightUserClient = new InsightUserClient(InsightUserManager.USER_SERVER_ADDRESS);
        if (insightUserClient.isConnectionGood()) {
            vector = bl ? insightUserClient.getMedeCollectionsByUserGroups(this.userName, this.userGroupProfiles) : insightUserClient.getCollectionsByUserGroups(this.userName, this.userGroupProfiles);
        } else {
            throw new SecurityServerConnectionException(false, true);
        }
        insightUserClient.closeConnection();
        LDAPAuthorizationHandler.debugOut("Received " + vector.size() + " collection(s).");
        if (vector == null || vector.size() < 1) {
            throw new AuthorizationException();
        }
        return vector;
    }

    public Object run() {
        this.performJndiOperation();
        return null;
    }

    private void performJndiOperation() {
        Subject subject = this.lc.getSubject();
        Set<Principal> set = subject.getPrincipals();
        InsightSecuritySettings insightSecuritySettings = InsightUserManager.LOGIN_PROPS;
        String string = insightSecuritySettings.getProperty("UserAttributeName");
        String string2 = insightSecuritySettings.getProperty("BaseDN");
        String string3 = insightSecuritySettings.getProperty("TargetAttributeName");
        String string4 = insightSecuritySettings.getProperty("OrganizationAttributeName");
        String string5 = insightSecuritySettings.getProperty("EmailAttributeName");
        String string6 = insightSecuritySettings.getProperty("PhoneAttributeName");
        String string7 = insightSecuritySettings.getProperty("LdapURL");
        LDAPAuthorizationHandler.debugOut("searchAttrName " + string);
        LDAPAuthorizationHandler.debugOut("baseDN " + string2);
        LDAPAuthorizationHandler.debugOut("targetAttrName " + string3);
        LDAPAuthorizationHandler.debugOut("ldapURL " + string7);
        LDAPAuthorizationHandler.debugOut("orgAttrName " + string4);
        LDAPAuthorizationHandler.debugOut("emailAttrName " + string5);
        LDAPAuthorizationHandler.debugOut("phoneAttrName " + string6);
        Iterator<Principal> iterator = set.iterator();
        if (iterator.hasNext()) {
            this.userName = iterator.next().getName();
        }
        String string8 = "(" + string + "=" + this.userName + ")";
        LDAPAuthorizationHandler.debugOut("Filter " + string8);
        Hashtable<String, String> hashtable = new Hashtable<String, String>(11);
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string7);
        hashtable.put("java.naming.security.authentication", "GSSAPI");
        hashtable.put("javax.security.sasl.server.authentication", "true");
        try {
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string2, string8, searchControls);
            try {
                if (namingEnumeration.hasMore()) {
                    SearchResult searchResult = namingEnumeration.next();
                    Attributes attributes = searchResult.getAttributes();
                    try {
                        Attribute attribute = attributes.get(string3);
                        this.userGroupProfiles = (String)attribute.get(0);
                        Attribute attribute2 = attributes.get(string5);
                        Attribute attribute3 = attributes.get(string4);
                        Attribute attribute4 = attributes.get(string6);
                        this.insightUser.setEmail(attribute2 == null ? "" : (String)attribute2.get(0));
                        this.insightUser.setOrganization(attribute3 == null ? "" : (String)attribute3.get(0));
                        this.insightUser.setPhone(attribute4 == null ? "" : (String)attribute4.get(0));
                        this.insightUser.setLastName(this.userName);
                        this.insightUser.setLoginName(this.userName);
                        LDAPAuthorizationHandler.debugOut(this.insightUser.toString());
                    }
                    catch (Exception exception) {
                        LDAPAuthorizationHandler.debugOut("Exception, the TargetAttributeName \"" + string3 + "\" was not found or configured incorrectly: " + InsightUtilities.getStackTrace((Throwable)exception));
                    }
                }
            }
            catch (Exception exception) {
                LDAPAuthorizationHandler.debugOut("Exception, the search filter \"" + string8 + "\" did not find the user, or the UserAttributeName or baseDN may not have been configured correctly: " + InsightUtilities.getStackTrace((Throwable)exception));
            }
            initialDirContext.close();
        }
        catch (CommunicationException communicationException) {
            LDAPAuthorizationHandler.debugOut("Communication exception:\n" + InsightUtilities.getStackTrace((Throwable)communicationException));
            this.ldapException = new SecurityServerConnectionException(false, true);
        }
        catch (NamingException namingException) {
            LDAPAuthorizationHandler.debugOut("Naming exception:\n" + InsightUtilities.getStackTrace((Throwable)namingException));
        }
    }

    public InsightUser getInsightUser(SecurityCallbackHandler securityCallbackHandler, IAuthenticationHandler iAuthenticationHandler) throws SecurityServerConnectionException {
        return this.insightUser;
    }

    public boolean supportsManagement(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public List getUserKeys(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return null;
    }

    public IUser getUser(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return null;
    }

    public void saveUser(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IUser iUser) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
    }

    public List getGroupKeys(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return null;
    }

    public IAuthorizationGroup getGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return null;
    }

    public void saveGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationGroup iAuthorizationGroup) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
    }

    public List getShareKeys(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return null;
    }

    public IShare getShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return null;
    }

    public void saveShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IShare iShare) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
    }

    public List getShareSubfolderList(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, ShareFolder shareFolder) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return new ArrayList();
    }

    public boolean addFolderToShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2, ShareFolder shareFolder, String string, boolean bl) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public boolean removeFolderFromShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, ShareFolder shareFolder, boolean bl) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public boolean linkKeys(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2, Object object) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public boolean unlinkKeys(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public boolean setUserShareRights(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IShareAuthorizationKey iShareAuthorizationKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public boolean addCollectionToGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, CollectionKey collectionKey, String string, int n, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(InsightUserManager.USER_SERVER_ADDRESS);
            if (insightUserClient.isConnectionGood()) {
                CollectionKeyWrapper collectionKeyWrapper = CollectionKeyWrapper.createCollectionKeyWrapper((CollectionKey)collectionKey);
                boolean bl = insightUserClient.addCollectionToGroup((CollectionKey)collectionKeyWrapper, string, n, iAuthorizationEntityKey.getUniqueIdentifier());
                return bl;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public boolean addUserToGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public boolean removeUserFromGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public boolean removeUserFromShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public boolean addUserToShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2, boolean bl, boolean bl2, boolean bl3) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public IAuthorizationEntityKey addUser(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, String string) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return null;
    }

    public boolean removeUser(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public IAuthorizationEntityKey addUserGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, String string, String string2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        if (this.addAuthorizationEntity(1, arrayList)) {
            return new ManagedInsightAuthorizationEntityKey(string, class$com$luna$insight$client$security$ManagedUserGroup == null ? (class$com$luna$insight$client$security$ManagedUserGroup = LDAPAuthorizationHandler.class$("com.luna.insight.client.security.ManagedUserGroup")) : class$com$luna$insight$client$security$ManagedUserGroup);
        }
        throw new AuthorizationException("Unable to add user group.");
    }

    private boolean addAuthorizationEntity(int n, Object object) throws SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(InsightUserManager.USER_SERVER_ADDRESS);
            if (insightUserClient.isConnectionGood()) {
                boolean bl = insightUserClient.addAuthorizationEntity(n, object);
                return bl;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public boolean removeUserGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    public IAuthorizationEntityKey addShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, String string) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return null;
    }

    public boolean removeShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

