/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.security;

import com.luna.insight.client.security.InsightUserManager;
import com.luna.insight.client.security.SimpleLDAPAuthenticationHandler;
import com.luna.insight.client.security.ldap.LDAPAuthenticationSearchImpl;
import com.luna.insight.server.Debug;
import com.luna.insight.server.security.InsightSecuritySettings;
import com.sun.net.ssl.internal.ssl.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;

public class LDAPAuthenticationSearchHandler
extends SimpleLDAPAuthenticationHandler {
    protected List searchAttributesList = new ArrayList();
    protected LDAPAuthenticationSearchImpl ldapAuthenticationSearch = new LDAPAuthenticationSearchImpl();
    protected InsightSecuritySettings securitySettings = InsightUserManager.getLoginProps();

    public LDAPAuthenticationSearchHandler() {
        this.ldapAuthenticationSearch.setLdapUserAttribute(this.securitySettings.getProperty("LdapUserAttribute"));
        this.ldapAuthenticationSearch.setLdapURL(this.securitySettings.getProperty("LdapURL"));
        this.ldapAuthenticationSearch.setBaseDN(this.securitySettings.getProperty("BaseDN"));
        this.ldapAuthenticationSearch.setLoginSSL((Boolean)this.securitySettings.get("LoginSSL"));
        this.ldapAuthenticationSearch.setLdapSecurityPrincipal(this.securitySettings.getProperty("LdapSecurityPrincipal"));
        this.ldapAuthenticationSearch.setLdapSecurityPrincipalAttributes(this.securitySettings.getProperty("LdapSecurityPrincipalAttributes"));
    }

    protected void createSearchAttributeList(InsightSecuritySettings insightSecuritySettings) throws Exception {
        boolean bl = false;
        int n = 1;
        while (!bl) {
            String string = insightSecuritySettings.getProperty("LdapSearchFilter_" + n);
            LDAPAuthenticationSearchHandler.debugOut("LdapSearchFilter_" + n + " = " + string);
            if (string == null) {
                bl = true;
            } else {
                String string2 = insightSecuritySettings.getProperty("LdapSearchAttributes_" + n);
                this.ldapAuthenticationSearch.addFilter(string, string2);
            }
            ++n;
        }
    }

    protected boolean authenticateUsingSimpleLDAP(String string, String string2) {
        try {
            this.createSearchAttributeList(this.securitySettings);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.ldapAuthenticationSearch.authenticate(string, string2);
    }

    public static void debugOut(String string) {
        LDAPAuthenticationSearchHandler.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut((String)("LDAPAuthenticationSearchHandler: " + string), (int)n);
    }

    static {
        String string = System.getProperty("java.version");
        if (string != null && string.length() > 0 && string.startsWith("1.3") && Security.getProvider("SunJSSE") == null) {
            Security.addProvider((java.security.Provider)new Provider());
        }
    }
}

