/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.security;

import com.luna.insight.client.security.DefaultAuthenticationHandler;
import com.luna.insight.client.security.DefaultCallbackHandler;
import com.luna.insight.client.security.LASInsightUserManager;
import com.luna.insight.client.security.ManagedInsightAuthorizationEntityKey;
import com.luna.insight.client.security.ManagedInsightUser;
import com.luna.insight.client.security.ManagedShare;
import com.luna.insight.client.security.ManagedUserGroup;
import com.luna.insight.client.security.ShareAuthorizationKey;
import com.luna.insight.client.security.iface.AuthenticationException;
import com.luna.insight.client.security.iface.AuthorizationException;
import com.luna.insight.client.security.iface.IAuthenticationHandler;
import com.luna.insight.client.security.iface.IAuthorizationEntity;
import com.luna.insight.client.security.iface.IAuthorizationEntityKey;
import com.luna.insight.client.security.iface.IAuthorizationGroup;
import com.luna.insight.client.security.iface.IAuthorizationHandler;
import com.luna.insight.client.security.iface.IShare;
import com.luna.insight.client.security.iface.IShareAuthorizationKey;
import com.luna.insight.client.security.iface.IUser;
import com.luna.insight.client.security.iface.SecurityCallbackHandler;
import com.luna.insight.client.security.iface.SecurityServerConnectionException;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUserClient;
import com.luna.insight.server.usergroup.ShareFolder;
import com.luna.insight.server.usergroup.UserGroupKey;
import com.luna.insight.server.usergroup.UserKey;
import com.luna.insight.server.usergroup.UserShareKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class LASAuthorizationHandler
implements IAuthorizationHandler,
Serializable {
    public static final long serialVersionUID = 29264L;
    protected Map entityMap = Collections.synchronizedMap(new HashMap());
    protected LASInsightUserManager lasInsightUserManager = null;
    static /* synthetic */ Class class$com$luna$insight$client$security$ManagedInsightUser;
    static /* synthetic */ Class class$com$luna$insight$client$security$ManagedUserGroup;
    static /* synthetic */ Class class$com$luna$insight$client$security$ManagedShare;

    public static void debugOut(String string) {
        LASAuthorizationHandler.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut((String)("DefaultAuthorizationHandler: " + string), (int)n);
    }

    public LASAuthorizationHandler(LASInsightUserManager lASInsightUserManager) {
        this.lasInsightUserManager = lASInsightUserManager;
    }

    public List getCollections(IAuthenticationHandler iAuthenticationHandler, boolean bl) throws AuthorizationException, SecurityServerConnectionException {
        if (!(iAuthenticationHandler instanceof DefaultAuthenticationHandler)) {
            throw new AuthorizationException();
        }
        DefaultAuthenticationHandler defaultAuthenticationHandler = (DefaultAuthenticationHandler)iAuthenticationHandler;
        String string = defaultAuthenticationHandler.getUsername();
        String string2 = defaultAuthenticationHandler.getPassword();
        if (string2 == null) {
            string2 = "";
        }
        LASAuthorizationHandler.debugOut("Authorize: " + string);
        Vector vector = new Vector();
        InsightUserClient insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
        if (insightUserClient.isConnectionGood()) {
            vector = bl ? insightUserClient.getAvailableMedeCollections(string, string2) : insightUserClient.getAvailableCollections(string, string2);
        } else {
            throw new SecurityServerConnectionException(false, true);
        }
        insightUserClient.closeConnection();
        LASAuthorizationHandler.debugOut("Received " + vector.size() + " collection(s).");
        if (vector == null || vector.size() < 1) {
            throw new AuthorizationException();
        }
        return vector;
    }

    public InsightUser getInsightUser(SecurityCallbackHandler securityCallbackHandler, IAuthenticationHandler iAuthenticationHandler) throws SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                InsightUser insightUser = insightUserClient.getInsightUser(securityCallbackHandler.getUsername());
                return insightUser;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    protected List getUserGroupsAndShares(SecurityCallbackHandler securityCallbackHandler) throws SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                List list = insightUserClient.getUserGroupsAndSharesForUser(securityCallbackHandler.getUsername());
                return list;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    protected List getUsersInGroup(String string) throws SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                List list = insightUserClient.getUserKeyListByGroup(string);
                return list;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    protected List getUsersInShare(String string) throws SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                List list = insightUserClient.getUserKeyListByShare(string);
                return list;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public boolean supportsManagement(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return true;
    }

    public List getUserKeys(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.getAuthorizationEntityKeys(iAuthenticationHandler, securityCallbackHandler, class$com$luna$insight$client$security$ManagedInsightUser == null ? (class$com$luna$insight$client$security$ManagedInsightUser = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedInsightUser")) : class$com$luna$insight$client$security$ManagedInsightUser);
    }

    public IUser getUser(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return (ManagedInsightUser)this.updateAuthorizationEntity(iAuthenticationHandler, securityCallbackHandler, iAuthorizationEntityKey, class$com$luna$insight$client$security$ManagedInsightUser == null ? (class$com$luna$insight$client$security$ManagedInsightUser = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedInsightUser")) : class$com$luna$insight$client$security$ManagedInsightUser, true);
    }

    public void saveUser(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IUser iUser) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        if (this.saveAuthorizationEntity(iUser)) {
            return;
        }
        throw new AuthorizationException();
    }

    public List getGroupKeys(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.getAuthorizationEntityKeys(iAuthenticationHandler, securityCallbackHandler, class$com$luna$insight$client$security$ManagedUserGroup == null ? (class$com$luna$insight$client$security$ManagedUserGroup = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedUserGroup")) : class$com$luna$insight$client$security$ManagedUserGroup);
    }

    public IAuthorizationGroup getGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return (ManagedUserGroup)this.updateAuthorizationEntity(iAuthenticationHandler, securityCallbackHandler, iAuthorizationEntityKey, class$com$luna$insight$client$security$ManagedUserGroup == null ? (class$com$luna$insight$client$security$ManagedUserGroup = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedUserGroup")) : class$com$luna$insight$client$security$ManagedUserGroup, true);
    }

    public void saveGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationGroup iAuthorizationGroup) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        if (this.saveAuthorizationEntity(iAuthorizationGroup)) {
            return;
        }
        throw new AuthorizationException();
    }

    public List getShareKeys(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.getAuthorizationEntityKeys(iAuthenticationHandler, securityCallbackHandler, class$com$luna$insight$client$security$ManagedShare == null ? (class$com$luna$insight$client$security$ManagedShare = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedShare")) : class$com$luna$insight$client$security$ManagedShare);
    }

    public IShare getShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return (ManagedShare)this.updateAuthorizationEntity(iAuthenticationHandler, securityCallbackHandler, iAuthorizationEntityKey, class$com$luna$insight$client$security$ManagedShare == null ? (class$com$luna$insight$client$security$ManagedShare = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedShare")) : class$com$luna$insight$client$security$ManagedShare, true);
    }

    public void saveShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IShare iShare) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        if (this.saveAuthorizationEntity(iShare)) {
            return;
        }
        throw new AuthorizationException();
    }

    private List getAuthorizationEntityKeys(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, Class clazz) throws SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                List list;
                ArrayList<ManagedInsightAuthorizationEntityKey> arrayList = new ArrayList<ManagedInsightAuthorizationEntityKey>();
                if (clazz == (class$com$luna$insight$client$security$ManagedInsightUser == null ? (class$com$luna$insight$client$security$ManagedInsightUser = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedInsightUser")) : class$com$luna$insight$client$security$ManagedInsightUser)) {
                    list = insightUserClient.getUserKeyList();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        UserKey userKey = (UserKey)iterator.next();
                        ManagedInsightAuthorizationEntityKey managedInsightAuthorizationEntityKey = new ManagedInsightAuthorizationEntityKey(userKey.getLoginName(), clazz);
                        String string = "";
                        if (userKey.getFirstName() != null && !userKey.getFirstName().equals("")) {
                            string = userKey.getFirstName() + " ";
                        }
                        if (userKey.getLastName() != null && !userKey.getLastName().equals("")) {
                            string = string + userKey.getLastName();
                        }
                        if (!string.equals("")) {
                            managedInsightAuthorizationEntityKey.setPresentationName(userKey.getLoginName() + " (" + string + ")");
                        }
                        arrayList.add(managedInsightAuthorizationEntityKey);
                    }
                } else if (clazz == (class$com$luna$insight$client$security$ManagedUserGroup == null ? (class$com$luna$insight$client$security$ManagedUserGroup = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedUserGroup")) : class$com$luna$insight$client$security$ManagedUserGroup)) {
                    list = insightUserClient.getUserGroupKeyList();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        UserGroupKey userGroupKey = (UserGroupKey)iterator.next();
                        arrayList.add(new ManagedInsightAuthorizationEntityKey(userGroupKey.getName(), clazz));
                    }
                } else if (clazz == (class$com$luna$insight$client$security$ManagedShare == null ? (class$com$luna$insight$client$security$ManagedShare = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedShare")) : class$com$luna$insight$client$security$ManagedShare)) {
                    list = insightUserClient.getShareKeyList();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        UserShareKey userShareKey = (UserShareKey)iterator.next();
                        arrayList.add(new ManagedInsightAuthorizationEntityKey(userShareKey.getName(), clazz));
                    }
                }
                list = arrayList;
                return list;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAuthorizationEntity updateAuthorizationEntity(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, Class clazz, boolean bl) throws AuthorizationException, SecurityServerConnectionException {
        ManagedInsightAuthorizationEntityKey managedInsightAuthorizationEntityKey = (ManagedInsightAuthorizationEntityKey)iAuthorizationEntityKey;
        if (managedInsightAuthorizationEntityKey.getKeyedClass() != clazz) {
            throw new IllegalArgumentException(managedInsightAuthorizationEntityKey.getKeyedClass().getName() + " is not a " + clazz.getName());
        }
        IAuthorizationEntity iAuthorizationEntity = null;
        Map map = this.entityMap;
        synchronized (map) {
            if (bl || null == (iAuthorizationEntity = (IAuthorizationEntity)this.entityMap.get(managedInsightAuthorizationEntityKey))) {
                if (clazz == (class$com$luna$insight$client$security$ManagedInsightUser == null ? (class$com$luna$insight$client$security$ManagedInsightUser = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedInsightUser")) : class$com$luna$insight$client$security$ManagedInsightUser)) {
                    InsightUser insightUser = this.getInsightUser(new DefaultCallbackHandler(managedInsightAuthorizationEntityKey.getUniqueIdentifier(), null), iAuthenticationHandler);
                    if (insightUser == null) {
                        throw new AuthorizationException("No user matching key: " + managedInsightAuthorizationEntityKey);
                    }
                    List list = this.getUserGroupsAndShares(new DefaultCallbackHandler(managedInsightAuthorizationEntityKey.getUniqueIdentifier(), null));
                    iAuthorizationEntity = new ManagedInsightUser(insightUser, null, null);
                    if (list != null) {
                        Object object;
                        ArrayList<ManagedInsightAuthorizationEntityKey> arrayList = new ArrayList<ManagedInsightAuthorizationEntityKey>();
                        Object object2 = ((List)list.get(0)).iterator();
                        while (object2.hasNext()) {
                            object = (UserGroupKey)object2.next();
                            arrayList.add(new ManagedInsightAuthorizationEntityKey(object.getName(), class$com$luna$insight$client$security$ManagedUserGroup == null ? LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedUserGroup") : class$com$luna$insight$client$security$ManagedUserGroup));
                        }
                        ((ManagedInsightUser)iAuthorizationEntity).setAuthorizationGroupKeys(arrayList);
                        object2 = new ArrayList();
                        object = ((List)list.get(1)).iterator();
                        while (object.hasNext()) {
                            UserShareKey userShareKey = (UserShareKey)object.next();
                            ShareAuthorizationKey shareAuthorizationKey = new ShareAuthorizationKey(userShareKey.getName(), class$com$luna$insight$client$security$ManagedShare == null ? LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedShare") : class$com$luna$insight$client$security$ManagedShare);
                            shareAuthorizationKey.setTarget(iAuthorizationEntity.getKey());
                            shareAuthorizationKey.setWrite(userShareKey.isWritePriv());
                            shareAuthorizationKey.setDelete(userShareKey.isDeletePriv());
                            shareAuthorizationKey.setCreate(userShareKey.isCreatePriv());
                            object2.add(shareAuthorizationKey);
                        }
                        ((ManagedInsightUser)iAuthorizationEntity).setShareAuthorizationKeys((List)object2);
                    }
                } else if (clazz == (class$com$luna$insight$client$security$ManagedUserGroup == null ? (class$com$luna$insight$client$security$ManagedUserGroup = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedUserGroup")) : class$com$luna$insight$client$security$ManagedUserGroup)) {
                    InsightUserClient insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
                    if (!insightUserClient.isConnectionGood()) throw new SecurityServerConnectionException(false, true);
                    List list = insightUserClient.getAuthorizationEntityInfo(1, managedInsightAuthorizationEntityKey.getUniqueIdentifier());
                    insightUserClient.closeConnection();
                    if (list == null) throw new AuthorizationException();
                    ArrayList<ManagedInsightAuthorizationEntityKey> arrayList = new ArrayList<ManagedInsightAuthorizationEntityKey>();
                    Iterator iterator = this.getUsersInGroup(managedInsightAuthorizationEntityKey.getUniqueIdentifier()).iterator();
                    while (iterator.hasNext()) {
                        UserKey userKey = (UserKey)iterator.next();
                        arrayList.add(new ManagedInsightAuthorizationEntityKey(userKey.getLoginName(), class$com$luna$insight$client$security$ManagedInsightUser == null ? LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedInsightUser") : class$com$luna$insight$client$security$ManagedInsightUser));
                    }
                    iAuthorizationEntity = new ManagedUserGroup(managedInsightAuthorizationEntityKey.getUniqueIdentifier(), arrayList);
                    ((ManagedUserGroup)iAuthorizationEntity).configureWithFullInfo(list);
                } else if (clazz == (class$com$luna$insight$client$security$ManagedShare == null ? (class$com$luna$insight$client$security$ManagedShare = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedShare")) : class$com$luna$insight$client$security$ManagedShare)) {
                    InsightUserClient insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
                    if (!insightUserClient.isConnectionGood()) throw new SecurityServerConnectionException(false, true);
                    List list = insightUserClient.getAuthorizationEntityInfo(2, managedInsightAuthorizationEntityKey.getUniqueIdentifier());
                    insightUserClient.closeConnection();
                    iAuthorizationEntity = new ManagedShare(managedInsightAuthorizationEntityKey.getUniqueIdentifier(), null);
                    ((ManagedShare)iAuthorizationEntity).configureWithFullInfo(list);
                    ArrayList<ShareAuthorizationKey> arrayList = new ArrayList<ShareAuthorizationKey>();
                    Iterator iterator = this.getUsersInShare(managedInsightAuthorizationEntityKey.getUniqueIdentifier()).iterator();
                    while (iterator.hasNext()) {
                        UserKey userKey = (UserKey)iterator.next();
                        ShareAuthorizationKey shareAuthorizationKey = new ShareAuthorizationKey(userKey.getLoginName(), class$com$luna$insight$client$security$ManagedInsightUser == null ? LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedInsightUser") : class$com$luna$insight$client$security$ManagedInsightUser);
                        shareAuthorizationKey.setTarget(iAuthorizationEntity.getKey());
                        shareAuthorizationKey.setWrite(userKey.isShareWritePriv());
                        shareAuthorizationKey.setDelete(userKey.isShareDeletePriv());
                        shareAuthorizationKey.setCreate(userKey.isShareCreatePriv());
                        arrayList.add(shareAuthorizationKey);
                    }
                    ((ManagedShare)iAuthorizationEntity).setShareAuthorizationKeys(arrayList);
                }
            }
            this.entityMap.put(managedInsightAuthorizationEntityKey, iAuthorizationEntity);
            return iAuthorizationEntity;
        }
    }

    public boolean addUserToShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2, boolean bl, boolean bl2, boolean bl3) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                boolean bl4 = insightUserClient.addUserToShare(iAuthorizationEntityKey.getUniqueIdentifier(), iAuthorizationEntityKey2.getUniqueIdentifier(), bl, bl2, bl3);
                return bl4;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public List getShareSubfolderList(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, ShareFolder shareFolder) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                List list = insightUserClient.getShareSubfolderList(iAuthorizationEntityKey.getUniqueIdentifier(), shareFolder.getFolderID());
                return list;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public boolean addFolderToShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2, ShareFolder shareFolder, String string, boolean bl) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                boolean bl2 = insightUserClient.createShareSubfolder(iAuthorizationEntityKey.getUniqueIdentifier(), iAuthorizationEntityKey2.getUniqueIdentifier(), shareFolder.getFolderID(), string, bl);
                return bl2;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public boolean removeFolderFromShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, ShareFolder shareFolder, boolean bl) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                boolean bl2 = insightUserClient.deleteShareSubfolder(iAuthorizationEntityKey.getUniqueIdentifier(), shareFolder.getFolderID(), bl);
                return bl2;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public boolean setUserShareRights(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IShareAuthorizationKey iShareAuthorizationKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                boolean bl;
                String string = null;
                String string2 = null;
                if (iShareAuthorizationKey.getKeyedClass() == (class$com$luna$insight$client$security$ManagedInsightUser == null ? (class$com$luna$insight$client$security$ManagedInsightUser = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedInsightUser")) : class$com$luna$insight$client$security$ManagedInsightUser)) {
                    string = iShareAuthorizationKey.getUniqueIdentifier();
                    string2 = iShareAuthorizationKey.getTarget().getUniqueIdentifier();
                } else if (iShareAuthorizationKey.getKeyedClass() == (class$com$luna$insight$client$security$ManagedShare == null ? (class$com$luna$insight$client$security$ManagedShare = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedShare")) : class$com$luna$insight$client$security$ManagedShare)) {
                    string = iShareAuthorizationKey.getTarget().getUniqueIdentifier();
                    string2 = iShareAuthorizationKey.getUniqueIdentifier();
                } else {
                    throw new IllegalArgumentException("key keys invalid class " + iShareAuthorizationKey.getKeyedClass());
                }
                boolean bl2 = bl = insightUserClient.setUserShareRights(string, string2, iShareAuthorizationKey.isWrite(), iShareAuthorizationKey.isDelete(), iShareAuthorizationKey.isCreate());
                return bl2;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public boolean addCollectionToGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, CollectionKey collectionKey, String string, int n, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                CollectionKeyWrapper collectionKeyWrapper = CollectionKeyWrapper.createCollectionKeyWrapper((CollectionKey)collectionKey);
                boolean bl = insightUserClient.addCollectionToGroup((CollectionKey)collectionKeyWrapper, string, n, iAuthorizationEntityKey.getUniqueIdentifier());
                return bl;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public boolean addUserToGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                boolean bl = insightUserClient.addUserToGroup(iAuthorizationEntityKey.getUniqueIdentifier(), iAuthorizationEntityKey2.getUniqueIdentifier());
                return bl;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public boolean removeUserFromGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                boolean bl = insightUserClient.removeUserFromGroup(iAuthorizationEntityKey.getUniqueIdentifier(), iAuthorizationEntityKey2.getUniqueIdentifier());
                return bl;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public boolean removeUserFromShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                boolean bl = insightUserClient.removeUserFromShare(iAuthorizationEntityKey.getUniqueIdentifier(), iAuthorizationEntityKey2.getUniqueIdentifier());
                return bl;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    public IAuthorizationEntityKey addUser(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, String string) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        if (this.addAuthorizationEntity(0, string)) {
            return new ManagedInsightAuthorizationEntityKey(string, class$com$luna$insight$client$security$ManagedInsightUser == null ? (class$com$luna$insight$client$security$ManagedInsightUser = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedInsightUser")) : class$com$luna$insight$client$security$ManagedInsightUser);
        }
        throw new AuthorizationException("Unable to add user.");
    }

    public boolean removeUser(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.removeAuthorizationEntity(0, iAuthorizationEntityKey);
    }

    public IAuthorizationEntityKey addUserGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, String string, String string2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        if (this.addAuthorizationEntity(1, arrayList)) {
            return new ManagedInsightAuthorizationEntityKey(string, class$com$luna$insight$client$security$ManagedUserGroup == null ? (class$com$luna$insight$client$security$ManagedUserGroup = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedUserGroup")) : class$com$luna$insight$client$security$ManagedUserGroup);
        }
        throw new AuthorizationException("Unable to add user group.");
    }

    public boolean removeUserGroup(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.removeAuthorizationEntity(1, iAuthorizationEntityKey);
    }

    public IAuthorizationEntityKey addShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, String string) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        if (this.addAuthorizationEntity(2, string)) {
            return new ManagedInsightAuthorizationEntityKey(string, class$com$luna$insight$client$security$ManagedShare == null ? (class$com$luna$insight$client$security$ManagedShare = LASAuthorizationHandler.class$("com.luna.insight.client.security.ManagedShare")) : class$com$luna$insight$client$security$ManagedShare);
        }
        throw new AuthorizationException("Unable to add share.");
    }

    public boolean removeShare(IAuthenticationHandler iAuthenticationHandler, SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.removeAuthorizationEntity(2, iAuthorizationEntityKey);
    }

    private boolean addAuthorizationEntity(int n, Object object) throws SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                boolean bl = insightUserClient.addAuthorizationEntity(n, object);
                return bl;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    private boolean removeAuthorizationEntity(int n, IAuthorizationEntityKey iAuthorizationEntityKey) throws SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                boolean bl = insightUserClient.removeAuthorizationEntity(n, (Object)iAuthorizationEntityKey.getUniqueIdentifier());
                if (bl) {
                    this.entityMap.remove(iAuthorizationEntityKey);
                }
                boolean bl2 = bl;
                return bl2;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    private boolean saveAuthorizationEntity(IAuthorizationEntity iAuthorizationEntity) throws SecurityServerConnectionException {
        InsightUserClient insightUserClient = null;
        try {
            Object object;
            int n;
            if (iAuthorizationEntity instanceof ManagedInsightUser) {
                n = 0;
                object = ((ManagedInsightUser)iAuthorizationEntity).getFullInfo();
            } else if (iAuthorizationEntity instanceof ManagedUserGroup) {
                n = 1;
                object = ((ManagedUserGroup)iAuthorizationEntity).getFullInfo();
            } else if (iAuthorizationEntity instanceof ManagedShare) {
                n = 2;
                object = ((ManagedShare)iAuthorizationEntity).getFullInfo();
            } else {
                boolean bl = false;
                return bl;
            }
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                boolean bl = insightUserClient.saveAuthorizationEntity(n, object);
                return bl;
            }
            throw new SecurityServerConnectionException(false, true);
        }
        finally {
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

