/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.security;

import com.luna.insight.client.security.DefaultAuthenticationHandler;
import com.luna.insight.client.security.LASInsightUserManager;
import com.luna.insight.client.security.iface.AuthenticationException;
import com.luna.insight.client.security.iface.SecurityCallbackHandler;
import com.luna.insight.client.security.iface.SecurityServerConnectionException;
import com.luna.insight.server.InsightUserClient;
import com.luna.insight.server.InsightVersion;
import java.io.Serializable;

public class LASAuthenticationHandler
extends DefaultAuthenticationHandler
implements Serializable {
    public static final long serialVersionUID = 25168L;
    protected LASInsightUserManager lasInsightUserManager = null;

    public LASAuthenticationHandler(LASInsightUserManager lASInsightUserManager) {
        this.lasInsightUserManager = lASInsightUserManager;
    }

    public void authenticate(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, SecurityServerConnectionException {
        this.username = securityCallbackHandler.getUsername();
        this.password = securityCallbackHandler.getPassword();
        LASAuthenticationHandler.debugOut("Check " + this.username);
        this.isAuthenticated = true;
        if (this.username.length() <= 0 || this.password.length() <= 0) {
            this.isAuthenticated = false;
        }
        if (this.isAuthenticated) {
            InsightUserClient insightUserClient = null;
            insightUserClient = new InsightUserClient(this.lasInsightUserManager.getUserServerAddress());
            if (insightUserClient.isConnectionGood()) {
                InsightVersion insightVersion = insightUserClient.getServerVersion();
                if (insightVersion != null && insightVersion.getMajorVersion() >= 5) {
                    this.isAuthenticated = insightUserClient.authenticateUsernameAndPassword(this.username, this.password);
                }
            } else {
                this.isAuthenticated = false;
            }
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
        LASAuthenticationHandler.debugOut("authenticate " + this.isAuthenticated);
        if (!this.isAuthenticated) {
            throw new AuthenticationException();
        }
    }
}

