/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.security;

import com.luna.insight.client.security.InsightUserManager;
import com.luna.insight.client.security.KerberosProxyCallbackHandler;
import com.luna.insight.client.security.iface.AuthenticationException;
import com.luna.insight.client.security.iface.IAuthenticationHandler;
import com.luna.insight.client.security.iface.SecurityCallbackHandler;
import com.luna.insight.client.security.iface.SecurityServerConnectionException;
import com.luna.insight.server.Debug;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KerberosAuthenticationHandler
implements IAuthenticationHandler {
    protected boolean isAuthenticated = false;
    protected LoginContext lc = null;

    public static void debugOut(String string) {
        KerberosAuthenticationHandler.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut((String)("KerberosAuthenticationHandler: " + string), (int)n);
    }

    public void authenticate(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, SecurityServerConnectionException {
        KerberosAuthenticationHandler.debugOut("Kerberos Authentication: authenticate()");
        this.lc = null;
        try {
            KerberosProxyCallbackHandler kerberosProxyCallbackHandler = new KerberosProxyCallbackHandler();
            kerberosProxyCallbackHandler.setDefaultCallBackHandler(securityCallbackHandler);
            try {
                this.lc = new LoginContext("Insight", kerberosProxyCallbackHandler);
            }
            catch (Exception exception) {
                KerberosAuthenticationHandler.debugOut("Exception creating Login Context " + exception);
            }
            this.lc.login();
            this.isAuthenticated = true;
        }
        catch (LoginException loginException) {
            KerberosAuthenticationHandler.debugOut("Authentication attempt failed " + loginException);
            if (loginException.getMessage().toLowerCase().indexOf("unable to find loginmodule class: com.sun.security.auth.module.krb5loginmodule") > -1) {
                InsightUserManager.getInstance().configureAsDefault();
            }
            throw new AuthenticationException();
        }
        KerberosAuthenticationHandler.debugOut("authenticate " + this.isAuthenticated);
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public LoginContext getLoginContext() {
        return this.lc;
    }
}

