/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.security;

import com.luna.insight.client.security.DefaultAuthenticationHandler;
import com.luna.insight.client.security.DefaultAuthorizationHandler;
import com.luna.insight.client.security.iface.AuthenticationException;
import com.luna.insight.client.security.iface.AuthorizationException;
import com.luna.insight.client.security.iface.IAuthenticationHandler;
import com.luna.insight.client.security.iface.IAuthorizationEntityKey;
import com.luna.insight.client.security.iface.IAuthorizationGroup;
import com.luna.insight.client.security.iface.IAuthorizationHandler;
import com.luna.insight.client.security.iface.IAuthorizationManager;
import com.luna.insight.client.security.iface.IShare;
import com.luna.insight.client.security.iface.IShareAuthorizationKey;
import com.luna.insight.client.security.iface.IUser;
import com.luna.insight.client.security.iface.SecurityCallbackHandler;
import com.luna.insight.client.security.iface.SecurityServerConnectionException;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUser;
import com.luna.insight.server.InsightUserClient;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.security.InsightSecuritySettings;
import java.util.List;
import java.util.Properties;

public class InsightUserManager
implements IAuthorizationManager {
    protected static InsightUserManager instance = null;
    protected static InsightSecuritySettings LOGIN_PROPS = null;
    protected static String LOGIN_MOD_CONFIG_FILENAME = InsightUtilities.getUserHomeDirFilepath((String)"login_module_config.conf", (String)"LunaImaging");
    protected static String KRB_CONFIG_FILENAME = InsightUtilities.getUserHomeDirFilepath((String)"krb_config.conf", (String)"LunaImaging");
    protected static String USER_SERVER_ADDRESS = "";
    protected static InsightVersion insightUserServerVersion = null;
    protected IAuthenticationHandler authenticationHandler = null;
    protected IAuthorizationHandler authorizationHandler = null;
    protected Properties securityProperties = null;

    public static void configure(String string, InsightSecuritySettings insightSecuritySettings) {
        LOGIN_PROPS = insightSecuritySettings;
        USER_SERVER_ADDRESS = string;
        insightUserServerVersion = null;
        try {
            String string2 = LOGIN_PROPS.getProperty("AuthenticationHandler");
            if (string2 != null && string2.endsWith("KerberosAuthenticationHandler")) {
                InsightUtilities.exportFileBytes((String)LOGIN_MOD_CONFIG_FILENAME, (byte[])((byte[])LOGIN_PROPS.get("LoginModuleConf")));
                InsightUtilities.exportFileBytes((String)KRB_CONFIG_FILENAME, (byte[])((byte[])LOGIN_PROPS.get("KerberosConf")));
                System.setProperty("java.security.krb5.conf", KRB_CONFIG_FILENAME);
                System.setProperty("java.security.auth.login.config", LOGIN_MOD_CONFIG_FILENAME);
            }
        }
        catch (Exception exception) {
            InsightUserManager.debugOut("WARNING: Failed to load security handlers (defaulting to plain handlers):\n" + InsightUtilities.getStackTrace((Throwable)exception));
            InsightUserManager.getInstance().configureAsDefault();
        }
        catch (Error error) {
            InsightUserManager.debugOut("WARNING: Failed to load security handlers (defaulting to plain handlers):\n" + InsightUtilities.getStackTrace((Throwable)error));
            InsightUserManager.getInstance().configureAsDefault();
        }
    }

    public static InsightUserManager getInstance() {
        if (instance == null) {
            instance = new InsightUserManager(LOGIN_PROPS);
        } else {
            instance.reconfigure(LOGIN_PROPS);
        }
        return instance;
    }

    public static void debugOut(String string) {
        InsightUserManager.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut((String)("InsightLoginManager: " + string), (int)n);
    }

    public InsightUserManager(Properties properties) {
        this.reconfigure(properties);
    }

    protected void reconfigure(Properties properties) {
        try {
            InsightUserManager.debugOut("Setting security handlers.");
            String string = properties.getProperty("AuthenticationHandler");
            String string2 = properties.getProperty("AuthorizationHandler");
            InsightUserManager.debugOut("Loading AuthenticationHandler: " + string);
            this.authenticationHandler = (IAuthenticationHandler)Class.forName(string).newInstance();
            InsightUserManager.debugOut("Loading AuthorizationHandler: " + string2);
            this.authorizationHandler = (IAuthorizationHandler)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            InsightUserManager.debugOut("WARNING: Failed to load security handlers (defaulting to plain handlers):\n" + InsightUtilities.getStackTrace((Throwable)exception));
            this.authenticationHandler = new DefaultAuthenticationHandler();
            this.authorizationHandler = new DefaultAuthorizationHandler();
        }
        catch (Error error) {
            InsightUserManager.debugOut("WARNING: Failed to load security handlers (defaulting to plain handlers):\n" + InsightUtilities.getStackTrace((Throwable)error));
            this.authenticationHandler = new DefaultAuthenticationHandler();
            this.authorizationHandler = new DefaultAuthorizationHandler();
        }
        InsightUserManager.debugOut("AuthenticationHandler class: " + this.authenticationHandler.getClass());
        InsightUserManager.debugOut("AuthorizationHandler class: " + this.authorizationHandler.getClass());
    }

    public InsightUser getInsightUser(SecurityCallbackHandler securityCallbackHandler) throws SecurityServerConnectionException {
        return this.authorizationHandler.getInsightUser(securityCallbackHandler, this.authenticationHandler);
    }

    public boolean isAuthenticated() {
        return this.authenticationHandler.isAuthenticated();
    }

    public List getCollections(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        this.authenticationHandler.authenticate(securityCallbackHandler);
        return this.authorizationHandler.getCollections(this.authenticationHandler, false);
    }

    public List getCollections(SecurityCallbackHandler securityCallbackHandler, boolean bl) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        this.authenticationHandler.authenticate(securityCallbackHandler);
        return this.authorizationHandler.getCollections(this.authenticationHandler, bl);
    }

    public List getMedeCollections(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.getCollections(securityCallbackHandler, true);
    }

    public IAuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public IAuthorizationHandler getAuthorizationHandler() {
        return this.authorizationHandler;
    }

    public void configureAsDefault() {
        this.authenticationHandler = new DefaultAuthenticationHandler();
        this.authorizationHandler = new DefaultAuthorizationHandler();
    }

    public boolean supportsAuthorizationManagement(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.supportsManagement(securityCallbackHandler);
    }

    public List getUserKeys(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.getUserKeys(this.authenticationHandler, securityCallbackHandler);
    }

    public IUser getUser(SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.getUser(this.authenticationHandler, securityCallbackHandler, iAuthorizationEntityKey);
    }

    public void saveUser(SecurityCallbackHandler securityCallbackHandler, IUser iUser) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        this.authorizationHandler.saveUser(this.authenticationHandler, securityCallbackHandler, iUser);
    }

    public List getAuthorizationGroupKeys(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.getGroupKeys(this.authenticationHandler, securityCallbackHandler);
    }

    public IAuthorizationGroup getAuthorizationGroup(SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.getGroup(this.authenticationHandler, securityCallbackHandler, iAuthorizationEntityKey);
    }

    public void saveAuthorizationGroup(SecurityCallbackHandler securityCallbackHandler, IAuthorizationGroup iAuthorizationGroup) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        this.authorizationHandler.saveGroup(this.authenticationHandler, securityCallbackHandler, iAuthorizationGroup);
    }

    public List getShareKeys(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.getShareKeys(this.authenticationHandler, securityCallbackHandler);
    }

    public IShare getShare(SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.getShare(this.authenticationHandler, securityCallbackHandler, iAuthorizationEntityKey);
    }

    public void saveShare(SecurityCallbackHandler securityCallbackHandler, IShare iShare) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        this.authorizationHandler.saveShare(this.authenticationHandler, securityCallbackHandler, iShare);
    }

    public boolean addUserToShare(SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2, boolean bl, boolean bl2, boolean bl3) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.addUserToShare(this.authenticationHandler, securityCallbackHandler, iAuthorizationEntityKey, iAuthorizationEntityKey2, bl, bl2, bl3);
    }

    public boolean setUserShareRights(SecurityCallbackHandler securityCallbackHandler, IShareAuthorizationKey iShareAuthorizationKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.setUserShareRights(this.authenticationHandler, securityCallbackHandler, iShareAuthorizationKey);
    }

    public boolean addCollectionToGroup(SecurityCallbackHandler securityCallbackHandler, CollectionKey collectionKey, String string, int n, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.addCollectionToGroup(this.authenticationHandler, securityCallbackHandler, collectionKey, string, n, iAuthorizationEntityKey);
    }

    public boolean addUserToGroup(SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.addUserToGroup(this.authenticationHandler, securityCallbackHandler, iAuthorizationEntityKey, iAuthorizationEntityKey2);
    }

    public boolean removeUserFromGroup(SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.removeUserFromGroup(this.authenticationHandler, securityCallbackHandler, iAuthorizationEntityKey, iAuthorizationEntityKey2);
    }

    public boolean removeUserFromShare(SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey, IAuthorizationEntityKey iAuthorizationEntityKey2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.removeUserFromShare(this.authenticationHandler, securityCallbackHandler, iAuthorizationEntityKey, iAuthorizationEntityKey2);
    }

    public IAuthorizationEntityKey addUser(SecurityCallbackHandler securityCallbackHandler, String string) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.addUser(this.authenticationHandler, securityCallbackHandler, string);
    }

    public boolean removeUser(SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.removeUser(this.authenticationHandler, securityCallbackHandler, iAuthorizationEntityKey);
    }

    public IAuthorizationEntityKey addUserGroup(SecurityCallbackHandler securityCallbackHandler, String string, String string2) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.addUserGroup(this.authenticationHandler, securityCallbackHandler, string, string2);
    }

    public boolean removeUserGroup(SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.removeUserGroup(this.authenticationHandler, securityCallbackHandler, iAuthorizationEntityKey);
    }

    public IAuthorizationEntityKey addShare(SecurityCallbackHandler securityCallbackHandler, String string) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.addShare(this.authenticationHandler, securityCallbackHandler, string);
    }

    public boolean removeShare(SecurityCallbackHandler securityCallbackHandler, IAuthorizationEntityKey iAuthorizationEntityKey) throws AuthenticationException, AuthorizationException, SecurityServerConnectionException {
        return this.authorizationHandler.removeShare(this.authenticationHandler, securityCallbackHandler, iAuthorizationEntityKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InsightVersion getInsightUserServerVersion(SecurityCallbackHandler securityCallbackHandler) throws SecurityServerConnectionException {
        if (insightUserServerVersion == null) {
            InsightUserClient insightUserClient = null;
            try {
                insightUserClient = new InsightUserClient(USER_SERVER_ADDRESS);
                if (insightUserClient.isConnectionGood()) {
                    insightUserServerVersion = insightUserClient.getServerVersion();
                }
                if (insightUserServerVersion == null) {
                    throw new SecurityServerConnectionException(false, false);
                }
            }
            finally {
                if (insightUserClient != null) {
                    insightUserClient.closeConnection();
                }
            }
        }
        return insightUserServerVersion;
    }

    public static InsightSecuritySettings getLoginProps() {
        return LOGIN_PROPS;
    }
}

