/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.security;

import com.luna.insight.client.security.InsightUserManager;
import com.luna.insight.client.security.iface.AuthenticationException;
import com.luna.insight.client.security.iface.IAuthenticationHandler;
import com.luna.insight.client.security.iface.SecurityCallbackHandler;
import com.luna.insight.client.security.iface.SecurityServerConnectionException;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUserClient;
import com.luna.insight.server.InsightVersion;

public class DefaultAuthenticationHandler
implements IAuthenticationHandler {
    protected String username = "";
    protected String password = "";
    protected boolean isAuthenticated = false;

    public static void debugOut(String string) {
        DefaultAuthenticationHandler.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut((String)("DefaultAuthenticationHandler: " + string), (int)n);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void authenticate(SecurityCallbackHandler securityCallbackHandler) throws AuthenticationException, SecurityServerConnectionException {
        this.username = securityCallbackHandler.getUsername();
        this.password = securityCallbackHandler.getPassword();
        DefaultAuthenticationHandler.debugOut("Check " + this.username);
        this.isAuthenticated = true;
        if (this.username.length() <= 0 || this.password.length() <= 0) {
            this.isAuthenticated = false;
        }
        if (this.isAuthenticated) {
            InsightUserClient insightUserClient = null;
            insightUserClient = new InsightUserClient(InsightUserManager.USER_SERVER_ADDRESS);
            if (insightUserClient.isConnectionGood()) {
                InsightVersion insightVersion = insightUserClient.getServerVersion();
                if (insightVersion != null && insightVersion.getMajorVersion() >= 5) {
                    this.isAuthenticated = insightUserClient.authenticateUsernameAndPassword(this.username, this.password);
                }
            } else {
                this.isAuthenticated = false;
            }
            if (insightUserClient != null) {
                insightUserClient.closeConnection();
            }
        }
        DefaultAuthenticationHandler.debugOut("authenticate " + this.isAuthenticated);
        if (!this.isAuthenticated) {
            throw new AuthenticationException();
        }
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }
}

